/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPublicKeyFormatFactory {
    private static String defaultFormat;
    private static HashMap formatTypes;
    private static Log log;
    private static Vector types;

    public static List getSupportedFormats() {
        return types;
    }

    public static SshPublicKeyFormat newInstance(String string) throws InvalidSshKeyException {
        try {
            if (formatTypes.containsKey(string)) {
                return (SshPublicKeyFormat)((Class)formatTypes.get(string)).newInstance();
            }
            throw new InvalidSshKeyException("The format type " + string + " is not supported");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidSshKeyException("Illegal access to class implementation of " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidSshKeyException("Failed to create instance of format type " + string);
        }
    }

    public static String getDefaultFormatType() {
        return defaultFormat;
    }

    static {
        Object object;
        formatTypes = new HashMap();
        log = LogFactory.getLog((Class)SshPublicKeyFormatFactory.class);
        types = new Vector();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(SECSHPublicKeyFormat.class.getName());
        arrayList.add(OpenSSHPublicKeyFormat.class.getName());
        defaultFormat = "SECSH-PublicKey-Base64Encoded";
        try {
            if (ConfigurationLoader.isConfigurationAvailable(SshAPIConfiguration.class)) {
                object = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(SshAPIConfiguration.class);
                defaultFormat = object.getDefaultPublicKeyFormat();
                arrayList.addAll(object.getPublicKeyFormats());
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        log.debug((Object)("Default public key format will be " + defaultFormat));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Class clazz = ConfigurationLoader.getExtensionClass(string);
                object = (SshPublicKeyFormat)clazz.newInstance();
                log.debug((Object)("Installing " + object.getFormatType() + " public key format"));
                formatTypes.put(object.getFormatType(), clazz);
                types.add(object.getFormatType());
            }
            catch (Exception exception) {
                log.warn((Object)("Public key format implemented by " + string + " will not be available"), (Throwable)exception);
            }
        }
    }
}

