/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostsTab
extends JPanel
implements OptionsTab,
ActionListener {
    public static final String GLOBAL_ICON = "/com/sshtools/common/ui/largeserveridentity.png";
    public static final String ALLOW_ICON = "/com/sshtools/common/ui/ok.png";
    public static final String DENY_ICON = "/com/sshtools/common/ui/cancel.png";
    public static final String REMOVE_ICON = "/com/sshtools/common/ui/remove.png";
    private static Log log = LogFactory.getLog((Class)HostsTab.class);
    private JList hosts;
    private AbstractKnownHostsKeyVerification hostKeyVerifier;
    private JButton remove;
    private HostsListModel model;

    public HostsTab(AbstractKnownHostsKeyVerification abstractKnownHostsKeyVerification) {
        this.hostKeyVerifier = abstractKnownHostsKeyVerification;
        this.model = new HostsListModel();
        this.hosts = new JList(this.model);
        this.hosts.setVisibleRowCount(10);
        this.hosts.setCellRenderer(new HostRenderer());
        this.hosts.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                HostsTab.this.setAvailableActions();
            }
        });
        this.remove = new JButton("Remove", new ResourceIcon(REMOVE_ICON));
        this.remove.addActionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel, this.remove, gridBagConstraints, 0);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JScrollPane(this.hosts), "Center");
        jPanel2.add((Component)jPanel, "East");
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(new ResourceIcon(GLOBAL_ICON), jPanel2);
        this.setLayout(new BorderLayout());
        this.add((Component)iconWrapperPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.remove) {
            this.model.removeHostAt(this.hosts.getSelectedIndex());
        }
        this.setAvailableActions();
    }

    private void setAvailableActions() {
        HostWrapper hostWrapper = this.model.getSize() > 0 && this.hosts.getSelectedValues().length == 1 ? this.model.getHostAt(this.hosts.getSelectedIndex()) : null;
        this.remove.setEnabled(hostWrapper != null);
    }

    public void reset() {
        ((HostsListModel)this.hosts.getModel()).refresh();
        this.setAvailableActions();
    }

    public String getTabContext() {
        return "Options";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Hosts";
    }

    public String getTabToolTipText() {
        return "Allowed and denied hosts.";
    }

    public int getTabMnemonic() {
        return 104;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        try {
            Map map = this.hostKeyVerifier.allowedHosts();
            String[] stringArray = new String[map.keySet().size()];
            map.keySet().toArray(stringArray);
            log.debug((Object)"Checking if any allowed hosts need to be removed");
            for (int i = stringArray.length - 1; i >= 0; --i) {
                HostWrapper hostWrapper;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Looking for host " + stringArray[i]));
                }
                if ((hostWrapper = this.model.getHost(stringArray[i])) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found host " + stringArray[i]));
                    }
                    if (hostWrapper.allow) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Denying host " + stringArray[i]));
                    }
                    this.hostKeyVerifier.removeAllowedHost(stringArray[i]);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Host removed " + stringArray[i]));
                }
                this.hostKeyVerifier.removeAllowedHost(stringArray[i]);
            }
            this.hostKeyVerifier.saveHostFile();
        }
        catch (InvalidHostFileException invalidHostFileException) {
            log.error((Object)"Failed to store hosts file.", (Throwable)invalidHostFileException);
        }
    }

    public void tabSelected() {
    }

    class HostsListModel
    extends AbstractListModel {
        List hosts = new ArrayList();

        public HostsListModel() {
            this.refresh();
        }

        public void refresh() {
            this.hosts.clear();
            Map map = HostsTab.this.hostKeyVerifier.allowedHosts();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Map map2 = (Map)map.get(string);
                this.hosts.add(new HostWrapper(true, string, map2));
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public HostWrapper getHost(String string) {
            Iterator iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostWrapper hostWrapper = (HostWrapper)iterator.next();
                if (!hostWrapper.host.equals(string)) continue;
                return hostWrapper;
            }
            return null;
        }

        public int getSize() {
            return this.hosts.size();
        }

        public Object getElementAt(int n) {
            return this.hosts.get(n);
        }

        public HostWrapper getHostAt(int n) {
            return (HostWrapper)this.hosts.get(n);
        }

        public void removeHostAt(int n) {
            this.hosts.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }

        public void updateHostAt(int n) {
            this.fireContentsChanged(this, n, n);
        }
    }

    class HostWrapper {
        boolean allow;
        String host;
        SshPublicKey key;
        Map keys;

        HostWrapper(boolean bl, String string, Map map) {
            this.allow = bl;
            this.host = string;
            this.keys = map;
        }
    }

    class HostRenderer
    extends DefaultListCellRenderer {
        Icon allowIcon = new ResourceIcon("/com/sshtools/common/ui/ok.png");
        Icon denyIcon = new ResourceIcon("/com/sshtools/common/ui/cancel.png");

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            HostWrapper hostWrapper = (HostWrapper)object;
            this.setIcon(hostWrapper.allow ? this.allowIcon : this.denyIcon);
            this.setText(hostWrapper.host);
            return this;
        }
    }
}

