/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.util;

import com.sshtools.daemon.util.StringPattern;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class StringUtil {
    public static final char CH_SPACE = ' ';
    public static final char CH_NEWLINE = '\n';
    public static final char CH_CR = '\r';
    public static final char CH_TAB = '\t';
    public static final String STR_SPACE = " ";
    public static final String STR_NEWLINE = "\n";
    public static final String STR_CR = "\r";
    public static final String STR_TAB = "\t";
    private static final String WORD_DELIM = " \t\n\r";
    private static StringUtil singleton = null;

    private static StringUtil getSingleton() {
        return singleton;
    }

    private static void setSingleton(StringUtil stringUtil) {
        singleton = stringUtil;
    }

    public static StringUtil current() {
        if (StringUtil.getSingleton() == null) {
            StringUtil.setSingleton(new StringUtil());
        }
        return StringUtil.getSingleton();
    }

    public String replaceAll(String string, String string2, String string3) {
        String string4 = null;
        String string5 = "";
        int n = -1;
        int n2 = 0;
        n2 = string2.length();
        string4 = string;
        while (string4.length() > 0 && n2 > 0) {
            n = string4.indexOf(string2);
            if (n >= 0) {
                string5 = string5 + string4.substring(0, n) + string3;
                string4 = string4.substring(n + n2);
                continue;
            }
            string5 = string5 + string4;
            string4 = "";
        }
        return string5;
    }

    public String repeat(char c, int n) {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer(n);
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String[] words(String string) {
        return this.parts(string, WORD_DELIM);
    }

    public String[] parts(String string, String string2) {
        return this.parts(string, string2, false);
    }

    public String[] allParts(String string, String string2) {
        return this.parts(string, string2, true);
    }

    public String[] substrings(String string, String string2) {
        return this.substrings(string, string2, false);
    }

    public String[] allSubstrings(String string, String string2) {
        return this.substrings(string, string2, true);
    }

    public String getDelimitedSubstring(String string, String string2, String string3) {
        int n;
        int n2;
        String string4 = "";
        if (string != null && string2 != null && string3 != null && (n2 = string.indexOf(string2)) >= 0 && (n = string.indexOf(string3, n2 + 1)) > n2) {
            string4 = string.substring(n2 + 1, n);
        }
        return string4;
    }

    public String getDelimitedSubstring(String string, String string2) {
        return this.getDelimitedSubstring(string, string2, string2);
    }

    public String stackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public String leftPadCh(String string, int n, char c) {
        return this.padCh(string, n, c, true);
    }

    public String leftPad(String string, int n) {
        return this.leftPadCh(string, n, ' ');
    }

    public String leftPadCh(int n, int n2, char c) {
        return this.leftPadCh(Integer.toString(n), n2, c);
    }

    public String leftPad(int n, int n2) {
        return this.leftPadCh(n, n2, '0');
    }

    public String rightPadCh(String string, int n, char c) {
        return this.padCh(string, n, c, false);
    }

    public String rightPad(String string, int n) {
        return this.rightPadCh(string, n, ' ');
    }

    public String rightPadCh(int n, int n2, char c) {
        return this.rightPadCh(Integer.toString(n), n2, c);
    }

    public String rightPad(int n, int n2) {
        return this.rightPadCh(n, n2, ' ');
    }

    public String centerCh(String string, int n, char c) {
        String string2 = null;
        int n2 = n - string.length();
        int n3 = 0;
        if (n2 <= 0) {
            return string;
        }
        n3 = n2 / 2;
        string2 = this.rightPadCh(string, n - n3, c);
        return this.leftPadCh(string2, n, c);
    }

    public String center(String string, int n) {
        return this.centerCh(string, n, ' ');
    }

    public String[] append(String[] stringArray, String string) {
        String[] stringArray2 = new String[]{string};
        return this.append(stringArray, stringArray2);
    }

    public String[] append(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = null;
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public String[] appendIfNotThere(String[] stringArray, String string) {
        if (this.contains(stringArray, string)) {
            return stringArray;
        }
        return this.append(stringArray, string);
    }

    public String[] appendIfNotThere(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = stringArray;
        if (stringArray2 == null) {
            return stringArray3;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3 = this.appendIfNotThere(stringArray3, stringArray2[i]);
        }
        return stringArray3;
    }

    public String[] remove(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length == 0 || stringArray2.length == 0) {
            return stringArray;
        }
        return this.removeFromStringArray(stringArray, stringArray2);
    }

    public String[] remove(String[] stringArray, String string) {
        String[] stringArray2 = new String[]{string};
        return this.remove(stringArray, stringArray2);
    }

    public String[] removeNull(String[] stringArray) {
        if (stringArray == null) {
            return stringArray;
        }
        return this.removeFromStringArray(stringArray, null);
    }

    public String asString(String[] stringArray, String string) {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer(stringArray.length * 20);
        if (stringArray.length > 0) {
            stringBuffer.append(stringArray[0].toString());
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(string);
                if (stringArray[i] == null) continue;
                stringBuffer.append(stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public String asString(String[] stringArray) {
        return this.asString(stringArray, ",");
    }

    public int indexOf(String[] stringArray, StringPattern stringPattern) {
        if (stringArray == null || stringArray.length == 0) {
            return -1;
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                if (stringPattern == null) {
                    bl = true;
                }
            } else if (stringPattern != null) {
                bl = stringPattern.matches(stringArray[i]);
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String[] stringArray, String string) {
        return this.indexOfString(stringArray, string, false);
    }

    public int indexOfIgnoreCase(String[] stringArray, String string) {
        return this.indexOfString(stringArray, string, true);
    }

    public boolean contains(String[] stringArray, String string, boolean bl) {
        if (bl) {
            return this.containsIgnoreCase(stringArray, string);
        }
        return this.contains(stringArray, string);
    }

    public boolean contains(String[] stringArray, StringPattern stringPattern) {
        return this.indexOf(stringArray, stringPattern) >= 0;
    }

    public boolean contains(String[] stringArray, String string) {
        return this.indexOf(stringArray, string) >= 0;
    }

    public boolean containsIgnoreCase(String[] stringArray, String string) {
        return this.indexOfIgnoreCase(stringArray, string) >= 0;
    }

    public String[] copyFrom(String[] stringArray, int n) {
        if (stringArray == null) {
            return null;
        }
        return this.copyFrom(stringArray, n, stringArray.length - 1);
    }

    public String[] copyFrom(String[] stringArray, int n, int n2) {
        int n3;
        int n4 = n2;
        if (stringArray == null) {
            return null;
        }
        if (n4 > stringArray.length - 1) {
            n4 = stringArray.length - 1;
        }
        if ((n3 = n4 - n + 1) < 1) {
            return new String[0];
        }
        String[] stringArray2 = new String[n3];
        System.arraycopy(stringArray, n, stringArray2, 0, n3);
        return stringArray2;
    }

    public String cutTail(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public String cutHead(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public String[] splitNameValue(String string, String string2) {
        String[] stringArray = new String[]{"", ""};
        if (string != null) {
            int n = string.indexOf(string2);
            if (n > 0) {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + string2.length());
            } else {
                stringArray[0] = string;
            }
        }
        return stringArray;
    }

    public String prefix(String string, String string2) {
        return this.prefix(string, string2, true);
    }

    public String suffix(String string, String string2) {
        return this.suffix(string, string2, true);
    }

    public String upTo(String string, String string2) {
        return this.prefix(string, string2, false);
    }

    public String startingFrom(String string, String string2) {
        return this.suffix(string, string2, false);
    }

    public String reverse(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        int n = 0;
        char c = stringCharacterIterator.last();
        while (c != '\uffff') {
            cArray[n] = c;
            ++n;
            c = stringCharacterIterator.previous();
        }
        return new String(cArray);
    }

    public Map toMap(String string, String string2, String string3, Map map) {
        if (string == null) {
            return map;
        }
        Map map2 = map == null ? new Hashtable() : map;
        String string4 = string2 == null ? "," : string2;
        String string5 = string3 == null ? "=" : string3;
        String[] stringArray = this.parts(string, string4);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.splitNameValue(stringArray[i], string5);
            stringArray2[0] = stringArray2[0].trim();
            stringArray2[1] = stringArray2[1].trim();
            if (stringArray2[0].length() <= 0) continue;
            map2.put(stringArray2[0], stringArray2[1]);
        }
        return map2;
    }

    public Map asMap(String string) {
        return this.toMap(string, null, null, null);
    }

    public Map asMap(String string, String string2) {
        return this.toMap(string, string2, null, null);
    }

    public Map asMap(String string, String string2, String string3) {
        return this.toMap(string, string2, string3, null);
    }

    public Map toMap(String string, String string2, Map map) {
        return this.toMap(string, string2, null, map);
    }

    public Map toMap(String string, Map map) {
        return this.toMap(string, null, null, map);
    }

    public Properties asProperties(String string) {
        return this.toProperties(string, null);
    }

    public Properties toProperties(String string, Properties properties) {
        Properties properties2 = properties == null ? new Properties() : properties;
        return (Properties)this.toMap(string, null, null, properties2);
    }

    protected String trimSeparator(String string, String string2) {
        int n = string2.length();
        while (string.startsWith(string2)) {
            string = string.substring(string2.length());
        }
        while (string.endsWith(string2)) {
            string = string.substring(0, string.length() - n);
        }
        return string;
    }

    protected String[] parts(String string, String string2, boolean bl) {
        ArrayList arrayList = null;
        StringTokenizer stringTokenizer = null;
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        if (string.length() == 0) {
            return new String[0];
        }
        arrayList = new ArrayList();
        stringTokenizer = new StringTokenizer(string, string2, bl);
        if (bl) {
            this.collectParts(arrayList, stringTokenizer, string2);
        } else {
            this.collectParts(arrayList, stringTokenizer);
        }
        return arrayList.toArray(new String[0]);
    }

    protected void collectParts(List list, StringTokenizer stringTokenizer) {
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
    }

    protected void collectParts(List list, StringTokenizer stringTokenizer, String string) {
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string.indexOf(string2) >= 0) {
                if (bl) {
                    list.add("");
                }
                bl = true;
                continue;
            }
            list.add(string2);
            bl = false;
        }
    }

    protected String[] substrings(String string, String string2, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string3 = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return new String[0];
        }
        if (string2 == null || string2.length() == 0) {
            if (string.length() == 0) {
                return new String[0];
            }
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        if (!bl) {
            string3 = this.trimSeparator(string, string2);
        }
        if ((n4 = string3.length()) > 0) {
            n3 = string2.length();
            n = string3.indexOf(string2, n2);
            while (n >= 0) {
                if (bl) {
                    if (n > 0) {
                        arrayList.add(string3.substring(n2, n));
                    }
                } else if (n > n2 + n3) {
                    arrayList.add(string3.substring(n2, n));
                }
                n2 = n + n3;
                n = string3.indexOf(string2, n2);
            }
            if (n2 < n4) {
                arrayList.add(string3.substring(n2));
            }
        }
        return arrayList.toArray(new String[0]);
    }

    protected String padCh(String string, int n, char c, boolean bl) {
        StringBuffer stringBuffer = null;
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        stringBuffer = new StringBuffer(n);
        if (!bl) {
            stringBuffer.append(string);
        }
        for (int i = 1; i <= n2; ++i) {
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected int indexOfString(String[] stringArray, String string, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return -1;
        }
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                if (string == null) {
                    bl2 = true;
                }
            } else {
                bl2 = bl ? stringArray[i].equalsIgnoreCase(string) : stringArray[i].equals(string);
            }
            if (!bl2) continue;
            return i;
        }
        return -1;
    }

    protected String prefix(String string, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return bl ? null : string;
        }
        int n = string.indexOf(string2);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return bl ? null : string;
    }

    protected String suffix(String string, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return bl ? null : string;
        }
        int n = string.indexOf(string2);
        if (n >= 0) {
            return string.substring(n + string2.length());
        }
        return bl ? null : string;
    }

    protected String[] removeFromStringArray(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            if (stringArray2 == null) {
                bl = stringArray[i] != null;
            } else {
                boolean bl2 = bl = !this.contains(stringArray2, stringArray[i]);
            }
            if (!bl) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

