/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import javax.crypto.spec.DESKeySpec;

public class DESedeKeySpec
implements KeySpec {
    public static final int DES_EDE_KEY_LEN = 24;
    private byte[] keyBytes = new byte[24];

    public DESedeKeySpec(byte[] byArray) throws InvalidKeyException {
        if (byArray.length < 24) {
            throw new InvalidKeyException("DESede key material too short in construction");
        }
        System.arraycopy(byArray, 0, this.keyBytes, 0, this.keyBytes.length);
    }

    public DESedeKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 24) {
            throw new InvalidKeyException("DESede key material too short in construction");
        }
        System.arraycopy(byArray, 0, this.keyBytes, 0, this.keyBytes.length);
    }

    public byte[] getKey() {
        byte[] byArray = new byte[24];
        System.arraycopy(this.keyBytes, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 24) {
            throw new InvalidKeyException("key material too short in DESedeKeySpec.isParityAdjusted");
        }
        return DESKeySpec.isParityAdjusted(byArray, n) && DESKeySpec.isParityAdjusted(byArray, n + 8) && DESKeySpec.isParityAdjusted(byArray, n + 16);
    }
}

