#
# OpenWatcom makefile for SSH2DOS (real mode - large)
#

#   Where is your compiler installed?
COMPPATH=c:\watcom

# Where is WATT32?
WATT32=c:\watt32

# Debug
DEBUG=-d2

# uncomment this for B&W mode
COLOR = -DCOLOR

#################################################################
# In normal cases, no other settings should be changed below!!! #
#################################################################

CC = wcc
LINKER = wlink

CFLAGS = -ml -0 -fpi -zt -bt=dos -s $(DEBUG) -i=$(COMPPATH)\h;include;$(WATT32)\inc $(COLOR) -DSSH2

.C.OBJ:	
        $(CC) $(CFLAGS) $[@

LIBS = lib\misc.lib lib\crypto.lib lib\ssh.lib lib\vt100.lib lib\wattcpwl.lib lib\zlib.lib

all:    ssh2dos.exe sftpdos.exe scp2dos.exe

ssh2dos.exe : ssh2dos.obj $(LIBS)
	$(LINKER) @ssh2dos.lnk

sftpdos.exe : sftpdos.obj sftp.obj $(LIBS)
	$(LINKER) @sftpdos.lnk

scp2dos.exe : scpdos.obj $(LIBS)
	$(LINKER) @scp2dos.lnk

lib\crypto.lib: sshrsa.obj sshdes.obj sshmd5.obj sshbn.obj sshpubk.obj int64.obj sshaes.obj  sshsha.obj sshsh512.obj sshdss.obj
	wlib -b -c lib\crypto.lib -+sshrsa.obj -+sshdes.obj -+sshmd5.obj -+sshbn.obj -+sshpubk.obj
	wlib -b -c lib\crypto.lib -+int64.obj -+sshaes.obj -+sshsha.obj -+sshsh512.obj -+sshdss.obj

lib\ssh.lib: negotiat.obj transprt.obj auth.obj channel.obj
	wlib -b -c lib\ssh.lib -+negotiat.obj -+transprt.obj -+auth.obj -+channel.obj

lib\vt100.lib: vttio.obj vidio.obj keyio.obj keymap.obj
	wlib -b -c lib\vt100.lib -+vttio.obj -+vidio.obj -+keyio.obj -+keymap.obj

lib\misc.lib: xmalloc.obj common.obj shell.obj
	wlib -b -c lib\misc.lib -+xmalloc.obj -+common.obj -+shell.obj

clean: .SYMBOLIC
	del *.obj
	del lib\vt100.lib
	del lib\crypto.lib
	del lib\misc.lib
	del lib\ssh.lib
	del ssh2dos.exe
	del scp2dos.exe
	del sftpdos.exe
