#
#   DJGPP makefile for SSH2DOS
#

# remove -DCOLOR for B&W mode
CFLAGS	      = -O6 -malign-jumps=2 -malign-loops=2 -malign-functions=2 \
		-fno-strength-reduce -ffast-math -I./include -Wall -DCOLOR

#which command to use to delete a file
RM=del
#RM=rm -f

#################################################################
# In normal cases, no other settings should be changed below!!! #
#################################################################


LDFLAGS	      =

LINKER	      = gcc

all:		ssh2d386.exe sftp386.exe

ssh2d386.exe:	ssh2dos.o sshzlib.o lib/libwatt.a lib/libvt100.a lib/libssh2.a lib/libcrypt.a
		@echo "Linking ssh2d386 ... "
		@$(LINKER) $(LDFLAGS) -o ssh2d386.exe ssh2dos.o sshzlib.o lib/libwatt.a lib/libvt100.a lib/libssh2.a lib/libcrypt.a
		@echo "done"

sftp386.exe:	sftpdos.o sshzlib.o sftp.o int64.o lib/libwatt.a lib/libvt100.a lib/libssh2.a lib/libcrypt.a
		@echo "Linking sftp386 ... "
		@$(LINKER) $(LDFLAGS) -o sftp386.exe sftpdos.o sshzlib.o sftp.o int64.o keyio.o lib/libwatt.a lib/libvt100.a lib/libssh2.a lib/libcrypt.a

lib/libvt100.a:	vttio.o vidio.o keyio.o keymap.o
		ar rs lib/libvt100.a vttio.o vidio.o keyio.o keymap.o

lib/libssh2.a:	transprt.o auth.o channel.o negotiat.o
		ar rs lib/libssh2.a transprt.o auth.o channel.o negotiat.o

lib/libcrypt.a:	sshbn.o sshaes.o sshdes.o sshmd5.o sshsha.o sshsh512.o int64.o sshrsa.o sshdss.o sshpubk.o
		ar rs lib/libcrypt.a sshbn.o sshaes.o sshdes.o sshmd5.o sshsha.o sshsh512.o int64.o sshrsa.o sshdss.o sshpubk.o

clean:
		$(RM) *.o
		$(RM) ssh2d386.exe
		$(RM) sftp386.exe
		$(RM) lib\libvt100.a
		$(RM) lib\libssh2.a
		$(RM) lib\libcrypt.a
