#ifndef _BN_H
#define _BN_H

/* Bignum functions */

typedef unsigned short *Bignum;

unsigned short ssh1_read_bignum(unsigned char *, Bignum *);
unsigned short ssh1_bignum_length(Bignum);
unsigned short ssh1_write_bignum(void *, Bignum);
Bignum modpow(Bignum, Bignum, Bignum);
Bignum modmul(Bignum, Bignum, Bignum);
Bignum bigmul(Bignum, Bignum);
Bignum bignum_from_bytes(unsigned char *, unsigned short);
Bignum copybn(Bignum);
unsigned short bignum_bitcount(Bignum);
unsigned char bignum_byte(Bignum, unsigned short);
short bignum_cmp(Bignum, Bignum);
void decbn(Bignum);
void freebn(Bignum);

Bignum bignum_bitmask(Bignum);
Bignum bignum_rshift(Bignum, unsigned short);
Bignum modinv(Bignum, Bignum);
Bignum bn_power_2(unsigned short);
Bignum bigmod(Bignum, Bignum);
Bignum bigmuladd(Bignum, Bignum, Bignum);
void bignum_set_bit(Bignum, unsigned short, unsigned short);


#endif
