#ifndef _TRANSPRT_H
#define _TRANSPRT_H

/* Packet structure */
struct Packet {
    unsigned long length;	/* body length */
    unsigned long maxlen;	/* max length */
    unsigned char type;		/* packet type */
    unsigned char *whole;	/* pointer to whole packet */
    unsigned char *body;	/* pointer to useful data */
    unsigned char *ptr;		/* sliding pointer in body */
};

/* Initialize important variables */
void SSH2_init(void);

/* request compression from server */
void Request_Compression(int);

#ifdef __TURBOC__
/* free compression memory */
void Disable_Compression(void);
#endif

/* get a packet from the transport layer */
short SSH2_pkt_read(unsigned char);

/* create header for raw outgoing packet */
void SSH2_pkt_init(unsigned char);

/* create outgoing packet */
void SSH2_pkt_send(void);

/* SSH2 packet assembly */
void SSH2_putuint32(unsigned long);
void SSH2_putbool(unsigned char);
void SSH2_putstring(unsigned char *);
void SSH2_putdata(unsigned char *, unsigned short);
unsigned short SSH2_putmp(unsigned short *);

/* SSH2 packet disassembly */
unsigned long SSH2_getuint32(void);
unsigned int SSH2_getbool(void);
unsigned short *SSH2_getmp(void);
void SSH2_getstring(char **, unsigned long *);

/* SSH2 disconnect */
void SSH2_Disconnect(unsigned long, char *);

#endif
