#ifndef _TRANSPRT_H
#define _TRANSPRT_H

/* Packet structure */

typedef struct {
    unsigned long length;	/* type + body length */
    unsigned long maxlen;	/* max length */
    unsigned char type;		/* packet type */
    char *whole;		/* pointer to whole packet */
    char *body;			/* pointer to useful data */
    char *ptr;			/* sliding pointer in body */
} Packet;

/* request compression from server */
extern void Request_Compression(int);

#ifdef __LARGE__
/* free compression memory */
extern void Disable_Compression(void);
#endif

/* get a packet from the transport layer */
extern void SSH1_Pkt_Read(unsigned char);
extern void SSH1_Pkt_Read_SucFail(void);

/* create header for raw outgoing packet */
extern void SSH1_pkt_init(unsigned char);

/* create outgoing packet */
extern void SSH1_pkt_send(void);

/* SSH1 packet assembly */
extern void SSH1_putuint32(unsigned long);
extern void SSH1_putbool(char);
extern void SSH1_putstring(char *);
extern void SSH1_putdata(char *, unsigned short);
extern void SSH1_putbn(unsigned short *);

extern void SendSSHPacket(char *, unsigned short);

/* SSH1 disconnect */
extern void SSH1_Disconnect(const char *fmt, ...);

#endif
