#ifndef _PROTOCOL_H
#define _PROTOCOL_H

/* Protocol data prototypes */

struct Packet {
    long length;	/* useful data length */
    int type;		/* packet type */
    unsigned long crc;		/* CRC */
    unsigned char *data;	/* pointer to packet */
    unsigned char *body;	/* pointer to useful data length */
    long maxlen;
};

/* request compression from server */
void RequestCompression(int);

/* clean up compression structures */
void UninitCompression(void);

/* get a packet with blocking */
int packet_read_block(void);

/* expect a packet type */
void packet_read_expect(int);

/* create header for raw outgoing packet */
void s_wrpkt_start(int, int);

/* create outgoing packet */
void s_wrpkt(void);

/* read and convert raw, encrypted packet to readable structure */
void ssh_gotdata(void);

#endif
