/* Blowfish cipher structures and functions */

typedef struct {
    unsigned long S0[256], S1[256], S2[256], S3[256], P[18];
    unsigned long biv0, biv1;		       /* for CBC mode */
} BlowfishContext;

#define SSH_SESSION_KEY_LENGTH	32

void blowfish_setkey(BlowfishContext *ctx,
                            const unsigned char *key, short keybytes);

void blowfish_encrypt_cbc(unsigned char *blk, int len,
                                 BlowfishContext *ctx);

void blowfish_decrypt_cbc(unsigned char *blk, int len,
				 BlowfishContext *ctx);
                                 