/* scpdos.c       Copyright (c) 2000-2002 Nagy Daniel
 *
 * $Date: 2002/02/11 18:15:17 $
 * $Revision: 1.7 $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version, with the
 * additional permission that it may be linked against Erick Engelke's
 * WATTCP source code and Jerry Joplin's CVT100 source code.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <io.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdarg.h> 
#include <sys/stat.h>

#ifdef __DJGPP__
#include "include/tcp_djgp.h"
#elif __TURBOC__
#include "include/tcp.h"
#endif

#include "include/ssh.h"
#include "include/protocol.h"
#include "include/des.h"
#include "include/blowfish.h"
#include "include/version.h"

/* connect to the remote host */
int connectssh(unsigned char *remotehost);

extern struct Packet pktin;
extern struct Packet pktout;
extern unsigned char *inbuf;
extern int cipher_type;         /* type of cipher */
extern int ssh_port;		/* SSH port of server */
extern char privileged;

char debug=0;
char verbose=0;
FILE *fileptr=NULL;

tcp_Socket s;           /* socket */
int status;             /* status of communication */
unsigned char username[20];
unsigned char password[20];
short passwdcmd=0;      /* password from command line? */

unsigned char *remotehost, *remotefile, *localfile;
char command[512];

unsigned long FileSize=0;         /* size of file we are sending */
FILE *fr;               /* local file we are reading */
unsigned long UpTo=0;             /* how much we have sent so far */
int remote, local;      /* Pointers to local and remote files */

#define write_buffer_size 16384
unsigned char *write_buffer=NULL;

unsigned long Getfilesize(char *s)
{
struct stat ss;

stat(s, &ss);
return(ss.st_size);
}

/* fatal error handler */
void fatal(const char *fmt, ...)
{
va_list ap;
char buf[1024];

  va_start(ap, fmt);
  vsprintf(buf, fmt, ap);
  va_end(ap);
  fprintf(stderr, "%s\n", buf);
  if(fileptr!=NULL) fclose(fileptr);
  if(fr!=NULL) fclose(fr);
  if(inbuf!=NULL) free(inbuf);
  if(write_buffer!=NULL) free(write_buffer);
  sock_close(&s);
  exit(255);
}

static int proggy=0;

void writedata(void)
{
unsigned long len;
char *Progress[4]={"\b|","\b/","\b","\b\\"};

if (UpTo==FileSize)
   {
     s_wrpkt_start(SSH_CMSG_EOF, 0);
     s_wrpkt();
   }
else
   {
   memset(write_buffer, 0, write_buffer_size);

   if ((FileSize-UpTo)>write_buffer_size)
      len=write_buffer_size;
   else
      len=(FileSize-UpTo);

   UpTo=UpTo+len;

   fread(write_buffer, len, 1, fr);

   s_wrpkt_start(SSH_CMSG_STDIN_DATA, len + 4);
   pktout.body[0] = pktout.body[1] = 0;
   pktout.body[2] = (len >> 8) & 0xFF;
   pktout.body[3] = len & 0xFF;
   memcpy(pktout.body+4, write_buffer, len);
   s_wrpkt();

   fprintf(stderr,"%s",Progress[++proggy%4]);
   }
}


int sendfile(void)
{
int len,i;

writedata();

	sock_tick(&s, &status); /* TCP wait */
	len=sock_fastread(&s,inbuf,4); /* Read some data */
	if(!len) return(0); /* Begin loop again if none */
	for (i = len = 0; i < 4; i++) len = (len << 8) + inbuf[i]; /* Get packet size */
	sock_read(&s,inbuf+4,len + 8 - (len%8)); /* Read it */
	ssh_gotdata(inbuf); /* uncrypt and get valuable data */

	switch(pktin.type) {
		case SSH_SMSG_STDOUT_DATA:
			{
			pktin.body[pktin.length-1]=0;
			cprintf("\n\r%s\r", pktin.body+4);
			break;
			}
		case SSH_SMSG_STDERR_DATA:
			{
			pktin.body[pktin.length-1]=0;
			cprintf("\n\r%s\r", pktin.body+4);
			fatal("Aborting...");
			}
		case SSH_SMSG_EXITSTATUS:
			{
			s_wrpkt_start(SSH_CMSG_EXIT_CONFIRMATION,0);
			s_wrpkt();
			return(EXIT_SSH);
			}
		case SSH_MSG_DISCONNECT:
			{
			 /* Connection reset by other party */
			pktin.body[pktin.length+4]=0;
			cputs(pktin.body+4);
			return(EXIT_SSH);
			}
		case    SSH_SMSG_SUCCESS:
			{
			break;
			}
		default:
			{
			cprintf("Unsupported packet received. Type: %d\n\r",pktin.type);
			return(0);
			}
		}
return(0);

sock_err:
  switch (status)
  {
    case 1 : cputs ("Connection closed\n\r");
	     break;
    case -1: cputs ("REMOTE HOST CLOSED CONNECTION\n\r");
	     break;
  }
  return(EXIT_SSH);

}


void sendcommand(void)
{
int len;
	s_wrpkt_start(13, (len = strlen(command)) + 4);
	pktout.body[0] = pktout.body[1] = 0;
	pktout.body[2] = (len >> 8) & 0xFF;
	pktout.body[3] = len & 0xFF;            /* up to 32k of string */
	memcpy(pktout.body+4, command, len);
	s_wrpkt();
}

/* Client loop. This runs until SSH connection is terminated */
int getfile(void)
{
int len,i;

	sock_tick(&s, &status); /* TCP wait */
	len=sock_fastread(&s,inbuf,4); /* Read some data */
	if(!len) return(0); /* Begin loop again if none */
	for (i = len = 0; i < 4; i++) len = (len << 8) + inbuf[i]; /* Get packet size */
	sock_read(&s,inbuf+4,len + 8 - (len%8)); /* Read it */
	ssh_gotdata(inbuf); /* uncrypt and get valuable data */

	switch(pktin.type) {
		case SSH_SMSG_STDOUT_DATA:
			{
			if((len=fwrite(pktin.body+4, pktin.length-5, 1, fileptr))
				!=1) fatal ("\nWrite error");
			putch('#');
			break;
			}
		case SSH_SMSG_STDERR_DATA:
			{
			pktin.body[pktin.length-1]=0;
			cprintf("\n\r%s\r", pktin.body+4);
			fatal("Aborting...");
			}
		case SSH_SMSG_EXITSTATUS:
			{
			s_wrpkt_start(SSH_CMSG_EXIT_CONFIRMATION,0);
			s_wrpkt();
			return(EXIT_SSH);
			}
		case SSH_MSG_DISCONNECT:
			{
			 /* Connection reset by other party */
			pktin.body[pktin.length+4]=0;
			cputs(pktin.body+4);
			return(EXIT_SSH);
			}
		case    SSH_SMSG_SUCCESS:
			{
			break;
			}
		default:
			{
			cprintf("Unsupported packet received. Type: %d\n\r",pktin.type);
			return(0);
			}
		}
return(0);

sock_err:
  switch (status)
  {
    case 1 : cputs ("Connection closed\n\r");
	     break;
    case -1: cputs ("REMOTE HOST CLOSED CONNECTION\n\r");
	     break;
  }
  return(EXIT_SSH);

}


/* Get command line arguments */

void getargs(int argc, char *argv[])
{
int i, len, pos1,pos2;
char *s;
char *usage="Usage: scpdos [options] from to\n"
	    "Options:\n"
            "from <username@remotehost:remotefile|localfile>\n"
            "to <username@remotehost:remotefile|localfile>\n"
	    "-c <3des|blowfish>     - cipher type\n"
	    "-p <port number>       - remote port\n"
	    "-P                     - use non privileged local port\n"
	    "-s                     - remote password\n"
	    "-v                     - verbose output\n"
	    "Default is 3des cipher.";

    for (i = 1; i < argc; ++i)
    {
	s = argv[i];
	if (*s != '-') break;
	switch (*++s)
	{
	case '\0':
	    fatal(usage);
	    return;

	case 'c':
	    if (*++s)
		{
		 if(!strcmp(s,"3des")) cipher_type = SSH_CIPHER_3DES;
		 else if(!strcmp(s,"blowfish")) cipher_type = SSH_CIPHER_BLOWFISH;
		 else fatal(usage);
		}
	    else if (++i < argc)
		{
		if(!strcmp(argv[i],"3des")) cipher_type = SSH_CIPHER_3DES;
		else if(!strcmp(argv[i],"blowfish")) cipher_type = SSH_CIPHER_BLOWFISH;
		else fatal(usage);
		}
	    else
		fatal(usage);
	    continue;

	case 'p':
	    if (*++s)
		 ssh_port = atoi(s);
	    else if (++i < argc)
		ssh_port = atoi(argv[i]);
	    else
		fatal(usage);
	    continue;

	case 'P':
	    privileged=0;
	    continue;

	case 's':
	    passwdcmd=1;
	    if (*++s) strncpy(password,s,20);
	    else if (++i < argc) strncpy(password,argv[i],20);
	    else
		fatal(usage);
	    continue;

	case 'v':
	    verbose=1;
	    continue;

	default:
	    fatal(usage);
	} /* end switch */

    }

no_more_options:;
    if (i + 2 != argc) fatal(usage);

/* Try and work out which file is remote and which file is local 
 * 
 * Works on the assumption that the "remote file" has to have a
 * "@" and a":" character.
 */

pos1=1;pos2=1;
if (strchr(argv[i],'@')==NULL || strchr(argv[i],':')==NULL) pos1=0;
if (strchr(argv[i+1],'@')==NULL || strchr(argv[i+1],':')==NULL) pos2=0;

if ((pos1==0)&&(pos2==0))
   {
   fatal("Error - both files seem to be local files.\n");
   }
else if ((pos1==1)&&(pos2==1))
   {
   fatal("Error - both files seem to be remote files.\n");
   }
else if (pos1==1)
   {
    remote=i;
    local=i+1;
   }
else
   {
    remote=i+1;
    local=i;
   }

    strncpy(username,argv[remote],20);
    remotehost = argv[remote];
    localfile = argv[local];

    i=0; len=20;
    while(username[i] !='@' && len>0)
	{
	i++; remotehost++; len--;
	}
    username[i]=0;
    remotehost++;

    remotefile = remotehost;

    len=strlen(remotehost);
    while(*remotefile != ':' && len>0)
	{
	remotefile++; len--;
	}
    if(len==0) fatal(usage);
    *remotefile=0;
    remotefile++;

if (remote>local) /* Test to see which way we are transferring files */
   {
    if (access(localfile, 0)==0)
       {
	FileSize=Getfilesize(localfile);
	if((fr=fopen(localfile,"rb"))==NULL) fatal("Error opening local file.\n");
       }
    else
       {
	fatal("Error - could not find local file.\n");
       }
    strcat(command, "cat >");
   } 
else
   {
    strcat(command, "cat ");
   }

 strcat(command, remotefile);

}



/* main program */
int main(int argc, char **argv)
{
int ch;

    cprintf("SCPDOS v%s\n\r", SSH_VERSION);

    if( ((inbuf=malloc(INBUF_SIZE))==NULL) ||
        ((write_buffer=malloc(write_buffer_size))==NULL) ) fatal("Not enough memory");

/* Do some preinitializations */

    memset(username,0,20);
    memset(password,0,20);

    getargs(argc, argv);

/* Initalizations */

    srand (time(NULL)); /* Initialize random number generator */

    if(connectssh(remotehost)) fatal("Connection error"); /* Connect to remote server */


#ifdef __DJGPP__
    tcp_cbreak(1);      /* No Break checking under DJGPP */
#endif


if (local>remote)  /* check which way we are transferring */
  { /* transferring from remote to local */

   if((fileptr=fopen(localfile,"r"))==NULL)
	{
	if((fileptr=fopen(localfile,"wb"))==NULL)
		fatal("Cannot create localfile");
	}
   else
	{
	cprintf("Local file exists. Overwrite? (Y/N)\n\r");
	if((ch=getch())=='y')
		{
		if((fileptr=fopen(localfile,"wb"))==NULL)
			fatal("Cannot create localfile");
		}
	else fileptr=NULL;
	}

	   cprintf("Receiving file: ");
	   sendcommand();
	   /* get the file */
	   while(EXIT_SSH!=getfile());

  }
else   /* transferring from local to remote */
  {
	   fprintf(stderr,"Sending file (%lu bytes):  ",FileSize);
	   sendcommand();
	   /* send the file */
	   while(EXIT_SSH!=sendfile());
	   fclose(fr);
  }

free(inbuf);
free(write_buffer);

/* Close TCP socket */

sock_close(&s);
return(0);

sock_err:
  switch (status)
  {
    case 1 : cputs ("Connection closed\n\r");
	     break;
    case -1: cputs ("REMOTE HOST CLOSED CONNECTION\n\r");
	     break;
  }
  if(fileptr!=NULL) fclose(fileptr);
  if(inbuf!=NULL) free(inbuf);
  if(write_buffer!=NULL) free(write_buffer);
  return(1);
}

