/************************************************************************
 * $Id: minibidi.h,v 1.1 2004/05/22 10:36:50 simon Exp $
 *
 * ------------
 * Description:
 * ------------
 * This is an implemention of Unicode's Bidirectional Algorithm
 * (known as UAX #9).
 *
 *   http://www.unicode.org/reports/tr9/
 * 
 * Author: Ahmad Khalifa
 *
 * -----------------
 * Revision Details:    (Updated by Revision Control System)
 * -----------------
 *  $Date: 2004/05/22 10:36:50 $
 *  $Author: simon $
 *  $Revision: 1.1 $
 *  $Source: /home/cvs/putty/minibidi.h,v $
 *
 * (www.arabeyes.org - under MIT license)
 *
 ************************************************************************/

/*
 * TODO:
 * =====
 * - work almost finished
 * - Shaping Table to be expanded to include the whole range.
 * - Ligature handling
 */

#include <stdlib.h>	/* definition of wchar_t*/

#define LMASK	0x3F	/* Embedding Level mask */
#define OMASK	0xC0	/* Override mask */
#define OISL	0x80	/* Override is L */
#define OISR	0x40	/* Override is R */

/* Shaping Helpers */
#define STYPE(xh) (((xh >= SHAPE_FIRST) && (xh <= SHAPE_LAST)) ? \
shapetypes[xh-SHAPE_FIRST].type : SU) /*))*/
#define SISOLATED(xh) (shapetypes[xh-SHAPE_FIRST].form_b)
#define SFINAL(xh) xh+1
#define SINITIAL(xh) xh+2
#define SMEDIAL(ch) ch+3

typedef struct bidi_char {
    wchar_t origwc, wc;
    unsigned short index;
} bidi_char;

/* function declarations */
void flipThisRun(bidi_char *from, unsigned char* level, int max, int count);
int findIndexOfRun(unsigned char* level , int start, int count, int tlevel);
unsigned char getType(wchar_t ch);
unsigned char setOverrideBits(unsigned char level, unsigned char override);
unsigned char getPreviousLevel(unsigned char* level, int from);
unsigned char leastGreaterOdd(unsigned char x);
unsigned char leastGreaterEven(unsigned char x);
unsigned char getRLE(wchar_t ch);
int do_shape(bidi_char *line, bidi_char *to, int count);
int do_bidi(bidi_char *line, int count);
void doMirror(wchar_t* ch);

/* character types */
enum
{
   L,
   LRE,
   LRO,
   R,
   AL,
   RLE,
   RLO,
   PDF,
   EN,
   ES,
   ET,
   AN,
   CS,
   NSM,
   BN,
   B,
   S,
   WS,
   ON,
};

/* Shaping Types */
enum
{
	SL, /* Left-Joining, doesnt exist in U+0600 - U+06FF */
	SR, /* Right-Joining, ie has Isolated, Final */
	SD, /* Dual-Joining, ie has Isolated, Final, Initial, Medial */
	SU, /* Non-Joining */
	SC  /* Join-Causing, like U+0640 (TATWEEL) */
};

typedef struct{
	char type;
	wchar_t form_b;
} shape_node;

/* Kept near the actual table, for verification. */
#define SHAPE_FIRST 0x621
#define SHAPE_LAST 0x64A

const shape_node shapetypes[] = {
/* index, Typ, Iso, Ligature Index*/
/* 621 */ {SU, 0xFE80},
/* 622 */ {SR, 0xFE81},
/* 623 */ {SR, 0xFE83},
/* 624 */ {SR, 0xFE85},
/* 625 */ {SR, 0xFE87},
/* 626 */ {SD, 0xFE89},
/* 627 */ {SR, 0xFE8D},
/* 628 */ {SD, 0xFE8F},
/* 629 */ {SR, 0xFE93},
/* 62A */ {SD, 0xFE95},
/* 62B */ {SD, 0xFE99},
/* 62C */ {SD, 0xFE9D},
/* 62D */ {SD, 0xFEA1},
/* 62E */ {SD, 0xFEA5},
/* 62F */ {SR, 0xFEA9},
/* 630 */ {SR, 0xFEAB},
/* 631 */ {SR, 0xFEAD},
/* 632 */ {SR, 0xFEAF},
/* 633 */ {SD, 0xFEB1},
/* 634 */ {SD, 0xFEB5},
/* 635 */ {SD, 0xFEB9},
/* 636 */ {SD, 0xFEBD},
/* 637 */ {SD, 0xFEC1},
/* 638 */ {SD, 0xFEC5},
/* 639 */ {SD, 0xFEC9},
/* 63A */ {SD, 0xFECD},
/* 63B */ {SU, 0x0},
/* 63C */ {SU, 0x0},
/* 63D */ {SU, 0x0},
/* 63E */ {SU, 0x0},
/* 63F */ {SU, 0x0},
/* 640 */ {SC, 0x0},
/* 641 */ {SD, 0xFED1},
/* 642 */ {SD, 0xFED5},
/* 643 */ {SD, 0xFED9},
/* 644 */ {SD, 0xFEDD},
/* 645 */ {SD, 0xFEE1},
/* 646 */ {SD, 0xFEE5},
/* 647 */ {SD, 0xFEE9},
/* 648 */ {SR, 0xFEED},
/* 649 */ {SR, 0xFEEF}, /* SD */
/* 64A */ {SD, 0xFEF1},
};

/*
 * This describes the data byte and its frequency  
 */
typedef struct
{
   unsigned char f;
   unsigned char d;
}RLENode;


/* This is an array of RLENodes, which is the
 * Compressed unicode types table
 */
const unsigned char RLE_table[] =
{
   0x09, 0x10, 0x01, 0x0F, 0x01, 0x10, 0x01, 0x11,
   0x01, 0x0F, 0x01, 0x0E, 0x0E, 0x0F, 0x03, 0x10,
   0x01, 0x11, 0x01, 0x12, 0x02, 0x0A, 0x03, 0x12,
   0x05, 0x0A, 0x01, 0x0C, 0x01, 0x0A, 0x01, 0x0C,
   0x01, 0x09, 0x01, 0x08, 0x0A, 0x0C, 0x01, 0x12,
   0x06, 0x00, 0x1A, 0x12, 0x06, 0x00, 0x1A, 0x12,
   0x04, 0x0E, 0x06, 0x0F, 0x01, 0x0E, 0x1A, 0x0C,
   0x01, 0x12, 0x01, 0x0A, 0x04, 0x12, 0x04, 0x00,
   0x01, 0x12, 0x05, 0x0A, 0x02, 0x08, 0x02, 0x12,
   0x01, 0x00, 0x01, 0x12, 0x03, 0x08, 0x01, 0x00,
   0x01, 0x12, 0x05, 0x00, 0x17, 0x12, 0x01, 0x00,
   0x1F, 0x12, 0x01, 0x00, 0xFF, 0x00, 0x2A, 0x12,
   0x01, 0x00, 0x12, 0x12, 0x1C, 0x00, 0x5E, 0x12,
   0x02, 0x00, 0x09, 0x12, 0x02, 0x00, 0x07, 0x12,
   0x0E, 0x00, 0x02, 0x12, 0x0E, 0x00, 0x05, 0x12,
   0x09, 0x00, 0x01, 0x12, 0x11, 0x0D, 0x50, 0x12,
   0x10, 0x0D, 0x10, 0x12, 0x0A, 0x00, 0x01, 0x12,
   0x0B, 0x00, 0x01, 0x12, 0x01, 0x00, 0x03, 0x12,
   0x01, 0x00, 0x01, 0x12, 0x01, 0x00, 0x14, 0x12,
   0x01, 0x00, 0x2C, 0x12, 0x01, 0x00, 0x26, 0x12,
   0x0A, 0x00, 0x83, 0x0D, 0x04, 0x12, 0x01, 0x0D,
   0x02, 0x00, 0x45, 0x12, 0x01, 0x00, 0x26, 0x12,
   0x02, 0x00, 0x02, 0x12, 0x06, 0x00, 0x10, 0x12,
   0x21, 0x00, 0x26, 0x12, 0x02, 0x00, 0x07, 0x12,
   0x01, 0x00, 0x27, 0x12, 0x01, 0x00, 0x01, 0x12,
   0x07, 0x0D, 0x11, 0x12, 0x01, 0x0D, 0x17, 0x12,
   0x01, 0x0D, 0x03, 0x03, 0x01, 0x0D, 0x01, 0x03,
   0x01, 0x0D, 0x02, 0x03, 0x01, 0x0D, 0x01, 0x12,
   0x0B, 0x03, 0x1B, 0x12, 0x05, 0x03, 0x05, 0x12,
   0x17, 0x0C, 0x01, 0x12, 0x0E, 0x04, 0x01, 0x12,
   0x03, 0x04, 0x01, 0x12, 0x01, 0x04, 0x1A, 0x12,
   0x05, 0x04, 0x0B, 0x0D, 0x0B, 0x12, 0x0A, 0x0B,
   0x0A, 0x0A, 0x01, 0x0B, 0x02, 0x04, 0x03, 0x0D,
   0x01, 0x04, 0x65, 0x0D, 0x07, 0x04, 0x01, 0x0D,
   0x07, 0x04, 0x02, 0x0D, 0x02, 0x12, 0x01, 0x0D,
   0x04, 0x12, 0x02, 0x08, 0x0A, 0x04, 0x05, 0x12,
   0x01, 0x04, 0x0E, 0x12, 0x01, 0x0E, 0x01, 0x04,
   0x01, 0x0D, 0x01, 0x04, 0x1B, 0x12, 0x03, 0x0D,
   0x1B, 0x12, 0x35, 0x04, 0x26, 0x0D, 0x0B, 0x04,
   0x01, 0x12, 0xFF, 0x12, 0x50, 0x0D, 0x02, 0x00,
   0x01, 0x12, 0x01, 0x00, 0x35, 0x12, 0x02, 0x0D,
   0x01, 0x00, 0x04, 0x0D, 0x08, 0x00, 0x04, 0x0D,
   0x01, 0x12, 0x02, 0x00, 0x01, 0x0D, 0x04, 0x12,
   0x03, 0x00, 0x0A, 0x0D, 0x02, 0x00, 0x0D, 0x12,
   0x10, 0x0D, 0x01, 0x00, 0x02, 0x12, 0x01, 0x00,
   0x08, 0x12, 0x02, 0x00, 0x02, 0x12, 0x02, 0x00,
   0x16, 0x12, 0x01, 0x00, 0x07, 0x12, 0x01, 0x00,
   0x01, 0x12, 0x03, 0x00, 0x04, 0x12, 0x02, 0x0D,
   0x01, 0x12, 0x01, 0x00, 0x03, 0x0D, 0x04, 0x12,
   0x02, 0x00, 0x02, 0x12, 0x02, 0x00, 0x02, 0x0D,
   0x01, 0x12, 0x09, 0x00, 0x01, 0x12, 0x04, 0x00,
   0x02, 0x12, 0x01, 0x00, 0x03, 0x0D, 0x02, 0x12,
   0x02, 0x00, 0x0C, 0x0A, 0x02, 0x00, 0x07, 0x12,
   0x07, 0x0D, 0x01, 0x12, 0x02, 0x00, 0x06, 0x12,
   0x04, 0x00, 0x02, 0x12, 0x02, 0x00, 0x16, 0x12,
   0x01, 0x00, 0x07, 0x12, 0x01, 0x00, 0x02, 0x12,
   0x01, 0x00, 0x02, 0x12, 0x01, 0x00, 0x02, 0x12,
   0x02, 0x0D, 0x01, 0x12, 0x01, 0x00, 0x03, 0x0D,
   0x02, 0x12, 0x04, 0x0D, 0x02, 0x12, 0x02, 0x0D,
   0x03, 0x12, 0x0B, 0x00, 0x04, 0x12, 0x01, 0x00,
   0x01, 0x12, 0x07, 0x00, 0x0A, 0x0D, 0x02, 0x00,
   0x03, 0x12, 0x0C, 0x0D, 0x02, 0x00, 0x01, 0x12,
   0x01, 0x00, 0x07, 0x12, 0x01, 0x00, 0x01, 0x12,
   0x01, 0x00, 0x03, 0x12, 0x01, 0x00, 0x16, 0x12,
   0x01, 0x00, 0x07, 0x12, 0x01, 0x00, 0x02, 0x12,
   0x01, 0x00, 0x05, 0x12, 0x02, 0x0D, 0x01, 0x00,
   0x04, 0x0D, 0x05, 0x12, 0x01, 0x0D, 0x02, 0x00,
   0x01, 0x12, 0x01, 0x00, 0x02, 0x0D, 0x01, 0x12,
   0x02, 0x00, 0x01, 0x12, 0x0F, 0x00, 0x01, 0x12,
   0x05, 0x00, 0x0A, 0x12, 0x11, 0x0D, 0x01, 0x00,
   0x02, 0x12, 0x01, 0x00, 0x08, 0x12, 0x02, 0x00,
   0x02, 0x12, 0x02, 0x00, 0x16, 0x12, 0x01, 0x00,
   0x07, 0x12, 0x01, 0x00, 0x02, 0x12, 0x02, 0x00,
   0x04, 0x12, 0x02, 0x0D, 0x01, 0x00, 0x02, 0x0D,
   0x01, 0x00, 0x01, 0x0D, 0x03, 0x12, 0x03, 0x00,
   0x02, 0x12, 0x02, 0x00, 0x02, 0x0D, 0x01, 0x12,
   0x08, 0x0D, 0x01, 0x00, 0x01, 0x12, 0x04, 0x00,
   0x02, 0x12, 0x01, 0x00, 0x03, 0x12, 0x04, 0x00,
   0x0B, 0x12, 0x11, 0x0D, 0x01, 0x00, 0x01, 0x12,
   0x01, 0x00, 0x06, 0x12, 0x03, 0x00, 0x03, 0x12,
   0x01, 0x00, 0x04, 0x12, 0x03, 0x00, 0x02, 0x12,
   0x01, 0x00, 0x01, 0x12, 0x01, 0x00, 0x02, 0x12,
   0x03, 0x00, 0x02, 0x12, 0x03, 0x00, 0x03, 0x12,
   0x03, 0x00, 0x08, 0x12, 0x01, 0x00, 0x03, 0x12,
   0x04, 0x00, 0x02, 0x0D, 0x01, 0x00, 0x02, 0x12,
   0x03, 0x00, 0x03, 0x12, 0x01, 0x00, 0x03, 0x0D,
   0x01, 0x12, 0x09, 0x00, 0x01, 0x12, 0x0F, 0x00,
   0x0C, 0x12, 0x0E, 0x00, 0x03, 0x12, 0x01, 0x00,
   0x08, 0x12, 0x01, 0x00, 0x03, 0x12, 0x01, 0x00,
   0x17, 0x12, 0x01, 0x00, 0x0A, 0x12, 0x01, 0x00,
   0x05, 0x12, 0x04, 0x0D, 0x03, 0x00, 0x04, 0x12,
   0x01, 0x0D, 0x03, 0x12, 0x01, 0x0D, 0x04, 0x12,
   0x07, 0x0D, 0x02, 0x12, 0x09, 0x00, 0x02, 0x12,
   0x04, 0x00, 0x0A, 0x12, 0x12, 0x00, 0x02, 0x12,
   0x01, 0x00, 0x08, 0x12, 0x01, 0x00, 0x03, 0x12,
   0x01, 0x00, 0x17, 0x12, 0x01, 0x00, 0x0A, 0x12,
   0x01, 0x00, 0x05, 0x12, 0x04, 0x00, 0x01, 0x0D,
   0x01, 0x00, 0x05, 0x12, 0x01, 0x0D, 0x01, 0x00,
   0x02, 0x12, 0x01, 0x00, 0x02, 0x0D, 0x02, 0x12,
   0x07, 0x00, 0x02, 0x12, 0x07, 0x00, 0x01, 0x12,
   0x01, 0x00, 0x02, 0x12, 0x04, 0x00, 0x0A, 0x12,
   0x12, 0x00, 0x02, 0x12, 0x01, 0x00, 0x08, 0x12,
   0x01, 0x00, 0x03, 0x12, 0x01, 0x00, 0x17, 0x12,
   0x01, 0x00, 0x10, 0x12, 0x04, 0x00, 0x03, 0x0D,
   0x03, 0x12, 0x02, 0x00, 0x03, 0x12, 0x01, 0x00,
   0x03, 0x0D, 0x01, 0x12, 0x09, 0x00, 0x01, 0x12,
   0x08, 0x00, 0x02, 0x12, 0x04, 0x00, 0x0A, 0x12,
   0x12, 0x00, 0x02, 0x12, 0x01, 0x00, 0x12, 0x12,
   0x03, 0x00, 0x18, 0x12, 0x01, 0x00, 0x09, 0x12,
   0x01, 0x00, 0x01, 0x12, 0x02, 0x00, 0x07, 0x12,
   0x03, 0x0D, 0x01, 0x12, 0x04, 0x00, 0x03, 0x0D,
   0x03, 0x12, 0x01, 0x0D, 0x01, 0x12, 0x01, 0x00,
   0x08, 0x12, 0x12, 0x00, 0x03, 0x12, 0x0C, 0x00,
   0x30, 0x0D, 0x01, 0x00, 0x02, 0x0D, 0x07, 0x12,
   0x04, 0x0A, 0x01, 0x00, 0x07, 0x0D, 0x08, 0x00,
   0x0D, 0x12, 0x25, 0x00, 0x02, 0x12, 0x01, 0x00,
   0x01, 0x12, 0x02, 0x00, 0x02, 0x12, 0x01, 0x00,
   0x01, 0x12, 0x02, 0x00, 0x01, 0x12, 0x06, 0x00,
   0x04, 0x12, 0x01, 0x00, 0x07, 0x12, 0x01, 0x00,
   0x03, 0x12, 0x01, 0x00, 0x01, 0x12, 0x01, 0x00,
   0x01, 0x12, 0x02, 0x00, 0x02, 0x12, 0x01, 0x00,
   0x04, 0x0D, 0x01, 0x00, 0x02, 0x0D, 0x06, 0x12,
   0x01, 0x0D, 0x02, 0x00, 0x01, 0x12, 0x02, 0x00,
   0x05, 0x12, 0x01, 0x00, 0x01, 0x12, 0x01, 0x0D,
   0x06, 0x12, 0x02, 0x00, 0x0A, 0x12, 0x02, 0x00,
   0x02, 0x12, 0x22, 0x00, 0x18, 0x0D, 0x02, 0x00,
   0x1B, 0x0D, 0x01, 0x00, 0x01, 0x0D, 0x01, 0x00,
   0x01, 0x0D, 0x01, 0x12, 0x04, 0x00, 0x0A, 0x12,
   0x01, 0x00, 0x22, 0x12, 0x06, 0x0D, 0x0E, 0x00,
   0x01, 0x0D, 0x05, 0x00, 0x01, 0x0D, 0x02, 0x00,
   0x04, 0x12, 0x04, 0x0D, 0x08, 0x12, 0x01, 0x0D,
   0x24, 0x12, 0x01, 0x00, 0x08, 0x0D, 0x01, 0x00,
   0x06, 0x12, 0x02, 0x00, 0x01, 0x12, 0x30, 0x00,
   0x22, 0x12, 0x01, 0x00, 0x05, 0x12, 0x01, 0x00,
   0x02, 0x12, 0x01, 0x00, 0x01, 0x0D, 0x04, 0x00,
   0x01, 0x0D, 0x01, 0x12, 0x03, 0x0D, 0x02, 0x00,
   0x01, 0x0D, 0x01, 0x12, 0x06, 0x00, 0x18, 0x0D,
   0x02, 0x12, 0x46, 0x00, 0x26, 0x12, 0x0A, 0x00,
   0x29, 0x12, 0x02, 0x00, 0x01, 0x12, 0x04, 0x00,
   0x5A, 0x12, 0x05, 0x00, 0x44, 0x12, 0x05, 0x00,
   0x52, 0x12, 0x06, 0x00, 0x07, 0x12, 0x01, 0x00,
   0x3F, 0x12, 0x01, 0x00, 0x01, 0x12, 0x01, 0x00,
   0x04, 0x12, 0x02, 0x00, 0x07, 0x12, 0x01, 0x00,
   0x01, 0x12, 0x01, 0x00, 0x04, 0x12, 0x02, 0x00,
   0x27, 0x12, 0x01, 0x00, 0x01, 0x12, 0x01, 0x00,
   0x04, 0x12, 0x02, 0x00, 0x1F, 0x12, 0x01, 0x00,
   0x01, 0x12, 0x01, 0x00, 0x04, 0x12, 0x02, 0x00,
   0x07, 0x12, 0x01, 0x00, 0x01, 0x12, 0x01, 0x00,
   0x04, 0x12, 0x02, 0x00, 0x07, 0x12, 0x01, 0x00,
   0x07, 0x12, 0x01, 0x00, 0x17, 0x12, 0x01, 0x00,
   0x1F, 0x12, 0x01, 0x00, 0x01, 0x12, 0x01, 0x00,
   0x04, 0x12, 0x02, 0x00, 0x07, 0x12, 0x01, 0x00,
   0x27, 0x12, 0x01, 0x00, 0x13, 0x12, 0x06, 0x00,
   0x1C, 0x12, 0x23, 0x00, 0x55, 0x12, 0x0C, 0x00,
   0xFF, 0x00, 0xFF, 0x00, 0x78, 0x12, 0x09, 0x11,
   0x01, 0x00, 0x1A, 0x12, 0x05, 0x00, 0x51, 0x12,
   0x0F, 0x00, 0x0D, 0x12, 0x01, 0x00, 0x04, 0x0D,
   0x03, 0x12, 0x0B, 0x00, 0x12, 0x0D, 0x03, 0x00,
   0x02, 0x12, 0x09, 0x00, 0x12, 0x0D, 0x02, 0x12,
   0x0C, 0x00, 0x0D, 0x12, 0x01, 0x00, 0x03, 0x12,
   0x01, 0x0D, 0x02, 0x12, 0x0C, 0x00, 0x37, 0x0D,
   0x07, 0x00, 0x08, 0x0D, 0x01, 0x00, 0x02, 0x0D,
   0x0B, 0x00, 0x07, 0x0A, 0x01, 0x00, 0x01, 0x12,
   0x03, 0x00, 0x0A, 0x12, 0x21, 0x0D, 0x03, 0x0E,
   0x01, 0x12, 0x01, 0x00, 0x0A, 0x12, 0x06, 0x00,
   0x58, 0x12, 0x08, 0x00, 0x29, 0x0D, 0x01, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0x5B, 0x00, 0x9C, 0x12, 0x04, 0x00,
   0x5A, 0x12, 0x06, 0x00, 0x16, 0x12, 0x02, 0x00,
   0x06, 0x12, 0x02, 0x00, 0x26, 0x12, 0x02, 0x00,
   0x06, 0x12, 0x02, 0x00, 0x08, 0x12, 0x01, 0x00,
   0x01, 0x12, 0x01, 0x00, 0x01, 0x12, 0x01, 0x00,
   0x01, 0x12, 0x01, 0x00, 0x1F, 0x12, 0x02, 0x00,
   0x35, 0x12, 0x01, 0x00, 0x07, 0x12, 0x01, 0x00,
   0x01, 0x12, 0x03, 0x00, 0x03, 0x12, 0x01, 0x00,
   0x07, 0x12, 0x03, 0x00, 0x04, 0x12, 0x02, 0x00,
   0x06, 0x12, 0x04, 0x00, 0x0D, 0x12, 0x05, 0x00,
   0x03, 0x12, 0x01, 0x00, 0x07, 0x12, 0x03, 0x11,
   0x0B, 0x0E, 0x03, 0x00, 0x01, 0x03, 0x01, 0x12,
   0x18, 0x11, 0x01, 0x0F, 0x01, 0x01, 0x01, 0x05,
   0x01, 0x07, 0x01, 0x02, 0x01, 0x06, 0x01, 0x11,
   0x01, 0x0A, 0x05, 0x12, 0x2A, 0x11, 0x01, 0x0E,
   0x04, 0x12, 0x06, 0x0E, 0x06, 0x08, 0x01, 0x00,
   0x01, 0x12, 0x02, 0x08, 0x06, 0x0A, 0x02, 0x12,
   0x03, 0x00, 0x01, 0x08, 0x0A, 0x0A, 0x02, 0x12,
   0x14, 0x0A, 0x12, 0x12, 0x1E, 0x0D, 0x1B, 0x12,
   0x17, 0x00, 0x01, 0x12, 0x04, 0x00, 0x01, 0x12,
   0x02, 0x00, 0x0A, 0x12, 0x01, 0x00, 0x01, 0x12,
   0x03, 0x00, 0x05, 0x12, 0x06, 0x00, 0x01, 0x12,
   0x01, 0x00, 0x01, 0x12, 0x01, 0x00, 0x01, 0x12,
   0x01, 0x00, 0x04, 0x0A, 0x01, 0x00, 0x03, 0x12,
   0x01, 0x00, 0x07, 0x12, 0x03, 0x00, 0x03, 0x12,
   0x05, 0x00, 0x05, 0x12, 0x16, 0x00, 0x24, 0x12,
   0x8E, 0x0A, 0x02, 0x12, 0xFF, 0x12, 0x23, 0x00,
   0x45, 0x12, 0x1A, 0x00, 0x01, 0x12, 0xCA, 0x08,
   0x3C, 0x00, 0x4E, 0x08, 0x01, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0x20, 0x11, 0x01, 0x12,
   0x04, 0x00, 0x03, 0x12, 0x19, 0x00, 0x09, 0x0D,
   0x06, 0x12, 0x01, 0x00, 0x05, 0x12, 0x02, 0x00,
   0x05, 0x12, 0x04, 0x00, 0x56, 0x12, 0x02, 0x0D,
   0x02, 0x12, 0x02, 0x00, 0x03, 0x12, 0x01, 0x00,
   0x5A, 0x12, 0x01, 0x00, 0x04, 0x12, 0x05, 0x00,
   0x28, 0x12, 0x04, 0x00, 0x5E, 0x12, 0x01, 0x00,
   0x28, 0x12, 0x38, 0x00, 0x2D, 0x12, 0x03, 0x00,
   0x24, 0x12, 0x1C, 0x00, 0x1C, 0x12, 0x03, 0x00,
   0x32, 0x12, 0x0F, 0x00, 0x0C, 0x12, 0x04, 0x00,
   0x2F, 0x12, 0x01, 0x00, 0x77, 0x12, 0x04, 0x00,
   0x63, 0x12, 0x02, 0x00, 0x1F, 0x12, 0x01, 0x00,
   0x01, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xCD, 0x00, 0x01, 0x12,
   0x4A, 0x00, 0x01, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xF5, 0x00,
   0x01, 0x12, 0x5A, 0x00, 0xFF, 0x00, 0xFF, 0x00,
   0xFF, 0x00, 0xFF, 0x00, 0x91, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0x7A, 0x00, 0x01, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xCD, 0x00,
   0x01, 0x12, 0x5C, 0x00, 0x01, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0x81, 0x00, 0x02, 0x12,
   0x7E, 0x00, 0x02, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0x02, 0x00, 0x02, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12, 0xFF, 0x12,
   0xFF, 0x12, 0x17, 0x00, 0xFF, 0x00, 0x30, 0x12,
   0x02, 0x00, 0x3B, 0x12, 0x95, 0x00, 0x07, 0x12,
   0x0C, 0x00, 0x05, 0x12, 0x05, 0x03, 0x01, 0x0D,
   0x01, 0x03, 0x0A, 0x0A, 0x01, 0x03, 0x0D, 0x12,
   0x01, 0x03, 0x05, 0x12, 0x01, 0x03, 0x01, 0x12,
   0x01, 0x03, 0x02, 0x12, 0x01, 0x03, 0x02, 0x12,
   0x01, 0x03, 0x0A, 0x04, 0x62, 0x12, 0x21, 0x04,
   0xFF, 0x04, 0x6C, 0x12, 0x12, 0x04, 0x40, 0x12,
   0x02, 0x04, 0x36, 0x12, 0x28, 0x04, 0x0D, 0x12,
   0x03, 0x0D, 0x10, 0x12, 0x10, 0x0D, 0x04, 0x12,
   0x2C, 0x0C, 0x01, 0x12, 0x01, 0x0C, 0x01, 0x12,
   0x02, 0x0C, 0x01, 0x12, 0x09, 0x0A, 0x01, 0x12,
   0x02, 0x0A, 0x02, 0x12, 0x05, 0x0A, 0x02, 0x12,
   0x05, 0x04, 0x05, 0x12, 0x01, 0x04, 0x87, 0x12,
   0x02, 0x0E, 0x01, 0x12, 0x03, 0x0A, 0x03, 0x12,
   0x05, 0x0A, 0x01, 0x0C, 0x01, 0x0A, 0x01, 0x0C,
   0x01, 0x09, 0x01, 0x08, 0x0A, 0x0C, 0x01, 0x12,
   0x06, 0x00, 0x1A, 0x12, 0x06, 0x00, 0x1A, 0x12,
   0x0B, 0x00, 0x59, 0x12, 0x03, 0x00, 0x06, 0x12,
   0x02, 0x00, 0x06, 0x12, 0x02, 0x00, 0x06, 0x12,
   0x02, 0x00, 0x03, 0x12, 0x03, 0x0A, 0x02, 0x12,
   0x03, 0x0A, 0x02, 0x12, 0x09, 0x00, 0x0E, 0x00,
};
