//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "FarConfiguration.h"
#include "FarPlugin.h"
#include <Common.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
__fastcall TFarConfiguration::TFarConfiguration() :
  TGUIConfiguration()
{
  Default();
}
//---------------------------------------------------------------------------
void __fastcall TFarConfiguration::Default()
{
  FForceInheritance = false;
  FConfirmOverwriting = false;
  FConfirmOverwritingOverride = false;

  DisksMenu = true;
  DisksMenuHotKey = 0;
  PluginsMenu = true;
  CommandPrefixes = "winscp,scp,sftp";

  CustomPanelModeDetailed = true;
  FullScreenDetailed = true;
  ColumnTypesDetailed = "N,S,DM,O,G,R";
  ColumnWidthsDetailed = "0,8,14,0,0,9";
  StatusColumnTypesDetailed = "NR";
  StatusColumnWidthsDetailed = "0";
}
//---------------------------------------------------------------------------
// duplicated from core\configuration.cpp
#define LASTELEM(ELEM) \
  ELEM.SubString(ELEM.LastDelimiter(".>")+1, ELEM.Length() - ELEM.LastDelimiter(".>"))
#define BLOCK(KEY, CANCREATE, BLOCK) \
  if (Storage->OpenSubKey(KEY, CANCREATE)) try { BLOCK } __finally { Storage->CloseSubKey(); }
#define REGCONFIG(CANCREATE) \
  BLOCK("Far", CANCREATE, \
    KEY(Bool,     DisksMenu); \
    KEY(Integer,  DisksMenuHotKey); \
    KEY(Bool,     PluginsMenu); \
    KEY(String,   CommandPrefixes); \
    KEY(Bool,     CustomPanelModeDetailed); \
    KEY(Bool,     FullScreenDetailed); \
    KEY(String,   ColumnTypesDetailed); \
    KEY(String,   ColumnWidthsDetailed); \
    KEY(String,   StatusColumnTypesDetailed); \
    KEY(String,   StatusColumnWidthsDetailed); \
  );
//---------------------------------------------------------------------------
void __fastcall TFarConfiguration::SaveSpecial(THierarchicalStorage * Storage)
{
  TGUIConfiguration::SaveSpecial(Storage);

  // duplicated from core\configuration.cpp
  #define KEY(TYPE, VAR) Storage->Write ## TYPE(LASTELEM(AnsiString(#VAR)), VAR)
  REGCONFIG(true);
  #undef KEY
}
//---------------------------------------------------------------------------
void __fastcall TFarConfiguration::LoadSpecial(THierarchicalStorage * Storage)
{
  TGUIConfiguration::LoadSpecial(Storage);

  // duplicated from core\configuration.cpp
  #define KEY(TYPE, VAR) VAR = Storage->Read ## TYPE(LASTELEM(AnsiString(#VAR)), VAR)
  #pragma warn -eas
  REGCONFIG(false);
  #pragma warn +eas
  #undef KEY
}
//---------------------------------------------------------------------------
void __fastcall TFarConfiguration::Load()
{
  FForceInheritance = true;
  try
  {
    TGUIConfiguration::Load();
  }
  __finally
  {
    FForceInheritance = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TFarConfiguration::Save()
{
  FForceInheritance = true;
  try
  {
    TGUIConfiguration::Save();
  }
  __finally
  {
    FForceInheritance = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TFarConfiguration::SetPlugin(TCustomFarPlugin * value)
{
  if (Plugin != value)
  {
    assert(!Plugin || !value);
    FPlugin = value;
  }
}
//---------------------------------------------------------------------------
bool __fastcall TFarConfiguration::GetConfirmOverwriting()
{
  if (FForceInheritance)
  {
    return TGUIConfiguration::GetConfirmOverwriting();
  }
  else if (FConfirmOverwritingOverride)
  {
    return FConfirmOverwriting;
  }
  else 
  {
    assert(Plugin);
    return (Plugin->FarAdvControl(ACTL_GETCONFIRMATIONS, NULL) & FCS_COPYOVERWRITE) != 0;
  }
}
//---------------------------------------------------------------------------
void __fastcall TFarConfiguration::SetConfirmOverwriting(bool value)
{
  if (FForceInheritance)
  {
    TGUIConfiguration::SetConfirmOverwriting(value);
  }
  if (ConfirmOverwriting != value)
  {
    FConfirmOverwritingOverride = true;
    FConfirmOverwriting = value;
  }
}
//---------------------------------------------------------------------------
bool __fastcall TFarConfiguration::GetConfirmDeleting()
{
  assert(Plugin);
  return (Plugin->FarAdvControl(ACTL_GETCONFIRMATIONS, NULL) & FCS_DELETE) != 0;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TFarConfiguration::ModuleFileName()
{
  assert(Plugin);
  return Plugin->ModuleName;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TFarConfiguration::GetPuttygenPath()
{
  return ExtractFilePath(ModuleFileName()) + "putty\\puttygen.exe";
}
//---------------------------------------------------------------------------
AnsiString __fastcall TFarConfiguration::GetPageantPath()
{
  return ExtractFilePath(ModuleFileName()) + "putty\\pageant.exe";
}

