//---------------------------------------------------------------------------
#ifndef FarConfigurationH
#define FarConfigurationH
//---------------------------------------------------------------------------
#include "GUIConfiguration.h"
//---------------------------------------------------------------------------
class TCustomFarPlugin;
//---------------------------------------------------------------------------
class TFarConfiguration : public TGUIConfiguration
{
public:
  __fastcall TFarConfiguration();

  __property TCustomFarPlugin * Plugin = { read = FPlugin, write = SetPlugin };
  __property bool ConfirmDeleting = { read = GetConfirmDeleting };
  __property bool DisksMenu = { read = FDisksMenu, write = FDisksMenu };
  __property int DisksMenuHotKey = { read = FDisksMenuHotKey, write = FDisksMenuHotKey };
  __property bool PluginsMenu = { read = FPluginsMenu, write = FPluginsMenu };
  __property AnsiString CommandPrefixes = { read = FCommandPrefixes, write = FCommandPrefixes };

  __property bool CustomPanelModeDetailed = { read = FCustomPanelModeDetailed, write = FCustomPanelModeDetailed };
  __property bool FullScreenDetailed = { read = FFullScreenDetailed, write = FFullScreenDetailed };
  __property AnsiString ColumnTypesDetailed = { read = FColumnTypesDetailed, write = FColumnTypesDetailed };
  __property AnsiString ColumnWidthsDetailed = { read = FColumnWidthsDetailed, write = FColumnWidthsDetailed };
  __property AnsiString StatusColumnTypesDetailed = { read = FStatusColumnTypesDetailed, write = FStatusColumnTypesDetailed };
  __property AnsiString StatusColumnWidthsDetailed = { read = FStatusColumnWidthsDetailed, write = FStatusColumnWidthsDetailed };

  __property AnsiString PageantPath = { read = GetPageantPath };
  __property AnsiString PuttygenPath = { read = GetPuttygenPath };

  virtual void __fastcall Load();
  virtual void __fastcall Save();
  virtual void __fastcall Default();

protected:
  virtual bool __fastcall GetConfirmOverwriting();
  virtual void __fastcall SetConfirmOverwriting(bool value);

  virtual void __fastcall SaveSpecial(THierarchicalStorage * Storage);
  virtual void __fastcall LoadSpecial(THierarchicalStorage * Storage);

  virtual AnsiString __fastcall ModuleFileName();

private:
  TCustomFarPlugin * FPlugin;
  bool FConfirmOverwriting;
  bool FConfirmOverwritingOverride;
  bool FForceInheritance;
  bool FDisksMenu;
  int FDisksMenuHotKey;
  bool FPluginsMenu;
  AnsiString FCommandPrefixes;

  bool FCustomPanelModeDetailed;
  bool FFullScreenDetailed;
  AnsiString FColumnTypesDetailed;
  AnsiString FColumnWidthsDetailed;
  AnsiString FStatusColumnTypesDetailed;
  AnsiString FStatusColumnWidthsDetailed;

  void __fastcall SetPlugin(TCustomFarPlugin * value);
  bool __fastcall GetConfirmDeleting();

  AnsiString __fastcall GetPuttygenPath();
  AnsiString __fastcall GetPageantPath();
};
//---------------------------------------------------------------------------
#define FarConfiguration ((TFarConfiguration *) Configuration)
//---------------------------------------------------------------------------
#endif
