//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <Common.h>
#include <Configuration.h>
#include <SecureShell.h>
#include <Net.h>
#include <ScpMain.h>
#include "FarConfiguration.h"
#include "FarPlugin.h"
#include "FarTexts.h"
#include "WinSCPPlugin.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
TWinSCPPlugin * __fastcall WinSCPPlugin()
{
  assert(FarPlugin);
  TWinSCPPlugin * Result = dynamic_cast<TWinSCPPlugin *>(FarPlugin);
  assert(Result);
  return Result;
}
//---------------------------------------------------------------------------
TConfiguration * __fastcall CreateConfiguration()
{
  return new TFarConfiguration();
}
//---------------------------------------------------------------------------
int __fastcall ExceptionMessageDialog(Exception * E,
  TQueryType Type, int Answers)
{
  TStrings * MoreMessages = NULL;
  if (E->InheritsFrom(__classid(ExtException)))
  {
    MoreMessages = ((ExtException *)E)->MoreMessages;
  }

  return WinSCPPlugin()->MoreMessageDialog(E->Message, MoreMessages, Type, Answers);
}
//---------------------------------------------------------------------------
void __fastcall ShowExtendedException(Exception * E, TObject * Sender)
{
  if (!E->Message.IsEmpty())
  {
    if (E->InheritsFrom(__classid(Exception)))
    {
      if (!E->InheritsFrom(__classid(EAbort)))
      {
        TQueryType Type;
        Type = (E->InheritsFrom(__classid(ESshTerminate)) ?
          qtInformation : qtError);
        /*if (E->InheritsFrom(__classid(EFatal)))
        {
          if (FatalExceptionMessageDialog(E, Type) == qaRetry)
          {
            ReconnectTerminal();
          }
        }
        else*/
        {
          ExceptionMessageDialog(E, Type, qaOK);
        } 
      }
    }
    else
    {
      ShowException(ExceptObject(), ExceptAddr());
    }
  }
  HandleExtendedException(E, Sender);
}
//---------------------------------------------------------------------------
AnsiString __fastcall GetRegistryKey()
{
  return "Software\\Martin Prikryl\\WinSCP 2";
}
//---------------------------------------------------------------------------
int __fastcall GetSessionPassword(AnsiString Prompt, AnsiString & Password)
{
  assert(FarPlugin);
  return FarPlugin->InputBox(FarPlugin->GetMsg(PASSWORD_TITLE),
    Prompt, Password, FIB_PASSWORD);
}
//---------------------------------------------------------------------------
void __fastcall HandleExtendedException(Exception * E, TObject* /*Sender*/)
{
  if (CurrentSSH)
  {
    CurrentSSH->Log->AddException(E);
  }

  /*if (E->InheritsFrom(__classid(EFatal)))
  {
    Application->Terminate();
  } */
}
//---------------------------------------------------------------------------
void __fastcall Busy(bool /*Start*/)
{
  // nothing
}
//---------------------------------------------------------------------------
AnsiString __fastcall SshVersionString()
{
  return FORMAT("WinSCP-FAR-release-%s", (Configuration->Version));
}

