//---------------------------------------------------------------------------
#ifndef WinSCPFileSystemH
#define WinSCPFileSystemH
//---------------------------------------------------------------------------
#include "FarPlugin.h"
#include <FileOperationProgress.h>
//---------------------------------------------------------------------------
class TTerminal;
class TSessionData;
class TRemoteFile;
class TWinSCPPlugin;
class TFarButton;
class TFarDialogItem;
class TFarDialog;
#define REMOTE_DIR_HISTORY "RemoteDirectory"
#define ASCII_MASK_HISTORY "AsciiMask"
#define LINK_FILENAME_HISTORY "RemoteLink"
#define LINK_POINT_TO_HISTORY "RemoteLinkPointTo"
//---------------------------------------------------------------------------
// for Properties dialog
const cpMode =  0x01;
const cpOwner = 0x02;
const cpGroup = 0x04;
//---------------------------------------------------------------------------
class TWinSCPFileSystem : public TCustomFarFileSystem
{
friend TWinSCPPlugin;
public:
  __fastcall TWinSCPFileSystem(TCustomFarPlugin * APlugin);
  virtual __fastcall ~TWinSCPFileSystem();

protected:
  bool __fastcall Connect(TSessionData * Data);
  void __fastcall SaveSession();

  virtual void __fastcall GetOpenPluginInfoEx(long unsigned & Flags,
    AnsiString & HostFile, AnsiString & CurDir, AnsiString & Format,
    AnsiString & PanelTitle, TFarPanelModes * PanelModes, int & StartPanelMode,
    int & StartSortMode, bool & StartSortOrder, TFarKeyBarTitles * KeyBarTitles,
    AnsiString & ShortcutData);
  virtual bool __fastcall GetFindDataEx(TList * PanelItems);
  virtual bool __fastcall ProcessKeyEx(int Key, unsigned int ControlState);
  virtual bool __fastcall SetDirectoryEx(const AnsiString Dir, int OpMode);
  virtual int __fastcall MakeDirectoryEx(AnsiString & Name, int OpMode);
  virtual bool __fastcall DeleteFilesEx(TList * PanelItems, int OpMode);
  virtual int __fastcall GetFilesEx(TList * PanelItems, bool Move,
    AnsiString & DestPath, int OpMode);
  virtual int __fastcall PutFilesEx(TList * PanelItems, bool Move, int OpMode);
  virtual bool __fastcall ProcessEventEx(int Event, void * Param);

  virtual void __fastcall HandleException(Exception * E, int OpMode = 0);

  bool __fastcall Connected();
  TWinSCPPlugin * __fastcall WinSCPPlugin();
  void __fastcall ShowOperationProgress(TFileOperationProgressType & ProgressData,
    bool Force);
  bool __fastcall SessionDialog(TSessionData * Data, bool & Connect);
  void __fastcall EditConnectSession(TSessionData * Data, bool Edit);
  bool __fastcall ExportSessions(TList * PanelItems, bool Move,
    AnsiString & DestPath, int OpMode);
  bool __fastcall ImportSessions(TList * PanelItems, bool Move, int OpMode);
  void __fastcall FileProperties();
  void __fastcall CreateLink();
  bool __fastcall PropertiesDialog(TStrings * FileList,
    const AnsiString Directory, TStrings * GroupList,
    TRemoteProperties * Properties, int AllowedChanges);
  bool __fastcall ExecuteCommand(const AnsiString Command);
  void __fastcall TerminalEchoAddLine(TObject * Sender, const AnsiString AddedLine);
  bool __fastcall CopyDialog(bool ToRemote, bool Move, TStrings * FileList,
    bool AllowTransferMode, AnsiString & TargetDirectory, TCopyParamType * Params);
  bool __fastcall LinkDialog(AnsiString & FileName, AnsiString & PointTo, bool & Symbolic,
    bool Edit, bool AllowSymbolic);

  __property TTerminal * Terminal = { read = FTerminal };

private:
  TTerminal * FTerminal;
  bool FDirectoryRead;
  THandle FProgressSaveScreenHandle;
  TStrings * FFileList;
  TList * FPanelItems;
  AnsiString FSavedFindFolder;
  AnsiString FLastEditFolder;
  AnsiString FLastEditFile;

  void __fastcall TerminalUpdateStatus(TObject * Sender);
  void __fastcall TerminalReadDirectory(TObject* Sender, bool ReloadOnly);
  void __fastcall OperationProgress(
    TFileOperationProgressType & ProgressData, TCancelStatus & /*Cancel*/);
  void __fastcall OperationFinished(TOperationSide Side,
    bool DragDrop, const AnsiString FileName, bool Success,
    bool & DisconnectWhenComplete);
  void __fastcall CutFirstDirectory(AnsiString & S, bool Unix);
  AnsiString __fastcall MinimizeName(const AnsiString FileName, int MaxLen, bool Unix);
  void __fastcall CancelConfiguration(TFileOperationProgressType & ProgressData);
  TStrings * __fastcall CreateFileList(TList * PanelItems,
    TOperationSide Side, bool SelectedOnly = false);
  TStrings * __fastcall TWinSCPFileSystem::CreateSelectedFileList(
    TOperationSide Side);
  AnsiString __fastcall FormatBytes(__int64 Bytes);
};
//---------------------------------------------------------------------------
class TSessionPanelItem : public TCustomFarPanelItem
{
public:
  __fastcall TSessionPanelItem(TSessionData * ASessionData);
  static void __fastcall SetPanelModes(TFarPanelModes * PanelModes);
  static void __fastcall SetKeyBarTitles(TFarKeyBarTitles * KeyBarTitles);

protected:
  TSessionData * FSessionData;

  virtual void __fastcall GetData(
    unsigned long & Flags, AnsiString & FileName, __int64 & Size,
    unsigned long & FileAttributes,
    TDateTime & LastWriteTime, TDateTime & LastAccess,
    unsigned long & NumberOfLinks, AnsiString & Description,
    AnsiString & Owner, void *& UserData, int & CustomColumnNumber);
};
//---------------------------------------------------------------------------
class TRemoteFilePanelItem : public TCustomFarPanelItem
{
public:
  __fastcall TRemoteFilePanelItem(TRemoteFile * ARemoteFile);
  static void __fastcall SetPanelModes(TFarPanelModes * PanelModes);
  static void __fastcall SetKeyBarTitles(TFarKeyBarTitles * KeyBarTitles);

protected:
  TRemoteFile * FRemoteFile;

  virtual void __fastcall GetData(
    unsigned long & Flags, AnsiString & FileName, __int64 & Size,
    unsigned long & FileAttributes,
    TDateTime & LastWriteTime, TDateTime & LastAccess,
    unsigned long & NumberOfLinks, AnsiString & Description,
    AnsiString & Owner, void *& UserData, int & CustomColumnNumber);
  virtual AnsiString __fastcall CustomColumnData(int Column);
  static void __fastcall TranslateColumnTypes(AnsiString & ColumnTypes,
    TStrings * ColumnTitles);
};
//---------------------------------------------------------------------------
TWinSCPPlugin * __fastcall WinSCPPlugin();
//---------------------------------------------------------------------------
#endif
