//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "WinSCPPlugin.h"
#include "WinSCPFileSystem.h"
#include "FarConfiguration.h"
#include "FarTexts.h"
#include "FarDialog.h"
#include "plugin.hpp"
#include <Common.h>
#include <ScpMain.h>
#include <Exceptions.h>
#include <Terminal.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
TCustomFarPlugin * __fastcall CreateFarPlugin(THandle Handle)
{
  return new TWinSCPPlugin(Handle);
}
//---------------------------------------------------------------------------
__fastcall TWinSCPPlugin::TWinSCPPlugin(THandle AHandle): TCustomFarPlugin(AHandle)
{
}
//---------------------------------------------------------------------------
__fastcall TWinSCPPlugin::~TWinSCPPlugin()
{
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::HandlesFunction(THandlesFunction Function)
{
  return (Function == hfProcessKey || Function == hfProcessEvent);
}
//---------------------------------------------------------------------------
int __fastcall TWinSCPPlugin::GetMinFarVersion()
{
  return MAKEFARVERSION(1, 70, 1282); // FAR 1.70 beta 4
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::GetPluginInfoEx(long unsigned & Flags,
  TStrings * DiskMenuStrings, TStrings * PluginMenuStrings,
  TStrings * PluginConfigStrings, TStrings * CommandPrefixes)
{
  Flags = 0;//PF_PRELOAD;
  if (FarConfiguration->DisksMenu)
  {
    DiskMenuStrings->AddObject(GetMsg(PLUGIN_TITLE),
      (TObject *)FarConfiguration->DisksMenuHotKey);
  }
  if (FarConfiguration->PluginsMenu)
  {
    PluginMenuStrings->Add(GetMsg(PLUGIN_TITLE));
  }
  PluginConfigStrings->Add(GetMsg(PLUGIN_TITLE));
  CommandPrefixes->CommaText = FarConfiguration->CommandPrefixes;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::ConfigureEx(int /*Item*/)
{
  bool Change = false;
  
  TFarMenuItems * MenuItems = new TFarMenuItems();
  try
  {
    int MInterface = MenuItems->Add(GetMsg(CONFIG_INTERFACE));
    MenuItems->AddSeparator();
    int MPageant = MenuItems->Add(GetMsg(CONFIG_PAGEANT));
    int MPuttygen = MenuItems->Add(GetMsg(CONFIG_PUTTYGEN));
    MenuItems->AddSeparator();
    int MAbout = MenuItems->Add(GetMsg(CONFIG_ABOUT));

    int Result;

    do
    {
      MenuItems->Disabled[MPageant] = !FileExists(FarConfiguration->PageantPath);
      MenuItems->Disabled[MPuttygen] = !FileExists(FarConfiguration->PuttygenPath);

      Result = Menu(FMENU_WRAPMODE, GetMsg(PLUGIN_TITLE), "", MenuItems);

      if (Result >= 0)
      {
        if (Result == MInterface)
        {
          if (ConfigurationDialog())
          {
            Change = true;
          }
        }
        else if (Result == MAbout)
        {
          AboutDialog();
        }
        else if (Result == MPageant)
        {
          ShellExecute(NULL, "open", FarConfiguration->PageantPath.c_str(),
            NULL, NULL, SW_SHOWNORMAL);
        }
        else if (Result == MPuttygen)
        {
          ShellExecute(NULL, "open", FarConfiguration->PuttygenPath.c_str(),
            NULL, NULL, SW_SHOWNORMAL);
        }
      }
    }
    while (Result >= 0);
  }
  __finally
  {
    delete MenuItems;
  }
  return Change;
}
//---------------------------------------------------------------------------
TCustomFarFileSystem * __fastcall TWinSCPPlugin::OpenPluginEx(int OpenFrom, int Item)
{
  TWinSCPFileSystem * FileSystem = NULL;
  try
  {
    FileSystem = new TWinSCPFileSystem(this);

    if (OpenFrom == OPEN_DISKMENU	|| OpenFrom == OPEN_PLUGINSMENU ||
        OpenFrom == OPEN_FINDLIST)
    {
      // nothing
    }
    else if (OpenFrom == OPEN_SHORTCUT || OpenFrom == OPEN_COMMANDLINE)
    {
      AnsiString Directory;
      AnsiString Name = (char*)Item;
      if (OpenFrom == OPEN_COMMANDLINE)
      {
        while (!Name.IsEmpty() && Name[1] == '/')
        {
          Name.Delete(1, 1);
        }
        int P = Name.Pos("/");
        int P2 = Name.Pos(":");
        if (!P || (P2 && P2 < P))
        {
          P = P2;
        }
        if (P)
        {
          Directory = Name.SubString(P + 1, Name.Length() - P);
          Name.SetLength(P - 1);
        }
      }
      else
      {
        int P = Name.Pos("\1");
        if (P)
        {
          Directory = Name.SubString(P + 1, Name.Length() - P);
          Name.SetLength(P - 1);
        }

        TWinSCPFileSystem * PanelSystem;
        PanelSystem = dynamic_cast<TWinSCPFileSystem *>(GetPanelFileSystem());
        if (PanelSystem && PanelSystem->Connected() &&
            PanelSystem->Terminal->SessionData->Name == Name)
        {
          //FarControl(FCTL_SETPANELDIR, Directory.c_str());
          PanelSystem->SetDirectoryEx(Directory, OPM_SILENT);
          PanelSystem->UpdatePanel();
          PanelSystem->RedrawPanel();
          Abort();
        }
        // directory will be set by FAR itself 
        Directory = "";
      }
      assert(StoredSessions);
      TSessionData * Session;
      Session = dynamic_cast<TSessionData *>(StoredSessions->FindByName(Name));
      if (!Session)
      {
        throw Exception(FORMAT(GetMsg(SESSION_NOT_EXISTS_ERROR), (Name)));
      }
      FileSystem->Connect(Session);
      if (!Directory.IsEmpty())
      {
        FileSystem->SetDirectoryEx(Directory, OPM_SILENT);
      }
    }
    else
    {
      assert(false);
    }
  }
  catch(...)
  {
    delete FileSystem;
    throw;
  }

  return FileSystem;
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::TerminalQueryUser(TObject * /*Sender*/,
  const AnsiString Query, TStrings * MoreMessages, int Answers,
  int Params, int & Answer, TQueryType Type)
{
  AnsiString AQuery = Query;
  if (Params & qpFatalAbort)
  {
    AQuery = FORMAT(GetMsg(WARN_FATAL_ERROR), (AQuery));
  }

  Answer = MoreMessageDialog(AQuery, MoreMessages, Type, Answers);
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::ApplicationException(TObject * /*Sender*/, Exception * E)
{
  HandleException(E);
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::HandleException(Exception * E, int OpMode)
{
  if ((OpMode & OPM_FIND) && !E->InheritsFrom(__classid(EFatal)))
  {
    HandleExtendedException(E, this);
  }
  else
  {
    ShowExtendedException(E, this);
  }
}
//---------------------------------------------------------------------------
int __fastcall TWinSCPPlugin::MoreMessageDialog(AnsiString Str,
  TStrings * MoreMessages, TQueryType Type, int Answers)
{
  int Result;
  TStrings * ButtonLabels = new TStringList();
  try
  {
    int TitleId;
    unsigned int Flags = 0;
    switch (Type) {
      case qtConfirmation: TitleId = MSG_TITLE_CONFIRMATION; break;
      case qtInformation: TitleId = MSG_TITLE_INFORMATION; break;
      case qtError: TitleId = MSG_TITLE_ERROR; Flags |= FMSG_WARNING; break;
      case qtWarning: TitleId = MSG_TITLE_WARNING; Flags |= FMSG_WARNING; break;
      default: assert(false);
    }
    int Buttons[15];
    int ButtonCount = 0;

    assert((Answers & qaCustom) == 0);

    if ((Answers & qaAbort) && (Answers & qaRetry))
    {
      // use warning colors for abort/retry confirmation dialog
      Flags |= FMSG_WARNING;
    }

    int AAnswers = Answers;
    
    #define ADD_BUTTON(TYPE) \
      if (AAnswers & qa ## TYPE) \
      { \
        ButtonLabels->Add(GetMsg(MSG_BUTTON_ ## TYPE)); \
        Buttons[ButtonCount] = qa ## TYPE; \
        ButtonCount++; \
        AAnswers -= qa ## TYPE; \
      }
    ADD_BUTTON(Yes);
    ADD_BUTTON(No);
    ADD_BUTTON(OK);
    ADD_BUTTON(Cancel);
    ADD_BUTTON(Abort);
    ADD_BUTTON(Retry);
    ADD_BUTTON(Ignore);
    ADD_BUTTON(All);
    ADD_BUTTON(NoToAll);
    ADD_BUTTON(YesToAll);
    ADD_BUTTON(Help);
    ADD_BUTTON(Skip);
    ADD_BUTTON(Prev);
    ADD_BUTTON(Next);
    #undef ADD_BUTTON

    assert(!AAnswers);

    #define MORE_BUTTON_ID -2
    do
    {
      AnsiString DialogStr = Str;
      if (MoreMessages && (MoreMessages->Count > 0))
      {
        AnsiString ExpansionLabel = GetMsg(FarConfiguration->ErrorDialogExpanded ?
          LESS_BUTTON : MORE_BUTTON);
        if (Buttons[ButtonCount-1] == MORE_BUTTON_ID)
        {
          ButtonLabels->Strings[ButtonCount-1] = ExpansionLabel;
        }
        else
        {
          ButtonLabels->Add(ExpansionLabel);
          Buttons[ButtonCount] = MORE_BUTTON_ID;
          ButtonCount++;
        }

        if (FarConfiguration->ErrorDialogExpanded)
        {
          DialogStr += AnsiString("\n\x01\n") + MoreMessages->Text;
          while (DialogStr[DialogStr.Length()] == '\n' ||
                 DialogStr[DialogStr.Length()] == '\r')
          {
            DialogStr.SetLength(DialogStr.Length() - 1);
          }
          DialogStr += "\n\x01\n";
        }
      }

      Result = Message(Flags, GetMsg(TitleId), DialogStr, ButtonLabels);
      if (Result < 0)
      {
        if (Answers & qaCancel)
        {
          Result = qaCancel;
        }
        else if (Answers & qaNo)
        {
          Result = qaNo;
        }
        else if (Answers & qaAbort)
        {
          Result = qaAbort;
        }
        else if (Answers & qaOK)
        {
          Result = qaOK;
        }
        else
        {
          assert(false);
          Result = qaOK;
        }
      }
      else
      {
        assert(Result >= 0 && Result < ButtonCount);
        Result = Buttons[Result];
      }

      if (Result == MORE_BUTTON_ID)
      {
        FarConfiguration->ErrorDialogExpanded = !FarConfiguration->ErrorDialogExpanded;
      }
    }
    while (Result == MORE_BUTTON_ID);
  }
  __finally
  {
    delete ButtonLabels;
  }
  return Result;
}


