//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "WinSCPPlugin.h"
#include "WinSCPFileSystem.h"
#include "FarTexts.h"
#include "FarDialog.h"
#include "FarConfiguration.h"
#include <ScpMain.h>
#include <Common.h>
#include <CopyParam.h>
#include "farkeys.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
enum TButtonResult { brCancel = -1, brOK = 1, brConnect, brTab = 0xFF00 };
enum TSessionTab { tabSession = 1, tabEnvironment, tabSsh, tabCount };
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::ConfigurationDialog()
{
  bool Result;
  TFarDialog * Dialog = new TFarDialog(this);
  try
  {
    TFarText * Text;

    Dialog->Size = TPoint(65, 21);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_INTERFACE))));

    TFarCheckBox * DisksMenuCheck = new TFarCheckBox(Dialog);
    DisksMenuCheck->Caption = GetMsg(CONFIG_DISKS_MENU);

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->Caption = GetMsg(CONFIG_HOTKEY_LABEL);
    Text->EnabledDependency = DisksMenuCheck;

    Dialog->NextItemPosition = ipRight;

    TFarRadioButton * AutoHotKeyButton = new TFarRadioButton(Dialog);
    AutoHotKeyButton->Caption = GetMsg(CONFIG_HOTKEY_AUTOASSIGN);
    AutoHotKeyButton->EnabledDependency = DisksMenuCheck;

    TFarRadioButton * ManualHotKeyButton = new TFarRadioButton(Dialog);
    ManualHotKeyButton->Caption = GetMsg(CONFIG_HOTKEY_MANUAL);
    ManualHotKeyButton->EnabledDependency = DisksMenuCheck;

    TFarEdit * HotKeyEdit = new TFarEdit(Dialog);
    HotKeyEdit->Width = 1;
    HotKeyEdit->Fixed = true;
    HotKeyEdit->Mask = "9";
    HotKeyEdit->EnabledDependency = ManualHotKeyButton;

    Text = new TFarText(Dialog);
    Text->Caption = "(1 - 9)";
    Text->EnabledDependency = ManualHotKeyButton;

    Dialog->NextItemPosition = ipNewLine;

    TFarCheckBox * PluginsMenuCheck = new TFarCheckBox(Dialog);
    PluginsMenuCheck->Caption = GetMsg(CONFIG_PLUGINS_MENU);

    new TFarSeparator(Dialog);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(CONFIG_COMAND_PREFIXES);

    TFarEdit * CommandPrefixesEdit = new TFarEdit(Dialog);

    new TFarSeparator(Dialog);

    TFarCheckBox * CustomPanelCheck = new TFarCheckBox(Dialog);
    CustomPanelCheck->Caption = GetMsg(CONFIG_PANEL_MODE_CHECK);

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_TYPES);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelTypesEdit = new TFarEdit(Dialog);
    CustomPanelTypesEdit->EnabledDependency = CustomPanelCheck;
    CustomPanelTypesEdit->Width = CustomPanelTypesEdit->Width / 2 - 1;

    Dialog->NextItemPosition = ipRight;

    Text = new TFarText(Dialog);
    Text->EnabledDependency = CustomPanelCheck;
    Text->Move(0, -1);
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_STATUS_TYPES);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelStatusTypesEdit = new TFarEdit(Dialog);
    CustomPanelStatusTypesEdit->EnabledDependency = CustomPanelCheck;

    Dialog->NextItemPosition = ipNewLine;

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_WIDTHS);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelWidthsEdit = new TFarEdit(Dialog);
    CustomPanelWidthsEdit->EnabledDependency = CustomPanelCheck;
    CustomPanelWidthsEdit->Width = CustomPanelTypesEdit->Width;

    Dialog->NextItemPosition = ipRight;

    Text = new TFarText(Dialog);
    Text->EnabledDependency = CustomPanelCheck;
    Text->Move(0, -1);
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_STATUS_WIDTHS);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelStatusWidthsEdit = new TFarEdit(Dialog);
    CustomPanelStatusWidthsEdit->EnabledDependency = CustomPanelCheck;

    Dialog->NextItemPosition = ipNewLine;

    TFarCheckBox * CustomPanelFullScreenCheck = new TFarCheckBox(Dialog);
    CustomPanelFullScreenCheck->Left += 4;
    CustomPanelFullScreenCheck->EnabledDependency = CustomPanelCheck;
    CustomPanelFullScreenCheck->Caption = GetMsg(CONFIG_PANEL_MODE_FULL_SCREEN);

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_HINT);
    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_HINT2);

    new TFarSeparator(Dialog);

    TFarButton * Button = new TFarButton(Dialog);
    Button->Caption = GetMsg(MSG_BUTTON_OK);
    Button->Default = true;
    Button->Result = brOK;
    Button->CenterGroup = true;

    Dialog->NextItemPosition = ipRight;

    Button = new TFarButton(Dialog);
    Button->Caption = GetMsg(MSG_BUTTON_Cancel);
    Button->Result = brCancel;
    Button->CenterGroup = true;

    DisksMenuCheck->Checked = FarConfiguration->DisksMenu;
    AutoHotKeyButton->Checked = !FarConfiguration->DisksMenuHotKey;
    ManualHotKeyButton->Checked = FarConfiguration->DisksMenuHotKey;
    HotKeyEdit->Text = FarConfiguration->DisksMenuHotKey ?
      IntToStr(FarConfiguration->DisksMenuHotKey) : AnsiString();
    PluginsMenuCheck->Checked = FarConfiguration->PluginsMenu;
    CommandPrefixesEdit->Text = FarConfiguration->CommandPrefixes;

    CustomPanelCheck->Checked = FarConfiguration->CustomPanelModeDetailed;
    CustomPanelTypesEdit->Text = FarConfiguration->ColumnTypesDetailed;
    CustomPanelWidthsEdit->Text = FarConfiguration->ColumnWidthsDetailed;
    CustomPanelStatusTypesEdit->Text = FarConfiguration->StatusColumnTypesDetailed;
    CustomPanelStatusWidthsEdit->Text = FarConfiguration->StatusColumnWidthsDetailed;
    CustomPanelFullScreenCheck->Checked = FarConfiguration->FullScreenDetailed;

    Result = (Dialog->ShowModal() == brOK);
    if (Result)
    {
      FarConfiguration->DisksMenu = DisksMenuCheck->Checked;
      FarConfiguration->DisksMenuHotKey =
        ManualHotKeyButton->Checked && !HotKeyEdit->IsEmpty ?
          StrToInt(HotKeyEdit->Text) : 0;
      FarConfiguration->PluginsMenu = PluginsMenuCheck->Checked;
      FarConfiguration->CommandPrefixes = CommandPrefixesEdit->Text;

      FarConfiguration->CustomPanelModeDetailed = CustomPanelCheck->Checked;
      FarConfiguration->ColumnTypesDetailed = CustomPanelTypesEdit->Text;
      FarConfiguration->ColumnWidthsDetailed = CustomPanelWidthsEdit->Text;
      FarConfiguration->StatusColumnTypesDetailed = CustomPanelStatusTypesEdit->Text;
      FarConfiguration->StatusColumnWidthsDetailed = CustomPanelStatusWidthsEdit->Text;
      FarConfiguration->FullScreenDetailed = CustomPanelFullScreenCheck->Checked;
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
class TAboutDialog : public TFarDialog
{
public:
  __fastcall TAboutDialog(TCustomFarPlugin * AFarPlugin);

private:
  void __fastcall UrlButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TAboutDialog::TAboutDialog(TCustomFarPlugin * AFarPlugin) :
  TFarDialog(AFarPlugin)
{
  TFarText * Text;
  TFarButton * Button;

  Size = TPoint(55, 19);
  Caption = FORMAT("%s - %s",
    (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_ABOUT))));

  Text = new TFarText(this);
  Text->Caption = Configuration->FileInfoString["FileDescription"];
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Caption = FORMAT(GetMsg(ABOUT_VERSION), (Configuration->Version));
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Move(0, 1);
  Text->Caption = FORMAT(GetMsg(ABOUT_PRODUCT_VERSION),
    (Configuration->FileInfoString["ProductName"],
     Configuration->ProductVersion));
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Move(0, 1);
  Text->Caption = Configuration->FileInfoString["LegalCopyright"];
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Caption = Configuration->FileInfoString["WWW"];
  Text->Color = 0x79;
  Text->CenterGroup = true;

  Button = new TFarButton(this);
  Button->Move(0, 1);
  Button->Caption = GetMsg(ABOUT_HOMEPAGE);
  Button->OnClick = UrlButtonClick;
  Button->Tag = 1;
  Button->CenterGroup = true;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(ABOUT_FORUM);
  Button->OnClick = UrlButtonClick;
  Button->Tag = 2;
  Button->CenterGroup = true;

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  Text = new TFarText(this);
  Text->Caption = GetMsg(ABOUT_PUTTY);
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Caption = GetMsg(ABOUT_PUTTY2);
  Text->CenterGroup = true;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(ABOUT_PUTTY_HOMEPAGE);
  Button->OnClick = UrlButtonClick;
  Button->Tag = 3;
  Button->CenterGroup = true;

  new TFarSeparator(this);

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Close);
  Button->Default = true;
  Button->Result = brOK;
  Button->CenterGroup = true;
  Button->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TAboutDialog::UrlButtonClick(TFarButton * Sender, bool & /*Close*/)
{
  AnsiString Address;
  switch (Sender->Tag) {
    case 1: Address = Configuration->FileInfoString["WWW"]; break;
    case 2: Address = Configuration->FileInfoString["WWW"] + "forum/"; break;
    case 3: Address = "http://www.chiark.greenend.org.uk/~sgtatham/putty/"; break;
  }
  ShellExecute(NULL, "open", Address.c_str(), NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::AboutDialog()
{
  TFarDialog * Dialog = new TAboutDialog(this);
  try
  {
    Dialog->ShowModal();
  }
  __finally
  {
    delete Dialog;
  }
}
//---------------------------------------------------------------------------
class TSessionDialog : public TFarDialog
{
public:
  __fastcall TSessionDialog(TCustomFarPlugin * AFarPlugin);

  bool __fastcall Execute(TSessionData * Data, bool & Connect);

protected:
  virtual void __fastcall Change();

private:
  int FTab;
  TFarButton * ConnectButton;
  TFarEdit * HostNameEdit;
  TFarEdit * PortNumberEdit;
  TFarEdit * UserNameEdit;
  TFarText * PasswordLabel;
  TFarEdit * PasswordEdit;
  TFarText * PrivateKeyLabel;
  TFarEdit * PrivateKeyEdit;
  TFarRadioButton * SCPonlyButton;
  TFarRadioButton * SFTPButton;
  TFarRadioButton * SFTPonlyButton;
  TFarCheckBox * UpdateDirectoriesCheck;
  TFarCheckBox * CacheDirectoriesCheck;
  TFarCheckBox * ResolveSymlinksCheck;
  TFarEdit * RemoteDirectoryEdit;
  TFarRadioButton * EOLTypeLFButton;
  TFarRadioButton * EOLTypeCRLFButton;
  TFarCheckBox * CompressionCheck;
  TFarRadioButton * SshProt1onlyButton;
  TFarRadioButton * SshProt1Button;
  TFarRadioButton * SshProt2Button;
  TFarRadioButton * SshProt2onlyButton;
  TFarListBox * CipherListBox;
  TFarButton * CipherUpButton;
  TFarButton * CipherDownButton;
  TFarCheckBox * Ssh2DESCheck;

  void __fastcall SelectTab(int Tab);
  void __fastcall Key(TFarDialog * Sender, TFarDialogItem * Item, long Key, bool & Handled);
  void __fastcall CipherButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall TabButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall UpdateControls();
};
//---------------------------------------------------------------------------
__fastcall TSessionDialog::TSessionDialog(TCustomFarPlugin * AFarPlugin) :
  TFarDialog(AFarPlugin)
{
  Size = TPoint(65, 21);

  FTab = 0;
  OnKey = Key;

  TRect CRect = ClientRect;

  TFarButton * Button;
  TFarSeparator * Separator;
  TFarText * Text;
  int GroupTop;
  int Pos;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_SESSION);
  Button->Result = brTab | tabSession;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_ENVIRONMENT);
  Button->Result = brTab | tabEnvironment;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_SSH);
  Button->Result = brTab | tabSsh;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  // Sesion tab

  NextItemPosition = ipNewLine;
  DefaultGroup = tabSession;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_GROUP_SESSION);
  GroupTop = Separator->Top;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_HOST_NAME);

  HostNameEdit = new TFarEdit(this);
  HostNameEdit->Right = CRect.Right - 12 - 2;

  NextItemPosition = ipRight;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PORT_NUMBER);
  Text->Move(0, -1);

  NextItemPosition = ipBelow;

  PortNumberEdit = new TFarEdit(this);
  PortNumberEdit->Fixed = true;
  PortNumberEdit->Mask = "99999";

  NextItemPosition = ipNewLine;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_USER_NAME);

  UserNameEdit = new TFarEdit(this);
  UserNameEdit->Width = UserNameEdit->Width / 2 - 1;

  NextItemPosition = ipRight;

  PasswordLabel = new TFarText(this);
  PasswordLabel->Caption = GetMsg(LOGIN_PASSWORD);
  PasswordLabel->Move(0, -1);

  NextItemPosition = ipBelow;

  PasswordEdit = new TFarEdit(this);
  PasswordEdit->Password = true;

  NextItemPosition = ipNewLine;

  PrivateKeyLabel = new TFarText(this);
  PrivateKeyLabel->Caption = GetMsg(LOGIN_PRIVATE_KEY);

  PrivateKeyEdit = new TFarEdit(this);

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_GROUP_PROTOCOL);

  SCPonlyButton = new TFarRadioButton(this);
  SCPonlyButton->Caption = GetMsg(LOGIN_SCP_ONLY);

  NextItemPosition = ipRight;

  SFTPButton = new TFarRadioButton(this);
  SFTPButton->Caption = GetMsg(LOGIN_SFTP);

  SFTPonlyButton = new TFarRadioButton(this);
  SFTPonlyButton->Caption = GetMsg(LOGIN_SFTP_ONLY);

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  Text = new TFarText(this);
  Text->Top = CRect.Bottom - 3;
  Text->Bottom = Text->Top;
  Text->Caption = GetMsg(LOGIN_TAB_HINT1);
  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TAB_HINT2);

  // Directories tab

  NextItemPosition = ipNewLine;

  DefaultGroup = tabEnvironment;
  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_DIRECTORIES_GROUP);

  UpdateDirectoriesCheck = new TFarCheckBox(this);
  UpdateDirectoriesCheck->Caption = GetMsg(LOGIN_UPDATE_DIRECTORIES);

  CacheDirectoriesCheck = new TFarCheckBox(this);
  CacheDirectoriesCheck->Caption = GetMsg(LOGIN_CACHE_DIRECTORIES);

  ResolveSymlinksCheck = new TFarCheckBox(this);
  ResolveSymlinksCheck->Caption = GetMsg(LOGIN_RESOLVE_SYMLINKS);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_REMOTE_DIRECTORY);

  RemoteDirectoryEdit = new TFarEdit(this);
  RemoteDirectoryEdit->History = REMOTE_DIR_HISTORY;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_EOL_GROUP);

  EOLTypeLFButton = new TFarRadioButton(this);
  EOLTypeLFButton->Caption = GetMsg(LOGIN_EOL_LF);

  NextItemPosition = ipRight;

  EOLTypeCRLFButton = new TFarRadioButton(this);
  EOLTypeCRLFButton->Caption = GetMsg(LOGIN_EOL_CRLF);

  // SSH tab

  NextItemPosition = ipNewLine;

  DefaultGroup = tabSsh;
  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_SSH_GROUP);

  CompressionCheck = new TFarCheckBox(this);
  CompressionCheck->Caption = GetMsg(LOGIN_COMPRESSION);

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_SSH_PROTOCOL_GROUP);

  SshProt1onlyButton = new TFarRadioButton(this);
  SshProt1onlyButton->Caption = GetMsg(LOGIN_SSH1_ONLY);

  NextItemPosition = ipRight;

  SshProt1Button = new TFarRadioButton(this);
  SshProt1Button->Caption = GetMsg(LOGIN_SSH1);

  SshProt2Button = new TFarRadioButton(this);
  SshProt2Button->Caption = GetMsg(LOGIN_SSH2);

  SshProt2onlyButton = new TFarRadioButton(this);
  SshProt2onlyButton->Caption = GetMsg(LOGIN_SSH2_ONLY);

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_ENCRYPTION_GROUP);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_CIPHER);

  CipherListBox = new TFarListBox(this);
  CipherListBox->Right = CipherListBox->Right - 15;
  CipherListBox->Height = 1 + CIPHER_COUNT + 1;
  Pos = CipherListBox->Bottom;

  NextItemPosition = ipRight;

  CipherUpButton = new TFarButton(this);
  CipherUpButton->Caption = GetMsg(LOGIN_CIPHER_UP);
  CipherUpButton->Move(0, 1);
  CipherUpButton->Result = -1;
  CipherUpButton->OnClick = CipherButtonClick;

  NextItemPosition = ipBelow;

  CipherDownButton = new TFarButton(this);
  CipherDownButton->Caption = GetMsg(LOGIN_CIPHER_DOWN);
  CipherDownButton->Result = 1;
  CipherDownButton->OnClick = CipherButtonClick;

  NextItemPosition = ipNewLine;

  Ssh2DESCheck = new TFarCheckBox(this);
  Ssh2DESCheck->Move(0, Pos - Ssh2DESCheck->Top + 1);
  Ssh2DESCheck->Caption = GetMsg(LOGIN_SSH2DES);

  // Buttons

  NextItemPosition = ipNewLine;
  DefaultGroup = 0;

  Separator = new TFarSeparator(this);
  Separator->Position = CRect.Bottom - 1;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_OK);
  Button->Default = true;
  Button->Result = brOK;
  Button->CenterGroup = true;

  NextItemPosition = ipRight;

  ConnectButton = new TFarButton(this);
  ConnectButton->Caption = "Connect";
  ConnectButton->Result = brConnect;
  ConnectButton->CenterGroup = true;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;

}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::UpdateControls()
{
  ConnectButton->Enabled = !HostNameEdit->IsEmpty && !UserNameEdit->IsEmpty;

  if (!PrivateKeyEdit->IsEmpty)
  {
    PasswordEdit->Text = "";
  }
  PasswordLabel->Enabled = PrivateKeyEdit->IsEmpty;
  PasswordEdit->Enabled = PrivateKeyEdit->IsEmpty;

  if (!PasswordEdit->IsEmpty)
  {
    PrivateKeyEdit->Text = "";
  }
  PrivateKeyLabel->Enabled = PasswordEdit->IsEmpty;
  PrivateKeyEdit->Enabled = PasswordEdit->IsEmpty;

  CipherUpButton->Enabled = CipherListBox->Items->Selected;
  CipherDownButton->Enabled =
    CipherListBox->Items->Selected < CipherListBox->Items->Count - 1;
  Ssh2DESCheck->Enabled = !SshProt1onlyButton->Checked;
}
//---------------------------------------------------------------------------
bool __fastcall TSessionDialog::Execute(TSessionData * SessionData, bool & Connect)
{
  if (SessionData->Name.IsEmpty())
  {
    Caption = "Add session";
  }
  else
  {
    Caption = FORMAT("%s - %s",
      ("Edit session", SessionData->Name));
  }

  for (int i = 0; i < ItemCount; i++)
  {
    TFarDialogItem * I = Item[i];
    if (I->Group)
    {
      I->Visible = false;
    }
  }

  SelectTab(tabSession);

  // load session data

  // Basic tab
  HostNameEdit->Text = SessionData->HostName;
  PortNumberEdit->AsInteger = SessionData->PortNumber;
  UserNameEdit->Text = SessionData->UserName;
  PasswordEdit->Text = SessionData->Password;
  PrivateKeyEdit->Text = SessionData->PublicKeyFile;

  switch (SessionData->FSProtocol) {
    case fsSCPonly: SCPonlyButton->Checked = true; break;
    case fsSFTP: SFTPButton->Checked = true; break;
    case fsSFTPonly:
    default: SFTPonlyButton->Checked = true; break;
  }

  // Environment tab
  RemoteDirectoryEdit->Text = SessionData->RemoteDirectory;
  UpdateDirectoriesCheck->Checked = SessionData->UpdateDirectories;
  CacheDirectoriesCheck->Checked = SessionData->CacheDirectories;
  ResolveSymlinksCheck->Checked = SessionData->ResolveSymlinks;

  if (SessionData->EOLType == eolLF)
  {
    EOLTypeLFButton->Checked = true;
  }
  else
  {
    EOLTypeCRLFButton->Checked = true;
  }

  // SSH tab
  CompressionCheck->Checked = SessionData->Compression;

  switch (SessionData->SshProt) {
    case ssh1only:  SshProt1onlyButton->Checked = true; break;
    case ssh1:      SshProt1Button->Checked = true; break;
    case ssh2:      SshProt2Button->Checked = true; break;
    case ssh2only:  SshProt2onlyButton->Checked = true; break;
  }

  CipherListBox->Items->Clear();
  assert(CIPHER_NAME_WARN+CIPHER_COUNT-1 == CIPHER_NAME_DES);
  for (int Index = 0; Index < CIPHER_COUNT; Index++)
  {
    CipherListBox->Items->AddObject(
      GetMsg(CIPHER_NAME_WARN+SessionData->Cipher[Index]),
      (TObject*)SessionData->Cipher[Index]);
  }

  int Button = ShowModal();
  bool Result = (Button == brOK || Button == brConnect);
  Connect = (Button == brConnect);
  if (Result)
  {
    // save session data

    // Basic tab
    SessionData->HostName = HostNameEdit->Text;
    SessionData->PortNumber = PortNumberEdit->AsInteger;
    SessionData->UserName = UserNameEdit->Text;
    SessionData->Password = PasswordEdit->Text;
    SessionData->PublicKeyFile = PrivateKeyEdit->Text;

    if (SCPonlyButton->Checked)
    {
      SessionData->FSProtocol = fsSCPonly;
    }
    else if (SFTPButton->Checked)
    {
      SessionData->FSProtocol = fsSFTP;
    }
    else
    {
      SessionData->FSProtocol = fsSFTPonly;
    }

    // Environment tab
    SessionData->RemoteDirectory = RemoteDirectoryEdit->Text;
    SessionData->UpdateDirectories = UpdateDirectoriesCheck->Checked;
    SessionData->CacheDirectories = CacheDirectoriesCheck->Checked;
    SessionData->ResolveSymlinks = ResolveSymlinksCheck->Checked;

    SessionData->EOLType = EOLTypeLFButton->Checked ? eolLF : eolCRLF;

    // SSH tab
    SessionData->Compression = CompressionCheck->Checked;
    SessionData->Ssh2DES = Ssh2DESCheck->Checked;

    if (SshProt1onlyButton->Checked) SessionData->SshProt = ssh1only;
      else
    if (SshProt1Button->Checked) SessionData->SshProt = ssh1;
      else
    if (SshProt2Button->Checked) SessionData->SshProt = ssh2;
      else SessionData->SshProt = ssh2only;

    for (int Index = 0; Index < CIPHER_COUNT; Index++)
    {
      SessionData->Cipher[Index] = (TCipher)CipherListBox->Items->Objects[Index];
    }
  }

  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::SelectTab(int Tab)
{
  if (FTab != Tab)
  {
    if (FTab)
    {
      ShowGroup(FTab, false);
    }
    ShowGroup(Tab, true);
    FTab = Tab;
  }

  for (int i = 0; i < ItemCount; i++)
  {
    TFarDialogItem * I = Item[i];
    if (I->Group == Tab && I->CanFocus())
    {
      I->SetFocus();
      break;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::Key(
  TFarDialog * /*Sender*/, TFarDialogItem * /*Item*/, long Key, bool & Handled)
{
  if (Key == KEY_CTRLPGDN || Key == KEY_CTRLPGUP)
  {
    int NewTab;
    if (Key == KEY_CTRLPGDN)
    {
      NewTab = FTab == tabCount - 1 ? tabSession : FTab + 1;
    }
    else
    {
      NewTab = FTab == 1 ? tabCount - 1 : FTab - 1;
    }
    SelectTab(NewTab);
    Handled = true;
  }
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::CipherButtonClick(TFarButton * Sender, bool & Close)
{
  if (Sender->Enabled)
  {
    int Source = CipherListBox->Items->Selected;
    int Dest = Source + Sender->Result;

    CipherListBox->Items->Move(Source, Dest);
    CipherListBox->Items->Selected = Dest;
  }

  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::TabButtonClick(TFarButton * Sender, bool & Close)
{
  assert(Sender);
  assert((Sender->Result & brTab) == brTab);

  SelectTab(Sender->Result - brTab);

  Close = false;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::SessionDialog(TSessionData * SessionData, bool & Connect)
{
  bool Result;
  TSessionDialog * Dialog = new TSessionDialog(FPlugin);
  try
  {
    Result = Dialog->Execute(SessionData, Connect);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TRightsContainer : public TFarDialogContainer
{
public:
  __fastcall TRightsContainer(TFarDialog * ADialog, bool AAnyDirectories,
    bool AAllowUndef, bool ShowButtons, TFarDialogItem * EnabledDependency);
  __property bool AddXToDirectories = { read = GetAddXToDirectories, write = SetAddXToDirectories };
  __property TRights Rights = { read = GetRights, write = SetRights };
  __property TFarCheckBox * Checks[TRightsFlag Flag] = { read = GetChecks };
  __property TRightState States[TRightsFlag Flag] = { read = GetStates, write = SetStates };

protected:
  bool FAnyDirectories;
  bool FAllowUndef;
  TFarCheckBox * CheckBoxes[9];
  TFarEdit * OctalEdit;
  TFarCheckBox * DirectoriesXCheck;

  virtual void __fastcall Change();
  void __fastcall UpdateControls();

private:
  TRights __fastcall GetRights();
  void __fastcall SetRights(TRights value);
  void __fastcall SetAddXToDirectories(bool value);
  bool __fastcall GetAddXToDirectories();
  TFarCheckBox * __fastcall GetChecks(TRightsFlag Flag);
  TRightState __fastcall GetStates(TRightsFlag Flag);
  void __fastcall SetStates(TRightsFlag Flag, TRightState value);
  void __fastcall OctalEditExit(TObject * Sender);
  void __fastcall RightsButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TRightsContainer::TRightsContainer(TFarDialog * ADialog,
  bool AAnyDirectories, bool AAllowUndef, bool ShowButtons,
  TFarDialogItem * EnabledDependency) :
  TFarDialogContainer(ADialog)
{
  FAnyDirectories = AAnyDirectories;
  FAllowUndef = AAllowUndef;

  TFarButton * Button;
  TFarText * Text;
  TFarCheckBox * CheckBox;

  Dialog->NextItemPosition = ipNewLine;

  int RowLabels[] = { PROPERTIES_OWNER_RIGHTS, PROPERTIES_GROUP_RIGHTS,
    PROPERTIES_OTHERS_RIGHTS };
  int ColLabels[] = { PROPERTIES_READ_RIGHTS, PROPERTIES_WRITE_RIGHTS,
    PROPERTIES_EXECUTE_RIGHTS };

  for (int RowIndex = 0; RowIndex < 3; RowIndex++)
  {
    Dialog->NextItemPosition = ipNewLine;
    Text = new TFarText(Dialog);
    if (RowIndex == 0)
    {
      Text->Top = 0;
    }
    Text->Left = 0;
    Add(Text);
    Text->EnabledDependency = EnabledDependency;
    Text->Caption = GetMsg(RowLabels[RowIndex]);

    Dialog->NextItemPosition = ipRight;

    for (int ColIndex = 0; ColIndex < 3; ColIndex++)
    {
      CheckBox = new TFarCheckBox(Dialog);
      CheckBoxes[RowIndex * 3 + ColIndex] = CheckBox;
      Add(CheckBox);
      CheckBox->EnabledDependency = EnabledDependency;
      CheckBox->Caption = GetMsg(ColLabels[ColIndex]);
      CheckBox->AllowGrayed = FAllowUndef;
    }
  }

  if (ShowButtons)
  {
    Dialog->NextItemPosition = ipRight;

    Button = new TFarButton(Dialog);
    Add(Button);
    Button->EnabledDependency = EnabledDependency;
    Button->Move(0, -2);
    Button->Caption = GetMsg(PROPERTIES_NONE_RIGHTS);
    Button->Tag = 0000;
    Button->OnClick = RightsButtonClick;

    Dialog->NextItemPosition = ipBelow;

    Button = new TFarButton(Dialog);
    Add(Button);
    Button->EnabledDependency = EnabledDependency;
    Button->Caption = GetMsg(PROPERTIES_DEFAULT_RIGHTS);
    Button->Tag = 0644;
    Button->OnClick = RightsButtonClick;

    Button = new TFarButton(Dialog);
    Add(Button);
    Button->EnabledDependency = EnabledDependency;
    Button->Caption = GetMsg(PROPERTIES_ALL_RIGHTS);
    Button->Tag = 0777;
    Button->OnClick = RightsButtonClick;
  }

  Dialog->NextItemPosition = ipNewLine;

  Text = new TFarText(Dialog);
  Add(Text);
  Text->EnabledDependency = EnabledDependency;
  Text->Left = 0;
  Text->Caption = GetMsg(PROPERTIES_OCTAL);

  Dialog->NextItemPosition = ipRight;

  OctalEdit = new TFarEdit(Dialog);
  Add(OctalEdit);
  OctalEdit->EnabledDependency = EnabledDependency;
  OctalEdit->Width = 4;
  OctalEdit->Mask = "999";
  OctalEdit->OnExit = OctalEditExit;

  if (FAnyDirectories)
  {
    Dialog->NextItemPosition = ipNewLine;

    DirectoriesXCheck = new TFarCheckBox(Dialog);
    Add(DirectoriesXCheck);
    DirectoriesXCheck->EnabledDependency = EnabledDependency;
    DirectoriesXCheck->Left = 0;
    DirectoriesXCheck->Caption = GetMsg(PROPERTIES_DIRECTORIES_X);
  }
  else
  {
    DirectoriesXCheck = NULL;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::RightsButtonClick(TFarButton * Sender,
  bool & /*Close*/)
{
  TRights R = Rights;
  R.Number = (unsigned short)Sender->Tag;
  Rights = R;
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::OctalEditExit(TObject * /*Sender*/)
{
  if (!OctalEdit->Text.Trim().IsEmpty())
  {
    TRights R = Rights;
    R.Octal = OctalEdit->Text.Trim();
    Rights = R;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::UpdateControls()
{
  if (Dialog->Handle)
  {
    TRights R = Rights;

    if (DirectoriesXCheck)
    {
      DirectoriesXCheck->Enabled = !((R.NumberSet & raExecute) == raExecute);
    }

    if (!OctalEdit->Focused())
    {
      OctalEdit->Text = R.IsUndef ? AnsiString() : R.Octal;
    }
    else if (OctalEdit->Text.Trim().Length() == 3)
    {
      try
      {
        OctalEditExit(NULL);
      }
      catch(...)
      {
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::Change()
{
  TFarDialogContainer::Change();

  if (Dialog->Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
TFarCheckBox * __fastcall TRightsContainer::GetChecks(TRightsFlag Flag)
{
  assert((Flag >= 0) && (Flag < LENOF(CheckBoxes)));
  return CheckBoxes[Flag];
}
//---------------------------------------------------------------------------
TRightState __fastcall TRightsContainer::GetStates(TRightsFlag Flag)
{
  switch (Checks[(TRightsFlag)Flag]->Selected) {
    case BSTATE_UNCHECKED: return rsNo;
    case BSTATE_CHECKED: return rsYes;
    case BSTATE_3STATE:
    default: return rsUndef;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::SetStates(TRightsFlag Flag, TRightState value)
{
  assert(((value == rsNo) || (value == rsYes) || (value == rsUndef)));
  TFarCheckBox * CheckBox = Checks[(TRightsFlag)Flag];
  switch (value) {
    case rsNo: CheckBox->Selected = BSTATE_UNCHECKED; break;
    case rsYes: CheckBox->Selected = BSTATE_CHECKED; break;
    case rsUndef: CheckBox->Selected = BSTATE_3STATE; break;
  }
}
//---------------------------------------------------------------------------
TRights __fastcall TRightsContainer::GetRights()
{
  TRights Result;
  Result.AllowUndef = FAllowUndef;
  for (int Flag = 0; Flag < LENOF(CheckBoxes); Flag++)
  {
    Result.RightUndef[(TRightsFlag)Flag] = States[(TRightsFlag)Flag];
  }
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::SetRights(TRights value)
{
  Dialog->LockChanges();
  try
  {
    FAllowUndef = true; // temporarily
    for (int Flag = 0; Flag < LENOF(CheckBoxes); Flag++)
    {
      States[(TRightsFlag)Flag] = value.RightUndef[(TRightsFlag)Flag];
    }
    FAllowUndef = value.AllowUndef;
  }
  __finally
  {
    Dialog->UnlockChanges();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TRightsContainer::GetAddXToDirectories()
{
  return DirectoriesXCheck ? DirectoriesXCheck->Checked : false;
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::SetAddXToDirectories(bool value)
{
  if (DirectoriesXCheck)
  {
    DirectoriesXCheck->Checked = value;
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TPropertiesDialog : public TFarDialog
{
public:
  __fastcall TPropertiesDialog(TCustomFarPlugin * AFarPlugin, TStrings * FileList,
    const AnsiString Directory, TStrings * GroupList, int AllowedChanges);

  bool __fastcall Execute(TRemoteProperties * Properties);

protected:
  virtual void __fastcall Change();
  void __fastcall UpdateProperties(TRemoteProperties & Properties);

private:
  bool FAnyDirectories;
  int FAllowedChanges;
  TRemoteProperties FOrigProperties;
  bool FMultiple;

  TRightsContainer * RightsContainer;
  TFarComboBox * OwnerComboBox;
  TFarComboBox * GroupComboBox;
  TFarCheckBox * RecursiveCheck;
  TFarButton * OkButton;
};
//---------------------------------------------------------------------------
__fastcall TPropertiesDialog::TPropertiesDialog(TCustomFarPlugin * AFarPlugin,
  TStrings * FileList, const AnsiString Directory, TStrings * GroupList,
  int AAllowedChanges) : TFarDialog(AFarPlugin)
{
  FAllowedChanges = AAllowedChanges;

  assert(FileList->Count > 0);
  TRemoteFile * OnlyFile = dynamic_cast<TRemoteFile *>(FileList->Objects[0]);
  assert(OnlyFile);
  FMultiple = (FileList->Count > 1);
  TRemoteFile * File;
  int Directories = 0;

  TStringList * UsedGroupList = NULL;
  TStringList * OwnerList = NULL;

  try
  {
    if (!GroupList)
    {
      UsedGroupList = new TStringList();
      UsedGroupList->Duplicates = dupIgnore;
      UsedGroupList->Sorted = true;
    }
    OwnerList = new TStringList();
    OwnerList->Duplicates = dupIgnore;
    OwnerList->Sorted = true;

    for (int Index = 0; Index < FileList->Count; Index++)
    {
      File = dynamic_cast<TRemoteFile *>(FileList->Objects[Index]);
      assert(File);
      if (UsedGroupList && !File->Group.IsEmpty())
      {
        UsedGroupList->Add(File->Group);
      }
      if (!File->Owner.IsEmpty())
      {
        OwnerList->Add(File->Owner);
      }
      if (File->IsDirectory)
      {
        Directories++;
      }
    }
    FAnyDirectories = (Directories > 0);

    Caption = GetMsg(PROPERTIES_CAPTION);

    Size = TPoint(55, 19);

    TFarButton * Button;
    TFarSeparator * Separator;
    TFarText * Text;
    TRect CRect = ClientRect;

    Text = new TFarText(this);
    Text->Caption = GetMsg(PROPERTIES_PROMPT);
    Text->CenterGroup = true;

    NextItemPosition = ipNewLine;

    Text = new TFarText(this);
    Text->CenterGroup = true;
    if (FileList->Count > 1)
    {
      Text->Caption = FORMAT(GetMsg(PROPERTIES_PROMPT_FILES), (FileList->Count));
    }
    else
    {
      Text->Caption = FORMAT(GetMsg(PROPERTIES_PROMPT_FILE), (FileList->Strings[0]));
    }

    new TFarSeparator(this);

    Text = new TFarText(this);
    Text->Caption = GetMsg(PROPERTIES_OWNER);
    Text->Enabled = FAllowedChanges & cpOwner;

    NextItemPosition = ipRight;

    OwnerComboBox = new TFarComboBox(this);
    OwnerComboBox->Width = 20;
    OwnerComboBox->Enabled = FAllowedChanges & cpOwner;
    OwnerComboBox->Items->Assign(OwnerList);

    NextItemPosition = ipNewLine;

    Text = new TFarText(this);
    Text->Caption = GetMsg(PROPERTIES_GROUP);
    Text->Enabled = FAllowedChanges & cpGroup;

    NextItemPosition = ipRight;

    GroupComboBox = new TFarComboBox(this);
    GroupComboBox->Width = OwnerComboBox->Width;
    GroupComboBox->Enabled = FAllowedChanges & cpGroup;
    GroupComboBox->Items->Assign(UsedGroupList ? UsedGroupList : GroupList);

    NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(this);
    Separator->Caption = GetMsg(PROPERTIES_RIGHTS);

    RightsContainer = new TRightsContainer(this, FAnyDirectories,
      FAnyDirectories || FMultiple, true, NULL);
    RightsContainer->Enabled = FAllowedChanges & cpMode;

    if (FAnyDirectories)
    {
      Separator = new TFarSeparator(this);
      Separator->Position = Separator->Position + RightsContainer->Top;

      RecursiveCheck = new TFarCheckBox(this);
      RecursiveCheck->Caption = GetMsg(PROPERTIES_RECURSIVE);
    }
    else
    {
      RecursiveCheck = NULL;
    }

    NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(this);
    Separator->Position = CRect.Bottom - 1;

    OkButton = new TFarButton(this);
    OkButton->Caption = GetMsg(MSG_BUTTON_OK);
    OkButton->Default = true;
    OkButton->Result = brOK;
    OkButton->CenterGroup = true;

    NextItemPosition = ipRight;

    Button = new TFarButton(this);
    Button->Caption = GetMsg(MSG_BUTTON_Cancel);
    Button->Result = brCancel;
    Button->CenterGroup = true;
  }
  __finally
  {
    delete OwnerList;
    delete UsedGroupList;
  }
}
//---------------------------------------------------------------------------
void __fastcall TPropertiesDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    TRemoteProperties FileProperties;
    UpdateProperties(FileProperties);

    OkButton->Enabled =
      // group name is specified or we set multiple-file properties and
      // no valid group was specified (there are at least two different groups)
      (!GroupComboBox->Text.IsEmpty() ||
       (FMultiple && !FOrigProperties.Valid.Contains(vpGroup)) ||
       (FOrigProperties.Group == GroupComboBox->Text)) &&
      // same but with owner
      (!OwnerComboBox->Text.IsEmpty() ||
       (FMultiple && !FOrigProperties.Valid.Contains(vpOwner)) ||
       (FOrigProperties.Owner == OwnerComboBox->Text)) &&
      ((FileProperties != FOrigProperties) || (RecursiveCheck && RecursiveCheck->Checked));
  }
}
//---------------------------------------------------------------------------
void __fastcall TPropertiesDialog::UpdateProperties(TRemoteProperties & Properties)
{
  if (FAllowedChanges & cpMode)
  {
    Properties.Valid << vpRights;
    Properties.Rights = RightsContainer->Rights;
    Properties.AddXToDirectories = RightsContainer->AddXToDirectories;
  }

  #define STORE_NAME(PROPERTY) \
    if (!PROPERTY ## ComboBox->Text.IsEmpty() && \
        FAllowedChanges & cp ## PROPERTY) \
    { \
      Properties.Valid << vp ## PROPERTY; \
      Properties.PROPERTY = PROPERTY ## ComboBox->Text.Trim(); \
    }
  STORE_NAME(Group);
  STORE_NAME(Owner);
  #undef STORE_NAME

  Properties.Recursive = RecursiveCheck != NULL && RecursiveCheck->Checked;
}
//---------------------------------------------------------------------------
bool __fastcall TPropertiesDialog::Execute(TRemoteProperties * Properties)
{
  TValidProperties Valid;
  if (Properties->Valid.Contains(vpRights) && FAllowedChanges & cpMode) Valid << vpRights;
  if (Properties->Valid.Contains(vpOwner) && FAllowedChanges & cpOwner) Valid << vpOwner;
  if (Properties->Valid.Contains(vpGroup) && FAllowedChanges & cpGroup) Valid << vpGroup;
  FOrigProperties = *Properties;
  FOrigProperties.Valid = Valid;
  FOrigProperties.Recursive = false;

  if (Properties->Valid.Contains(vpRights))
  {
    RightsContainer->Rights = Properties->Rights;
    RightsContainer->AddXToDirectories = Properties->AddXToDirectories;
  }
    else
  {
    RightsContainer->Rights = TRights();
    RightsContainer->AddXToDirectories = false;
  }
  OwnerComboBox->Text = Properties->Valid.Contains(vpOwner) ?
    Properties->Owner : AnsiString();
  GroupComboBox->Text = Properties->Valid.Contains(vpGroup) ?
    Properties->Group : AnsiString();
  if (RecursiveCheck)
  {
    RecursiveCheck->Checked = Properties->Recursive;
  }

  bool Result = ShowModal() != brCancel;
  if (Result)
  {
    *Properties = TRemoteProperties();
    UpdateProperties(*Properties);
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::PropertiesDialog(TStrings * FileList,
  const AnsiString Directory, TStrings * GroupList,
  TRemoteProperties * Properties, int AllowedChanges)
{
  bool Result;
  TPropertiesDialog * Dialog = new TPropertiesDialog(FPlugin, FileList,
    Directory, GroupList, AllowedChanges);
  try
  {
    Result = Dialog->Execute(Properties);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TCopyDialog : TFarDialog
{
public:
  __fastcall TCopyDialog(TCustomFarPlugin * AFarPlugin,
    bool ToRemote, bool Move, TStrings * FileList,
    bool AllowTransferMode);

  bool __fastcall Execute(AnsiString & TargetDirectory, TCopyParamType * Params);

protected:
  virtual void __fastcall Init();
  virtual bool __fastcall CloseQuery();

private:
  TFarEdit * DirectoryEdit;
  TFarRadioButton * TMTextButton;
  TFarRadioButton * TMBinaryButton;
  TFarRadioButton * TMAutomaticButton;
  TFarEdit * AsciiFileMaskEdit;
  TRightsContainer * RightsContainer;
  TFarRadioButton * CCNoChangeButton;
  TFarRadioButton * CCUpperCaseButton;
  TFarRadioButton * CCLowerCaseButton;
  TFarRadioButton * CCFirstUpperCaseButton;
  TFarCheckBox * ReplaceInvalidCharsCheck;
  TFarCheckBox * PreserveRightsCheck;
  TFarCheckBox * PreserveTimeCheck;
  TFarCheckBox * PreserveReadOnlyCheck;
  TFarCheckBox * SaveSettingsCheck;

  bool FExpanded;
  int FExpansionDelta;
  TRect FLastPosition;
  bool FToRemote;
  bool FAllowTransferMode;

  void __fastcall MoreButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TCopyDialog::TCopyDialog(TCustomFarPlugin * AFarPlugin,
  bool ToRemote, bool Move, TStrings * FileList,
  bool AllowTransferMode) : TFarDialog(AFarPlugin)
{
  FToRemote = ToRemote;
  FAllowTransferMode = AllowTransferMode;

  TFarButton * Button;
  TFarSeparator * Separator;
  TFarText * Text;
  TFarBox * Box;

  Size = TPoint(76, 19 + (ToRemote ? 0 : 1));
  TRect CRect = ClientRect;

  Caption = GetMsg(Move ? MOVE_TITLE : COPY_TITLE);
  AnsiString Prompt;
  if (FileList->Count > 1)
  {
    Prompt = FORMAT(GetMsg(Move ? MOVE_FILES_PROMPT : COPY_FILES_PROMPT), (FileList->Count));
  }
  else
  {
    Prompt = FORMAT(GetMsg(Move ? MOVE_FILE_PROMPT : COPY_FILE_PROMPT),
      (FileList->Strings[0]));
  }

  Text = new TFarText(this);
  Text->Caption = Prompt;

  DirectoryEdit = new TFarEdit(this);
  DirectoryEdit->History = ToRemote ? REMOTE_DIR_HISTORY : "Copy";

  DefaultGroup = 1;

  int TMWidth = 37;
  int TMTop;
  int TMBottom;

  Box = new TFarBox(this);
  Box->Left--;
  Box->Width = TMWidth + 2;
  Box->Caption = GetMsg(TRANSFER_MODE);

  NextItemPosition = ipRight;

  Box = new TFarBox(this);
  Box->Left -= 2;
  Box->Right++;
  Box->Caption = GetMsg(TRANSFER_ATTRIBUTES);

  NextItemPosition = ipNewLine;

  TMTextButton = new TFarRadioButton(this);
  TMTop = TMTextButton->Top;
  TMTextButton->Caption = GetMsg(TRANSFER_MODE_TEXT);
  TMTextButton->Enabled = AllowTransferMode;

  TMBinaryButton = new TFarRadioButton(this);
  TMBinaryButton->Caption = GetMsg(TRANSFER_MODE_BINARY);
  TMBinaryButton->Enabled = AllowTransferMode;

  TMAutomaticButton = new TFarRadioButton(this);
  TMAutomaticButton->Caption = GetMsg(TRANSFER_MODE_AUTOMATIC);
  TMAutomaticButton->Enabled = AllowTransferMode;

  Text = new TFarText(this);
  Text->Caption = GetMsg(TRANSFER_MODE_MASK);
  Text->EnabledDependency = TMAutomaticButton;
  Text->Enabled = AllowTransferMode;

  AsciiFileMaskEdit = new TFarEdit(this);
  AsciiFileMaskEdit->EnabledDependency = TMAutomaticButton;
  AsciiFileMaskEdit->Enabled = AllowTransferMode;
  AsciiFileMaskEdit->Width = TMWidth;
  AsciiFileMaskEdit->History = ASCII_MASK_HISTORY;

  Box = new TFarBox(this);
  Box->Left--;
  Box->Width = TMWidth + 2;
  Box->Caption = GetMsg(TRANSFER_FILENAME_MODIFICATION);

  CCNoChangeButton = new TFarRadioButton(this);
  CCNoChangeButton->Caption = GetMsg(TRANSFER_FILENAME_NOCHANGE);

  NextItemPosition = ipRight;

  CCUpperCaseButton = new TFarRadioButton(this);
  CCUpperCaseButton->Caption = GetMsg(TRANSFER_FILENAME_UPPERCASE);

  NextItemPosition = ipNewLine;

  CCLowerCaseButton = new TFarRadioButton(this);
  CCLowerCaseButton->Caption = GetMsg(TRANSFER_FILENAME_LOWERCASE);

  NextItemPosition = ipRight;

  CCFirstUpperCaseButton = new TFarRadioButton(this);
  CCFirstUpperCaseButton->Caption = GetMsg(TRANSFER_FILENAME_FIRSTUPPERCASE);

  NextItemPosition = ipNewLine;

  if (!ToRemote)
  {
    ReplaceInvalidCharsCheck = new TFarCheckBox(this);
    ReplaceInvalidCharsCheck->Caption = GetMsg(TRANSFER_FILENAME_REPLACE_INVALID);
    ReplaceInvalidCharsCheck->Enabled = !ToRemote;
    TMBottom = ReplaceInvalidCharsCheck->Top;
  }
  else
  {
    TMBottom = CCFirstUpperCaseButton->Top;
  }

  if (ToRemote)
  {
    PreserveRightsCheck = new TFarCheckBox(this);
    PreserveRightsCheck->Left += TMWidth + 2;
    PreserveRightsCheck->Top = TMTop;
    PreserveRightsCheck->Bottom = TMTop;
    PreserveRightsCheck->Caption = GetMsg(TRANSFER_PRESERVE_RIGHTS);

    NextItemPosition = ipBelow;

    RightsContainer = new TRightsContainer(this, true, false, false, PreserveRightsCheck);

    PreserveTimeCheck = new TFarCheckBox(this);
    PreserveTimeCheck->Left += TMWidth + 2;
    PreserveTimeCheck->Caption = GetMsg(TRANSFER_PRESERVE_TIMESTAMP);
    PreserveTimeCheck->Top = TMTop + 6;
  }
  else
  {
    PreserveTimeCheck = new TFarCheckBox(this);
    PreserveTimeCheck->Left += TMWidth + 2;
    PreserveTimeCheck->Caption = GetMsg(TRANSFER_PRESERVE_TIMESTAMP);
    PreserveTimeCheck->Move(0, TMTop - PreserveTimeCheck->Top);

    NextItemPosition = ipBelow;

    PreserveReadOnlyCheck = new TFarCheckBox(this);
    PreserveReadOnlyCheck->Caption = GetMsg(TRANSFER_PRESERVE_READONLY);
  }

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Position = TMBottom + 1;

  SaveSettingsCheck = new TFarCheckBox(this);
  SaveSettingsCheck->Caption = GetMsg(TRANSFER_REUSE_SETTINGS);

  DefaultGroup = 0;

  Separator = new TFarSeparator(this);
  Separator->Position = CRect.Bottom - 1;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_OK);
  Button->Default = true;
  Button->Result = brOK;
  Button->CenterGroup = true;
  Button->EnabledDependency = DirectoryEdit;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LESS_BUTTON);
  Button->CenterGroup = true;
  Button->OnClick = MoreButtonClick;
  FExpanded = true;
  FExpansionDelta = Size.y - 8;

  if (!FarConfiguration->CopyParamDialogExpanded)
  {
    bool Close;
    MoreButtonClick(Button, Close);
  }
}
//---------------------------------------------------------------------------
void __fastcall TCopyDialog::MoreButtonClick(TFarButton * Sender, bool & /*Close*/)
{
  LockChanges();
  try
  {
    FExpanded = !FExpanded;
    TRect B = Bounds;
    int Factor;
    if (FExpanded)
    {
      Sender->Caption = GetMsg(LESS_BUTTON);
      ShowGroup(1, true);
      Factor = 1;
    }
    else
    {
      Sender->Caption = GetMsg(MORE_BUTTON);
      ShowGroup(1, false);
      Factor = -1;
    }
    if (FLastPosition == B)
    {
      B.Top -= Factor * FExpansionDelta / 2;
      B.Bottom += Factor * (FExpansionDelta - FExpansionDelta / 2);
      FLastPosition = B;
    }
    else
    {
      B.Bottom += Factor * FExpansionDelta;
      FLastPosition = TRect(-1, -1, -1, -1);
    }
    Bounds = B;
  }
  __finally
  {
    UnlockChanges();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TCopyDialog::Execute(AnsiString & TargetDirectory, TCopyParamType * Params)
{
  DirectoryEdit->Text = TargetDirectory;

  if (FAllowTransferMode)
  {
    switch (Params->TransferMode) {
      case tmAscii: TMTextButton->Checked = true; break;
      case tmBinary: TMBinaryButton->Checked = true; break;
      default: TMAutomaticButton->Checked = true; break;
    }
  }
  else
  {
    TMBinaryButton->Checked = true;
  }

  //FOrigMasks = Params->AsciiFileMask.Masks;
  AsciiFileMaskEdit->Text = Params->AsciiFileMask.Masks;

  switch (Params->FileNameCase) {
    case ncLowerCase: CCLowerCaseButton->Checked = true; break;
    case ncUpperCase: CCUpperCaseButton->Checked = true; break;
    case ncFirstUpperCase: CCFirstUpperCaseButton->Checked = true; break;
    default:
    case ncNoChange: CCNoChangeButton->Checked = true; break;
  }

  if (FToRemote)
  {
    RightsContainer->AddXToDirectories = Params->AddXToDirectories;
    RightsContainer->Rights = Params->Rights;
    PreserveRightsCheck->Checked = Params->PreserveRights;
  }
  else
  {
    PreserveReadOnlyCheck->Checked = Params->PreserveReadOnly;
    ReplaceInvalidCharsCheck->Checked = Params->ReplaceInvalidChars;
  }

  PreserveTimeCheck->Checked = Params->PreserveTime;

  bool Result = ShowModal() != brCancel;

  if (Result)
  {
    TargetDirectory = DirectoryEdit->Text;

    assert(TMTextButton->Checked || TMBinaryButton->Checked || TMAutomaticButton->Checked);
    if (TMTextButton->Checked) Params->TransferMode = tmAscii;
      else
    if (TMAutomaticButton->Checked) Params->TransferMode = tmAutomatic;
      else Params->TransferMode = tmBinary;

    if (Params->TransferMode == tmAutomatic)
    {
      Params->AsciiFileMask.Masks = AsciiFileMaskEdit->Text;
      assert(Params->AsciiFileMask.IsValid());
    }

    if (CCLowerCaseButton->Checked) Params->FileNameCase = ncLowerCase;
      else
    if (CCUpperCaseButton->Checked) Params->FileNameCase = ncUpperCase;
      else
    if (CCFirstUpperCaseButton->Checked) Params->FileNameCase = ncFirstUpperCase;
      else Params->FileNameCase = ncNoChange;

    if (FToRemote)
    {
      Params->AddXToDirectories = RightsContainer->AddXToDirectories;
      Params->Rights = RightsContainer->Rights;
      Params->PreserveRights = PreserveRightsCheck->Checked;
    }
    else
    {
      Params->ReplaceInvalidChars = ReplaceInvalidCharsCheck->Checked;
      Params->PreserveReadOnly = PreserveReadOnlyCheck->Checked;
    }

    Params->PreserveTime = PreserveTimeCheck->Checked;

    Configuration->BeginUpdate();
    try
    {
      FarConfiguration->CopyParamDialogExpanded = FExpanded;
      if (SaveSettingsCheck->Checked)
      {
        Configuration->CopyParam = *Params;
      }
    }
    __finally
    {
      Configuration->EndUpdate();
    }
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TCopyDialog::CloseQuery()
{
  bool CanClose = TFarDialog::CloseQuery();

  if (CanClose && Result >= 0)
  {
    AnsiString Directory = DirectoryEdit->Text;
    if (!FToRemote && !DirectoryExists(Directory))
    {
      if (WinSCPPlugin()->MoreMessageDialog(FORMAT(GetMsg(CREATE_LOCAL_DIRECTORY), (Directory)),
            NULL, qtConfirmation, qaOK | qaCancel) != qaCancel)
      {
        if (!ForceDirectories(Directory))
        {
          DirectoryEdit->SetFocus();
          throw Exception(FORMAT(GetMsg(CREATE_LOCAL_DIR_ERROR), (Directory)));
        }
      }
      else
      {
        DirectoryEdit->SetFocus();
        Abort();
      }
    };

    if (CanClose && TMAutomaticButton->Checked)
    {
      TFileMasks Masks = AsciiFileMaskEdit->Text;
      int Start, Length;
      if (!Masks.IsValid(Start, Length))
      {
        if (!FExpanded)
        {
          bool Close;
          MoreButtonClick(NULL, Close);
        }
        AsciiFileMaskEdit->SetFocus();
        throw Exception(FORMAT(GetMsg(MASK_ERROR), (Masks.Masks.SubString(Start+1, Length))));
      }
    }
  }
  return CanClose;
}
//---------------------------------------------------------------------------
void __fastcall TCopyDialog::Init()
{
  TFarDialog::Init();
  FLastPosition = Bounds;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::CopyDialog(bool ToRemote,
  bool Move, TStrings * FileList, bool AllowTransferMode,
  AnsiString & TargetDirectory, TCopyParamType * Params)
{
  bool Result;
  TCopyDialog * Dialog = new TCopyDialog(FPlugin, ToRemote,
    Move, FileList, AllowTransferMode);
  try
  {
    Result = Dialog->Execute(TargetDirectory, Params);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TLinkDialog : TFarDialog
{
public:
  __fastcall TLinkDialog(TCustomFarPlugin * AFarPlugin,
    bool Edit, bool AllowSymbolic);

  bool __fastcall Execute(AnsiString & FileName, AnsiString & PointTo,
    bool & Symbolic);

protected:
  virtual void __fastcall Change();

private:
  TFarEdit * FileNameEdit;
  TFarEdit * PointToEdit;
  TFarCheckBox * SymbolicCheck;
  TFarButton * OkButton;
};
//---------------------------------------------------------------------------
__fastcall TLinkDialog::TLinkDialog(TCustomFarPlugin * AFarPlugin,
    bool Edit, bool AllowSymbolic) : TFarDialog(AFarPlugin)
{
  TFarButton * Button;
  TFarSeparator * Separator;
  TFarText * Text;

  Size = TPoint(76, 12);
  TRect CRect = ClientRect;

  Caption = GetMsg(Edit ? LINK_EDIT_CAPTION : LINK_ADD_CAPTION);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LINK_FILE);
  Text->Enabled = !Edit;

  FileNameEdit = new TFarEdit(this);
  FileNameEdit->Enabled = !Edit;
  FileNameEdit->History = LINK_FILENAME_HISTORY;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LINK_POINT_TO);

  PointToEdit = new TFarEdit(this);
  PointToEdit->History = LINK_POINT_TO_HISTORY;

  new TFarSeparator(this);

  SymbolicCheck = new TFarCheckBox(this);
  SymbolicCheck->Caption = GetMsg(LINK_SYMLINK);
  SymbolicCheck->Enabled = AllowSymbolic && !Edit;

  Separator = new TFarSeparator(this);
  Separator->Position = CRect.Bottom - 1;

  OkButton = new TFarButton(this);
  OkButton->Caption = GetMsg(MSG_BUTTON_OK);
  OkButton->Default = true;
  OkButton->Result = brOK;
  OkButton->CenterGroup = true;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;
}
//---------------------------------------------------------------------------
void __fastcall TLinkDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    OkButton->Enabled = !FileNameEdit->Text.IsEmpty() &&
      !PointToEdit->Text.IsEmpty();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TLinkDialog::Execute(AnsiString & FileName, AnsiString & PointTo,
    bool & Symbolic)
{
  FileNameEdit->Text = FileName;
  PointToEdit->Text = PointTo;
  SymbolicCheck->Checked = Symbolic;

  bool Result = ShowModal() != brCancel;
  if (Result)
  {
    FileName = FileNameEdit->Text;
    PointTo = PointToEdit->Text;
    Symbolic = SymbolicCheck->Checked;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::LinkDialog(AnsiString & FileName,
  AnsiString & PointTo, bool & Symbolic, bool Edit, bool AllowSymbolic)
{
  bool Result;
  TLinkDialog * Dialog = new TLinkDialog(FPlugin, Edit, AllowSymbolic);
  try
  {
    Result = Dialog->Execute(FileName, PointTo, Symbolic);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}

