#define MainFileSource "..\far.dll"
#define ParentRegistryKey "Software\Martin Prikryl"
#define RegistryKey ParentRegistryKey+"\WinSCP 2"

#define Status ""

#define Major
#define Minor
#define Rev
#define Build
#expr ParseVersion(MainFileSource, Major, Minor, Rev, Build)
#define Version Str(Major)+"."+Str(Minor)+(Rev > 0 ? "."+Str(Rev) : "")+(Status != "" ? " "+Status : "")

[Setup]
AppId=winscpfar
AppName=WinSCP plugin for FAR
AppPublisher=Martin Prikryl
AppPublisherURL=http://winscp.sourceforge.net/eng/far.php
AppSupportURL=http://winscp.sourceforge.net/forum/
AppUpdatesURL=http://winscp.sourceforge.net/eng/download.php
DefaultDirName={pf}\FAR\Plugins\WinSCP
DisableProgramGroupPage=true
LicenseFile=licence
UninstallDisplayIcon={app}\winscp.ico
OutputDir=files_far\
DisableStartupPrompt=yes
AppVersion={#Version}
AppVerName=WinSCP plugin for FAR {#Version}
OutputBaseFilename=winscpfar{#Major}{#Minor}{#Rev}setup
Compression=bzip/9

[Types]
Name: full; Description: "Full installation"
Name: compact; Description: "Compact installation"
Name: custom; Description: "Custom installation"; Flags: iscustom

[Components]
Name: main; Description: "WinSCP plugin for FAR"; Types: full custom compact; Flags: fixed
Name: pageant; Description: "PuTTYgen (key generator)"; Types: full
Name: puttygen; Description: "Pageant (SSH authentication agent)"; Types: full

[Files]
Source: "{#MainFileSource}"; DestName: "WinSCP.dll"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "..\far.lng"; DestName: "WinSCP.lng"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "WinSCP.ico"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "licence"; DestName: "licence"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "C:\Program Files\PuTTY\LICENCE"; DestDir: "{app}\PuTTY"; Components: pageant puttygen; Flags: ignoreversion
Source: "C:\Program Files\PuTTY\putty.hlp"; DestDir: "{app}\PuTTY"; Components: pageant puttygen; Flags: ignoreversion
Source: "C:\Program Files\PuTTY\pageant.exe"; DestDir: "{app}\PuTTY"; Components: pageant; Flags: ignoreversion
Source: "C:\Program Files\PuTTY\puttygen.exe"; DestDir: "{app}\PuTTY"; Components: puttygen; Flags: ignoreversion
