//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "WinSCPPlugin.h"
#include "WinSCPFileSystem.h"
#include "FarTexts.h"
#include "FarDialog.h"
#include "FarConfiguration.h"
#include <GUITools.h>
#include <ScpMain.h>
#include <Common.h>
#include <CopyParam.h>
#include <TextsCore.h>
#include <Terminal.h>
#include <Bookmarks.h>
#include <Queue.h>
#include <farkeys.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
enum TButtonResult { brCancel = -1, brOK = 1, brConnect, brTab = 0xFF00 };
enum TSessionTab { tabSession = 1, tabEnvironment, tabSCP, 
  tabConnection, tabProxy, tabSsh, tabAuthentication, tabBugs, tabCount };
//---------------------------------------------------------------------------
class TWinSCPDialog : public TFarDialog
{
public:
  __fastcall TWinSCPDialog(TCustomFarPlugin * AFarPlugin) : TFarDialog(AFarPlugin)
  {
  }

  void __fastcall AddStandardButtons(int Shift = 0)
  {
    NextItemPosition = ipNewLine;

    TFarSeparator * Separator = new TFarSeparator(this);
    Separator->Top += Shift;
    Separator->Bottom += Shift;

    assert(OkButton == NULL);
    OkButton = new TFarButton(this);
    OkButton->Caption = GetMsg(MSG_BUTTON_OK);
    OkButton->Default = true;
    OkButton->Result = brOK;
    OkButton->CenterGroup = true;

    NextItemPosition = ipRight;

    assert(CancelButton == NULL);
    CancelButton = new TFarButton(this);
    CancelButton->Caption = GetMsg(MSG_BUTTON_Cancel);
    CancelButton->Result = brCancel;
    CancelButton->CenterGroup = true;
  }

  TFarButton * OkButton;
  TFarButton * CancelButton;
};
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::ConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    TFarText * Text;

    Dialog->Size = TPoint(65, 23);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_INTERFACE))));

    TFarCheckBox * DisksMenuCheck = new TFarCheckBox(Dialog);
    DisksMenuCheck->Caption = GetMsg(CONFIG_DISKS_MENU);

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->Caption = GetMsg(CONFIG_HOTKEY_LABEL);
    Text->EnabledDependency = DisksMenuCheck;

    Dialog->NextItemPosition = ipRight;

    TFarRadioButton * AutoHotKeyButton = new TFarRadioButton(Dialog);
    AutoHotKeyButton->Caption = GetMsg(CONFIG_HOTKEY_AUTOASSIGN);
    AutoHotKeyButton->EnabledDependency = DisksMenuCheck;

    TFarRadioButton * ManualHotKeyButton = new TFarRadioButton(Dialog);
    ManualHotKeyButton->Caption = GetMsg(CONFIG_HOTKEY_MANUAL);
    ManualHotKeyButton->EnabledDependency = DisksMenuCheck;

    TFarEdit * HotKeyEdit = new TFarEdit(Dialog);
    HotKeyEdit->Width = 1;
    HotKeyEdit->Fixed = true;
    HotKeyEdit->Mask = "9";
    HotKeyEdit->EnabledDependency = ManualHotKeyButton;

    Text = new TFarText(Dialog);
    Text->Caption = "(1 - 9)";
    Text->EnabledDependency = ManualHotKeyButton;

    Dialog->NextItemPosition = ipNewLine;

    TFarCheckBox * PluginsMenuCheck = new TFarCheckBox(Dialog);
    PluginsMenuCheck->Caption = GetMsg(CONFIG_PLUGINS_MENU);

    TFarCheckBox * PluginsMenuCommandsCheck = new TFarCheckBox(Dialog);
    PluginsMenuCommandsCheck->Caption = GetMsg(CONFIG_PLUGINS_MENU_COMMANDS);

    TFarCheckBox * HostNameInTitleCheck = new TFarCheckBox(Dialog);
    HostNameInTitleCheck->Caption = GetMsg(CONFIG_HOST_NAME_IN_TITLE);

    new TFarSeparator(Dialog);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(CONFIG_COMAND_PREFIXES);

    TFarEdit * CommandPrefixesEdit = new TFarEdit(Dialog);

    new TFarSeparator(Dialog);

    TFarCheckBox * CustomPanelCheck = new TFarCheckBox(Dialog);
    CustomPanelCheck->Caption = GetMsg(CONFIG_PANEL_MODE_CHECK);

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_TYPES);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelTypesEdit = new TFarEdit(Dialog);
    CustomPanelTypesEdit->EnabledDependency = CustomPanelCheck;
    CustomPanelTypesEdit->Width = CustomPanelTypesEdit->Width / 2 - 1;

    Dialog->NextItemPosition = ipRight;

    Text = new TFarText(Dialog);
    Text->EnabledDependency = CustomPanelCheck;
    Text->Move(0, -1);
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_STATUS_TYPES);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelStatusTypesEdit = new TFarEdit(Dialog);
    CustomPanelStatusTypesEdit->EnabledDependency = CustomPanelCheck;

    Dialog->NextItemPosition = ipNewLine;

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_WIDTHS);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelWidthsEdit = new TFarEdit(Dialog);
    CustomPanelWidthsEdit->EnabledDependency = CustomPanelCheck;
    CustomPanelWidthsEdit->Width = CustomPanelTypesEdit->Width;

    Dialog->NextItemPosition = ipRight;

    Text = new TFarText(Dialog);
    Text->EnabledDependency = CustomPanelCheck;
    Text->Move(0, -1);
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_STATUS_WIDTHS);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelStatusWidthsEdit = new TFarEdit(Dialog);
    CustomPanelStatusWidthsEdit->EnabledDependency = CustomPanelCheck;

    Dialog->NextItemPosition = ipNewLine;

    TFarCheckBox * CustomPanelFullScreenCheck = new TFarCheckBox(Dialog);
    CustomPanelFullScreenCheck->Left += 4;
    CustomPanelFullScreenCheck->EnabledDependency = CustomPanelCheck;
    CustomPanelFullScreenCheck->Caption = GetMsg(CONFIG_PANEL_MODE_FULL_SCREEN);

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_HINT);
    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_HINT2);

    Dialog->AddStandardButtons();

    DisksMenuCheck->Checked = FarConfiguration->DisksMenu;
    AutoHotKeyButton->Checked = !FarConfiguration->DisksMenuHotKey;
    ManualHotKeyButton->Checked = FarConfiguration->DisksMenuHotKey;
    HotKeyEdit->Text = FarConfiguration->DisksMenuHotKey ?
      IntToStr(FarConfiguration->DisksMenuHotKey) : AnsiString();
    PluginsMenuCheck->Checked = FarConfiguration->PluginsMenu;
    PluginsMenuCommandsCheck->Checked = FarConfiguration->PluginsMenuCommands;
    HostNameInTitleCheck->Checked = FarConfiguration->HostNameInTitle;
    CommandPrefixesEdit->Text = FarConfiguration->CommandPrefixes;

    CustomPanelCheck->Checked = FarConfiguration->CustomPanelModeDetailed;
    CustomPanelTypesEdit->Text = FarConfiguration->ColumnTypesDetailed;
    CustomPanelWidthsEdit->Text = FarConfiguration->ColumnWidthsDetailed;
    CustomPanelStatusTypesEdit->Text = FarConfiguration->StatusColumnTypesDetailed;
    CustomPanelStatusWidthsEdit->Text = FarConfiguration->StatusColumnWidthsDetailed;
    CustomPanelFullScreenCheck->Checked = FarConfiguration->FullScreenDetailed;

    Result = (Dialog->ShowModal() == brOK);
    if (Result)
    {
      FarConfiguration->DisksMenu = DisksMenuCheck->Checked;
      FarConfiguration->DisksMenuHotKey =
        ManualHotKeyButton->Checked && !HotKeyEdit->IsEmpty ?
          StrToInt(HotKeyEdit->Text) : 0;
      FarConfiguration->PluginsMenu = PluginsMenuCheck->Checked;
      FarConfiguration->PluginsMenuCommands = PluginsMenuCommandsCheck->Checked;
      FarConfiguration->HostNameInTitle = HostNameInTitleCheck->Checked;

      FarConfiguration->CommandPrefixes = CommandPrefixesEdit->Text;

      FarConfiguration->CustomPanelModeDetailed = CustomPanelCheck->Checked;
      FarConfiguration->ColumnTypesDetailed = CustomPanelTypesEdit->Text;
      FarConfiguration->ColumnWidthsDetailed = CustomPanelWidthsEdit->Text;
      FarConfiguration->StatusColumnTypesDetailed = CustomPanelStatusTypesEdit->Text;
      FarConfiguration->StatusColumnWidthsDetailed = CustomPanelStatusWidthsEdit->Text;
      FarConfiguration->FullScreenDetailed = CustomPanelFullScreenCheck->Checked;
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::LoggingConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    TFarSeparator * Separator;

    Dialog->Size = TPoint(65, 11);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_LOGGING))));

    TFarCheckBox * LoggingCheck = new TFarCheckBox(Dialog);
    LoggingCheck->Caption = GetMsg(LOGGING_ENABLE);

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(LOGGING_OPTIONS_GROUP);

    TFarCheckBox * LogToFileCheck = new TFarCheckBox(Dialog);
    LogToFileCheck->Caption = GetMsg(LOGGING_LOG_TO_FILE);
    LogToFileCheck->EnabledDependency = LoggingCheck;

    TFarEdit * LogFileNameEdit = new TFarEdit(Dialog);
    LogFileNameEdit->Left += 4;
    LogFileNameEdit->History = LOG_FILE_HISTORY;
    LogFileNameEdit->EnabledDependency = LogToFileCheck;

    TFarRadioButton * LogFileAppendButton = new TFarRadioButton(Dialog);
    LogFileAppendButton->Left += 4;
    LogFileAppendButton->Caption = GetMsg(LOGGING_LOG_FILE_APPEND);
    LogFileAppendButton->EnabledDependency = LogToFileCheck;

    Dialog->NextItemPosition = ipRight;

    TFarRadioButton * LogFileOverwriteButton = new TFarRadioButton(Dialog);
    LogFileOverwriteButton->Caption = GetMsg(LOGGING_LOG_FILE_OVERWRITE);
    LogFileOverwriteButton->EnabledDependency = LogToFileCheck;

    /*Dialog->NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(LOGGING_LOG_VIEW_GROUP);

    TFarRadioButton * LogWindowCompleteButton = new TFarRadioButton(Dialog);
    LogWindowCompleteButton->Caption = GetMsg(LOGGING_LOG_VIEW_COMPLETE);
    LogWindowCompleteButton->EnabledDependency = LoggingCheck;

    TFarRadioButton * LogWindowLinesButton = new TFarRadioButton(Dialog);
    LogWindowLinesButton->Caption = GetMsg(LOGGING_LOG_VIEW_LINES);
    LogWindowLinesButton->EnabledDependency = LoggingCheck;

    Dialog->NextItemPosition = ipRight;

    TFarEdit * LogWindowLinesEdit = new TFarEdit(Dialog);
    LogWindowLinesEdit->Fixed = true;
    LogWindowLinesEdit->Mask = "9999";
    LogWindowLinesEdit->Width = 7;
    LogWindowLinesEdit->EnabledDependency = LogWindowLinesButton;

    TFarText * Text = new TFarText(Dialog);
    Text->Caption = GetMsg(LOGGING_LOG_VIEW_LINES2);
    Text->EnabledDependency = LoggingCheck;
    */
    Dialog->AddStandardButtons();

    LoggingCheck->Checked = Configuration->Logging;
    LogToFileCheck->Checked = Configuration->LogToFile;
    LogFileNameEdit->Text =
      (!Configuration->LogToFile && Configuration->LogFileName.IsEmpty()) ?
      GetTemporaryPath() + "winscp.log" : Configuration->LogFileName;
    LogFileAppendButton->Checked = Configuration->LogFileAppend;
    LogFileOverwriteButton->Checked = !Configuration->LogFileAppend;
    /*LogWindowCompleteButton->Checked = Configuration->LogWindowComplete;
    LogWindowLinesButton->Checked = !Configuration->LogWindowComplete;
    LogWindowLinesEdit->AsInteger = !Configuration->LogWindowComplete ?
      Configuration->LogWindowLines : 500;*/

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Configuration->BeginUpdate();
      try
      {
        Configuration->Logging = LoggingCheck->Checked;
        Configuration->LogToFile = LogToFileCheck->Checked;
        if (LogToFileCheck->Checked)
        {
          Configuration->LogFileName = LogFileNameEdit->Text;
        }
        Configuration->LogFileAppend = LogFileAppendButton->Checked;
        /*Configuration->LogWindowComplete = LogWindowCompleteButton->Checked;
        if (!LogWindowCompleteButton->Checked)
        {
          Configuration->LogWindowLines = LogWindowLinesEdit->AsInteger;
        } */
      }
      __finally
      {
        Configuration->EndUpdate();
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::TransferConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    TFarSeparator * Separator;
    TFarText * Text;

    Dialog->Size = TPoint(55, 22);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_TRANSFER))));

    TFarCheckBox * CalculateSizeCheck = new TFarCheckBox(Dialog);
    CalculateSizeCheck->Caption = GetMsg(TRANSFER_CALCULATE_SIZE);

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(TRANSFER_RESUME);

    TFarRadioButton * ResumeOnButton = new TFarRadioButton(Dialog);
    ResumeOnButton->Caption = GetMsg(TRANSFER_RESUME_ON);

    TFarRadioButton * ResumeSmartButton = new TFarRadioButton(Dialog);
    ResumeSmartButton->Caption = GetMsg(TRANSFER_RESUME_SMART);
    int ResumeThresholdLeft = ResumeSmartButton->Right;

    TFarRadioButton * ResumeOffButton = new TFarRadioButton(Dialog);
    ResumeOffButton->Caption = GetMsg(TRANSFER_RESUME_OFF);

    TFarEdit * ResumeThresholdEdit = new TFarEdit(Dialog);
    ResumeThresholdEdit->Move(0, -2);
    ResumeThresholdEdit->Left = ResumeThresholdLeft + 3;
    ResumeThresholdEdit->Fixed = true;
    ResumeThresholdEdit->Mask = "9999999";
    ResumeThresholdEdit->Width = 9;
    ResumeThresholdEdit->EnabledDependency = ResumeSmartButton;

    Dialog->NextItemPosition = ipRight;

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(TRANSFER_RESUME_THRESHOLD_UNIT);
    Text->EnabledDependency = ResumeSmartButton;

    Dialog->NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(Dialog);
    Separator->Move(0, 1);
    Separator->Caption = GetMsg(TRANSFER_EDITOR_DOWNLOAD);

    TFarRadioButton * EditorDownloadDefaultButton = new TFarRadioButton(Dialog);
    EditorDownloadDefaultButton->Caption = GetMsg(TRANSFER_EDITOR_DOWNLOAD_DEFAULT);

    TFarRadioButton * EditorDownloadOptionsButton = new TFarRadioButton(Dialog);
    EditorDownloadOptionsButton->Caption = GetMsg(TRANSFER_EDITOR_DOWNLOAD_OPTIONS);

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(TRANSFER_EDITOR_UPLOAD);

    TFarRadioButton * EditorUploadSameButton = new TFarRadioButton(Dialog);
    EditorUploadSameButton->Caption = GetMsg(TRANSFER_EDITOR_UPLOAD_SAME);

    TFarRadioButton * EditorUploadOptionsButton = new TFarRadioButton(Dialog);
    EditorUploadOptionsButton->Caption = GetMsg(TRANSFER_EDITOR_UPLOAD_OPTIONS);

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(TRANSFER_BACKGROUND);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(TRANSFER_QUEUE_LIMIT);

    Dialog->NextItemPosition = ipRight;

    TFarEdit * QueueTransferLimitEdit = new TFarEdit(Dialog);
    QueueTransferLimitEdit->Fixed = true;
    QueueTransferLimitEdit->Mask = "9";
    QueueTransferLimitEdit->Width = 3;

    Dialog->NextItemPosition = ipNewLine;

    TFarCheckBox * QueueCheck = new TFarCheckBox(Dialog);
    QueueCheck->Caption = GetMsg(TRANSFER_QUEUE_DEFAULT);

    TFarCheckBox * QueueAutoPopupCheck = new TFarCheckBox(Dialog);
    QueueAutoPopupCheck->Caption = GetMsg(TRANSFER_AUTO_POPUP);

    TFarCheckBox * RememberPasswordCheck = new TFarCheckBox(Dialog);
    RememberPasswordCheck->Caption = GetMsg(TRANSFER_REMEMBER_PASSWORD);

    Dialog->AddStandardButtons();

    CalculateSizeCheck->Checked = GUIConfiguration->CopyParam.CalculateSize;
    ResumeOnButton->Checked = GUIConfiguration->CopyParam.ResumeSupport == rsOn;
    ResumeSmartButton->Checked = GUIConfiguration->CopyParam.ResumeSupport == rsSmart;
    ResumeOffButton->Checked = GUIConfiguration->CopyParam.ResumeSupport == rsOff;
    ResumeThresholdEdit->AsInteger =
      static_cast<int>(GUIConfiguration->CopyParam.ResumeThreshold / 1024);
    EditorDownloadDefaultButton->Checked = FarConfiguration->EditorDownloadDefaultMode;
    EditorDownloadOptionsButton->Checked = !FarConfiguration->EditorDownloadDefaultMode;
    EditorUploadSameButton->Checked = FarConfiguration->EditorUploadSameOptions;
    EditorUploadOptionsButton->Checked = !FarConfiguration->EditorUploadSameOptions;

    QueueTransferLimitEdit->AsInteger = FarConfiguration->QueueTransfersLimit;
    QueueCheck->Checked = FarConfiguration->CopyParam.Queue;
    QueueAutoPopupCheck->Checked = FarConfiguration->QueueAutoPopup;
    RememberPasswordCheck->Checked = Configuration->RememberPassword;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Configuration->BeginUpdate();
      try
      {
        TGUICopyParamType CopyParam = GUIConfiguration->CopyParam;

        CopyParam.CalculateSize = CalculateSizeCheck->Checked;

        if (ResumeOnButton->Checked) CopyParam.ResumeSupport = rsOn;
        if (ResumeSmartButton->Checked) CopyParam.ResumeSupport = rsSmart;
        if (ResumeOffButton->Checked) CopyParam.ResumeSupport = rsOff;
        CopyParam.ResumeThreshold = ResumeThresholdEdit->AsInteger * 1024;

        FarConfiguration->EditorDownloadDefaultMode = EditorDownloadDefaultButton->Checked;
        FarConfiguration->EditorUploadSameOptions = EditorUploadSameButton->Checked;

        FarConfiguration->QueueTransfersLimit = QueueTransferLimitEdit->AsInteger;
        CopyParam.Queue = QueueCheck->Checked;
        FarConfiguration->QueueAutoPopup = QueueAutoPopupCheck->Checked;
        Configuration->RememberPassword = RememberPasswordCheck->Checked;

        GUIConfiguration->CopyParam = CopyParam;
      }
      __finally
      {
        Configuration->EndUpdate();
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::ConfirmationsConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    Dialog->Size = TPoint(65, 8);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_CONFIRMATIONS))));

    TFarCheckBox * ConfirmOverwritingCheck = new TFarCheckBox(Dialog);
    ConfirmOverwritingCheck->AllowGrayed = true;
    ConfirmOverwritingCheck->Caption = GetMsg(CONFIRMATIONS_CONFIRM_OVERWRITING);

    TFarCheckBox * ContinueOnErrorCheck = new TFarCheckBox(Dialog);
    ContinueOnErrorCheck->Caption = GetMsg(CONFIRMATIONS_CONTINUE_ON_ERROR);

    Dialog->AddStandardButtons();

    ConfirmOverwritingCheck->Selected = !FarConfiguration->ConfirmOverwritingOverride ?
      BSTATE_3STATE : (Configuration->ConfirmOverwriting ? BSTATE_CHECKED :
        BSTATE_UNCHECKED);
    ContinueOnErrorCheck->Checked = FarConfiguration->ContinueOnError;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Configuration->BeginUpdate();
      try
      {
        FarConfiguration->ConfirmOverwritingOverride =
          ConfirmOverwritingCheck->Selected != BSTATE_3STATE;
        if (FarConfiguration->ConfirmOverwritingOverride)
        {
          Configuration->ConfirmOverwriting = ConfirmOverwritingCheck->Checked;
        }
        FarConfiguration->ContinueOnError = ContinueOnErrorCheck->Checked;
      }
      __finally
      {
        Configuration->EndUpdate();
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::IntegrationConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    TFarText * Text;

    Dialog->Size = TPoint(65, 12);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_INTEGRATION))));

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(INTEGRATION_PUTTY);

    TFarEdit * PuttyPathEdit = new TFarEdit(Dialog);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(INTEGRATION_PAGEANT);

    TFarEdit * PageantPathEdit = new TFarEdit(Dialog);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(INTEGRATION_PUTTYGEN);

    TFarEdit * PuttygenPathEdit = new TFarEdit(Dialog);

    Dialog->AddStandardButtons();

    PuttyPathEdit->Text = FarConfiguration->PuttyPath;
    PageantPathEdit->Text = FarConfiguration->PageantPath;
    PuttygenPathEdit->Text = FarConfiguration->PuttygenPath;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Configuration->BeginUpdate();
      try
      {
        FarConfiguration->PuttyPath = PuttyPathEdit->Text;
        FarConfiguration->PageantPath = PageantPathEdit->Text;
        FarConfiguration->PuttygenPath = PuttygenPathEdit->Text;
      }
      __finally
      {
        Configuration->EndUpdate();
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
class TAboutDialog : public TFarDialog
{
public:
  __fastcall TAboutDialog(TCustomFarPlugin * AFarPlugin);

private:
  void __fastcall UrlButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TAboutDialog::TAboutDialog(TCustomFarPlugin * AFarPlugin) :
  TFarDialog(AFarPlugin)
{
  TFarText * Text;
  TFarButton * Button;

  Size = TPoint(55, 19);
  Caption = FORMAT("%s - %s",
    (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_ABOUT))));

  Text = new TFarText(this);
  Text->Caption = Configuration->FileInfoString["FileDescription"];
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Caption = FORMAT(GetMsg(ABOUT_VERSION), (Configuration->Version));
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Move(0, 1);
  Text->Caption = FORMAT(GetMsg(ABOUT_PRODUCT_VERSION),
    (Configuration->FileInfoString["ProductName"],
     Configuration->ProductVersion));
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Move(0, 1);
  Text->Caption = Configuration->FileInfoString["LegalCopyright"];
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Caption = Configuration->FileInfoString["WWW"];
  Text->Color = 0x79;
  Text->CenterGroup = true;

  Button = new TFarButton(this);
  Button->Move(0, 1);
  Button->Caption = GetMsg(ABOUT_HOMEPAGE);
  Button->OnClick = UrlButtonClick;
  Button->Tag = 1;
  Button->CenterGroup = true;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(ABOUT_FORUM);
  Button->OnClick = UrlButtonClick;
  Button->Tag = 2;
  Button->CenterGroup = true;

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  Text = new TFarText(this);
  Text->Caption = GetMsg(ABOUT_PUTTY);
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Caption = GetMsg(ABOUT_PUTTY2);
  Text->CenterGroup = true;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(ABOUT_PUTTY_HOMEPAGE);
  Button->OnClick = UrlButtonClick;
  Button->Tag = 3;
  Button->CenterGroup = true;

  new TFarSeparator(this);

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Close);
  Button->Default = true;
  Button->Result = brOK;
  Button->CenterGroup = true;
  Button->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TAboutDialog::UrlButtonClick(TFarButton * Sender, bool & /*Close*/)
{
  AnsiString Address;
  switch (Sender->Tag) {
    case 1: Address = Configuration->FileInfoString["WWW"] + "eng/far.php"; break;
    case 2: Address = Configuration->FileInfoString["WWW"] + "forum/"; break;
    case 3: Address = LoadStr(PUTTY_URL); break;
  }
  ShellExecute(NULL, "open", Address.c_str(), NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::AboutDialog()
{
  TFarDialog * Dialog = new TAboutDialog(this);
  try
  {
    Dialog->ShowModal();
  }
  __finally
  {
    delete Dialog;
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TPasswordDialog : public TFarDialog
{
public:
  __fastcall TPasswordDialog(TCustomFarPlugin * AFarPlugin,
    AnsiString Prompt, TPromptKind Kind);

  bool __fastcall Execute(AnsiString & Password);

protected:
  virtual void __fastcall Change();

private:
  AnsiString FPrompt;
  TFarEdit * PasswordEdit;
  TFarEdit * NormalEdit;
  TFarCheckBox * HideTypingCheck;
  
  void __fastcall ShowPromptClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TPasswordDialog::TPasswordDialog(TCustomFarPlugin * AFarPlugin,
    AnsiString Prompt, TPromptKind Kind) : TFarDialog(AFarPlugin)
{
  TFarButton * Button;
  TFarText * Text;

  FPrompt = Prompt;

  TPoint S = TPoint(50 + (Kind == pkServerPrompt ? 25 : 0),
    8 + (Kind == pkServerPrompt ? 4 : 0));
  int P = Prompt.Pos("\n");
  if (P > 0)
  {
    Prompt.SetLength(P - 1);
  }
  P = Prompt.Pos("\r");
  if (P > 0)
  {
    Prompt.SetLength(P - 1);
  }
  if (S.x - 10 < Prompt.Length())
  {
    S.x = Prompt.Length() + 10;
    if (S.x > 80)
    {
      Prompt.SetLength(80 - 10 - 4);
      Prompt += " ...";
      S.x = 80;
    }
  }
  Size = S;

  int Msg;
  switch (Kind) {
    case pkPassphrase:
      Msg = PASSPHRASE_TITLE;
      break;
    case pkServerPrompt:
      Msg = SERVER_PASSWORD_TITLE;
      break;
    default:
      assert(false);
    case pkPassword:
      Msg = PASSWORD_TITLE;
      break;
  }
  Caption = GetMsg(Msg);

  Text = new TFarText(this);
  Text->Caption = Prompt;

  PasswordEdit = new TFarEdit(this);
  PasswordEdit->Password = true;

  if (Kind == pkServerPrompt)
  {
    NormalEdit = new TFarEdit(this);
    NormalEdit->Move(0, -1);
    NormalEdit->Visible = false;
  }
  else
  {
    NormalEdit = NULL;
  }

  if (Kind == pkServerPrompt)
  {
    new TFarSeparator(this);

    HideTypingCheck = new TFarCheckBox(this);
    HideTypingCheck->Caption = GetMsg(SERVER_PASSWORD_HIDE_TYPING);
    HideTypingCheck->Checked = true;

    Text = new TFarText(this);
    Text->Caption = GetMsg(SERVER_PASSWORD_NOTE1);
    Text = new TFarText(this);
    Text->Caption = GetMsg(SERVER_PASSWORD_NOTE2);
  }
  else
  {
    HideTypingCheck = NULL;
  }

  new TFarSeparator(this);

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_OK);
  Button->Default = true;
  Button->Result = brOK;
  Button->CenterGroup = true;

  NextItemPosition = ipRight;

  if (Prompt != FPrompt)
  {
    Button = new TFarButton(this);
    Button->Caption = GetMsg(PASSWORD_SHOW_PROMPT);
    Button->OnClick = ShowPromptClick;
    Button->CenterGroup = true;
  }

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;
}
//---------------------------------------------------------------------------
void __fastcall TPasswordDialog::ShowPromptClick(TFarButton * /*Sender*/,
  bool & /*Close*/)
{
  TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);

  WinSCPPlugin->MoreMessageDialog(FPrompt, NULL, qtInformation, qaOK);
}
//---------------------------------------------------------------------------
void __fastcall TPasswordDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    if (HideTypingCheck &&
        (HideTypingCheck->Checked != PasswordEdit->Visible))
    {
      AnsiString Value;
      Value = HideTypingCheck->Checked ? NormalEdit->Text : PasswordEdit->Text;
      PasswordEdit->Visible = HideTypingCheck->Checked;
      NormalEdit->Visible = !HideTypingCheck->Checked;
      (HideTypingCheck->Checked ? PasswordEdit : NormalEdit)->Text = Value;
    }
  }
}
//---------------------------------------------------------------------------
bool __fastcall TPasswordDialog::Execute(AnsiString & Password)
{
  PasswordEdit->Text = Password;

  bool Result = (ShowModal() != brCancel);
  if (Result)
  {
    Password = (!HideTypingCheck || HideTypingCheck->Checked) ?
      PasswordEdit->Text : NormalEdit->Text;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::PasswordDialog(AnsiString Prompt, TPromptKind Kind,
  AnsiString & Password)
{
  bool Result;
  TPasswordDialog * Dialog = new TPasswordDialog(FPlugin, Prompt, Kind);
  try
  {
    Result = Dialog->Execute(Password);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
class TSessionDialog : public TFarDialog
{
public:
  __fastcall TSessionDialog(TCustomFarPlugin * AFarPlugin, bool DefaultSave);

  bool __fastcall Execute(TSessionData * Data, bool & Connect);

protected:
  virtual void __fastcall Change();

private:
  int FTab;
  bool FEditing;
  TFarButton * ConnectButton;
  TFarEdit * HostNameEdit;
  TFarEdit * PortNumberEdit;
  TFarEdit * UserNameEdit;
  TFarText * PasswordLabel;
  TFarEdit * PasswordEdit;
  TFarText * PrivateKeyLabel;
  TFarEdit * PrivateKeyEdit;
  TFarRadioButton * SCPonlyButton;
  TFarRadioButton * SFTPButton;
  TFarRadioButton * SFTPonlyButton;
  TFarCheckBox * UpdateDirectoriesCheck;
  TFarCheckBox * CacheDirectoriesCheck;
  TFarCheckBox * CacheDirectoryChangesCheck;
  TFarCheckBox * PreserveDirectoryChangesCheck;
  TFarCheckBox * ResolveSymlinksCheck;
  TFarEdit * RemoteDirectoryEdit;
  TFarRadioButton * EOLTypeLFButton;
  TFarRadioButton * EOLTypeCRLFButton;
  TFarRadioButton * ConsiderDSTOnCheck;
  TFarRadioButton * ConsiderDSTOffCheck;
  TFarCheckBox * CompressionCheck;
  TFarRadioButton * SshProt1onlyButton;
  TFarRadioButton * SshProt1Button;
  TFarRadioButton * SshProt2Button;
  TFarRadioButton * SshProt2onlyButton;
  TFarListBox * CipherListBox;
  TFarButton * CipherUpButton;
  TFarButton * CipherDownButton;
  TFarCheckBox * Ssh2DESCheck;
  TFarRadioButton * DefaultShellButton;
  TFarRadioButton * ShellEnterButton;
  TFarComboBox * ShellEdit;
  TFarRadioButton * ReturnVarAutodetectButton;
  TFarRadioButton * ReturnVarEnterButton;
  TFarComboBox * ReturnVarEdit;
  TFarCheckBox * LookupUserGroupsCheck;
  TFarCheckBox * ClearAliasesCheck;
  TFarCheckBox * UnsetNationalVarsCheck;
  TFarCheckBox * AliasGroupListCheck;
  TFarCheckBox * IgnoreLsWarningsCheck;
  TFarCheckBox * Scp1CompatibilityCheck;
  TFarEdit * TimeDifferenceEdit;
  TFarEdit * TimeDifferenceMinutesEdit;
  TFarEdit * TimeoutEdit;
  TFarRadioButton * PingOffButton;
  TFarRadioButton * PingNullPacketButton;
  TFarRadioButton * PingDummyCommandButton;
  TFarEdit * PingIntervalSecEdit;
  TFarRadioButton * ProxyNoneButton;
  TFarRadioButton * ProxySocks4Button;
  TFarRadioButton * ProxySocks5Button;
  TFarRadioButton * ProxyHTTPButton;
  TFarRadioButton * ProxyTelnetButton;
  TFarEdit * ProxyHostEdit;
  TFarEdit * ProxyPortEdit;
  TFarEdit * ProxyUsernameEdit;
  TFarEdit * ProxyPasswordEdit;
  TFarEdit * ProxyTelnetCommandEdit;
  TFarCheckBox * ProxyLocalhostCheck;
  TFarRadioButton * ProxyDNSOffButton;
  TFarRadioButton * ProxyDNSAutoButton;
  TFarRadioButton * ProxyDNSOnButton;
  TFarComboBox * BugIgnore1Combo;
  TFarComboBox * BugPlainPW1Combo;
  TFarComboBox * BugRSA1Combo;
  TFarComboBox * BugHMAC2Combo;
  TFarComboBox * BugDeriveKey2Combo;
  TFarComboBox * BugRSAPad2Combo;
  TFarComboBox * BugDHGEx2Combo;
  TFarComboBox * BugPKSessID2Combo;
  TFarCheckBox * AuthTISCheck;
  TFarCheckBox * AuthKICheck;
  TFarCheckBox * AuthKIPasswordCheck;
  TFarCheckBox * AgentFwdCheck;
  TFarCheckBox * AuthGSSAPICheck;

  void __fastcall SelectTab(int Tab);
  void __fastcall Key(TFarDialog * Sender, TFarDialogItem * Item, long Key, bool & Handled);
  void __fastcall CipherButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall TabButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall AuthGSSAPICheckAllowChange(TFarDialogItem * Sender, long NewState, bool & Allow);
  void __fastcall UpdateControls();
};
//---------------------------------------------------------------------------
#define BUGS() \
  BUG(Ignore1, LOGIN_BUGS_IGNORE1); \
  BUG(PlainPW1, LOGIN_BUGS_PLAIN_PW1); \
  BUG(RSA1, LOGIN_BUGS_RSA1); \
  BUG(HMAC2, LOGIN_BUGS_HMAC2); \
  BUG(DeriveKey2, LOGIN_BUGS_DERIVE_KEY2); \
  BUG(RSAPad2, LOGIN_BUGS_RSA_PAD2); \
  BUG(DHGEx2, LOGIN_BUGS_DHGEX2); \
  BUG(PKSessID2, LOGIN_BUGS_PKSESSID2);
//---------------------------------------------------------------------------
__fastcall TSessionDialog::TSessionDialog(TCustomFarPlugin * AFarPlugin,
  bool DefaultSave) : TFarDialog(AFarPlugin)
{
  Size = TPoint(66, 22);

  FTab = 0;
  OnKey = Key;

  TRect CRect = ClientRect;

  TFarButton * Button;
  TFarSeparator * Separator;
  TFarText * Text;
  int GroupTop;
  int Pos;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_SESSION);
  Button->Result = brTab | tabSession;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_ENVIRONMENT);
  Button->Result = brTab | tabEnvironment;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_SCP);
  Button->Result = brTab | tabSCP;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_CONNECTION);
  Button->Result = brTab | tabConnection;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  NextItemPosition = ipNewLine;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_PROXY);
  Button->Result = brTab | tabProxy;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_SSH);
  Button->Result = brTab | tabSsh;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_AUTH);
  Button->Result = brTab | tabAuthentication;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(LOGIN_TAB_BUGS);
  Button->Result = brTab | tabBugs;
  Button->CenterGroup = true;
  Button->OnClick = TabButtonClick;

  // Sesion tab

  NextItemPosition = ipNewLine;
  DefaultGroup = tabSession;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_GROUP_SESSION);
  GroupTop = Separator->Top;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_HOST_NAME);

  HostNameEdit = new TFarEdit(this);
  HostNameEdit->Right = CRect.Right - 12 - 2;

  NextItemPosition = ipRight;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PORT_NUMBER);
  Text->Move(0, -1);

  NextItemPosition = ipBelow;

  PortNumberEdit = new TFarEdit(this);
  PortNumberEdit->Fixed = true;
  PortNumberEdit->Mask = "99999";

  NextItemPosition = ipNewLine;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_USER_NAME);

  UserNameEdit = new TFarEdit(this);
  UserNameEdit->Width = UserNameEdit->Width / 2 - 1;

  NextItemPosition = ipRight;

  PasswordLabel = new TFarText(this);
  PasswordLabel->Caption = GetMsg(LOGIN_PASSWORD);
  PasswordLabel->Move(0, -1);

  NextItemPosition = ipBelow;

  PasswordEdit = new TFarEdit(this);
  PasswordEdit->Password = true;

  NextItemPosition = ipNewLine;

  PrivateKeyLabel = new TFarText(this);
  PrivateKeyLabel->Caption = GetMsg(LOGIN_PRIVATE_KEY);

  PrivateKeyEdit = new TFarEdit(this);

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_GROUP_PROTOCOL);

  SCPonlyButton = new TFarRadioButton(this);
  SCPonlyButton->Caption = GetMsg(LOGIN_SCP_ONLY);

  NextItemPosition = ipRight;

  SFTPButton = new TFarRadioButton(this);
  SFTPButton->Caption = GetMsg(LOGIN_SFTP);

  SFTPonlyButton = new TFarRadioButton(this);
  SFTPonlyButton->Caption = GetMsg(LOGIN_SFTP_ONLY);

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  Text = new TFarText(this);
  Text->Top = CRect.Bottom - 3;
  Text->Bottom = Text->Top;
  Text->Caption = GetMsg(LOGIN_TAB_HINT1);
  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TAB_HINT2);

  // Environment tab

  NextItemPosition = ipNewLine;

  DefaultGroup = tabEnvironment;
  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_DIRECTORIES_GROUP);

  UpdateDirectoriesCheck = new TFarCheckBox(this);
  UpdateDirectoriesCheck->Caption = GetMsg(LOGIN_UPDATE_DIRECTORIES);

  CacheDirectoriesCheck = new TFarCheckBox(this);
  CacheDirectoriesCheck->Caption = GetMsg(LOGIN_CACHE_DIRECTORIES);

  CacheDirectoryChangesCheck = new TFarCheckBox(this);
  CacheDirectoryChangesCheck->Caption = GetMsg(LOGIN_CACHE_DIRECTORY_CHANGES);

  PreserveDirectoryChangesCheck = new TFarCheckBox(this);
  PreserveDirectoryChangesCheck->Caption = GetMsg(LOGIN_PRESERVE_DIRECTORY_CHANGES);
  PreserveDirectoryChangesCheck->EnabledDependency = CacheDirectoryChangesCheck;
  PreserveDirectoryChangesCheck->Left += 4;

  ResolveSymlinksCheck = new TFarCheckBox(this);
  ResolveSymlinksCheck->Caption = GetMsg(LOGIN_RESOLVE_SYMLINKS);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_REMOTE_DIRECTORY);

  RemoteDirectoryEdit = new TFarEdit(this);
  RemoteDirectoryEdit->History = REMOTE_DIR_HISTORY;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_EOL_GROUP);

  EOLTypeLFButton = new TFarRadioButton(this);
  EOLTypeLFButton->Caption = GetMsg(LOGIN_EOL_LF);

  NextItemPosition = ipRight;

  EOLTypeCRLFButton = new TFarRadioButton(this);
  EOLTypeCRLFButton->Caption = GetMsg(LOGIN_EOL_CRLF);

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_CONSIDER_DST_GROUP);

  ConsiderDSTOnCheck = new TFarRadioButton(this);
  ConsiderDSTOnCheck->Caption = GetMsg(LOGIN_CONSIDER_DST_ON);

  ConsiderDSTOffCheck = new TFarRadioButton(this);
  ConsiderDSTOffCheck->Caption = GetMsg(LOGIN_CONSIDER_DST_OFF);

  // SCP Tab

  NextItemPosition = ipNewLine;

  DefaultGroup = tabSCP;

  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_SHELL_GROUP);

  DefaultShellButton = new TFarRadioButton(this);
  DefaultShellButton->Caption = GetMsg(LOGIN_SHELL_DEFAULT);

  NextItemPosition = ipRight;

  ShellEnterButton = new TFarRadioButton(this);
  ShellEnterButton->Caption = GetMsg(LOGIN_SHELL_ENTER);

  ShellEdit = new TFarComboBox(this);
  ShellEdit->Items->Add("/bin/bash");
  ShellEdit->Items->Add("/bin/ksh");
  ShellEdit->EnabledDependency = ShellEnterButton;

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_RETURN_VAR_GROUP);

  ReturnVarAutodetectButton = new TFarRadioButton(this);
  ReturnVarAutodetectButton->Caption = GetMsg(LOGIN_RETURN_VAR_AUTODETECT);

  NextItemPosition = ipRight;

  ReturnVarEnterButton = new TFarRadioButton(this);
  ReturnVarEnterButton->Caption = GetMsg(LOGIN_RETURN_VAR_ENTER);

  ReturnVarEdit = new TFarComboBox(this);
  ReturnVarEdit->Items->Add("?");
  ReturnVarEdit->Items->Add("status");
  ReturnVarEdit->EnabledDependency = ReturnVarEnterButton;

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_SCP_OPTIONS);

  LookupUserGroupsCheck = new TFarCheckBox(this);
  LookupUserGroupsCheck->Caption = GetMsg(LOGIN_LOOKUP_USER_GROUPS);

  NextItemPosition = ipRight;

  UnsetNationalVarsCheck = new TFarCheckBox(this);
  UnsetNationalVarsCheck->Caption = GetMsg(LOGIN_CLEAR_NATIONAL_VARS);

  NextItemPosition = ipNewLine;

  ClearAliasesCheck = new TFarCheckBox(this);
  ClearAliasesCheck->Caption = GetMsg(LOGIN_CLEAR_ALIASES);

  NextItemPosition = ipRight;

  AliasGroupListCheck = new TFarCheckBox(this);
  AliasGroupListCheck->Caption = GetMsg(LOGIN_ALIAS_GROUP_LIST);

  NextItemPosition = ipNewLine;

  IgnoreLsWarningsCheck = new TFarCheckBox(this);
  IgnoreLsWarningsCheck->Caption = GetMsg(LOGIN_IGNORE_LS_WARNINGS);

  NextItemPosition = ipRight;

  Scp1CompatibilityCheck = new TFarCheckBox(this);
  Scp1CompatibilityCheck->Caption = GetMsg(LOGIN_SCP1_COMPATIBILITY);

  NextItemPosition = ipNewLine;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TIME_DIFFERENCE);

  NextItemPosition = ipRight;

  TimeDifferenceEdit = new TFarEdit(this);
  TimeDifferenceEdit->Fixed = true;
  TimeDifferenceEdit->Mask = "###";
  TimeDifferenceEdit->Width = 4;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TIME_DIFFERENCE_HOURS);

  TimeDifferenceMinutesEdit = new TFarEdit(this);
  TimeDifferenceMinutesEdit->Fixed = true;
  TimeDifferenceMinutesEdit->Mask = "###";
  TimeDifferenceMinutesEdit->Width = 4;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TIME_DIFFERENCE_MINUTES);

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  // Connection tab

  NextItemPosition = ipNewLine;

  DefaultGroup = tabConnection;
  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_TIMEOUTS_GROUP);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TIMEOUT);

  NextItemPosition = ipRight;

  TimeoutEdit = new TFarEdit(this);
  TimeoutEdit->Fixed = true;
  TimeoutEdit->Mask = "###";
  TimeoutEdit->Width = 4;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TIMEOUT_SECONDS);

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_PING_GROUP);

  PingOffButton = new TFarRadioButton(this);
  PingOffButton->Caption = GetMsg(LOGIN_PING_OFF);

  PingNullPacketButton = new TFarRadioButton(this);
  PingNullPacketButton->Caption = GetMsg(LOGIN_PING_NULL_PACKET);

  PingDummyCommandButton = new TFarRadioButton(this);
  PingDummyCommandButton->Caption = GetMsg(LOGIN_PING_DUMMY_COMMAND);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PING_INTERVAL);
  Text->EnabledDependencyNegative = PingOffButton;

  NextItemPosition = ipRight;

  PingIntervalSecEdit = new TFarEdit(this);
  PingIntervalSecEdit->Fixed = true;
  PingIntervalSecEdit->Mask = "###";
  PingIntervalSecEdit->Width = 4;
  PingIntervalSecEdit->EnabledDependencyNegative = PingOffButton;

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  // Proxy tab

  DefaultGroup = tabProxy;
  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_PROXY_GROUP);

  ProxyNoneButton = new TFarRadioButton(this);
  ProxyNoneButton->Caption = GetMsg(LOGIN_PROXY_NONE);

  NextItemPosition = ipRight;

  ProxySocks4Button = new TFarRadioButton(this);
  ProxySocks4Button->Caption = GetMsg(LOGIN_PROXY_SOCKS4);

  ProxySocks5Button = new TFarRadioButton(this);
  ProxySocks5Button->Caption = GetMsg(LOGIN_PROXY_SOCKS5);

  ProxyHTTPButton = new TFarRadioButton(this);
  ProxyHTTPButton->Caption = GetMsg(LOGIN_PROXY_HTTP);

  ProxyTelnetButton = new TFarRadioButton(this);
  ProxyTelnetButton->Caption = GetMsg(LOGIN_PROXY_TELNET);

  NextItemPosition = ipNewLine;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_HOST);
  Text->EnabledDependencyNegative = ProxyNoneButton;

  ProxyHostEdit = new TFarEdit(this);
  ProxyHostEdit->Right = CRect.Right - 12 - 2;
  ProxyHostEdit->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipRight;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_PORT);
  Text->Move(0, -1);
  Text->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipBelow;

  ProxyPortEdit = new TFarEdit(this);
  ProxyPortEdit->Fixed = true;
  ProxyPortEdit->Mask = "99999";
  ProxyPortEdit->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipNewLine;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_USERNAME);
  Text->EnabledDependencyNegative = ProxyNoneButton;

  ProxyUsernameEdit = new TFarEdit(this);
  ProxyUsernameEdit->Width = ProxyUsernameEdit->Width / 2 - 1;
  ProxyUsernameEdit->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipRight;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_PASSWORD);
  Text->Move(0, -1);
  Text->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipBelow;

  ProxyPasswordEdit = new TFarEdit(this);
  ProxyPasswordEdit->Password = true;
  ProxyPasswordEdit->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_PROXY_SETTINGS_GROUP);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_TELNET_COMMAND);
  Text->EnabledDependency = ProxyTelnetButton;

  NextItemPosition = ipRight;

  ProxyTelnetCommandEdit = new TFarEdit(this);
  ProxyTelnetCommandEdit->EnabledDependency = ProxyTelnetButton;

  NextItemPosition = ipNewLine;

  ProxyLocalhostCheck = new TFarCheckBox(this);
  ProxyLocalhostCheck->Caption = GetMsg(LOGIN_PROXY_LOCALHOST);
  ProxyLocalhostCheck->EnabledDependencyNegative = ProxyNoneButton;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_DNS);
  Text->EnabledDependencyNegative = ProxyNoneButton;

  ProxyDNSOffButton = new TFarRadioButton(this);
  ProxyDNSOffButton->Caption = GetMsg(LOGIN_PROXY_DNS_NO);
  ProxyDNSOffButton->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipRight;

  ProxyDNSAutoButton = new TFarRadioButton(this);
  ProxyDNSAutoButton->Caption = GetMsg(LOGIN_PROXY_DNS_AUTO);
  ProxyDNSAutoButton->EnabledDependencyNegative = ProxyNoneButton;

  ProxyDNSOnButton = new TFarRadioButton(this);
  ProxyDNSOnButton->Caption = GetMsg(LOGIN_PROXY_DNS_YES);
  ProxyDNSOnButton->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  // SSH tab

  NextItemPosition = ipNewLine;

  DefaultGroup = tabSsh;
  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_SSH_GROUP);

  CompressionCheck = new TFarCheckBox(this);
  CompressionCheck->Caption = GetMsg(LOGIN_COMPRESSION);

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_SSH_PROTOCOL_GROUP);

  SshProt1onlyButton = new TFarRadioButton(this);
  SshProt1onlyButton->Caption = GetMsg(LOGIN_SSH1_ONLY);

  NextItemPosition = ipRight;

  SshProt1Button = new TFarRadioButton(this);
  SshProt1Button->Caption = GetMsg(LOGIN_SSH1);

  SshProt2Button = new TFarRadioButton(this);
  SshProt2Button->Caption = GetMsg(LOGIN_SSH2);

  SshProt2onlyButton = new TFarRadioButton(this);
  SshProt2onlyButton->Caption = GetMsg(LOGIN_SSH2_ONLY);

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_ENCRYPTION_GROUP);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_CIPHER);

  CipherListBox = new TFarListBox(this);
  CipherListBox->Right = CipherListBox->Right - 15;
  CipherListBox->Height = 1 + CIPHER_COUNT + 1;
  Pos = CipherListBox->Bottom;

  NextItemPosition = ipRight;

  CipherUpButton = new TFarButton(this);
  CipherUpButton->Caption = GetMsg(LOGIN_CIPHER_UP);
  CipherUpButton->Move(0, 1);
  CipherUpButton->Result = -1;
  CipherUpButton->OnClick = CipherButtonClick;

  NextItemPosition = ipBelow;

  CipherDownButton = new TFarButton(this);
  CipherDownButton->Caption = GetMsg(LOGIN_CIPHER_DOWN);
  CipherDownButton->Result = 1;
  CipherDownButton->OnClick = CipherButtonClick;

  NextItemPosition = ipNewLine;

  Ssh2DESCheck = new TFarCheckBox(this);
  Ssh2DESCheck->Move(0, Pos - Ssh2DESCheck->Top + 1);
  Ssh2DESCheck->Caption = GetMsg(LOGIN_SSH2DES);

  // Authentication tab

  DefaultGroup = tabAuthentication;

  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_AUTH_GROUP);

  AuthTISCheck = new TFarCheckBox(this);
  AuthTISCheck->Caption = GetMsg(LOGIN_AUTH_TIS);

  AuthKICheck = new TFarCheckBox(this);
  AuthKICheck->Caption = GetMsg(LOGIN_AUTH_KI);

  AuthKIPasswordCheck = new TFarCheckBox(this);
  AuthKIPasswordCheck->Caption = GetMsg(LOGIN_AUTH_KI_PASSWORD);
  AuthKIPasswordCheck->Move(2, 0);

  AuthGSSAPICheck = new TFarCheckBox(this);
  AuthGSSAPICheck->Caption = GetMsg(LOGIN_AUTH_GSSAPI);
  AuthGSSAPICheck->OnAllowChange = AuthGSSAPICheckAllowChange;

  AgentFwdCheck = new TFarCheckBox(this);
  AgentFwdCheck->Caption = GetMsg(LOGIN_AUTH_AGENT_FWD);

  new TFarSeparator(this);

  // Bugs tab

  DefaultGroup = tabBugs;

  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_BUGS_GROUP);

  #define BUG(BUGID, MSG) \
    Text = new TFarText(this); \
    Text->Caption = GetMsg(MSG); \
    NextItemPosition = ipRight; \
    Bug ## BUGID ## Combo = new TFarComboBox(this); \
    Bug ## BUGID ## Combo->DropDownList = true; \
    Bug ## BUGID ## Combo->Width = 7; \
    Bug ## BUGID ## Combo->Items->Add(GetMsg(LOGIN_BUGS_AUTO)); \
    Bug ## BUGID ## Combo->Items->Add(GetMsg(LOGIN_BUGS_OFF)); \
    Bug ## BUGID ## Combo->Items->Add(GetMsg(LOGIN_BUGS_ON)); \
    NextItemPosition = ipNewLine;
  BUGS();
  #undef BUG

  new TFarSeparator(this);

  // Buttons

  NextItemPosition = ipNewLine;
  DefaultGroup = 0;

  Separator = new TFarSeparator(this);
  Separator->Position = CRect.Bottom - 1;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_OK);
  Button->Default = DefaultSave;
  Button->Result = brOK;
  Button->CenterGroup = true;

  NextItemPosition = ipRight;

  ConnectButton = new TFarButton(this);
  ConnectButton->Caption = "Connect";
  ConnectButton->Default = !DefaultSave;
  ConnectButton->Result = brConnect;
  ConnectButton->CenterGroup = true;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;

}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::UpdateControls()
{
  ConnectButton->Enabled = !HostNameEdit->IsEmpty && !UserNameEdit->IsEmpty;

  if (!PrivateKeyEdit->IsEmpty)
  {
    PasswordEdit->Text = "";
  }
  PasswordLabel->Enabled = PrivateKeyEdit->IsEmpty;
  PasswordEdit->Enabled = PrivateKeyEdit->IsEmpty;

  if (!PasswordEdit->IsEmpty)
  {
    PrivateKeyEdit->Text = "";
  }
  PrivateKeyLabel->Enabled = PasswordEdit->IsEmpty;
  PrivateKeyEdit->Enabled = PasswordEdit->IsEmpty;

  CipherUpButton->Enabled = CipherListBox->Items->Selected;
  CipherDownButton->Enabled =
    CipherListBox->Items->Selected < CipherListBox->Items->Count - 1;
  Ssh2DESCheck->Enabled = !SshProt1onlyButton->Checked;

  AuthKIPasswordCheck->Enabled = AuthTISCheck->Checked || AuthKICheck->Checked;
}
//---------------------------------------------------------------------------
bool __fastcall TSessionDialog::Execute(TSessionData * SessionData, bool & Connect)
{
  FEditing = !SessionData->Name.IsEmpty();

  for (int i = 0; i < ItemCount; i++)
  {
    TFarDialogItem * I = Item[i];
    if (I->Group)
    {
      I->Visible = false;
    }
  }

  SelectTab(tabSession);

  // load session data

  // Basic tab
  HostNameEdit->Text = SessionData->HostName;
  PortNumberEdit->AsInteger = SessionData->PortNumber;
  UserNameEdit->Text = SessionData->UserName;
  PasswordEdit->Text = SessionData->Password;
  PrivateKeyEdit->Text = SessionData->PublicKeyFile;

  switch (SessionData->FSProtocol) {
    case fsSCPonly: SCPonlyButton->Checked = true; break;
    case fsSFTP: SFTPButton->Checked = true; break;
    case fsSFTPonly:
    default: SFTPonlyButton->Checked = true; break;
  }

  // Environment tab
  RemoteDirectoryEdit->Text = SessionData->RemoteDirectory;
  UpdateDirectoriesCheck->Checked = SessionData->UpdateDirectories;
  CacheDirectoriesCheck->Checked = SessionData->CacheDirectories;
  CacheDirectoryChangesCheck->Checked = SessionData->CacheDirectoryChanges;
  PreserveDirectoryChangesCheck->Checked = SessionData->PreserveDirectoryChanges;
  ResolveSymlinksCheck->Checked = SessionData->ResolveSymlinks;

  if (SessionData->EOLType == eolLF)
  {
    EOLTypeLFButton->Checked = true;
  }
  else
  {
    EOLTypeCRLFButton->Checked = true;
  }
  ConsiderDSTOnCheck->Checked = SessionData->ConsiderDST;
  ConsiderDSTOffCheck->Checked = !SessionData->ConsiderDST;

  // SCP tab
  (SessionData->DefaultShell ? DefaultShellButton : ShellEnterButton)->Checked = true;

  ShellEdit->Text = SessionData->Shell;
  (SessionData->DetectReturnVar ? ReturnVarAutodetectButton : ReturnVarEnterButton)->Checked = true;
  ReturnVarEdit->Text = SessionData->ReturnVar;
  LookupUserGroupsCheck->Checked = SessionData->LookupUserGroups;
  ClearAliasesCheck->Checked = SessionData->ClearAliases;
  IgnoreLsWarningsCheck->Checked = SessionData->IgnoreLsWarnings;
  Scp1CompatibilityCheck->Checked = SessionData->Scp1Compatibility;
  UnsetNationalVarsCheck->Checked = SessionData->UnsetNationalVars;
  AliasGroupListCheck->Checked = SessionData->AliasGroupList;
  int TimeDifferenceMin = DateTimeToTimeStamp(SessionData->TimeDifference).Time / 60000;
  if (double(SessionData->TimeDifference) < 0)
  {
    TimeDifferenceMin = -TimeDifferenceMin;
  }
  TimeDifferenceEdit->AsInteger = TimeDifferenceMin / 60;
  TimeDifferenceMinutesEdit->AsInteger = TimeDifferenceMin % 60;

  // Connection tab
  switch (SessionData->PingType)
  {
    case ptNullPacket:
      PingNullPacketButton->Checked = true;
      break;

    case ptDummyCommand:
      PingDummyCommandButton->Checked = true;
      break;

    default:
      PingOffButton->Checked = true;
      break;
  }
  PingIntervalSecEdit->AsInteger = SessionData->PingInterval;
  TimeoutEdit->AsInteger = SessionData->Timeout;

  // Proxy tab
  switch (SessionData->ProxyMethod) {
    case pmHTTP: ProxyHTTPButton->Checked = true; break;
    case pmSocks4: ProxySocks4Button->Checked = true; break;
    case pmSocks5: ProxySocks5Button->Checked = true; break;
    case pmTelnet: ProxyTelnetButton->Checked = true; break;
    default: ProxyNoneButton->Checked = true; break;
  }
  ProxyHostEdit->Text = SessionData->ProxyHost;
  ProxyPortEdit->AsInteger = SessionData->ProxyPort;
  ProxyUsernameEdit->Text = SessionData->ProxyUsername;
  ProxyPasswordEdit->Text = SessionData->ProxyPassword;
  ProxyTelnetCommandEdit->Text = SessionData->ProxyTelnetCommand;
  ProxyLocalhostCheck->Checked = SessionData->ProxyLocalhost;
  switch (SessionData->ProxyDNS) {
    case asOn: ProxyDNSOnButton->Checked = true; break;
    case asOff: ProxyDNSOffButton->Checked = true; break;
    default: ProxyDNSAutoButton->Checked = true; break;
  }

  // SSH tab
  CompressionCheck->Checked = SessionData->Compression;
  Ssh2DESCheck->Checked = SessionData->Ssh2DES;

  switch (SessionData->SshProt) {
    case ssh1only:  SshProt1onlyButton->Checked = true; break;
    case ssh1:      SshProt1Button->Checked = true; break;
    case ssh2:      SshProt2Button->Checked = true; break;
    case ssh2only:  SshProt2onlyButton->Checked = true; break;
  }

  CipherListBox->Items->Clear();
  assert(CIPHER_NAME_WARN+CIPHER_COUNT-1 == CIPHER_NAME_DES);
  for (int Index = 0; Index < CIPHER_COUNT; Index++)
  {
    CipherListBox->Items->AddObject(
      GetMsg(CIPHER_NAME_WARN + int(SessionData->Cipher[Index])),
      (TObject*)SessionData->Cipher[Index]);
  }

  // Authentication tab
  AuthTISCheck->Checked = SessionData->AuthTIS;
  AuthKICheck->Checked = SessionData->AuthKI;
  AuthKIPasswordCheck->Checked = SessionData->AuthKIPassword;
  AgentFwdCheck->Checked = SessionData->AgentFwd;
  AuthGSSAPICheck->Checked = SessionData->AuthGSSAPI;

  // Bugs tab

  #define BUG(BUGID, MSG) \
    Bug ## BUGID ## Combo->Items->Selected = 2 - SessionData->Bug[sb ## BUGID]
  BUGS();
  #undef BUG

  int Button = ShowModal();
  bool Result = (Button == brOK || Button == brConnect);
  Connect = (Button == brConnect);
  if (Result)
  {
    // save session data

    // Basic tab
    SessionData->HostName = HostNameEdit->Text;
    SessionData->PortNumber = PortNumberEdit->AsInteger;
    SessionData->UserName = UserNameEdit->Text;
    SessionData->Password = PasswordEdit->Text;
    SessionData->PublicKeyFile = PrivateKeyEdit->Text;

    if (SCPonlyButton->Checked)
    {
      SessionData->FSProtocol = fsSCPonly;
    }
    else if (SFTPButton->Checked)
    {
      SessionData->FSProtocol = fsSFTP;
    }
    else
    {
      SessionData->FSProtocol = fsSFTPonly;
    }

    // Environment tab
    SessionData->RemoteDirectory = RemoteDirectoryEdit->Text;
    SessionData->UpdateDirectories = UpdateDirectoriesCheck->Checked;
    SessionData->CacheDirectories = CacheDirectoriesCheck->Checked;
    SessionData->CacheDirectoryChanges = CacheDirectoryChangesCheck->Checked;
    SessionData->PreserveDirectoryChanges = PreserveDirectoryChangesCheck->Checked;
    SessionData->ResolveSymlinks = ResolveSymlinksCheck->Checked;

    SessionData->EOLType = EOLTypeLFButton->Checked ? eolLF : eolCRLF;
    SessionData->ConsiderDST = ConsiderDSTOnCheck->Checked;

    // SCP tab
    SessionData->DefaultShell = DefaultShellButton->Checked;
    if (ShellEnterButton->Checked)
      SessionData->Shell = ShellEdit->Text;
    SessionData->DetectReturnVar = ReturnVarAutodetectButton->Checked;
    if (ReturnVarEnterButton->Checked)
      SessionData->ReturnVar = ReturnVarEdit->Text;
    SessionData->LookupUserGroups = LookupUserGroupsCheck->Checked;
    SessionData->ClearAliases = ClearAliasesCheck->Checked;
    SessionData->IgnoreLsWarnings = IgnoreLsWarningsCheck->Checked;
    SessionData->Scp1Compatibility = Scp1CompatibilityCheck->Checked;
    if (EOLTypeLFButton->Checked) SessionData->EOLType = eolLF;
      else SessionData->EOLType = eolCRLF;
    SessionData->UnsetNationalVars = UnsetNationalVarsCheck->Checked;
    SessionData->AliasGroupList = AliasGroupListCheck->Checked;
    SessionData->TimeDifference =
      (double(TimeDifferenceEdit->AsInteger) / 24) +
      (double(TimeDifferenceMinutesEdit->AsInteger) / 24 / 60);

    // Connection tab
    if (PingNullPacketButton->Checked)
    {
      SessionData->PingType = ptNullPacket;
    }
    else if (PingDummyCommandButton->Checked)
    {
      SessionData->PingType = ptDummyCommand;
    }
    else
    {
      SessionData->PingType = ptOff;
    }
    SessionData->PingInterval = PingIntervalSecEdit->AsInteger;
    SessionData->Timeout = TimeoutEdit->AsInteger;

    // Proxy tab
    if (ProxyHTTPButton->Checked) SessionData->ProxyMethod = pmHTTP;
      else
    if (ProxySocks4Button->Checked) SessionData->ProxyMethod = pmSocks4;
      else
    if (ProxySocks5Button->Checked) SessionData->ProxyMethod = pmSocks5;
      else
    if (ProxyTelnetButton->Checked) SessionData->ProxyMethod = pmTelnet;
      else SessionData->ProxyMethod = pmNone;

    SessionData->ProxyHost = ProxyHostEdit->Text;
    SessionData->ProxyPort = ProxyPortEdit->AsInteger;
    SessionData->ProxyUsername = ProxyUsernameEdit->Text;
    SessionData->ProxyPassword = ProxyPasswordEdit->Text;
    SessionData->ProxyTelnetCommand = ProxyTelnetCommandEdit->Text;
    SessionData->ProxyLocalhost = ProxyLocalhostCheck->Checked;

    if (ProxyDNSOnButton->Checked) SessionData->ProxyDNS = asOn;
      else
    if (ProxyDNSOffButton->Checked) SessionData->ProxyDNS = asOff;
      else SessionData->ProxyDNS = asAuto;

    // SSH tab
    SessionData->Compression = CompressionCheck->Checked;
    SessionData->Ssh2DES = Ssh2DESCheck->Checked;

    if (SshProt1onlyButton->Checked) SessionData->SshProt = ssh1only;
      else
    if (SshProt1Button->Checked) SessionData->SshProt = ssh1;
      else
    if (SshProt2Button->Checked) SessionData->SshProt = ssh2;
      else SessionData->SshProt = ssh2only;

    for (int Index = 0; Index < CIPHER_COUNT; Index++)
    {
      SessionData->Cipher[Index] = (TCipher)CipherListBox->Items->Objects[Index];
    }

    // Authentication tab
    SessionData->AuthTIS = AuthTISCheck->Checked;
    SessionData->AuthKI = AuthKICheck->Checked;
    SessionData->AuthKIPassword = AuthKIPasswordCheck->Checked;
    SessionData->AgentFwd = AgentFwdCheck->Checked;
    SessionData->AuthGSSAPI = AuthGSSAPICheck->Checked;

    // Bugs tab

    #define BUG(BUGID, MSG) \
      SessionData->Bug[sb ## BUGID] = (TAutoSwitch)(2 - Bug ## BUGID ## Combo->Items->Selected);
    BUGS();
    #undef BUG
  }

  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::SelectTab(int Tab)
{
  if (FTab != Tab)
  {
    if (FTab)
    {
      ShowGroup(FTab, false);
    }
    ShowGroup(Tab, true);
    FTab = Tab;
  }

  AnsiString TabName;
  bool FirstFound = false;
  for (int i = 0; i < ItemCount; i++)
  {
    TFarDialogItem * I = Item[i];
    if (!FirstFound && (I->Group == Tab) && I->CanFocus() )
    {
      I->SetFocus();
      FirstFound = true;
    }
    TFarButton * B = dynamic_cast<TFarButton*>(I);
    if (B && (B->Result == (brTab | Tab)))
    {
      TabName = B->Caption;
    }
  }

  assert(!TabName.IsEmpty());

  Caption = FORMAT("%s - %s",
    (TabName, GetMsg(FEditing ? LOGIN_EDIT : LOGIN_ADD)));
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::Key(
  TFarDialog * /*Sender*/, TFarDialogItem * /*Item*/, long Key, bool & Handled)
{
  if (Key == KEY_CTRLPGDN || Key == KEY_CTRLPGUP)
  {
    int NewTab;
    if (Key == KEY_CTRLPGDN)
    {
      NewTab = FTab == tabCount - 1 ? tabSession : FTab + 1;
    }
    else
    {
      NewTab = FTab == 1 ? tabCount - 1 : FTab - 1;
    }
    SelectTab(NewTab);
    Handled = true;
  }
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::CipherButtonClick(TFarButton * Sender, bool & Close)
{
  if (Sender->Enabled)
  {
    int Source = CipherListBox->Items->Selected;
    int Dest = Source + Sender->Result;

    CipherListBox->Items->Move(Source, Dest);
    CipherListBox->Items->Selected = Dest;
  }

  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::TabButtonClick(TFarButton * Sender, bool & Close)
{
  assert(Sender);
  assert((Sender->Result & brTab) == brTab);

  SelectTab(Sender->Result - brTab);

  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::AuthGSSAPICheckAllowChange(TFarDialogItem * /*Sender*/,
  long NewState, bool & /*Allow*/)
{
  if (NewState == BSTATE_CHECKED)
  {
    TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);

    WinSCPPlugin->MoreMessageDialog(GetMsg(GSSAPI_NOT_INSTALLED),
      NULL, qtError, qaOK);
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::SessionDialog(TSessionData * SessionData,
  bool & Connect, bool DefaultSave)
{
  bool Result;
  TSessionDialog * Dialog = new TSessionDialog(FPlugin, DefaultSave);
  try
  {
    Result = Dialog->Execute(SessionData, Connect);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TRightsContainer : public TFarDialogContainer
{
public:
  __fastcall TRightsContainer(TFarDialog * ADialog, bool AAnyDirectories,
    bool AAllowUndef, bool ShowSpecials, bool Extended,
    TFarDialogItem * EnabledDependency);
  __property bool AddXToDirectories = { read = GetAddXToDirectories, write = SetAddXToDirectories };
  __property TRights Rights = { read = GetRights, write = SetRights };
  __property TFarCheckBox * Checks[TRights::TRight Right] = { read = GetChecks };
  __property TRights::TState States[TRights::TRight Right] = { read = GetStates, write = SetStates };

protected:
  bool FAnyDirectories;
  bool FAllowUndef;
  TFarCheckBox * FCheckBoxes[12];
  TRights::TState FFixedStates[12];
  TFarEdit * OctalEdit;
  TFarCheckBox * DirectoriesXCheck;

  virtual void __fastcall Change();
  void __fastcall UpdateControls();

private:
  TRights __fastcall GetRights();
  void __fastcall SetRights(const TRights & value);
  void __fastcall SetAddXToDirectories(bool value);
  bool __fastcall GetAddXToDirectories();
  TFarCheckBox * __fastcall GetChecks(TRights::TRight Right);
  TRights::TState __fastcall GetStates(TRights::TRight Right);
  void __fastcall SetStates(TRights::TRight Flag, TRights::TState value);
  void __fastcall OctalEditExit(TObject * Sender);
  void __fastcall RightsButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TRightsContainer::TRightsContainer(TFarDialog * ADialog,
  bool AAnyDirectories, bool AAllowUndef, bool ShowButtons,
  bool ShowSpecials, TFarDialogItem * EnabledDependency) :
  TFarDialogContainer(ADialog)
{
  FAnyDirectories = AAnyDirectories;
  FAllowUndef = AAllowUndef;

  TFarButton * Button;
  TFarText * Text;
  TFarCheckBox * CheckBox;

  Dialog->NextItemPosition = ipNewLine;

  static int RowLabels[] = { PROPERTIES_OWNER_RIGHTS, PROPERTIES_GROUP_RIGHTS,
    PROPERTIES_OTHERS_RIGHTS };
  static int ColLabels[] = { PROPERTIES_READ_RIGHTS, PROPERTIES_WRITE_RIGHTS,
    PROPERTIES_EXECUTE_RIGHTS };
  static int SpecialLabels[] = { PROPERTIES_SETUID_RIGHTS, PROPERTIES_SETGID_RIGHTS,
    PROPERTIES_STICKY_BIT_RIGHTS };

  for (int RowIndex = 0; RowIndex < 3; RowIndex++)
  {
    Dialog->NextItemPosition = ipNewLine;
    Text = new TFarText(Dialog);
    if (RowIndex == 0)
    {
      Text->Top = 0;
    }
    Text->Left = 0;
    Add(Text);
    Text->EnabledDependency = EnabledDependency;
    Text->Caption = GetMsg(RowLabels[RowIndex]);

    Dialog->NextItemPosition = ipRight;

    for (int ColIndex = 0; ColIndex < 3; ColIndex++)
    {
      CheckBox = new TFarCheckBox(Dialog);
      FCheckBoxes[(RowIndex + 1)* 3 + ColIndex] = CheckBox;
      Add(CheckBox);
      CheckBox->EnabledDependency = EnabledDependency;
      CheckBox->Caption = GetMsg(ColLabels[ColIndex]);
      CheckBox->AllowGrayed = FAllowUndef;
    }

    if (ShowSpecials)
    {
      CheckBox = new TFarCheckBox(Dialog);
      Add(CheckBox);
      CheckBox->Visible = ShowSpecials;
      CheckBox->EnabledDependency = EnabledDependency;
      CheckBox->Caption = GetMsg(SpecialLabels[RowIndex]);
      CheckBox->AllowGrayed = FAllowUndef;
      FCheckBoxes[RowIndex] = CheckBox;
    }
    else
    {
      FCheckBoxes[RowIndex] = NULL;
      FFixedStates[RowIndex] = TRights::rsNo;
    }
  }

  Dialog->NextItemPosition = ipNewLine;

  Text = new TFarText(Dialog);
  Add(Text);
  Text->EnabledDependency = EnabledDependency;
  Text->Left = 0;
  Text->Caption = GetMsg(PROPERTIES_OCTAL);

  Dialog->NextItemPosition = ipRight;

  OctalEdit = new TFarEdit(Dialog);
  Add(OctalEdit);
  OctalEdit->EnabledDependency = EnabledDependency;
  OctalEdit->Width = 5;
  OctalEdit->Mask = "9999";
  OctalEdit->OnExit = OctalEditExit;

  if (ShowButtons)
  {
    Dialog->NextItemPosition = ipRight;

    Button = new TFarButton(Dialog);
    Add(Button);
    Button->EnabledDependency = EnabledDependency;
    Button->Caption = GetMsg(PROPERTIES_NONE_RIGHTS);
    Button->Tag = TRights::rfNo;
    Button->OnClick = RightsButtonClick;

    Button = new TFarButton(Dialog);
    Add(Button);
    Button->EnabledDependency = EnabledDependency;
    Button->Caption = GetMsg(PROPERTIES_DEFAULT_RIGHTS);
    Button->Tag = TRights::rfDefault;
    Button->OnClick = RightsButtonClick;

    Button = new TFarButton(Dialog);
    Add(Button);
    Button->EnabledDependency = EnabledDependency;
    Button->Caption = GetMsg(PROPERTIES_ALL_RIGHTS);
    Button->Tag = TRights::rfAll;
    Button->OnClick = RightsButtonClick;
  }

  if (FAnyDirectories)
  {
    Dialog->NextItemPosition = ipNewLine;

    DirectoriesXCheck = new TFarCheckBox(Dialog);
    Add(DirectoriesXCheck);
    DirectoriesXCheck->EnabledDependency = EnabledDependency;
    DirectoriesXCheck->Left = 0;
    DirectoriesXCheck->Caption = GetMsg(PROPERTIES_DIRECTORIES_X);
  }
  else
  {
    DirectoriesXCheck = NULL;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::RightsButtonClick(TFarButton * Sender,
  bool & /*Close*/)
{
  TRights R = Rights;
  R.Number = (unsigned short)Sender->Tag;
  Rights = R;
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::OctalEditExit(TObject * /*Sender*/)
{
  if (!OctalEdit->Text.Trim().IsEmpty())
  {
    TRights R = Rights;
    R.Octal = OctalEdit->Text.Trim();
    Rights = R;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::UpdateControls()
{
  if (Dialog->Handle)
  {
    TRights R = Rights;

    if (DirectoriesXCheck)
    {
      DirectoriesXCheck->Enabled =
        !((R.NumberSet & TRights::rfExec) == TRights::rfExec);
    }

    if (!OctalEdit->Focused())
    {
      OctalEdit->Text = R.IsUndef ? AnsiString() : R.Octal;
    }
    else if (OctalEdit->Text.Trim().Length() >= 3)
    {
      try
      {
        OctalEditExit(NULL);
      }
      catch(...)
      {
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::Change()
{
  TFarDialogContainer::Change();

  if (Dialog->Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
TFarCheckBox * __fastcall TRightsContainer::GetChecks(TRights::TRight Right)
{
  assert((Right >= 0) && (Right < LENOF(FCheckBoxes)));
  return FCheckBoxes[Right];
}
//---------------------------------------------------------------------------
TRights::TState __fastcall TRightsContainer::GetStates(TRights::TRight Right)
{
  TFarCheckBox * CheckBox = Checks[Right];
  if (CheckBox != NULL)
  {
    switch (CheckBox->Selected) {
      case BSTATE_UNCHECKED: return TRights::rsNo;
      case BSTATE_CHECKED: return TRights::rsYes;
      case BSTATE_3STATE:
      default: return TRights::rsUndef;
    }
  }
  else
  {
    return FFixedStates[Right];
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::SetStates(TRights::TRight Right,
  TRights::TState value)
{
  TFarCheckBox * CheckBox = Checks[Right];
  if (CheckBox != NULL)
  {
    switch (value) {
      case TRights::rsNo: CheckBox->Selected = BSTATE_UNCHECKED; break;
      case TRights::rsYes: CheckBox->Selected = BSTATE_CHECKED; break;
      case TRights::rsUndef: CheckBox->Selected = BSTATE_3STATE; break;
    }
  }
  else
  {
    FFixedStates[Right]= value;
  }
}
//---------------------------------------------------------------------------
TRights __fastcall TRightsContainer::GetRights()
{
  TRights Result;
  Result.AllowUndef = FAllowUndef;
  for (int Right = 0; Right < LENOF(FCheckBoxes); Right++)
  {
    Result.RightUndef[static_cast<TRights::TRight>(Right)] =
      States[static_cast<TRights::TRight>(Right)];
  }
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::SetRights(const TRights & value)
{
  Dialog->LockChanges();
  try
  {
    FAllowUndef = true; // temporarily
    for (int Right = 0; Right < LENOF(FCheckBoxes); Right++)
    {
      States[static_cast<TRights::TRight>(Right)] =
        value.RightUndef[static_cast<TRights::TRight>(Right)];
    }
    FAllowUndef = value.AllowUndef;
  }
  __finally
  {
    Dialog->UnlockChanges();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TRightsContainer::GetAddXToDirectories()
{
  return DirectoriesXCheck ? DirectoriesXCheck->Checked : false;
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::SetAddXToDirectories(bool value)
{
  if (DirectoriesXCheck)
  {
    DirectoriesXCheck->Checked = value;
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TPropertiesDialog : public TFarDialog
{
public:
  __fastcall TPropertiesDialog(TCustomFarPlugin * AFarPlugin, TStrings * FileList,
    const AnsiString Directory, TStrings * GroupList, TStrings * UserList,
    int AllowedChanges);

  bool __fastcall Execute(TRemoteProperties * Properties);

protected:
  virtual void __fastcall Change();
  void __fastcall UpdateProperties(TRemoteProperties & Properties);

private:
  bool FAnyDirectories;
  int FAllowedChanges;
  TRemoteProperties FOrigProperties;
  bool FMultiple;

  TRightsContainer * RightsContainer;
  TFarComboBox * OwnerComboBox;
  TFarComboBox * GroupComboBox;
  TFarCheckBox * RecursiveCheck;
  TFarButton * OkButton;
};
//---------------------------------------------------------------------------
__fastcall TPropertiesDialog::TPropertiesDialog(TCustomFarPlugin * AFarPlugin,
  TStrings * FileList, const AnsiString Directory, TStrings * GroupList,
  TStrings * UserList, int AAllowedChanges) : TFarDialog(AFarPlugin)
{
  FAllowedChanges = AAllowedChanges;

  assert(FileList->Count > 0);
  TRemoteFile * OnlyFile = dynamic_cast<TRemoteFile *>(FileList->Objects[0]);
  USEDPARAM(OnlyFile);
  assert(OnlyFile);
  FMultiple = (FileList->Count > 1);
  TRemoteFile * File;
  int Directories = 0;

  TStringList * UsedGroupList = NULL;
  TStringList * UsedUserList = NULL;

  try
  {
    if ((GroupList == NULL) || (GroupList->Count == 0))
    {
      UsedGroupList = new TStringList();
      UsedGroupList->Duplicates = dupIgnore;
      UsedGroupList->Sorted = true;
    }
    if ((UserList == NULL) || (UserList->Count == 0))
    {
      UsedUserList = new TStringList();
      UsedUserList->Duplicates = dupIgnore;
      UsedUserList->Sorted = true;
    }

    for (int Index = 0; Index < FileList->Count; Index++)
    {
      File = dynamic_cast<TRemoteFile *>(FileList->Objects[Index]);
      assert(File);
      if (UsedGroupList && !File->Group.IsEmpty())
      {
        UsedGroupList->Add(File->Group);
      }
      if (UsedUserList && !File->Owner.IsEmpty())
      {
        UsedUserList->Add(File->Owner);
      }
      if (File->IsDirectory)
      {
        Directories++;
      }
    }
    FAnyDirectories = (Directories > 0);

    Caption = GetMsg(PROPERTIES_CAPTION);

    Size = TPoint(56, 19);

    TFarButton * Button;
    TFarSeparator * Separator;
    TFarText * Text;
    TRect CRect = ClientRect;

    Text = new TFarText(this);
    Text->Caption = GetMsg(PROPERTIES_PROMPT);
    Text->CenterGroup = true;

    NextItemPosition = ipNewLine;

    Text = new TFarText(this);
    Text->CenterGroup = true;
    if (FileList->Count > 1)
    {
      Text->Caption = FORMAT(GetMsg(PROPERTIES_PROMPT_FILES), (FileList->Count));
    }
    else
    {
      Text->Caption = TWinSCPFileSystem::MinimizeName(FileList->Strings[0],
        ClientSize.x, true);
    }

    new TFarSeparator(this);

    Text = new TFarText(this);
    Text->Caption = GetMsg(PROPERTIES_OWNER);
    Text->Enabled = FAllowedChanges & cpOwner;

    NextItemPosition = ipRight;

    OwnerComboBox = new TFarComboBox(this);
    OwnerComboBox->Width = 20;
    OwnerComboBox->Enabled = FAllowedChanges & cpOwner;
    OwnerComboBox->Items->Assign(UsedUserList ? UsedUserList : UserList);

    NextItemPosition = ipNewLine;

    Text = new TFarText(this);
    Text->Caption = GetMsg(PROPERTIES_GROUP);
    Text->Enabled = FAllowedChanges & cpGroup;

    NextItemPosition = ipRight;

    GroupComboBox = new TFarComboBox(this);
    GroupComboBox->Width = OwnerComboBox->Width;
    GroupComboBox->Enabled = FAllowedChanges & cpGroup;
    GroupComboBox->Items->Assign(UsedGroupList ? UsedGroupList : GroupList);

    NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(this);
    Separator->Caption = GetMsg(PROPERTIES_RIGHTS);

    RightsContainer = new TRightsContainer(this, FAnyDirectories,
      FAnyDirectories || FMultiple, true, true, NULL);
    RightsContainer->Enabled = FAllowedChanges & cpMode;

    if (FAnyDirectories)
    {
      Separator = new TFarSeparator(this);
      Separator->Position = Separator->Position + RightsContainer->Top;

      RecursiveCheck = new TFarCheckBox(this);
      RecursiveCheck->Caption = GetMsg(PROPERTIES_RECURSIVE);
    }
    else
    {
      RecursiveCheck = NULL;
    }

    NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(this);
    Separator->Position = CRect.Bottom - 1;

    OkButton = new TFarButton(this);
    OkButton->Caption = GetMsg(MSG_BUTTON_OK);
    OkButton->Default = true;
    OkButton->Result = brOK;
    OkButton->CenterGroup = true;

    NextItemPosition = ipRight;

    Button = new TFarButton(this);
    Button->Caption = GetMsg(MSG_BUTTON_Cancel);
    Button->Result = brCancel;
    Button->CenterGroup = true;
  }
  __finally
  {
    delete UsedUserList;
    delete UsedGroupList;
  }
}
//---------------------------------------------------------------------------
void __fastcall TPropertiesDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    TRemoteProperties FileProperties;
    UpdateProperties(FileProperties);

    OkButton->Enabled =
      // group name is specified or we set multiple-file properties and
      // no valid group was specified (there are at least two different groups)
      (!GroupComboBox->Text.IsEmpty() ||
       (FMultiple && !FOrigProperties.Valid.Contains(vpGroup)) ||
       (FOrigProperties.Group == GroupComboBox->Text)) &&
      // same but with owner
      (!OwnerComboBox->Text.IsEmpty() ||
       (FMultiple && !FOrigProperties.Valid.Contains(vpOwner)) ||
       (FOrigProperties.Owner == OwnerComboBox->Text)) &&
      ((FileProperties != FOrigProperties) || (RecursiveCheck && RecursiveCheck->Checked));
  }
}
//---------------------------------------------------------------------------
void __fastcall TPropertiesDialog::UpdateProperties(TRemoteProperties & Properties)
{
  if (FAllowedChanges & cpMode)
  {
    Properties.Valid << vpRights;
    Properties.Rights = RightsContainer->Rights;
    Properties.AddXToDirectories = RightsContainer->AddXToDirectories;
  }

  #define STORE_NAME(PROPERTY) \
    if (!PROPERTY ## ComboBox->Text.IsEmpty() && \
        FAllowedChanges & cp ## PROPERTY) \
    { \
      Properties.Valid << vp ## PROPERTY; \
      Properties.PROPERTY = PROPERTY ## ComboBox->Text.Trim(); \
    }
  STORE_NAME(Group);
  STORE_NAME(Owner);
  #undef STORE_NAME

  Properties.Recursive = RecursiveCheck != NULL && RecursiveCheck->Checked;
}
//---------------------------------------------------------------------------
bool __fastcall TPropertiesDialog::Execute(TRemoteProperties * Properties)
{
  TValidProperties Valid;
  if (Properties->Valid.Contains(vpRights) && FAllowedChanges & cpMode) Valid << vpRights;
  if (Properties->Valid.Contains(vpOwner) && FAllowedChanges & cpOwner) Valid << vpOwner;
  if (Properties->Valid.Contains(vpGroup) && FAllowedChanges & cpGroup) Valid << vpGroup;
  FOrigProperties = *Properties;
  FOrigProperties.Valid = Valid;
  FOrigProperties.Recursive = false;

  if (Properties->Valid.Contains(vpRights))
  {
    RightsContainer->Rights = Properties->Rights;
    RightsContainer->AddXToDirectories = Properties->AddXToDirectories;
  }
    else
  {
    RightsContainer->Rights = TRights();
    RightsContainer->AddXToDirectories = false;
  }
  OwnerComboBox->Text = Properties->Valid.Contains(vpOwner) ?
    Properties->Owner : AnsiString();
  GroupComboBox->Text = Properties->Valid.Contains(vpGroup) ?
    Properties->Group : AnsiString();
  if (RecursiveCheck)
  {
    RecursiveCheck->Checked = Properties->Recursive;
  }

  bool Result = ShowModal() != brCancel;
  if (Result)
  {
    *Properties = TRemoteProperties();
    UpdateProperties(*Properties);
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::PropertiesDialog(TStrings * FileList,
  const AnsiString Directory, TStrings * GroupList, TStrings * UserList,
  TRemoteProperties * Properties, int AllowedChanges)
{
  bool Result;
  TPropertiesDialog * Dialog = new TPropertiesDialog(FPlugin, FileList,
    Directory, GroupList, UserList, AllowedChanges);
  try
  {
    Result = Dialog->Execute(Properties);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TCopyDialog : TFarDialog
{
public:
  __fastcall TCopyDialog(TCustomFarPlugin * AFarPlugin,
    bool ToRemote, bool Move, TStrings * FileList, int Options);

  bool __fastcall Execute(AnsiString & TargetDirectory, TGUICopyParamType * Params);

protected:
  virtual void __fastcall Init();
  virtual bool __fastcall CloseQuery();

private:
  TFarEdit * DirectoryEdit;
  TFarRadioButton * TMTextButton;
  TFarRadioButton * TMBinaryButton;
  TFarRadioButton * TMAutomaticButton;
  TFarEdit * AsciiFileMaskEdit;
  TRightsContainer * RightsContainer;
  TFarRadioButton * CCNoChangeButton;
  TFarRadioButton * CCUpperCaseButton;
  TFarRadioButton * CCLowerCaseButton;
  TFarRadioButton * CCFirstUpperCaseButton;
  TFarCheckBox * ReplaceInvalidCharsCheck;
  TFarCheckBox * PreserveRightsCheck;
  TFarCheckBox * PreserveTimeCheck;
  TFarCheckBox * PreserveReadOnlyCheck;
  TFarCheckBox * SaveSettingsCheck;
  TFarCheckBox * QueueCheck;
  TFarCheckBox * QueueNoConfirmationCheck;

  bool FExpanded;
  int FExpansionDelta;
  TRect FLastPosition;
  bool FToRemote;
  int FOptions;

  void __fastcall MoreButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TCopyDialog::TCopyDialog(TCustomFarPlugin * AFarPlugin,
  bool ToRemote, bool Move, TStrings * FileList,
  int Options) : TFarDialog(AFarPlugin)
{
  FToRemote = ToRemote;
  FOptions = Options;

  TFarButton * Button;
  TFarSeparator * Separator;
  TFarText * Text;
  TFarBox * Box;

  Size = TPoint(76, 17 +
    (((FOptions & coTempTransfer) == 0) ? 3 : 0) + (ToRemote ? 0 : 1));
  TRect CRect = ClientRect;

  Caption = GetMsg(Move ? MOVE_TITLE : COPY_TITLE);

  if ((FOptions & coTempTransfer) == 0)
  {
    AnsiString Prompt;
    if (FileList->Count > 1)
    {
      Prompt = FORMAT(GetMsg(Move ? MOVE_FILES_PROMPT : COPY_FILES_PROMPT), (FileList->Count));
    }
    else
    {
      Prompt = FORMAT(GetMsg(Move ? MOVE_FILE_PROMPT : COPY_FILE_PROMPT),
        (ToRemote ? ExtractFileName(FileList->Strings[0]) :
            UnixExtractFileName(FileList->Strings[0])));
    }

    Text = new TFarText(this);
    Text->Caption = Prompt;

    DirectoryEdit = new TFarEdit(this);
    DirectoryEdit->History = ToRemote ? REMOTE_DIR_HISTORY : "Copy";
  }

  DefaultGroup = 1;

  int TMWidth = 37;
  int TMTop;
  int TMBottom;

  Box = new TFarBox(this);
  Box->Left--;
  Box->Width = TMWidth + 2;
  Box->Caption = GetMsg(TRANSFER_MODE);

  NextItemPosition = ipRight;

  Box = new TFarBox(this);
  Box->Left -= 2;
  Box->Right++;
  Box->Caption = GetMsg(TRANSFER_ATTRIBUTES);

  NextItemPosition = ipNewLine;

  bool AllowTransferMode = ((Options & coDisableTransferMode) == 0);
  TMTextButton = new TFarRadioButton(this);
  TMTop = TMTextButton->Top;
  TMTextButton->Caption = GetMsg(TRANSFER_MODE_TEXT);
  TMTextButton->Enabled = AllowTransferMode;

  TMBinaryButton = new TFarRadioButton(this);
  TMBinaryButton->Caption = GetMsg(TRANSFER_MODE_BINARY);
  TMBinaryButton->Enabled = AllowTransferMode;

  TMAutomaticButton = new TFarRadioButton(this);
  TMAutomaticButton->Caption = GetMsg(TRANSFER_MODE_AUTOMATIC);
  TMAutomaticButton->Enabled = AllowTransferMode;

  Text = new TFarText(this);
  Text->Caption = GetMsg(TRANSFER_MODE_MASK);
  Text->EnabledDependency = TMAutomaticButton;
  Text->Enabled = AllowTransferMode;

  AsciiFileMaskEdit = new TFarEdit(this);
  AsciiFileMaskEdit->EnabledDependency = TMAutomaticButton;
  AsciiFileMaskEdit->Enabled = AllowTransferMode;
  AsciiFileMaskEdit->Width = TMWidth;
  AsciiFileMaskEdit->History = ASCII_MASK_HISTORY;

  Box = new TFarBox(this);
  Box->Left--;
  Box->Width = TMWidth + 2;
  Box->Caption = GetMsg(TRANSFER_FILENAME_MODIFICATION);

  CCNoChangeButton = new TFarRadioButton(this);
  CCNoChangeButton->Caption = GetMsg(TRANSFER_FILENAME_NOCHANGE);

  NextItemPosition = ipRight;

  CCUpperCaseButton = new TFarRadioButton(this);
  CCUpperCaseButton->Caption = GetMsg(TRANSFER_FILENAME_UPPERCASE);

  NextItemPosition = ipNewLine;

  CCLowerCaseButton = new TFarRadioButton(this);
  CCLowerCaseButton->Caption = GetMsg(TRANSFER_FILENAME_LOWERCASE);

  NextItemPosition = ipRight;

  CCFirstUpperCaseButton = new TFarRadioButton(this);
  CCFirstUpperCaseButton->Caption = GetMsg(TRANSFER_FILENAME_FIRSTUPPERCASE);

  NextItemPosition = ipNewLine;

  if (!ToRemote)
  {
    ReplaceInvalidCharsCheck = new TFarCheckBox(this);
    ReplaceInvalidCharsCheck->Caption = GetMsg(TRANSFER_FILENAME_REPLACE_INVALID);
    ReplaceInvalidCharsCheck->Enabled = !ToRemote;
    TMBottom = ReplaceInvalidCharsCheck->Top;
  }
  else
  {
    TMBottom = CCFirstUpperCaseButton->Top;
  }

  if (ToRemote)
  {
    PreserveRightsCheck = new TFarCheckBox(this);
    PreserveRightsCheck->Left += TMWidth + 2;
    PreserveRightsCheck->Top = TMTop;
    PreserveRightsCheck->Bottom = TMTop;
    PreserveRightsCheck->Caption = GetMsg(TRANSFER_PRESERVE_RIGHTS);

    NextItemPosition = ipBelow;

    RightsContainer = new TRightsContainer(this, true, false, false,
      false, PreserveRightsCheck);

    PreserveTimeCheck = new TFarCheckBox(this);
    PreserveTimeCheck->Left += TMWidth + 2;
    PreserveTimeCheck->Caption = GetMsg(TRANSFER_PRESERVE_TIMESTAMP);
    PreserveTimeCheck->Top = TMTop + 6;
  }
  else
  {
    PreserveTimeCheck = new TFarCheckBox(this);
    PreserveTimeCheck->Left += TMWidth + 2;
    PreserveTimeCheck->Caption = GetMsg(TRANSFER_PRESERVE_TIMESTAMP);
    PreserveTimeCheck->Move(0, TMTop - PreserveTimeCheck->Top);

    NextItemPosition = ipBelow;

    PreserveReadOnlyCheck = new TFarCheckBox(this);
    PreserveReadOnlyCheck->Caption = GetMsg(TRANSFER_PRESERVE_READONLY);
  }

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Position = TMBottom + 1;

  SaveSettingsCheck = new TFarCheckBox(this);
  SaveSettingsCheck->Caption = GetMsg(TRANSFER_REUSE_SETTINGS);

  DefaultGroup = 0;

  if ((FOptions & coTempTransfer) == 0)
  {
    QueueCheck = new TFarCheckBox(this);
    QueueCheck->Caption = GetMsg(TRANSFER_QUEUE);
    QueueCheck->Top = CRect.Bottom - 2;
    QueueCheck->Bottom = QueueCheck->Top + 1;

    NextItemPosition = ipRight;

    QueueNoConfirmationCheck = new TFarCheckBox(this);
    QueueNoConfirmationCheck->Caption = GetMsg(TRANSFER_QUEUE_NO_CONFIRMATION);
    QueueNoConfirmationCheck->EnabledDependency = QueueCheck;

    NextItemPosition = ipNewLine;
  }

  Separator = new TFarSeparator(this);
  Separator->Position = CRect.Bottom - 1;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_OK);
  Button->Default = true;
  Button->Result = brOK;
  Button->CenterGroup = true;
  Button->EnabledDependency =
    ((Options & coTempTransfer) == 0) ? DirectoryEdit : NULL;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;

  if ((Options & coTempTransfer) == 0)
  {
    Button = new TFarButton(this);
    Button->Caption = GetMsg(LESS_BUTTON);
    Button->CenterGroup = true;
    Button->OnClick = MoreButtonClick;
    FExpanded = true;
    FExpansionDelta = Size.y - 9;

    if (!FarConfiguration->CopyParamDialogExpanded)
    {
      bool Close;
      MoreButtonClick(Button, Close);
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TCopyDialog::MoreButtonClick(TFarButton * Sender, bool & /*Close*/)
{
  LockChanges();
  try
  {
    FExpanded = !FExpanded;
    TRect B = Bounds;
    int Factor;
    if (FExpanded)
    {
      Sender->Caption = GetMsg(LESS_BUTTON);
      ShowGroup(1, true);
      Factor = 1;
    }
    else
    {
      Sender->Caption = GetMsg(MORE_BUTTON);
      ShowGroup(1, false);
      Factor = -1;
    }
    if (FLastPosition == B)
    {
      B.Top -= Factor * FExpansionDelta / 2;
      B.Bottom += Factor * (FExpansionDelta - FExpansionDelta / 2);
      FLastPosition = B;
    }
    else
    {
      B.Bottom += Factor * FExpansionDelta;
      FLastPosition = TRect(-1, -1, -1, -1);
    }
    Bounds = B;
  }
  __finally
  {
    UnlockChanges();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TCopyDialog::Execute(AnsiString & TargetDirectory,
  TGUICopyParamType * Params)
{
  if ((FOptions & coTempTransfer) == 0)
  {
    DirectoryEdit->Text =
      (FToRemote ? UnixIncludeTrailingBackslash(TargetDirectory) :
        IncludeTrailingBackslash(TargetDirectory)) + Params->FileMask;

    QueueCheck->Checked = Params->Queue;
    QueueNoConfirmationCheck->Checked = Params->QueueNoConfirmation;
  }

  if ((FOptions & coDisableTransferMode) == 0)
  {
    switch (Params->TransferMode) {
      case tmAscii: TMTextButton->Checked = true; break;
      case tmBinary: TMBinaryButton->Checked = true; break;
      default: TMAutomaticButton->Checked = true; break;
    }
  }
  else
  {
    TMBinaryButton->Checked = true;
  }

  AsciiFileMaskEdit->Text = Params->AsciiFileMask.Masks;

  switch (Params->FileNameCase) {
    case ncLowerCase: CCLowerCaseButton->Checked = true; break;
    case ncUpperCase: CCUpperCaseButton->Checked = true; break;
    case ncFirstUpperCase: CCFirstUpperCaseButton->Checked = true; break;
    default:
    case ncNoChange: CCNoChangeButton->Checked = true; break;
  }

  if (FToRemote)
  {
    RightsContainer->AddXToDirectories = Params->AddXToDirectories;
    RightsContainer->Rights = Params->Rights;
    PreserveRightsCheck->Checked = Params->PreserveRights;
  }
  else
  {
    PreserveReadOnlyCheck->Checked = Params->PreserveReadOnly;
    ReplaceInvalidCharsCheck->Checked = Params->ReplaceInvalidChars;
  }

  PreserveTimeCheck->Checked = Params->PreserveTime;

  bool Result = ShowModal() != brCancel;

  if (Result)
  {
    if ((FOptions & coTempTransfer) == 0)
    {
      Params->FileMask = FToRemote ? UnixExtractFileName(DirectoryEdit->Text) :
        ExtractFileName(DirectoryEdit->Text);
      TargetDirectory = FToRemote ? UnixExtractFilePath(DirectoryEdit->Text) :
        ExtractFilePath(DirectoryEdit->Text);

      Params->Queue = QueueCheck->Checked;
      Params->QueueNoConfirmation = QueueNoConfirmationCheck->Checked;
    }

    assert(TMTextButton->Checked || TMBinaryButton->Checked || TMAutomaticButton->Checked);
    if (TMTextButton->Checked) Params->TransferMode = tmAscii;
      else
    if (TMAutomaticButton->Checked) Params->TransferMode = tmAutomatic;
      else Params->TransferMode = tmBinary;

    if (Params->TransferMode == tmAutomatic)
    {
      Params->AsciiFileMask.Masks = AsciiFileMaskEdit->Text;
      assert(Params->AsciiFileMask.IsValid());
    }

    if (CCLowerCaseButton->Checked) Params->FileNameCase = ncLowerCase;
      else
    if (CCUpperCaseButton->Checked) Params->FileNameCase = ncUpperCase;
      else
    if (CCFirstUpperCaseButton->Checked) Params->FileNameCase = ncFirstUpperCase;
      else Params->FileNameCase = ncNoChange;

    if (FToRemote)
    {
      Params->AddXToDirectories = RightsContainer->AddXToDirectories;
      Params->Rights = RightsContainer->Rights;
      Params->PreserveRights = PreserveRightsCheck->Checked;
    }
    else
    {
      Params->ReplaceInvalidChars = ReplaceInvalidCharsCheck->Checked;
      Params->PreserveReadOnly = PreserveReadOnlyCheck->Checked;
    }

    Params->PreserveTime = PreserveTimeCheck->Checked;

    Configuration->BeginUpdate();
    try
    {
      if ((FOptions & coTempTransfer) == 0)
      {
        FarConfiguration->CopyParamDialogExpanded = FExpanded;
      }
      if (SaveSettingsCheck->Checked)
      {
        GUIConfiguration->CopyParam = *Params;
      }
    }
    __finally
    {
      Configuration->EndUpdate();
    }
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TCopyDialog::CloseQuery()
{
  bool CanClose = TFarDialog::CloseQuery();

  if (CanClose && Result >= 0)
  {
    if (!FToRemote && ((FOptions & coTempTransfer) == 0))
    {
      AnsiString Directory = ExtractFilePath(DirectoryEdit->Text);
      if (!DirectoryExists(Directory))
      {
        TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);

        if (WinSCPPlugin->MoreMessageDialog(FORMAT(GetMsg(CREATE_LOCAL_DIRECTORY), (Directory)),
              NULL, qtConfirmation, qaOK | qaCancel) != qaCancel)
        {
          if (!ForceDirectories(Directory))
          {
            DirectoryEdit->SetFocus();
            throw Exception(FORMAT(GetMsg(CREATE_LOCAL_DIR_ERROR), (Directory)));
          }
        }
        else
        {
          DirectoryEdit->SetFocus();
          Abort();
        }
      }
    }

    if (CanClose && TMAutomaticButton->Checked)
    {
      TFileMasks Masks = AsciiFileMaskEdit->Text;
      int Start, Length;
      if (!Masks.IsValid(Start, Length))
      {
        if (!FExpanded)
        {
          bool Close;
          MoreButtonClick(NULL, Close);
        }
        AsciiFileMaskEdit->SetFocus();
        throw Exception(FORMAT(GetMsg(MASK_ERROR), (Masks.Masks.SubString(Start+1, Length))));
      }
    }
  }
  return CanClose;
}
//---------------------------------------------------------------------------
void __fastcall TCopyDialog::Init()
{
  TFarDialog::Init();
  FLastPosition = Bounds;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::CopyDialog(bool ToRemote,
  bool Move, TStrings * FileList, 
  AnsiString & TargetDirectory, TGUICopyParamType * Params, int Options)
{
  bool Result;
  TCopyDialog * Dialog = new TCopyDialog(FPlugin, ToRemote,
    Move, FileList, Options);
  try
  {
    Result = Dialog->Execute(TargetDirectory, Params);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TLinkDialog : TFarDialog
{
public:
  __fastcall TLinkDialog(TCustomFarPlugin * AFarPlugin,
    bool Edit, bool AllowSymbolic);

  bool __fastcall Execute(AnsiString & FileName, AnsiString & PointTo,
    bool & Symbolic);

protected:
  virtual void __fastcall Change();

private:
  TFarEdit * FileNameEdit;
  TFarEdit * PointToEdit;
  TFarCheckBox * SymbolicCheck;
  TFarButton * OkButton;
};
//---------------------------------------------------------------------------
__fastcall TLinkDialog::TLinkDialog(TCustomFarPlugin * AFarPlugin,
    bool Edit, bool AllowSymbolic) : TFarDialog(AFarPlugin)
{
  TFarButton * Button;
  TFarSeparator * Separator;
  TFarText * Text;

  Size = TPoint(76, 12);
  TRect CRect = ClientRect;

  Caption = GetMsg(Edit ? LINK_EDIT_CAPTION : LINK_ADD_CAPTION);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LINK_FILE);
  Text->Enabled = !Edit;

  FileNameEdit = new TFarEdit(this);
  FileNameEdit->Enabled = !Edit;
  FileNameEdit->History = LINK_FILENAME_HISTORY;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LINK_POINT_TO);

  PointToEdit = new TFarEdit(this);
  PointToEdit->History = LINK_POINT_TO_HISTORY;

  new TFarSeparator(this);

  SymbolicCheck = new TFarCheckBox(this);
  SymbolicCheck->Caption = GetMsg(LINK_SYMLINK);
  SymbolicCheck->Enabled = AllowSymbolic && !Edit;

  Separator = new TFarSeparator(this);
  Separator->Position = CRect.Bottom - 1;

  OkButton = new TFarButton(this);
  OkButton->Caption = GetMsg(MSG_BUTTON_OK);
  OkButton->Default = true;
  OkButton->Result = brOK;
  OkButton->CenterGroup = true;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;
}
//---------------------------------------------------------------------------
void __fastcall TLinkDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    OkButton->Enabled = !FileNameEdit->Text.IsEmpty() &&
      !PointToEdit->Text.IsEmpty();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TLinkDialog::Execute(AnsiString & FileName, AnsiString & PointTo,
    bool & Symbolic)
{
  FileNameEdit->Text = FileName;
  PointToEdit->Text = PointTo;
  SymbolicCheck->Checked = Symbolic;

  bool Result = ShowModal() != brCancel;
  if (Result)
  {
    FileName = FileNameEdit->Text;
    PointTo = PointToEdit->Text;
    Symbolic = SymbolicCheck->Checked;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::LinkDialog(AnsiString & FileName,
  AnsiString & PointTo, bool & Symbolic, bool Edit, bool AllowSymbolic)
{
  bool Result;
  TLinkDialog * Dialog = new TLinkDialog(FPlugin, Edit, AllowSymbolic);
  try
  {
    Result = Dialog->Execute(FileName, PointTo, Symbolic);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TWinSCPFileSystem::FileSystemInfoDialog()
{
  TWinSCPDialog * Dialog = new TWinSCPDialog(FPlugin);
  try
  {
    TFarText * Text;
    TFarSeparator * Separator;

    Dialog->Size = TPoint(73, 25);
    Dialog->Caption = GetMsg(SERVER_PROTOCOL_INFORMATION);

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(SERVER_INFORMATION_GROUP);

    #define ADD_INFO(LABEL, VALUE) \
      Text = new TFarText(Dialog); \
      Text->Caption = FORMAT("%-*s %s", (40, GetMsg(LABEL), (VALUE)));

    ADD_INFO(SERVER_SSH_VERSION, IntToStr(Terminal->SshVersion));
    ADD_INFO(SERVER_SSH_IMPLEMENTATION, Terminal->SshImplementation);
    AnsiString Str = CipherNames[Terminal->CSCipher];
    if (Terminal->CSCipher != Terminal->SCCipher)
    {
      Str += FORMAT("/%s", (CipherNames[Terminal->SCCipher]));
    }
    ADD_INFO(SERVER_CIPHER, Str);
    Str = BooleanToStr(Terminal->CSCompression != ctNone);
    if (Terminal->CSCompression != Terminal->SCCompression)
    {
      Str += FORMAT("/%s", (BooleanToStr(Terminal->SCCompression != ctNone)));
    }
    ADD_INFO(SERVER_COMPRESSION, Str);
    ADD_INFO(SERVER_FS_PROTOCOL, Terminal->ProtocolName);

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(PROTOCOL_INFORMATION_GROUP);

    ADD_INFO(PROTOCOL_MODE_CHANGING,
      BooleanToStr(Terminal->IsCapable[fcModeChanging]));
    ADD_INFO(PROTOCOL_OWNER_GROUP_CHANGING, FORMAT("%s/%s",
      (BooleanToStr(Terminal->IsCapable[fcOwnerChanging]),
       BooleanToStr(Terminal->IsCapable[fcGroupChanging]))));
    ADD_INFO(PROTOCOL_ANY_COMMAND,
      BooleanToStr(Terminal->IsCapable[fcAnyCommand]));
    ADD_INFO(PROTOCOL_SYMBOLIC_HARD_LINK, FORMAT("%s/%s",
      (BooleanToStr(Terminal->IsCapable[fcSymbolicLink]),
       BooleanToStr(Terminal->IsCapable[fcHardLink]))));
    ADD_INFO(PROTOCOL_USER_GROUP_LISTING,
      BooleanToStr(Terminal->IsCapable[fcUserGroupListing]));
    ADD_INFO(PROTOCOL_NATIVE_TEXT_MODE,
      BooleanToStr(Terminal->IsCapable[fcNativeTextMode]));

    new TFarSeparator(Dialog);

    TFarListBox * InfoListBox = new TFarListBox(Dialog);
    InfoListBox->NoBox = true;
    InfoListBox->Height = 5;
    InfoListBox->Items->AddStrings(Terminal->AdditionalInfo);

    new TFarSeparator(Dialog);

    TFarButton * Button = new TFarButton(Dialog);
    Button->Caption = GetMsg(MSG_BUTTON_OK);
    Button->Default = true;
    Button->Result = brOK;
    Button->CenterGroup = true;

    Dialog->ShowModal();
  }
  __finally
  {
    delete Dialog;
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
/*class TOpenDirectoryDialog : TWinSCPDialog
{
public:
  __fastcall TOpenDirectoryDialog(TCustomFarPlugin * AFarPlugin, bool Add);

  bool __fastcall Execute(AnsiString & Directory, TBookmarkList * BookmarkList);

protected:
  virtual void __fastcall Change();

private:
  TFarListBox * BookmarksList;
  TFarButton * RemoveButton;
  TFarButton * UpButton;
  TFarButton * DownButton;
  TBookmarkList * FBookmarkList;

  void __fastcall UpdateControls();
  void __fastcall LoadBookmarks();
  void __fastcall UpDownButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall RemoveButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TOpenDirectoryDialog::TOpenDirectoryDialog(
  TCustomFarPlugin * AFarPlugin, bool Add) : TWinSCPDialog(AFarPlugin)
{
  Size = TPoint(76, 18);
  TRect CRect = ClientRect;

  Caption = GetMsg(Add ? OPEN_DIRECTORY_ADD_BOOMARK_ACTION :
    OPEN_DIRECTORY_BROWSE_CAPTION);

  BookmarksList = new TFarListBox(this);
  BookmarksList->Right = BookmarksList->Right - 15;
  BookmarksList->Height = 1 + 10 + 1;

  NextItemPosition = ipRight;

  RemoveButton = new TFarButton(this);
  RemoveButton->Caption = GetMsg(OPEN_DIRECTORY_REMOVE);
  RemoveButton->Move(0, 1);
  RemoveButton->EnabledDependency = BookmarksList;
  RemoveButton->OnClick = RemoveButtonClick;

  NextItemPosition = ipBelow;

  UpButton = new TFarButton(this);
  UpButton->Caption = GetMsg(OPEN_DIRECTORY_UP);
  UpButton->Move(0, BookmarksList->Height - 5);
  UpButton->Result = -1;
  UpButton->OnClick = UpDownButtonClick;

  DownButton = new TFarButton(this);
  DownButton->Caption = GetMsg(OPEN_DIRECTORY_DOWN);
  DownButton->Result = 1;
  DownButton->OnClick = UpDownButtonClick;

  AddStandardButtons(1);

  OkButton->EnabledDependency = BookmarksList;
}
//---------------------------------------------------------------------------
void __fastcall TOpenDirectoryDialog::Change()
{
  TWinSCPDialog::Change();

  if (Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
void __fastcall TOpenDirectoryDialog::UpdateControls()
{
  UpButton->Enabled = (BookmarksList->Items->Selected > 0);
  DownButton->Enabled = (BookmarksList->Items->Selected >= 0) &&
    (BookmarksList->Items->Selected < BookmarksList->Items->Count - 1);
}
//---------------------------------------------------------------------------
void __fastcall TOpenDirectoryDialog::LoadBookmarks()
{
  BookmarksList->Items->Clear();
  for (int i = 0; i < FBookmarkList->Count; i++)
  {
    TBookmark * Bookmark = FBookmarkList->Bookmarks[i];
    AnsiString Directory = Bookmark->Remote;
    if (!Directory.IsEmpty() && (BookmarksList->Items->IndexOf(Directory) < 0))
    {
      BookmarksList->Items->AddObject(Directory, Bookmark);
    }
  }
}
//---------------------------------------------------------------------------
bool __fastcall TOpenDirectoryDialog::Execute(AnsiString & Directory,
  TBookmarkList * BookmarkList)
{
  FBookmarkList = BookmarkList;
  LoadBookmarks();

  BookmarksList->Items->Selected = BookmarksList->Items->IndexOf(Directory);

  bool Result = ShowModal() != brCancel;
  if (Result)
  {
    assert(BookmarksList->Items->Selected >= 0);
    Directory = BookmarksList->Items->Strings[BookmarksList->Items->Selected];
  }
  FBookmarkList = NULL;
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TOpenDirectoryDialog::RemoveButtonClick(TFarButton * Sender,
  bool & Close)
{
  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TOpenDirectoryDialog::UpDownButtonClick(TFarButton * Sender,
  bool & Close)
{
  Close = false;
} */
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::OpenDirectoryDialog(
  bool Add, AnsiString & Directory, TBookmarkList * BookmarkList)
{
  bool Result;
  TFarMenuItems * BookmarkItems = new TFarMenuItems();
  TList * Bookmarks = new TList();
  try
  {
    BookmarkItems->Sorted = true;
    const int BreakKeys[] = { VK_DELETE, VK_F8, VK_RETURN + (PKF_CONTROL << 16),
      'C' + (PKF_CONTROL << 16), VK_INSERT + (PKF_CONTROL << 16), 0 };
    BookmarkItems->Clear();
    int ItemFocused = -1;
    for (int i = 0; i < BookmarkList->Count; i++)
    {
      TBookmark * Bookmark = BookmarkList->Bookmarks[i];
      AnsiString RemoteDirectory = Bookmark->Remote;
      if (!RemoteDirectory.IsEmpty() && (BookmarkItems->IndexOf(RemoteDirectory) < 0))
      {
        int Pos;
        Pos = BookmarkItems->Add(RemoteDirectory);
        if (RemoteDirectory == Directory)
        {
          ItemFocused = Pos;
        }
        else if (ItemFocused >= 0 && ItemFocused >= Pos)
        {
          ItemFocused++;
        }
        Bookmarks->Insert(Pos, Bookmark);
      }
    }

    if (BookmarkItems->Count == 0)
    {
      throw Exception(GetMsg(OPEN_DIRECTORY_NO_BOOKMARK));
    }

    BookmarkItems->ItemFocused = ItemFocused;

    int BreakCode;
    bool Repeat;

    do
    {
      Repeat = false;
      AnsiString Caption = GetMsg(Add ? OPEN_DIRECTORY_ADD_BOOMARK_ACTION :
        OPEN_DIRECTORY_BROWSE_CAPTION);
      ItemFocused = FPlugin->Menu(FMENU_AUTOHIGHLIGHT | FMENU_SHOWAMPERSAND,
        Caption, GetMsg(OPEN_DIRECTORY_HELP), BookmarkItems, BreakKeys, BreakCode);
      TBookmark * Bookmark = (ItemFocused >= 0) ?
        static_cast<TBookmark *>(Bookmarks->Items[ItemFocused]) : NULL;
      if (BreakCode >= 0)
      {
        assert(BreakCode >= 0 && BreakCode <= 4);
        if (BreakCode == 0 || BreakCode == 1)
        {
          assert(ItemFocused >= 0);
          assert(Bookmark != NULL);
          BookmarkList->Delete(Bookmark);
          BookmarkItems->Delete(ItemFocused);
          Bookmarks->Delete(ItemFocused);
          BookmarkItems->ItemFocused = (ItemFocused < BookmarkItems->Count - 1) ?
            ItemFocused : BookmarkItems->Count - 1;
          Repeat = true;
        }
        else if (BreakCode == 2)
        {
          FarControl(FCTL_INSERTCMDLINE, Bookmark->Remote.c_str());
        }
        else if (BreakCode == 3 || BreakCode == 4)
        {
          FPlugin->FarCopyToClipboard(Bookmark->Remote);
          Repeat = true;
        }
      }
      else if (ItemFocused >= 0)
      {
        assert(Bookmark != NULL);
        Directory = Bookmark->Remote;
      }
    }
    while (Repeat && (BookmarkItems->Count > 0));

    Result = (BreakCode < 0) && (ItemFocused >= 0);
  }
  __finally
  {
    delete BookmarkItems;
    delete Bookmarks;
  }

  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::ApplyCommandDialog(AnsiString & Command,
  int & Params)
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(FPlugin);
  try
  {
    TFarText * Text;

    Dialog->Size = TPoint(76, 12);
    Dialog->Caption = GetMsg(APPLY_COMMAND_TITLE);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(APPLY_COMMAND_PROMPT);

    TFarEdit * CustomCommandEdit = new TFarEdit(Dialog);
    CustomCommandEdit->History = APPLY_COMMAND_HISTORY;

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(APPLY_COMMAND_HINT1);
    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(APPLY_COMMAND_HINT2);

    new TFarSeparator(Dialog);

    TFarCheckBox * CustomCommandApplyToDirectoriesCheck = new TFarCheckBox(Dialog);
    CustomCommandApplyToDirectoriesCheck->Caption =
      GetMsg(APPLY_COMMAND_APPLY_TO_DIRECTORIES);

    Dialog->NextItemPosition = ipRight;

    TFarCheckBox * CustomCommandRecursiveCheck = new TFarCheckBox(Dialog);
    CustomCommandRecursiveCheck->Caption = GetMsg(APPLY_COMMAND_RECURSIVE);

    Dialog->AddStandardButtons();

    CustomCommandEdit->Text = Command;
    CustomCommandApplyToDirectoriesCheck->Checked = Params & ccApplyToDirectories;
    CustomCommandRecursiveCheck->Checked = Params & ccRecursive;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Command = CustomCommandEdit->Text;
      Params &= ~(ccApplyToDirectories | ccRecursive);
      Params |=
        (CustomCommandApplyToDirectoriesCheck->Checked ? ccApplyToDirectories : 0) |
        (CustomCommandRecursiveCheck->Checked ? ccRecursive : 0);
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::SynchronizeDialog(TTerminal::TSynchronizeMode & Mode,
  int & Params, AnsiString & LocalDirectory, AnsiString & RemoteDirectory,
  bool & SaveSettings)
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(FPlugin);
  try
  {
    TFarText * Text;
    TFarSeparator * Separator;

    Dialog->Size = TPoint(76, 15);
    Dialog->Caption = GetMsg(SYNCHRONIZE_TITLE);

    AnsiString Label;

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(SYNCHRONIZE_LOCAL_LABEL);

    TFarEdit * LocalDirectoryEdit = new TFarEdit(Dialog);
    LocalDirectoryEdit->History = LOCAL_SYNC_HISTORY;

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(SYNCHRONIZE_REMOTE_LABEL);

    TFarEdit * RemoteDirectoryEdit = new TFarEdit(Dialog);
    RemoteDirectoryEdit->History = REMOTE_SYNC_HISTORY;

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(SYNCHRONIZE_GROUP);

    TFarRadioButton * SynchronizeBothButton = new TFarRadioButton(Dialog);
    SynchronizeBothButton->Caption = GetMsg(SYNCHRONIZE_BOTH);

    Dialog->NextItemPosition = ipRight;

    TFarRadioButton * SynchronizeRemoteButton = new TFarRadioButton(Dialog);
    SynchronizeRemoteButton->Caption = GetMsg(SYNCHRONIZE_REMOTE);

    TFarRadioButton * SynchronizeLocalButton = new TFarRadioButton(Dialog);
    SynchronizeLocalButton->Caption = GetMsg(SYNCHRONIZE_LOCAL);

    Dialog->NextItemPosition = ipNewLine;

    TFarCheckBox * SynchronizeDeleteCheck = new TFarCheckBox(Dialog);
    SynchronizeDeleteCheck->Caption = GetMsg(SYNCHRONIZE_DELETE);
    SynchronizeDeleteCheck->EnabledDependencyNegative = SynchronizeBothButton;

    Dialog->NextItemPosition = ipRight;

    TFarCheckBox * SynchronizeNoConfirmationCheck = new TFarCheckBox(Dialog);
    SynchronizeNoConfirmationCheck->Caption = GetMsg(SYNCHRONIZE_NO_CONFIRMATION);

    Dialog->NextItemPosition = ipNewLine;

    new TFarSeparator(Dialog);

    TFarCheckBox * SaveSettingsCheck = new TFarCheckBox(Dialog);
    SaveSettingsCheck->Caption = GetMsg(SYNCHRONIZE_REUSE_SETTINGS);

    Dialog->AddStandardButtons();

    LocalDirectoryEdit->Text = LocalDirectory;
    RemoteDirectoryEdit->Text = RemoteDirectory;
    SynchronizeRemoteButton->Checked = (Mode == TTerminal::smRemote);
    SynchronizeLocalButton->Checked = (Mode == TTerminal::smLocal);
    SynchronizeBothButton->Checked = (Mode == TTerminal::smBoth);
    SynchronizeDeleteCheck->Checked = (Params & TTerminal::spDelete) != 0;
    SynchronizeNoConfirmationCheck->Checked = (Params & TTerminal::spNoConfirmation) != 0;
    SaveSettingsCheck->Checked = SaveSettings;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      RemoteDirectory = RemoteDirectoryEdit->Text;
      LocalDirectory = LocalDirectoryEdit->Text;

      if (SynchronizeRemoteButton->Checked)
      {
        Mode = TTerminal::smRemote;
      }
      else if (SynchronizeLocalButton->Checked)
      {
        Mode = TTerminal::smLocal;
      }
      else
      {
        Mode = TTerminal::smBoth;
      }

      Params &= ~(TTerminal::spDelete | TTerminal::spNoConfirmation);
      Params |=
        (SynchronizeDeleteCheck->Checked ? TTerminal::spDelete : 0) |
        (SynchronizeNoConfirmationCheck->Checked ? TTerminal::spNoConfirmation : 0);

      SaveSettings = SaveSettingsCheck->Checked;
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::RemoteMoveDialog(TStrings * FileList,
  AnsiString & Target, AnsiString & FileMask)
{
  AnsiString Prompt = FileNameFormatString(GetMsg(REMOTE_MOVE_FILE),
    GetMsg(REMOTE_MOVE_FILES), FileList, true);

  AnsiString Value = UnixIncludeTrailingBackslash(Target) + FileMask;
  bool Result = FPlugin->InputBox(GetMsg(REMOTE_MOVE_TITLE), Prompt,
    Value, 0, MOVE_TO_HISTORY);
  if (Result && !Value.IsEmpty())
  {
    Target = UnixExtractFilePath(Value);
    FileMask = UnixExtractFileName(Value);
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TQueueDialog : TFarDialog
{
public:
  __fastcall TQueueDialog(TCustomFarPlugin * AFarPlugin,
    TWinSCPFileSystem * AFileSystem, bool ClosingPlugin);

  bool __fastcall Execute(TTerminalQueueStatus * Status);

protected:
  virtual void __fastcall Change();
  virtual void __fastcall Idle();
  bool __fastcall UpdateQueue();
  void __fastcall LoadQueue();
  void __fastcall RefreshQueue();
  bool __fastcall FillQueueItemLine(AnsiString & Line,
    TQueueItemProxy * QueueItem, int Index);
  void __fastcall UpdateControls();
  void __fastcall Key(TFarDialog * Sender, TFarDialogItem * Item, long Key,
    bool & Handled);
  virtual bool __fastcall CloseQuery();

private:
  TTerminalQueueStatus * FStatus;
  TWinSCPFileSystem * FFileSystem;
  bool FClosingPlugin;

  TFarListBox * QueueListBox;
  TFarButton * ShowButton;
  TFarButton * ExecuteButton;
  TFarButton * DeleteButton;
  TFarButton * MoveUpButton;
  TFarButton * MoveDownButton;
  TFarButton * CloseButton;

  void __fastcall OperationButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TQueueDialog::TQueueDialog(TCustomFarPlugin * AFarPlugin,
  TWinSCPFileSystem * AFileSystem, bool ClosingPlugin) :
  TFarDialog(AFarPlugin), FFileSystem(AFileSystem),
  FClosingPlugin(ClosingPlugin)
{
  TFarSeparator * Separator;
  TFarText * Text;

  Size = TPoint(80, 23);
  TRect CRect = ClientRect;
  int ListTop;
  int ListHeight = ClientSize.y - 4;

  OnKey = Key;

  Caption = GetMsg(QUEUE_TITLE);

  Text = new TFarText(this);
  Text->Caption = GetMsg(QUEUE_HEADER);

  Separator = new TFarSeparator(this);
  ListTop = Separator->Bottom;

  Separator = new TFarSeparator(this);
  Separator->Move(0, ListHeight);

  ShowButton = new TFarButton(this);
  ShowButton->Caption = GetMsg(QUEUE_SHOW);
  ShowButton->OnClick = OperationButtonClick;
  ShowButton->CenterGroup = true;

  NextItemPosition = ipRight;

  ExecuteButton = new TFarButton(this);
  ExecuteButton->Caption = GetMsg(QUEUE_EXECUTE);
  ExecuteButton->OnClick = OperationButtonClick;
  ExecuteButton->CenterGroup = true;

  DeleteButton = new TFarButton(this);
  DeleteButton->Caption = GetMsg(QUEUE_DELETE);
  DeleteButton->OnClick = OperationButtonClick;
  DeleteButton->CenterGroup = true;

  MoveUpButton = new TFarButton(this);
  MoveUpButton->Caption = GetMsg(QUEUE_MOVE_UP);
  MoveUpButton->OnClick = OperationButtonClick;
  MoveUpButton->CenterGroup = true;

  MoveDownButton = new TFarButton(this);
  MoveDownButton->Caption = GetMsg(QUEUE_MOVE_DOWN);
  MoveDownButton->OnClick = OperationButtonClick;
  MoveDownButton->CenterGroup = true;

  CloseButton = new TFarButton(this);
  CloseButton->Caption = GetMsg(QUEUE_CLOSE);
  CloseButton->Result = brCancel;
  CloseButton->CenterGroup = true;
  CloseButton->Default = true;

  NextItemPosition = ipNewLine;

  QueueListBox = new TFarListBox(this);
  QueueListBox->Top = ListTop + 1;
  QueueListBox->Height = ListHeight;
  QueueListBox->NoBox = true;
  QueueListBox->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::OperationButtonClick(TFarButton * Sender,
  bool & /*Close*/)
{
  TQueueItemProxy * QueueItem;
  if (QueueListBox->Items->Selected >= 0)
  {
    QueueItem = reinterpret_cast<TQueueItemProxy *>(
      QueueListBox->Items->Objects[QueueListBox->Items->Selected]);

    if (Sender == ShowButton)
    {
      QueueItem->ProcessUserAction();
    }
    else if (Sender == ExecuteButton)
    {
      QueueItem->ExecuteNow();
    }
    else if ((Sender == MoveUpButton) || (Sender == MoveDownButton))
    {
      QueueItem->Move(Sender == MoveUpButton);
    }
    else if (Sender == DeleteButton)
    {
      QueueItem->Delete();
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::Key(
  TFarDialog * /*Sender*/, TFarDialogItem * /*Item*/, long Key, bool & Handled)
{
  if (QueueListBox->Focused())
  {
    TFarButton * DoButton = NULL;
    if (Key == KEY_ENTER)
    {
      if (ShowButton->Enabled)
      {
        DoButton = ShowButton;
      }
      else if (ExecuteButton->Enabled)
      {
        DoButton = ExecuteButton;
      }
      Handled = true;
    }
    else if (Key == KEY_DEL)
    {
      if (DeleteButton->Enabled)
      {
        DoButton = DeleteButton;
      }
    }
    else if (Key == KEY_CTRLUP)
    {
      if (MoveUpButton->Enabled)
      {
        DoButton = MoveUpButton;
      }
    }
    else if (Key == KEY_CTRLDOWN)
    {
      if (MoveDownButton->Enabled)
      {
        DoButton = MoveDownButton;
      }
    }

    if (DoButton != NULL)
    {
      bool Close;
      OperationButtonClick(DoButton, Close);
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::UpdateControls()
{
  TQueueItemProxy * QueueItem = NULL;
  if (QueueListBox->Items->Selected >= 0)
  {
    QueueItem = reinterpret_cast<TQueueItemProxy *>(
      QueueListBox->Items->Objects[QueueListBox->Items->Selected]);
  }

  ShowButton->Enabled = (QueueItem != NULL) &&
    TQueueItem::IsUserActionStatus(QueueItem->Status);
  ExecuteButton->Enabled = (QueueItem != NULL) &&
    (QueueItem->Status == TQueueItem::qsPending);
  DeleteButton->Enabled = (QueueItem != NULL) &&
    (QueueItem->Status != TQueueItem::qsDone) &&
    !TQueueItem::IsUserActionStatus(QueueItem->Status);
  MoveUpButton->Enabled = (QueueItem != NULL) &&
    (QueueItem->Status == TQueueItem::qsPending) &&
    (QueueItem->Index > FStatus->ActiveCount);
  MoveDownButton->Enabled = (QueueItem != NULL) &&
    (QueueItem->Status == TQueueItem::qsPending) &&
    (QueueItem->Index < FStatus->Count - 1);
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::Idle()
{
  TFarDialog::Idle();

  if (UpdateQueue())
  {
    LoadQueue();
    UpdateControls();
  }
  else
  {
    RefreshQueue();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TQueueDialog::CloseQuery()
{
  bool Result = TFarDialog::CloseQuery();
  if (Result)
  {
    TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);
    Result = !FClosingPlugin || (FStatus->Count == 0) ||
      (WinSCPPlugin->MoreMessageDialog(GetMsg(QUEUE_PENDING_ITEMS), NULL,
        qtWarning, qaOK | qaCancel) == qaCancel);
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TQueueDialog::UpdateQueue()
{
  assert(FFileSystem != NULL);
  TTerminalQueueStatus * Status = FFileSystem->ProcessQueue();
  bool Result = (Status != NULL);
  if (Result)
  {
    FStatus = Status;
  }
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::RefreshQueue()
{
  if (QueueListBox->Items->Count > 0)
  {
    bool Change = false;
    int TopIndex = QueueListBox->Items->TopIndex;
    int Index = TopIndex;

    int ILine = 0;
    while ((Index - ILine > 0) &&
           (QueueListBox->Items->Objects[Index] ==
              QueueListBox->Items->Objects[Index - ILine - 1]))
    {
      ILine++;
    }

    TQueueItemProxy * PrevQueueItem = NULL;
    TQueueItemProxy * QueueItem;
    AnsiString Line;
    while ((Index < QueueListBox->Items->Count) &&
           (Index < TopIndex + QueueListBox->Height))
    {
      QueueItem = reinterpret_cast<TQueueItemProxy*>(
        QueueListBox->Items->Objects[Index]);
      assert(QueueItem != NULL);
      if ((PrevQueueItem != NULL) && (QueueItem != PrevQueueItem))
      {
        ILine = 0;
      }

      if (TQueueItem::IsUserActionStatus(QueueItem->Status) &&
          !QueueItem->ProcessingUserAction)
      {
        FillQueueItemLine(Line, QueueItem, ILine);
        if (QueueListBox->Items->Strings[Index] != Line)
        {
          Change = true;
          QueueListBox->Items->Strings[Index] = Line;
        }
      }

      PrevQueueItem = QueueItem;
      Index++;
      ILine++;
    }

    if (Change)
    {
      Redraw();
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::LoadQueue()
{
  TStringList * List = new TStringList();
  try
  {
    AnsiString Line;
    TQueueItemProxy * QueueItem;
    for (int Index = 0; Index < FStatus->Count; Index++)
    {
      QueueItem = FStatus->Items[Index];
      int ILine = 0;
      while (FillQueueItemLine(Line, QueueItem, ILine))
      {
        List->AddObject(Line, reinterpret_cast<TObject*>(QueueItem));
        ILine++;
      }
    }
    QueueListBox->SetItems(List);
  }
  __finally
  {
    delete List;
  }
}
//---------------------------------------------------------------------------
bool __fastcall TQueueDialog::FillQueueItemLine(AnsiString & Line,
  TQueueItemProxy * QueueItem, int Index)
{
  int PathMaxLen = 50;

  if ((Index > 2) ||
      ((Index == 2) && (QueueItem->Status == TQueueItem::qsPending)))
  {
    return false;
  }

  AnsiString ProgressStr;

  switch (QueueItem->Status)
  {
    case TQueueItem::qsPending:
      ProgressStr = GetMsg(QUEUE_PENDING);
      break;

    case TQueueItem::qsConnecting:
      ProgressStr = GetMsg(QUEUE_CONNECTING);
      break;

    case TQueueItem::qsQuery:
      ProgressStr = GetMsg(QUEUE_QUERY);
      break;

    case TQueueItem::qsError:
      ProgressStr = GetMsg(QUEUE_ERROR);
      break;

    case TQueueItem::qsPrompt:
      ProgressStr = GetMsg(QUEUE_PROMPT);
      break;
  }

  bool BlinkHide = TQueueItem::IsUserActionStatus(QueueItem->Status) &&
    !QueueItem->ProcessingUserAction &&
    ((GetTickCount() % 2000) >= 1000);

  AnsiString Operation;
  AnsiString Direction;
  AnsiString Values[2];
  TFileOperationProgressType * ProgressData = QueueItem->ProgressData;
  TQueueItem::TInfo * Info = QueueItem->Info;

  if (Index == 0)
  {
    if (!BlinkHide)
    {
      switch (Info->Operation)
      {
        case foCopy:
          Operation = GetMsg(QUEUE_COPY);
          break;

        case foMove:
          Operation = GetMsg(QUEUE_MOVE);
          break;
      }
      Direction = GetMsg((Info->Side == osLocal) ? QUEUE_UPLOAD : QUEUE_DOWNLOAD);
    }

    Values[0] = FFileSystem->MinimizeName(Info->Source, PathMaxLen,
      (Info->Side == osRemote));

    if (ProgressData != NULL)
    {
      Values[1] = FFileSystem->FormatBytes(ProgressData->TotalTransfered);
    }
  }
  else if (Index == 1)
  {
    Values[0] = FFileSystem->MinimizeName(Info->Destination, PathMaxLen,
      (Info->Side == osLocal));
      
    if (ProgressStr.IsEmpty())
    {
      Values[1] = FORMAT("%d%%", (ProgressData->OverallProgress()));
    }
    else if (!BlinkHide)
    {
      Values[1] = ProgressStr;
    }
  }
  else
  {
    if (ProgressData != NULL)
    {
      Values[0] = FFileSystem->MinimizeName(ProgressData->FileName, PathMaxLen,
        (Info->Side == osRemote));
      Values[1] = FORMAT("%d%%", (ProgressData->TransferProgress()));
    }
    else
    {
      Values[0] = ProgressStr;
    }
  }

  Line = FORMAT("%1s %1s  %-*.*s %s",
    (Operation, Direction, PathMaxLen, PathMaxLen, Values[0], Values[1]));

  return true;
}
//---------------------------------------------------------------------------
bool __fastcall TQueueDialog::Execute(TTerminalQueueStatus * Status)
{
  FStatus = Status;

  UpdateQueue();
  LoadQueue();

  bool Result = (ShowModal() != brCancel);

  FStatus = NULL;
  
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::QueueDialog(
  TTerminalQueueStatus * Status, bool ClosingPlugin)
{
  bool Result;
  TQueueDialog * Dialog = new TQueueDialog(FPlugin, this, ClosingPlugin);
  try
  {
    Result = Dialog->Execute(Status);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------


