//---------------------------------------------------------------------------
#ifndef FarDialogH
#define FarDialogH
//---------------------------------------------------------------------------
#include "FarPlugin.h"
//---------------------------------------------------------------------------
class TFarDialogContainer;
class TFarDialogItem;
class TFarButton;
class TFarSeparator;
class TFarBox;
class TFarList;
struct FarDialogItem;
enum TItemPosition { ipNewLine, ipBelow, ipRight };
//---------------------------------------------------------------------------
typedef void __fastcall (__closure * TFarKeyEvent)
  (TFarDialog * Sender, TFarDialogItem * Item, long Key, bool & Handled);
typedef void __fastcall (__closure * TFarProcessGroupEvent)
  (TFarDialogItem * Item, void * Arg);
//---------------------------------------------------------------------------
class TFarDialog : public TObject
{
friend TFarDialogItem;
friend TFarDialogContainer;
friend TFarButton;
friend TFarList;
public:
  __fastcall TFarDialog(TCustomFarPlugin * AFarPlugin);
  __fastcall ~TFarDialog();

  int __fastcall ShowModal();
  void __fastcall ShowGroup(int Group, bool Show);
  void __fastcall EnableGroup(int Group, bool Enable);

  __property TRect Bounds = { read = FBounds, write = SetBounds };
  __property TRect ClientRect = { read = GetClientRect };
  __property AnsiString HelpTopic = { read = FHelpTopic, write = SetHelpTopic };
  __property unsigned int Flags = { read = FFlags, write = SetFlags };
  __property bool Centered = { read = GetCentered, write = SetCentered };
  __property TPoint Size = { read = GetSize, write = SetSize };
  __property TPoint ClientSize = { read = GetClientSize };
  __property AnsiString Caption = { read = GetCaption, write = SetCaption };
  __property HANDLE Handle = { read = FHandle };
  __property TFarButton * DefaultButton = { read = FDefaultButton };
  __property TFarBox * BorderBox = { read = FBorderBox };
  __property TFarDialogItem * Item[int Index] = { read = GetItem };
  __property int ItemCount = { read = GetItemCount };
  __property TItemPosition NextItemPosition = { read = FNextItemPosition, write = FNextItemPosition };
  __property int DefaultGroup = { read = FDefaultGroup, write = FDefaultGroup };
  __property int Tag = { read = FTag, write = FTag };
  __property TFarDialogItem * ItemFocused = { read = FItemFocused, write = SetItemFocused };
  __property int Result = { read = FResult };

  __property TFarKeyEvent OnKey = { read = FOnKey, write = FOnKey };

  void __fastcall Redraw();
  void __fastcall LockChanges();
  void __fastcall UnlockChanges();

protected:
  __property TCustomFarPlugin * FarPlugin = { read = FFarPlugin };
  __property TObjectList * Items = { read = FItems };

  void __fastcall Add(TFarDialogItem * Item);
  long __fastcall SendMessage(int Msg, int Param1, int Param2);
  virtual long __fastcall DialogProc(int Msg, int Param1, long Param2);
  virtual long __fastcall FailDialogProc(int Msg, int Param1, long Param2);
  long __fastcall DefaultDialogProc(int Msg, int Param1, long Param2);
  virtual void __fastcall Change();
  virtual void __fastcall Init();
  virtual bool __fastcall CloseQuery();
  AnsiString __fastcall GetMsg(int MsgId);
  void __fastcall GetNextItemPosition(int & Left, int & Top);
  void __fastcall RefreshBounds();
  virtual void __fastcall Idle();
  void __fastcall BreakSynchronize();
  void __fastcall Synchronize(TThreadMethod Method);
  void __fastcall Close(TFarButton * Button);
  void __fastcall ProcessGroup(int Group, TFarProcessGroupEvent Callback, void * Arg);
  void __fastcall ShowItem(TFarDialogItem * Item, void * Arg);
  void __fastcall EnableItem(TFarDialogItem * Item, void * Arg);
  bool __fastcall ChangesLocked();

  static long WINAPI DialogProcGeneral(HANDLE Handle, int Msg, int Param1, long Param2);

private:
  TCustomFarPlugin * FFarPlugin;
  TRect FBounds;
  unsigned int FFlags;
  AnsiString FHelpTopic;
  bool FVisible;
  TObjectList * FItems;
  HANDLE FHandle;
  TFarButton * FDefaultButton;
  TFarBox * FBorderBox;
  TItemPosition FNextItemPosition;
  int FDefaultGroup;
  int FTag;
  TFarDialogItem * FItemFocused;
  TFarKeyEvent FOnKey;
  FarDialogItem * FDialogItems;
  int FDialogItemsCapacity;
  bool FRedrawPending;
  int FChangesLocked;
  bool FChangesPending;
  int FResult;
  bool FNeedsSynchronize;
  HANDLE FSynchronizeObjects[2];
  TThreadMethod FSynchronizeMethod;

  void __fastcall SetBounds(TRect value);
  void __fastcall SetHelpTopic(AnsiString value);
  void __fastcall SetFlags(unsigned int value);
  void __fastcall SetCentered(bool value);
  bool __fastcall GetCentered();
  TPoint __fastcall GetSize();
  void __fastcall SetSize(TPoint value);
  void __fastcall SetCaption(AnsiString value);
  AnsiString __fastcall GetCaption();
  TFarDialogItem * __fastcall GetItem(int Index);
  TRect __fastcall GetClientRect();
  int __fastcall GetItemCount();
  void __fastcall SetItemFocused(TFarDialogItem * value);
  TPoint __fastcall GetClientSize();
};
//---------------------------------------------------------------------------
class TFarDialogContainer : public TObject
{
friend TFarDialog;
friend TFarDialogItem;
public:
  __property int Left = { read = FLeft, write = SetPosition, index = 0 };
  __property int Top = { read = FTop, write = SetPosition, index = 1 };
  __property bool Enabled = { read = FEnabled, write = SetEnabled };

protected:
  __fastcall TFarDialogContainer(TFarDialog * ADialog);
  __fastcall ~TFarDialogContainer();

  __property TFarDialog * Dialog = { read = FDialog };

  void __fastcall Add(TFarDialogItem * Item);
  void __fastcall Remove(TFarDialogItem * Item);
  virtual void __fastcall Change();
  AnsiString __fastcall GetMsg(int MsgId);

private:
  int FLeft;
  int FTop;
  TObjectList * FItems;
  TFarDialog * FDialog;
  bool FEnabled;

  void __fastcall SetPosition(int Index, int value);
  void __fastcall SetEnabled(bool value);
};
//---------------------------------------------------------------------------
#define DIF_INVERSE 0x00000001UL
//---------------------------------------------------------------------------
class TFarDialogItem : public TObject
{
friend TFarDialog;
friend TFarDialogContainer;
friend TFarList;
public:
  __property TRect Bounds = { read = FBounds, write = SetBounds };
  __property TRect ActualBounds = { read = GetActualBounds };
  __property int Left = { read = GetCoordinate, write = SetCoordinate, index = 0 };
  __property int Top = { read = GetCoordinate, write = SetCoordinate, index = 1 };
  __property int Right = { read = GetCoordinate, write = SetCoordinate, index = 2 };
  __property int Bottom = { read = GetCoordinate, write = SetCoordinate, index = 3 };
  __property int Width = { read = GetWidth, write = SetWidth };
  __property int Height = { read = GetHeight, write = SetHeight };
  __property unsigned int Flags = { read = GetFlags, write = SetFlags };
  __property bool Enabled = { read = FEnabled, write = SetEnabled };
  __property bool IsEnabled = { read = FIsEnabled };
  __property TFarDialogItem * EnabledDependency = { read = FEnabledDependency, write = SetEnabledDependency };
  __property TFarDialogItem * EnabledDependencyNegative = { read = FEnabledDependencyNegative, write = SetEnabledDependencyNegative };
  __property bool IsEmpty = { read = GetIsEmpty };
  __property int Group = { read = FGroup, write = FGroup };
  __property bool Visible = { read = GetFlag, write = SetFlag, index = DIF_HIDDEN | DIF_INVERSE };
  __property int Tag = { read = FTag, write = FTag };
  __property TFarDialog * Dialog = { read = FDialog };

  __property TNotifyEvent OnExit = { read = FOnExit, write = FOnExit };

  void __fastcall Move(int DeltaX, int DeltaY);
  virtual bool __fastcall CanFocus();
  bool __fastcall Focused();
  void __fastcall SetFocus();

protected:
  int FDefaultType;
  int FGroup;
  int FTag;
  TNotifyEvent FOnExit;

  __fastcall TFarDialogItem(TFarDialog * ADialog, int AType);
  __fastcall ~TFarDialogItem();

  __property FarDialogItem * DialogItem = { read = GetDialogItem };
  __property bool CenterGroup = { read = GetFlag, write = SetFlag, index = DIF_CENTERGROUP };
  __property AnsiString Data = { read = GetData, write = SetData };
  __property int Type = { read = GetType, write = SetType };
  __property int Item = { read = FItem };
  __property int Selected = { read = GetSelected, write = SetSelected };
  __property TFarDialogContainer * Container = { read = FContainer, write = SetContainer };
  __property bool Checked = { read = GetChecked, write = SetChecked };

  void __fastcall DialogResized();
  long __fastcall SendMessage(int Msg, int Param);
  virtual long __fastcall ItemProc(int Msg, long Param);
  long __fastcall DefaultItemProc(int Msg, int Param);
  virtual long __fastcall FailItemProc(int Msg, long Param);
  virtual void __fastcall Change();
  void __fastcall DialogChange();
  void __fastcall SetAlterType(int Index, bool value);
  bool __fastcall GetAlterType(int Index);
  virtual void __fastcall UpdateBounds();
  virtual void __fastcall Init();
  virtual bool __fastcall CloseQuery();

  virtual bool __fastcall GetIsEmpty();
  virtual void __fastcall SetData(const AnsiString value);
  void __fastcall UpdateData(const AnsiString value);
  void __fastcall UpdateSelected(int value);

  bool __fastcall GetFlag(int Index);
  void __fastcall SetFlag(int Index, bool value);

  virtual void __fastcall DoFocus();
  virtual void __fastcall DoExit();

  char __fastcall GetColor(int Index);
  void __fastcall SetColor(int Index, char value);

private:
  FarDialogItem * FInternalDialogItem;
  TFarDialog * FDialog;
  TRect FBounds;
  TFarDialogItem * FEnabledDependency;
  TFarDialogItem * FEnabledDependencyNegative;
  TFarDialogContainer * FContainer;
  int FItem;
  bool FEnabled;
  bool FIsEnabled;
  unsigned long FColors;
  unsigned long FColorMask;

  void __fastcall SetBounds(TRect value);
  void __fastcall SetFlags(unsigned int value);
  void __fastcall UpdateFlags(unsigned int value);
  AnsiString __fastcall GetData();
  TRect __fastcall GetActualBounds();
  unsigned int __fastcall GetFlags();
  void __fastcall SetType(int value);
  int __fastcall GetType();
  void __fastcall SetEnabledDependency(TFarDialogItem * value);
  void __fastcall SetEnabledDependencyNegative(TFarDialogItem * value);
  void __fastcall SetSelected(int value);
  int __fastcall GetSelected();
  void __fastcall SetCoordinate(int Index, int value);
  int __fastcall GetCoordinate(int Index);
  void __fastcall SetWidth(int value);
  int __fastcall GetWidth();
  void __fastcall SetHeight(int value);
  int __fastcall GetHeight();
  TFarDialogItem * __fastcall GetPrevItem();
  void __fastcall UpdateFocused(bool value);
  void __fastcall SetContainer(TFarDialogContainer * value);
  void __fastcall SetEnabled(bool value);
  void __fastcall UpdateEnabled();
  void __fastcall SetChecked(bool value);
  bool __fastcall GetChecked();
  FarDialogItem * __fastcall GetDialogItem();
};
//---------------------------------------------------------------------------
class TFarBox : public TFarDialogItem
{
public:
  __fastcall TFarBox(TFarDialog * ADialog);

  __property AnsiString Caption = { read = Data, write = Data };
  __property bool Double = { read = GetAlterType, write = SetAlterType, index = DI_DOUBLEBOX };
};
//---------------------------------------------------------------------------
typedef void __fastcall (__closure * TFarButtonClick)(TFarButton * Sender, bool & Close);
//---------------------------------------------------------------------------
class TFarButton : public TFarDialogItem
{
public:
  __fastcall TFarButton(TFarDialog * ADialog);

  __property AnsiString Caption = { read = Data, write = Data };
  __property int Result = { read = FResult, write = FResult };
  __property bool Default = { read = GetDefault, write = SetDefault };
  __property CenterGroup;
  __property TFarButtonClick OnClick = { read = FOnClick, write = FOnClick };

protected:
  virtual void __fastcall SetData(const AnsiString value);
  virtual long __fastcall ItemProc(int Msg, long Param);

private:
  int FResult;
  TFarButtonClick FOnClick;

  void __fastcall SetDefault(bool value);
  bool __fastcall GetDefault();
};
//---------------------------------------------------------------------------
typedef void __fastcall (__closure * TFarAllowChange)(TFarDialogItem * Sender,
  long NewState, bool & AllowChange);
//---------------------------------------------------------------------------
class TFarCheckBox : public TFarDialogItem
{
public:
  __fastcall TFarCheckBox(TFarDialog * ADialog);

  __property AnsiString Caption = { read = Data, write = Data };
  __property bool AllowGrayed = { read = GetFlag, write = SetFlag, index = DIF_3STATE	};
  __property TFarAllowChange OnAllowChange = { read = FOnAllowChange, write = FOnAllowChange };
  __property Checked;
  __property Selected;

protected:
  TFarAllowChange FOnAllowChange;
  virtual long __fastcall ItemProc(int Msg, long Param);
  virtual bool __fastcall GetIsEmpty();
  virtual void __fastcall SetData(const AnsiString value);
};
//---------------------------------------------------------------------------
class TFarRadioButton : public TFarDialogItem
{
public:
  __fastcall TFarRadioButton(TFarDialog * ADialog);

  __property Checked;
  __property AnsiString Caption = { read = Data, write = Data };
  __property TFarAllowChange OnAllowChange = { read = FOnAllowChange, write = FOnAllowChange };

protected:
  TFarAllowChange FOnAllowChange;
  virtual long __fastcall ItemProc(int Msg, long Param);
  virtual bool __fastcall GetIsEmpty();
  virtual void __fastcall SetData(const AnsiString value);
};
//---------------------------------------------------------------------------
class TFarEdit : public TFarDialogItem
{
public:
  __fastcall TFarEdit(TFarDialog * ADialog);

  __property AnsiString Text = { read = Data, write = Data };
  __property int AsInteger = { read = GetAsInteger, write = SetAsInteger };
  __property bool Password = { read = GetAlterType, write = SetAlterType, index = DI_PSWEDIT };
  __property bool Fixed = { read = GetAlterType, write = SetAlterType, index = DI_FIXEDIT };
  __property AnsiString Mask = { read = GetHistoryMask, write = SetHistoryMask, index = 1 };
  __property AnsiString History = { read = GetHistoryMask, write = SetHistoryMask, index = 0 };
  __property bool ExpandEnvVars = { read = GetFlag, write = SetFlag, index = DIF_EDITEXPAND };
  __property bool AutoSelect = { read = GetFlag, write = SetFlag, index = DIF_SELECTONENTRY };

protected:
  virtual long __fastcall ItemProc(int Msg, long Param);

private:
  AnsiString __fastcall GetHistoryMask(int Index);
  void __fastcall SetHistoryMask(int Index, AnsiString value);
  void __fastcall SetAsInteger(int value);
  int __fastcall GetAsInteger();
};
//---------------------------------------------------------------------------
class TFarSeparator : public TFarDialogItem
{
public:
  __fastcall TFarSeparator(TFarDialog * ADialog);

  __property bool Double = { read = GetDouble, write = SetDouble };
  __property AnsiString Caption = { read = Data, write = Data };
  __property int Position = { read = GetPosition, write = SetPosition };

protected:
  virtual void __fastcall UpdateBounds();

private:
  void __fastcall SetDouble(bool value);
  bool __fastcall GetDouble();
  void __fastcall SetPosition(int value);
  int __fastcall GetPosition();
};
//---------------------------------------------------------------------------
class TFarText : public TFarDialogItem
{
public:
  __fastcall TFarText(TFarDialog * ADialog);

  __property AnsiString Caption = { read = Data, write = Data };
  __property CenterGroup;
  __property char Color = { read = GetColor, write = SetColor, index = 0 };

protected:
  virtual void __fastcall SetData(const AnsiString value);
};
//---------------------------------------------------------------------------
class FarList;
class TFarListBox;
class TFarComboBox;
//---------------------------------------------------------------------------
class TFarList : public TStringList
{
friend TFarListBox;
friend TFarComboBox;
public:
  __fastcall TFarList(TFarDialogItem * ADialogItem);
  virtual __fastcall ~TFarList();

  __property int Selected = { read = GetSelected, write = SetSelected };
  __property int TopIndex = { read = GetTopIndex, write = SetTopIndex };

protected:
	virtual void __fastcall Changed();
  virtual long __fastcall ItemProc(int Msg, long Param);
  virtual void __fastcall Init();
  void __fastcall UpdatePosition(int Position);
  int __fastcall GetPosition();
  virtual void __fastcall Put(int Index, const AnsiString S);
  void __fastcall SetCurPos(int Position, int TopIndex);

  __property FarList * ListItems = { read = FListItems };
  __property TFarDialogItem * DialogItem = { read = FDialogItem };

private:
  FarList * FListItems;
  TFarDialogItem * FDialogItem;
  bool FNoDialogUpdate;

  inline int __fastcall GetSelectedInt(bool Init);
  int __fastcall GetSelected();
  void __fastcall SetSelected(int value);
  int __fastcall GetTopIndex();
  void __fastcall SetTopIndex(int value);
};
//---------------------------------------------------------------------------
enum TFarListBoxAutoSelect { asFocus, asAlways };
//---------------------------------------------------------------------------
class TFarListBox : public TFarDialogItem
{
public:
  __fastcall TFarListBox(TFarDialog * ADialog);
  __fastcall ~TFarListBox();

  void __fastcall SetItems(TStrings * value);

  __property bool NoAmpersand = { read = GetFlag, write = SetFlag, index = DIF_LISTNOAMPERSAND };
  __property bool AutoHighlight = { read = GetFlag, write = SetFlag, index = DIF_LISTAUTOHIGHLIGHT };
  __property bool NoBox = { read = GetFlag, write = SetFlag, index = DIF_LISTNOBOX };
  __property bool WrapMode = { read = GetFlag, write = SetFlag, index = DIF_LISTWRAPMODE };
  __property TFarList * Items = { read = FList, write = SetList };
  __property TFarListBoxAutoSelect AutoSelect = { read = FAutoSelect, write = SetAutoSelect };

protected:
  virtual long __fastcall ItemProc(int Msg, long Param);
  virtual void __fastcall Init();
  virtual bool __fastcall CloseQuery();

private:
  TFarList * FList;
  TFarListBoxAutoSelect FAutoSelect;
  bool FDenyClose;

  void __fastcall SetAutoSelect(TFarListBoxAutoSelect value);
  void __fastcall UpdateMouseReaction();
  void __fastcall SetList(TFarList * value);
};
//---------------------------------------------------------------------------
class TFarComboBox : public TFarDialogItem
{
public:
  __fastcall TFarComboBox(TFarDialog * ADialog);
  __fastcall ~TFarComboBox();

  __property bool NoAmpersand = { read = GetFlag, write = SetFlag, index = DIF_LISTNOAMPERSAND };
  __property bool AutoHighlight = { read = GetFlag, write = SetFlag, index = DIF_LISTAUTOHIGHLIGHT };
  __property bool WrapMode = { read = GetFlag, write = SetFlag, index = DIF_LISTWRAPMODE };
  __property TFarList * Items = { read = FList };
  __property AnsiString Text = { read = Data, write = Data };
  __property bool AutoSelect = { read = GetFlag, write = SetFlag, index = DIF_SELECTONENTRY };
  __property bool DropDownList = { read = GetFlag, write = SetFlag, index = DIF_DROPDOWNLIST };

protected:
  virtual long __fastcall ItemProc(int Msg, long Param);
  virtual void __fastcall Init();

private:
  TFarList * FList;
};
//---------------------------------------------------------------------------
AnsiString __fastcall StripHotKey(AnsiString Text);
//---------------------------------------------------------------------------
#endif
