//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "WinSCPPlugin.h"
#include "WinSCPFileSystem.h"
#include "FarConfiguration.h"
#include "FarTexts.h"
#include "FarDialog.h"
#include "plugin.hpp"
#include <Common.h>
#include <ScpMain.h>
#include <Exceptions.h>
#include <Terminal.h>
#include <GUITools.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
TCustomFarPlugin * __fastcall CreateFarPlugin(THandle Handle)
{
  return new TWinSCPPlugin(Handle);
}
//---------------------------------------------------------------------------
TMessageParams::TMessageParams()
{
  Flags = 0;
  Aliases = NULL;
  AliasesCount = 0;
}
//---------------------------------------------------------------------------
__fastcall TWinSCPPlugin::TWinSCPPlugin(THandle AHandle): TCustomFarPlugin(AHandle)
{
  FInitialized = false;
  CreateMutex(NULL, false, "WinSCPFar");
}
//---------------------------------------------------------------------------
__fastcall TWinSCPPlugin::~TWinSCPPlugin()
{
  if (FInitialized)
  {
    FarConfiguration->Plugin = NULL;
    Finalize();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::HandlesFunction(THandlesFunction Function)
{
  return (Function == hfProcessKey || Function == hfProcessEvent);
}
//---------------------------------------------------------------------------
int __fastcall TWinSCPPlugin::GetMinFarVersion()
{
  return FAR170BETA5;
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::SetStartupInfo(const struct PluginStartupInfo * Info)
{
  try
  {
    TCustomFarPlugin::SetStartupInfo(Info);
    assert(!FInitialized);
    Initialize("");
    FInitialized = true;
  }
  catch(Exception & E)
  {
    HandleException(&E);
  }
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::GetPluginInfoEx(long unsigned & Flags,
  TStrings * DiskMenuStrings, TStrings * PluginMenuStrings,
  TStrings * PluginConfigStrings, TStrings * CommandPrefixes)
{
  Flags = 0;//PF_PRELOAD;
  if (FarConfiguration->DisksMenu)
  {
    DiskMenuStrings->AddObject(GetMsg(PLUGIN_TITLE),
      (TObject *)FarConfiguration->DisksMenuHotKey);
  }
  if (FarConfiguration->PluginsMenu)
  {
    PluginMenuStrings->Add(GetMsg(PLUGIN_TITLE));
  }
  if (FarConfiguration->PluginsMenuCommands)
  {
    PluginMenuStrings->Add(GetMsg(MENU_COMMANDS));
  }
  PluginConfigStrings->Add(GetMsg(PLUGIN_TITLE));
  CommandPrefixes->CommaText = FarConfiguration->CommandPrefixes;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::ConfigureEx(int /*Item*/)
{
  bool Change = false;
  
  TFarMenuItems * MenuItems = new TFarMenuItems();
  try
  {
    int MInterface = MenuItems->Add(GetMsg(CONFIG_INTERFACE));
    int MConfirmations = MenuItems->Add(GetMsg(CONFIG_CONFIRMATIONS));
    int MTransfer = MenuItems->Add(GetMsg(CONFIG_TRANSFER));
    int MLogging = MenuItems->Add(GetMsg(CONFIG_LOGGING));
    int MIntegration = MenuItems->Add(GetMsg(CONFIG_INTEGRATION));
    MenuItems->AddSeparator();
    int MAbout = MenuItems->Add(GetMsg(CONFIG_ABOUT));

    int Result;

    do
    {
      Result = Menu(FMENU_WRAPMODE, GetMsg(PLUGIN_TITLE), "", MenuItems);

      if (Result >= 0)
      {
        if (Result == MInterface)
        {
          if (ConfigurationDialog())
          {
            Change = true;
          }
        }
        else if (Result == MTransfer)
        {
          if (TransferConfigurationDialog())
          {
            Change = true;
          }
        }
        else if (Result == MConfirmations)
        {
          if (ConfirmationsConfigurationDialog())
          {
            Change = true;
          }
        }
        else if (Result == MLogging)
        {
          if (LoggingConfigurationDialog())
          {
            Change = true;
          }
        }
        else if (Result == MIntegration)
        {
          if (IntegrationConfigurationDialog())
          {
            Change = true;
          }
        }
        else if (Result == MAbout)
        {
          AboutDialog();
        }
      }
    }
    while (Result >= 0);
  }
  __finally
  {
    delete MenuItems;
  }
  return Change;
}
//---------------------------------------------------------------------------
TCustomFarFileSystem * __fastcall TWinSCPPlugin::OpenPluginEx(int OpenFrom, int Item)
{
  TWinSCPFileSystem * FileSystem = NULL;
  try
  {
    if ((OpenFrom == OPEN_PLUGINSMENU) &&
        (!FarConfiguration->PluginsMenu || (Item == 1)))
    {
      CommandsMenu();
    }
    else
    {
      FileSystem = new TWinSCPFileSystem(this);

      if (OpenFrom == OPEN_DISKMENU	|| OpenFrom == OPEN_PLUGINSMENU ||
          OpenFrom == OPEN_FINDLIST)
      {
        // nothing
      }
      else if (OpenFrom == OPEN_SHORTCUT || OpenFrom == OPEN_COMMANDLINE)
      {
        AnsiString Directory;
        AnsiString Name = (char*)Item;
        if (OpenFrom == OPEN_COMMANDLINE)
        {
          while (!Name.IsEmpty() && Name[1] == '/')
          {
            Name.Delete(1, 1);
          }
          int P = Name.Pos("/");
          int P2 = Name.Pos(":");
          if (!P || (P2 && P2 < P))
          {
            P = P2;
          }
          if (P)
          {
            Directory = Name.SubString(P + 1, Name.Length() - P);
            Name.SetLength(P - 1);
          }
        }
        else
        {
          int P = Name.Pos("\1");
          if (P)
          {
            Directory = Name.SubString(P + 1, Name.Length() - P);
            Name.SetLength(P - 1);
          }

          TWinSCPFileSystem * PanelSystem;
          PanelSystem = dynamic_cast<TWinSCPFileSystem *>(GetPanelFileSystem());
          if (PanelSystem && PanelSystem->Connected() &&
              PanelSystem->Terminal->SessionData->Name == Name)
          {
            PanelSystem->SetDirectoryEx(Directory, OPM_SILENT);
            PanelSystem->UpdatePanel();
            PanelSystem->RedrawPanel();
            Abort();
          }
          // directory will be set by FAR itself 
          Directory = "";
        }
        assert(StoredSessions);
        TSessionData * Session;
        Session = dynamic_cast<TSessionData *>(StoredSessions->FindByName(Name));
        if (!Session)
        {
          throw Exception(FORMAT(GetMsg(SESSION_NOT_EXISTS_ERROR), (Name)));
        }
        FileSystem->Connect(Session);
        if (!Directory.IsEmpty())
        {
          FileSystem->SetDirectoryEx(Directory, OPM_SILENT);
        }
      }
      else
      {
        assert(false);
      }
    }
  }
  catch(...)
  {
    delete FileSystem;
    throw;
  }

  return FileSystem;
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::CommandsMenu()
{
  TFarMenuItems * MenuItems = new TFarMenuItems();
  try
  {
    int MAttributes = MenuItems->Add(GetMsg(MENU_COMMANDS_ATTRIBUTES));
    int MLink = MenuItems->Add(GetMsg(MENU_COMMANDS_LINK));
    int MApplyCommand = MenuItems->Add(GetMsg(MENU_COMMANDS_APPLY_COMMAND));
    int MFullSynchronize = MenuItems->Add(GetMsg(MENU_COMMANDS_FULL_SYNCHRONIZE));
    int MSynchronize = MenuItems->Add(GetMsg(MENU_COMMANDS_SYNCHRONIZE));
    int MQueue = MenuItems->Add(GetMsg(MENU_COMMANDS_QUEUE));
    int MInformation = MenuItems->Add(GetMsg(MENU_COMMANDS_INFORMATION));
    int MClearCaches = MenuItems->Add(GetMsg(MENU_COMMANDS_CLEAR_CACHES));
    int MPutty = MenuItems->Add(GetMsg(MENU_COMMANDS_PUTTY));
    MenuItems->AddSeparator();
    int MAddBookmark = MenuItems->Add(GetMsg(MENU_COMMANDS_ADD_BOOKMARK));
    int MOpenDirectory = MenuItems->Add(GetMsg(MENU_COMMANDS_OPEN_DIRECTORY));
    MenuItems->AddSeparator();
    int MPageant = MenuItems->Add(GetMsg(MENU_COMMANDS_PAGEANT));
    int MPuttygen = MenuItems->Add(GetMsg(MENU_COMMANDS_PUTTYGEN));
    MenuItems->AddSeparator();
    int MLog = MenuItems->Add(GetMsg(MENU_COMMANDS_LOG));
    int MConfigure = MenuItems->Add(GetMsg(MENU_COMMANDS_CONFIGURE));
    MenuItems->AddSeparator();
    int MAbout = MenuItems->Add(GetMsg(CONFIG_ABOUT));

    TWinSCPFileSystem * FileSystem;
    TWinSCPFileSystem * AnotherFileSystem;
    FileSystem = dynamic_cast<TWinSCPFileSystem *>(GetPanelFileSystem());
    AnotherFileSystem = dynamic_cast<TWinSCPFileSystem *>(GetPanelFileSystem(true));
    bool FSConnected = (FileSystem != NULL) && FileSystem->Connected();
    bool AnotherFSConnected = (AnotherFileSystem != NULL) && AnotherFileSystem->Connected();
    MenuItems->Disabled[MLog] =
      !Configuration->Logging || !Configuration->LogToFile ||
      !FileExists(Configuration->LogFileName);
    MenuItems->Disabled[MAttributes] = !FSConnected;
    MenuItems->Disabled[MLink] = !FSConnected;
    MenuItems->Disabled[MApplyCommand] = !FSConnected;
    MenuItems->Disabled[MFullSynchronize] = !FSConnected && !AnotherFSConnected;
    MenuItems->Disabled[MSynchronize] = !FSConnected && !AnotherFSConnected;
    MenuItems->Disabled[MQueue] = !FSConnected;
    MenuItems->Disabled[MClearCaches] = !FSConnected || FileSystem->AreCachesEmpty();
    MenuItems->Disabled[MPutty] = !FSConnected || !FileExistsEx(FarConfiguration->PuttyPath);
    MenuItems->Disabled[MAddBookmark] = !FSConnected;
    MenuItems->Disabled[MOpenDirectory] = !FSConnected;
    MenuItems->Disabled[MPageant] = !FileExistsEx(FarConfiguration->PageantPath);
    MenuItems->Disabled[MPuttygen] = !FileExistsEx(FarConfiguration->PuttygenPath);
    MenuItems->Disabled[MInformation] = !FSConnected;

    int Result = Menu(FMENU_WRAPMODE, GetMsg(MENU_COMMANDS), "", MenuItems);

    if (Result >= 0)
    {
      if (Result == MLog)
      {
        Viewer(Configuration->LogFileName, VF_NONMODAL);
      }
      else if (Result == MAttributes)
      {
        assert(FileSystem);
        FileSystem->FileProperties();
      }
      else if (Result == MLink)
      {
        assert(FileSystem);
        FileSystem->CreateLink();
      }
      else if (Result == MApplyCommand)
      {
        assert(FileSystem);
        FileSystem->ApplyCommand();
      }
      else if (Result == MFullSynchronize)
      {
        if (FileSystem != NULL)
        {
          FileSystem->FullSynchronize(true);
        }
        else
        {
          assert(AnotherFileSystem != NULL);
          AnotherFileSystem->FullSynchronize(false);
        }
      }
      else if (Result == MSynchronize)
      {
        if (FileSystem != NULL)
        {
          FileSystem->Synchronize();
        }
        else
        {
          assert(AnotherFileSystem != NULL);
          AnotherFileSystem->Synchronize();
        }
      }
      else if (Result == MQueue)
      {
        assert(FileSystem);
        FileSystem->QueueShow(false);
      }
      else if (Result == MAddBookmark || Result == MOpenDirectory)
      {
        assert(FileSystem);
        FileSystem->OpenDirectory(Result == MAddBookmark);
      }
      else if (Result == MConfigure)
      {
        ConfigureEx(0);
      }
      else if (Result == MAbout)
      {
        AboutDialog();
      }
      else if (Result == MPutty)
      {
        assert(FileSystem);
        FileSystem->OpenSessionInPutty();
      }
      else if (Result == MPageant || Result == MPuttygen)
      {
        AnsiString Path = (Result == MPageant) ?
          FarConfiguration->PageantPath : FarConfiguration->PuttygenPath;
        if (FindFile(Path))
        {
          ShellExecute(NULL, "open", Path.c_str(), NULL, NULL, SW_SHOWNORMAL);
        }
      }
      else if (Result == MClearCaches)
      {
        assert(FileSystem);
        FileSystem->ClearCaches();
      }
      else
      {
        assert(FileSystem);
        FileSystem->ShowInformation();
      }
    }
  }
  __finally
  {
    delete MenuItems;
  }
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::ApplicationException(TObject * /*Sender*/, Exception * E)
{
  HandleException(E);
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::ShowExtendedException(Exception * E)
{
  if (!E->Message.IsEmpty())
  {
    if (E->InheritsFrom(__classid(Exception)))
    {
      if (!E->InheritsFrom(__classid(EAbort)))
      {
        TQueryType Type;
        Type = (E->InheritsFrom(__classid(ESshTerminate)) ?
          qtInformation : qtError);

        TStrings * MoreMessages = NULL;
        if (E->InheritsFrom(__classid(ExtException)))
        {
          MoreMessages = ((ExtException *)E)->MoreMessages;
        }

        AnsiString Message = TranslateExceptionMessage(E);
        MoreMessageDialog(Message, MoreMessages, Type, qaOK);
      }
    }
    else
    {
      ShowException(ExceptObject(), ExceptAddr());
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::HandleException(Exception * E, int OpMode)
{
  if (((OpMode & OPM_FIND) == 0) || E->InheritsFrom(__classid(EFatal)))
  {
    ShowExtendedException(E);
  }
}
//---------------------------------------------------------------------------
int __fastcall TWinSCPPlugin::MoreMessageDialog(AnsiString Str,
  TStrings * MoreMessages, TQueryType Type, int Answers,
  const TMessageParams * Params)
{
  int Result;
  TStrings * ButtonLabels = new TStringList();
  try
  {
    unsigned int Flags = 0;

    if (Params != NULL)
    {
      Flags = Params->Flags;
    }

    int TitleId;
    switch (Type) {
      case qtConfirmation: TitleId = MSG_TITLE_CONFIRMATION; break;
      case qtInformation: TitleId = MSG_TITLE_INFORMATION; break;
      case qtError: TitleId = MSG_TITLE_ERROR; Flags |= FMSG_WARNING; break;
      case qtWarning: TitleId = MSG_TITLE_WARNING; Flags |= FMSG_WARNING; break;
      default: assert(false);
    }
    int Buttons[15];
    int ButtonCount = 0;

    if ((Answers & qaAbort) && (Answers & qaRetry))
    {
      // use warning colors for abort/retry confirmation dialog
      Flags |= FMSG_WARNING;
    }

    int AAnswers = Answers;
    
    #define ADD_BUTTON(TYPE) \
      if (AAnswers & qa ## TYPE) \
      { \
        ButtonLabels->Add(GetMsg(MSG_BUTTON_ ## TYPE)); \
        Buttons[ButtonCount] = qa ## TYPE; \
        ButtonCount++; \
        AAnswers -= qa ## TYPE; \
      }
    ADD_BUTTON(Yes);
    ADD_BUTTON(No);
    ADD_BUTTON(OK);
    ADD_BUTTON(Cancel);
    ADD_BUTTON(Abort);
    ADD_BUTTON(Retry);
    ADD_BUTTON(Ignore);
    ADD_BUTTON(All);
    ADD_BUTTON(NoToAll);
    ADD_BUTTON(YesToAll);
    ADD_BUTTON(Help);
    ADD_BUTTON(Skip);
    #undef ADD_BUTTON

    USEDPARAM(AAnswers);
    assert(!AAnswers);

    if ((Params != NULL) && (Params->Aliases != NULL))
    {
      for (int bi = 0; bi < ButtonCount; bi++)
      {
        for (unsigned int ai = 0; ai < Params->AliasesCount; ai++)
        {
          if (static_cast<int>(Params->Aliases[ai].Button) == Buttons[bi])
          {
            ButtonLabels->Strings[bi] = Params->Aliases[ai].Alias;
            break;
          }
        }
      }
    }

    #define MORE_BUTTON_ID -2
    do
    {
      AnsiString DialogStr = Str;
      if (MoreMessages && (MoreMessages->Count > 0))
      {
        AnsiString ExpansionLabel = GetMsg(FarConfiguration->ErrorDialogExpanded ?
          LESS_BUTTON : MORE_BUTTON);
        if (Buttons[ButtonCount-1] == MORE_BUTTON_ID)
        {
          ButtonLabels->Strings[ButtonCount-1] = ExpansionLabel;
        }
        else
        {
          ButtonLabels->Add(ExpansionLabel);
          Buttons[ButtonCount] = MORE_BUTTON_ID;
          ButtonCount++;
        }

        if (FarConfiguration->ErrorDialogExpanded)
        {
          DialogStr += AnsiString("\n\x01\n") + MoreMessages->Text;
          while (DialogStr[DialogStr.Length()] == '\n' ||
                 DialogStr[DialogStr.Length()] == '\r')
          {
            DialogStr.SetLength(DialogStr.Length() - 1);
          }
          DialogStr += "\n\x01\n";
        }
      }

      Result = Message(Flags, GetMsg(TitleId), DialogStr, ButtonLabels);
      if (Result < 0)
      {
        Result = CancelAnswer(Answers);
      }
      else
      {
        assert(Result >= 0 && Result < ButtonCount);
        Result = Buttons[Result];
      }

      if (Result == MORE_BUTTON_ID)
      {
        FarConfiguration->ErrorDialogExpanded = !FarConfiguration->ErrorDialogExpanded;
      }
    }
    while (Result == MORE_BUTTON_ID);
  }
  __finally
  {
    delete ButtonLabels;
  }
  return Result;
}


