//---------------------------------------------------------------------------
#ifndef WinSCPFileSystemH
#define WinSCPFileSystemH
//---------------------------------------------------------------------------
#include <Interface.h>
#include "FarPlugin.h"
#include <FileOperationProgress.h>
#include <Terminal.h>
#include <GUIConfiguration.h>
#include <SynchronizeController.h>
//---------------------------------------------------------------------------
class TTerminal;
class TSessionData;
class TRemoteFile;
class TBookmarkList;
class TWinSCPPlugin;
class TFarButton;
class TFarDialogItem;
class TFarDialog;
class TTerminalQueue;
class TTerminalQueueStatus;
class TQueueItem;
class TKeepaliveThread;
struct TMessageParams;
#define REMOTE_DIR_HISTORY "WinscpRemoteDirectory"
#define ASCII_MASK_HISTORY "WinscpAsciiMask"
#define LINK_FILENAME_HISTORY "WinscpRemoteLink"
#define LINK_POINT_TO_HISTORY "WinscpRemoteLinkPointTo"
#define APPLY_COMMAND_HISTORY "WinscpApplyCmd"
#define APPLY_COMMAND_PARAM_HISTORY "WinscpApplyCmdParam"
#define LOG_FILE_HISTORY "WinscpLogFile"
#define REMOTE_SYNC_HISTORY "WinscpRemoteSync"
#define LOCAL_SYNC_HISTORY "WinscpLocalSync"
#define MOVE_TO_HISTORY "WinscpMoveTo"
#define EXCLUDE_FILE_MASK_HISTORY "WinscpExcludeFileMask"
//---------------------------------------------------------------------------
// for Properties dialog
const cpMode =  0x01;
const cpOwner = 0x02;
const cpGroup = 0x04;
// for Copy dialog
const coTempTransfer        = 0x01;
const coDisableTransferMode = 0x02;
const coDisableNewerOnly    = 0x04;
//---------------------------------------------------------------------------
class TWinSCPFileSystem : public TCustomFarFileSystem
{
friend class TWinSCPPlugin;
friend class TKeepaliveThread;
friend class TQueueDialog;
public:
  __fastcall TWinSCPFileSystem(TCustomFarPlugin * APlugin);
  virtual __fastcall ~TWinSCPFileSystem();

  virtual void __fastcall Close();

protected:
  bool __fastcall Connect(TSessionData * Data);
  void __fastcall SaveSession();

  virtual void __fastcall GetOpenPluginInfoEx(long unsigned & Flags,
    AnsiString & HostFile, AnsiString & CurDir, AnsiString & Format,
    AnsiString & PanelTitle, TFarPanelModes * PanelModes, int & StartPanelMode,
    int & StartSortMode, bool & StartSortOrder, TFarKeyBarTitles * KeyBarTitles,
    AnsiString & ShortcutData);
  virtual bool __fastcall GetFindDataEx(TList * PanelItems);
  virtual bool __fastcall ProcessKeyEx(int Key, unsigned int ControlState);
  virtual bool __fastcall SetDirectoryEx(const AnsiString Dir, int OpMode);
  virtual int __fastcall MakeDirectoryEx(AnsiString & Name, int OpMode);
  virtual bool __fastcall DeleteFilesEx(TList * PanelItems, int OpMode);
  virtual int __fastcall GetFilesEx(TList * PanelItems, bool Move,
    AnsiString & DestPath, int OpMode);
  virtual int __fastcall PutFilesEx(TList * PanelItems, bool Move, int OpMode);
  virtual bool __fastcall ProcessEventEx(int Event, void * Param);

  virtual void __fastcall HandleException(Exception * E, int OpMode = 0);
  void __fastcall KeepaliveThreadCallback();

  bool __fastcall Connected();
  TWinSCPPlugin * __fastcall WinSCPPlugin();
  void __fastcall ShowOperationProgress(TFileOperationProgressType & ProgressData,
    bool Force);
  bool __fastcall SessionDialog(TSessionData * Data, bool & Connect, bool DefaultSave);
  void __fastcall EditConnectSession(TSessionData * Data, bool Edit);
  void __fastcall DuplicateRenameSession(TSessionData * Data,
    bool Duplicate);
  bool __fastcall ExportSessions(TList * PanelItems, bool Move,
    AnsiString & DestPath, int OpMode);
  bool __fastcall ImportSessions(TList * PanelItems, bool Move, int OpMode);
  void __fastcall FileProperties();
  void __fastcall CreateLink();
  void __fastcall TransferFiles(bool Move);
  void __fastcall RenameFile();
  void __fastcall ApplyCommand();
  void __fastcall ShowInformation();
  void __fastcall InsertFileNameOnCommandLine();
  void __fastcall FullSynchronize(bool Source);
  void __fastcall Synchronize();
  void __fastcall OpenDirectory(bool Add);
  void __fastcall HomeDirectory();
  bool __fastcall PropertiesDialog(TStrings * FileList,
    const AnsiString Directory, TStrings * GroupList, TStrings * UserList,
    TRemoteProperties * Properties, int AllowedChanges);
  bool __fastcall ExecuteCommand(const AnsiString Command);
  void __fastcall TerminalEchoAddLine(TObject * Sender, const AnsiString AddedLine);
  bool __fastcall CopyDialog(bool ToRemote, bool Move, TStrings * FileList,
    AnsiString & TargetDirectory, TGUICopyParamType * Params, int Options);
  bool __fastcall LinkDialog(AnsiString & FileName, AnsiString & PointTo, bool & Symbolic,
    bool Edit, bool AllowSymbolic);
  void __fastcall FileSystemInfoDialog();
  bool __fastcall OpenDirectoryDialog(bool Add, AnsiString & Directory,
    TBookmarkList * BookmarkList);
  bool __fastcall ApplyCommandDialog(AnsiString & Command, int & Params);
  bool __fastcall FullSynchronizeDialog(TTerminal::TSynchronizeMode & Mode, int & Params,
    AnsiString & LocalDirectory, AnsiString & RemoteDirectory,
    bool & SaveSettings);
  bool __fastcall RemoteTransferDialog(TStrings * FileList, AnsiString & Target,
    AnsiString & FileMask, bool Move);
  bool __fastcall RenameFileDialog(TRemoteFile * File, AnsiString & NewName);
  int __fastcall MoreMessageDialog(AnsiString Str, TStrings * MoreMessages,
    TQueryType Type, int Answers, const TMessageParams * Params = NULL);
  bool __fastcall PasswordDialog(AnsiString Prompt, TPromptKind Kind,
    AnsiString & Password);
  bool __fastcall QueueDialog(TTerminalQueueStatus * Status, bool ClosingPlugin);
  bool __fastcall SynchronizeDialog(TSynchronizeParamType & Params,
    TSynchronizeStartStopEvent OnStartStop, bool & SaveSettings);
  void __fastcall DoSynchronize(TSynchronizeController * Sender,
    const AnsiString LocalDirectory, const AnsiString RemoteDirectory,
    const TSynchronizeParamType & Params);
  void __fastcall DoSynchronizeInvalid(TSynchronizeController * Sender,
    const AnsiString Directory);
  void __fastcall Synchronize(const AnsiString LocalDirectory,
    const AnsiString RemoteDirectory, TTerminal::TSynchronizeMode Mode,
    const TCopyParamType & CopyParam, int Params);
  void __fastcall RequireCapability(int Capability);
  bool __fastcall AreCachesEmpty();
  void __fastcall ClearCaches();
  void __fastcall OpenSessionInPutty();
  void __fastcall QueueShow(bool ClosingPlugin);
  TTerminalQueueStatus * __fastcall ProcessQueue();
  bool __fastcall EnsureCommandSessionFallback(TFSCapability Capability);
  void __fastcall ConnectTerminal(TTerminal * Terminal);
  void __fastcall TemporarilyDownloadFiles(TStrings * FileList, bool ForceText, 
    AnsiString & TempDir);

  __property TTerminal * Terminal = { read = FTerminal };

private:
  TTerminal * FTerminal;
  TTerminalQueue * FQueue;
  TTerminalQueueStatus * FQueueStatus;
  TCriticalSection * FQueueStatusSection;
  bool FQueueStatusInvalidated;
  bool FQueueItemInvalidated;
  bool FRefreshLocalDirectory;
  bool FRefreshRemoteDirectory;
  bool FReloadDirectory;
  THandle FProgressSaveScreenHandle;
  THandle FSynchronizationSaveScreenHandle;
  TDateTime FSynchronizationStart;
  TStrings * FFileList;
  TList * FPanelItems;
  AnsiString FSavedFindFolder;
  AnsiString FLastEditFolder;
  AnsiString FLastEditFile;
  TGUICopyParamType FLastEditCopyParam;
  bool FNoProgress;
  TKeepaliveThread * FKeepaliveThread;

  void __fastcall TerminalClose(TObject * Sender);
  void __fastcall TerminalUpdateStatus(TObject * Sender);
  void __fastcall TerminalReadDirectory(TObject* Sender, bool ReloadOnly);
  void __fastcall TerminalStartReadDirectory(TObject * Sender);
  void __fastcall TerminalQueryUser(TObject * Sender,
    const AnsiString Query, TStrings * MoreMessages, int Answers,
    const TQueryParams * Params, int & Answer, TQueryType Type);
  void __fastcall TerminalPromptUser(TSecureShell * SecureShell,
    AnsiString Prompt, TPromptKind Kind, AnsiString & Response, bool & Result);
  void __fastcall TerminalShowExtendedException(TSecureShell * SecureShell,
    Exception * E);
  void __fastcall OperationProgress(
    TFileOperationProgressType & ProgressData, TCancelStatus & Cancel);
  void __fastcall OperationFinished(TFileOperation Operation,
    TOperationSide Side, bool DragDrop, const AnsiString FileName, bool Success,
    bool & DisconnectWhenComplete);
  void __fastcall CancelConfiguration(TFileOperationProgressType & ProgressData);
  TStrings * __fastcall CreateFileList(TList * PanelItems,
    TOperationSide Side, bool SelectedOnly = false, AnsiString Directory = "");
  TStrings * __fastcall CreateSelectedFileList(TOperationSide Side, 
    TFarPanelInfo * PanelInfo = NULL);
  AnsiString __fastcall FormatBytes(__int64 Bytes);
  void __fastcall CustomCommandGetParamValue(
    const AnsiString AName, AnsiString & Value);
  void __fastcall TerminalSynchronizeDirectory(const AnsiString LocalDirectory,
    const AnsiString RemoteDirectory, bool & Continue);
  void __fastcall QueueListUpdate(TTerminalQueue * Queue);
  void __fastcall QueueItemUpdate(TTerminalQueue * Queue, TQueueItem * Item);
};
//---------------------------------------------------------------------------
class TSessionPanelItem : public TCustomFarPanelItem
{
public:
  __fastcall TSessionPanelItem(TSessionData * ASessionData);
  static void __fastcall SetPanelModes(TFarPanelModes * PanelModes);
  static void __fastcall SetKeyBarTitles(TFarKeyBarTitles * KeyBarTitles);

protected:
  TSessionData * FSessionData;

  virtual void __fastcall GetData(
    unsigned long & Flags, AnsiString & FileName, __int64 & Size,
    unsigned long & FileAttributes,
    TDateTime & LastWriteTime, TDateTime & LastAccess,
    unsigned long & NumberOfLinks, AnsiString & Description,
    AnsiString & Owner, void *& UserData, int & CustomColumnNumber);
};
//---------------------------------------------------------------------------
class TRemoteFilePanelItem : public TCustomFarPanelItem
{
public:
  __fastcall TRemoteFilePanelItem(TRemoteFile * ARemoteFile);
  static void __fastcall SetPanelModes(TFarPanelModes * PanelModes);
  static void __fastcall SetKeyBarTitles(TFarKeyBarTitles * KeyBarTitles);

protected:
  TRemoteFile * FRemoteFile;

  virtual void __fastcall GetData(
    unsigned long & Flags, AnsiString & FileName, __int64 & Size,
    unsigned long & FileAttributes,
    TDateTime & LastWriteTime, TDateTime & LastAccess,
    unsigned long & NumberOfLinks, AnsiString & Description,
    AnsiString & Owner, void *& UserData, int & CustomColumnNumber);
  virtual AnsiString __fastcall CustomColumnData(int Column);
  static void __fastcall TranslateColumnTypes(AnsiString & ColumnTypes,
    TStrings * ColumnTitles);
};
//---------------------------------------------------------------------------
#endif
