//---------------------------------------------------------------------------
#ifndef FarPluginH
#define FarPluginH
//---------------------------------------------------------------------------
#include <plugin.hpp>
//---------------------------------------------------------------------------
class TCustomFarFileSystem;
class TFarPanelModes;
class TFarKeyBarTitles;
class TFarPanelInfo;
class TFarDialog;
class TFarDialogItem;
class TCriticalSection;
//---------------------------------------------------------------------------
const int MaxMessageWidth = 64;
//---------------------------------------------------------------------------
enum TFarShiftStatus { fsNone, fsCtrl, fsAlt, fsShift, fsCtrlShift,
  fsAltShift, fsCtrlAlt };
enum THandlesFunction { hfProcessKey, hfProcessHostFile, hfProcessEvent }; 
//---------------------------------------------------------------------------
enum
{
  FAR170BETA4 = MAKEFARVERSION(1, 70, 1282),
  FAR170BETA5 = MAKEFARVERSION(1, 70, 1634),
  FAR170ALPHA6 = MAKEFARVERSION(1, 70, 1812)
};
//---------------------------------------------------------------------------
const size_t StartupInfoMinSize = 372;
const size_t StandardFunctionsMinSize = 228;
//---------------------------------------------------------------------------
class TCustomFarPlugin : public TObject
{
friend TCustomFarFileSystem;
friend TFarDialog;
friend TFarDialogItem;
public:
  __fastcall TCustomFarPlugin(HWND AHandle);
  virtual __fastcall ~TCustomFarPlugin();
  virtual int __fastcall GetMinFarVersion();
  virtual void __fastcall SetStartupInfo(const struct PluginStartupInfo * Info);
  virtual void __fastcall ExitFAR();
  virtual void __fastcall GetPluginInfo(struct PluginInfo * Info);
  virtual int __fastcall Configure(int Item);
  virtual void * __fastcall OpenPlugin(int OpenFrom, int Item);
  virtual void __fastcall ClosePlugin(void * Plugin);
  virtual void __fastcall GetOpenPluginInfo(HANDLE Plugin, struct OpenPluginInfo * Info);
  virtual int __fastcall GetFindData(HANDLE Plugin,
    struct PluginPanelItem ** PanelItem, int * ItemsNumber, int OpMode);
  virtual void __fastcall FreeFindData(HANDLE Plugin, struct PluginPanelItem * PanelItem,
    int ItemsNumber);
  virtual int __fastcall ProcessHostFile(HANDLE Plugin,
    struct PluginPanelItem * PanelItem, int ItemsNumber, int OpMode);
  virtual int __fastcall ProcessKey(HANDLE Plugin, int Key, unsigned int ControlState);
  virtual int __fastcall ProcessEvent(HANDLE Plugin, int Event, void * Param);
  virtual int __fastcall SetDirectory(HANDLE Plugin, const char * Dir, int OpMode);
  virtual int __fastcall MakeDirectory(HANDLE Plugin, char * Name, int OpMode);
  virtual int __fastcall DeleteFiles(HANDLE Plugin, struct PluginPanelItem *PanelItem,
    int ItemsNumber, int OpMode);
  virtual int __fastcall GetFiles(HANDLE Plugin, struct PluginPanelItem *PanelItem,
    int ItemsNumber, int Move, char * DestPath, int OpMode);
  virtual int __fastcall PutFiles(HANDLE Plugin, struct PluginPanelItem *PanelItem,
    int ItemsNumber, int Move, int OpMode);

  virtual void __fastcall HandleException(Exception * E, int OpMode = 0);

  static char * DuplicateStr(const AnsiString Str, bool AllowEmpty = false);
  int __fastcall Message(unsigned int Flags, const AnsiString Title,
    const AnsiString Message, TStrings * Buttons = NULL);
  int __fastcall MaxMessageLines();
  int __fastcall Menu(unsigned int Flags, const AnsiString Title,
    const AnsiString Bottom, TStrings * Items, const int * BreakKeys,
    int & BreakCode);
  int __fastcall Menu(unsigned int Flags, const AnsiString Title,
    const AnsiString Bottom, TStrings * Items);
  int __fastcall Menu(unsigned int Flags, const AnsiString Title,
    const AnsiString Bottom, const FarMenuItem * Items, int Count,
    const int * BreakKeys, int & BreakCode);
  bool __fastcall InputBox(const AnsiString Title, const AnsiString Prompt,
    AnsiString & Text, unsigned long Flags, const AnsiString HistoryName = "",
    int MaxLen = 255);
  void __fastcall ShowProgress(const AnsiString Message);
  void __fastcall ClearProgress();
  AnsiString __fastcall GetMsg(int MsgId);
  void __fastcall SaveScreen(THandle & Screen);
  void __fastcall RestoreScreen(THandle & Screen);
  bool __fastcall CheckForEsc();
  bool __fastcall Viewer(const AnsiString FileName, unsigned int Flags,
    const AnsiString Title = "");

  int __fastcall FarAdvControl(int Command, void * Param);
  bool __fastcall FarControl(int Command, void * Param);
  unsigned int __fastcall FarSystemSettings();
  void __fastcall Text(int X, int Y, int Color, const AnsiString Str);
  void __fastcall FlushText();
  void __fastcall WriteConsole(const AnsiString Str);
  void __fastcall FarCopyToClipboard(const AnsiString Str);
  int __fastcall FarVersion();
  AnsiString __fastcall FormatFarVersion(int Version);
  AnsiString __fastcall TemporaryDir();

  void __fastcall ShowConsoleTitle(const AnsiString Title);
  void __fastcall ClearConsoleTitle();
  void __fastcall UpdateConsoleTitle(const AnsiString Title);
  void __fastcall UpdateConsoleTitleProgress(int Progress);
  void __fastcall ShowTerminalScreen();
  void __fastcall SaveTerminalScreen();
  void __fastcall ScrollTerminalScreen(int Rows);
  TPoint __fastcall TerminalInfo(TPoint * Size = NULL, TPoint * Cursor = NULL);

  TCustomFarFileSystem * __fastcall GetPanelFileSystem(bool Another = false);

  __property AnsiString ModuleName = { read = GetModuleName };
  __property TFarDialog * TopDialog = { read = FTopDialog };
  __property HWND Handle = { read = FHandle };
  __property TCriticalSection * CriticalSection = { read = FCriticalSection };

protected:
  PluginStartupInfo FStartupInfo;
  FarStandardFunctions FFarStandardFunctions;
  HWND FHandle;
  TObjectList * FOpenedPlugins;
  THandle FProgressSaveScreenHandle;
  TFarDialog * FTopDialog;
  HANDLE FConsoleInput;
  HANDLE FConsoleOutput;
  int FFarVersion;
  bool FTerminalScreenShowing;
  TCriticalSection * FCriticalSection;
  bool FOldFar;
  bool FValidFarSystemSettings;
  unsigned int FFarSystemSettings;

  virtual bool __fastcall HandlesFunction(THandlesFunction Function);
  virtual void __fastcall GetPluginInfoEx(long unsigned & Flags,
    TStrings * DiskMenuStrings, TStrings * PluginMenuStrings,
    TStrings * PluginConfigStrings, TStrings * CommandPrefixes) = 0;
  virtual TCustomFarFileSystem * __fastcall OpenPluginEx(int OpenFrom, int Item) = 0;
  virtual bool __fastcall ConfigureEx(int Item) = 0;
  virtual void __fastcall HandleFileSystemException(TCustomFarFileSystem * FileSystem, 
    Exception * E, int OpMode = 0);
  virtual bool __fastcall IsOldFar();
  virtual void __fastcall OldFar();
  void __fastcall ResetCachedInfo();

private:
  PluginInfo FPluginInfo;
  TStringList * FSavedTitles;
  AnsiString FCurrentTitle;
  int FCurrentProgress;

  void __fastcall ClearPluginInfo(PluginInfo & Info);
  AnsiString __fastcall GetModuleName();
  void __fastcall UpdateConsoleTitle();
};
//---------------------------------------------------------------------------
class TCustomFarFileSystem : public TObject
{
friend TFarPanelInfo;
friend TCustomFarPlugin;
public:
  __fastcall TCustomFarFileSystem(TCustomFarPlugin * APlugin);
  virtual __fastcall ~TCustomFarFileSystem();
  void __fastcall GetOpenPluginInfo(struct OpenPluginInfo * Info);
  int __fastcall GetFindData(struct PluginPanelItem ** PanelItem,
    int * ItemsNumber, int OpMode);
  void __fastcall FreeFindData(struct PluginPanelItem * PanelItem, int ItemsNumber);
  int __fastcall ProcessHostFile(struct PluginPanelItem * PanelItem,
    int ItemsNumber, int OpMode);
  int __fastcall ProcessKey(int Key, unsigned int ControlState);
  int __fastcall ProcessEvent(int Event, void * Param);
  int __fastcall SetDirectory(const char * Dir, int OpMode);
  int __fastcall MakeDirectory(char * Name, int OpMode);
  int __fastcall DeleteFiles(struct PluginPanelItem * PanelItem, 
    int ItemsNumber, int OpMode);
  int __fastcall GetFiles(struct PluginPanelItem *PanelItem,
    int ItemsNumber, int Move, char * DestPath, int OpMode);
  int __fastcall PutFiles(struct PluginPanelItem *PanelItem,
    int ItemsNumber, int Move, int OpMode);
  virtual void __fastcall Close();

protected:
  TCustomFarPlugin * FPlugin;
  bool FClosed;

  virtual void __fastcall GetOpenPluginInfoEx(long unsigned & Flags,
    AnsiString & HostFile, AnsiString & CurDir, AnsiString & Format,
    AnsiString & PanelTitle, TFarPanelModes * PanelModes, int & StartPanelMode,
    int & StartSortMode, bool & StartSortOrder, TFarKeyBarTitles * KeyBarTitles,
    AnsiString & ShortcutData) = 0;
  virtual bool __fastcall GetFindDataEx(TList * PanelItems, int OpMode) = 0;
  virtual bool __fastcall ProcessHostFileEx(TList * PanelItems, int OpMode);
  virtual bool __fastcall ProcessKeyEx(int Key, unsigned int ControlState);
  virtual bool __fastcall ProcessEventEx(int Event, void * Param);
  virtual bool __fastcall SetDirectoryEx(const AnsiString Dir, int OpMode);
  virtual int __fastcall MakeDirectoryEx(AnsiString & Name, int OpMode);
  virtual bool __fastcall DeleteFilesEx(TList * PanelItems, int OpMode);
  virtual int __fastcall GetFilesEx(TList * PanelItems, bool Move,
    AnsiString & DestPath, int OpMode);
  virtual int __fastcall PutFilesEx(TList * PanelItems, bool Move, int OpMode);

  void __fastcall ResetCachedInfo();
  bool __fastcall FarControl(int Command, void * Param);
  bool __fastcall UpdatePanel(bool ClearSelection = false, bool Another = false);
  void __fastcall RedrawPanel(bool Another = false);
  void __fastcall ClosePlugin();
  AnsiString __fastcall GetMsg(int MsgId);

  virtual void __fastcall HandleException(Exception * E, int OpMode = 0);

  __property TFarPanelInfo * PanelInfo = { read = GetPanelInfo, index = 0 };
  __property TFarPanelInfo * AnotherPanelInfo = { read = GetPanelInfo, index = 1 };
  __property TCriticalSection * CriticalSection = { read = FCriticalSection };

protected:
  TCriticalSection * FCriticalSection;

private:
  OpenPluginInfo FOpenPluginInfo;
  TFarPanelInfo * FPanelInfo[2];
  static unsigned int FInstances;

  void __fastcall ClearOpenPluginInfo(OpenPluginInfo & Info);
  TList * __fastcall CreatePanelItemList(struct PluginPanelItem * PanelItem,
    int ItemsNumber);
  TFarPanelInfo * __fastcall GetPanelInfo(int Another);
};
//---------------------------------------------------------------------------
#define PANEL_MODES_COUNT 10
class TFarPanelModes : public TObject
{
friend class TCustomFarFileSystem;
public:
  void __fastcall SetPanelMode(int Mode, const AnsiString ColumnTypes = "",
    const AnsiString ColumnWidths = "", TStrings * ColumnTitles = NULL,
    bool FullScreen = false, bool DetailedStatus = true, bool AlignExtensions = true,
    bool CaseConversion = true, const AnsiString StatusColumnTypes = "",
    const AnsiString StatusColumnWidths = "");

private:
  PanelMode FPanelModes[PANEL_MODES_COUNT];
  bool FReferenced;

  __fastcall TFarPanelModes();
  virtual __fastcall ~TFarPanelModes();

  void __fastcall FillOpenPluginInfo(struct OpenPluginInfo * Info);
  static void __fastcall ClearPanelMode(PanelMode & Mode);
  static int __fastcall CommaCount(const AnsiString ColumnTypes);
};
//---------------------------------------------------------------------------
class TFarKeyBarTitles : public TObject
{
friend class TCustomFarFileSystem;
public:
  void __fastcall ClearFileKeyBarTitles();
  void __fastcall ClearKeyBarTitle(TFarShiftStatus ShiftStatus,
    int FunctionKeyStart, int FunctionKeyEnd = 0);
  void __fastcall SetKeyBarTitle(TFarShiftStatus ShiftStatus, int FunctionKey,
    const AnsiString Title);

private:
  KeyBarTitles FKeyBarTitles;
  bool FReferenced;

  __fastcall TFarKeyBarTitles();
  virtual __fastcall ~TFarKeyBarTitles();
  
  void __fastcall FillOpenPluginInfo(struct OpenPluginInfo * Info);
  static void __fastcall ClearKeyBarTitles(KeyBarTitles & Titles);
};
//---------------------------------------------------------------------------
class TCustomFarPanelItem : TObject
{
friend class TCustomFarFileSystem;
public:

protected:
  virtual void __fastcall GetData(
    unsigned long & Flags, AnsiString & FileName, __int64 & Size,
    unsigned long & FileAttributes,
    TDateTime & LastWriteTime, TDateTime & LastAccess,
    unsigned long & NumberOfLinks, AnsiString & Description,
    AnsiString & Owner, void *& UserData, int & CustomColumnNumber) = 0;
  virtual AnsiString __fastcall CustomColumnData(int Column);

  void __fastcall FillPanelItem(struct PluginPanelItem * PanelItem);
};
//---------------------------------------------------------------------------
class TFarPanelItem : TCustomFarPanelItem
{
public:
  __fastcall TFarPanelItem(PluginPanelItem * APanelItem);
  __property unsigned long Flags = { read = GetFlags };
  __property unsigned long FileAttributes = { read = GetFileAttributes };
  __property AnsiString FileName = { read = GetFileName };
  __property void * UserData = { read = GetUserData };
  __property bool Selected = { read = GetSelected, write = SetSelected };
  __property bool IsParentDirectory = { read = GetIsParentDirectory };
  __property bool IsFile = { read = GetIsFile };

protected:
  PluginPanelItem * FPanelItem;

  virtual void __fastcall GetData(
    unsigned long & Flags, AnsiString & FileName, __int64 & Size,
    unsigned long & FileAttributes,
    TDateTime & LastWriteTime, TDateTime & LastAccess,
    unsigned long & NumberOfLinks, AnsiString & Description,
    AnsiString & Owner, void *& UserData, int & CustomColumnNumber);
  virtual AnsiString __fastcall CustomColumnData(int Column);

private:
  unsigned long __fastcall GetFlags();
  AnsiString __fastcall GetFileName();
  void * __fastcall GetUserData();
  bool __fastcall GetSelected();
  void __fastcall SetSelected(bool value);
  bool __fastcall GetIsParentDirectory();
  bool __fastcall GetIsFile();
  unsigned long __fastcall GetFileAttributes();
};
//---------------------------------------------------------------------------
class THintPanelItem : public TCustomFarPanelItem
{
public:
  __fastcall THintPanelItem(const AnsiString AHint);

protected:
  virtual void __fastcall GetData(
    unsigned long & Flags, AnsiString & FileName, __int64 & Size,
    unsigned long & FileAttributes,
    TDateTime & LastWriteTime, TDateTime & LastAccess,
    unsigned long & NumberOfLinks, AnsiString & Description,
    AnsiString & Owner, void *& UserData, int & CustomColumnNumber);
    
private:
  AnsiString FHint;
};
//---------------------------------------------------------------------------
enum TFarPanelType { ptFile, ptTree, ptQuickView, ptInfo };
//---------------------------------------------------------------------------
class TFarPanelInfo : public TObject
{
public:
  __fastcall TFarPanelInfo(PanelInfo * APanelInfo, TCustomFarFileSystem * AOwner);
  virtual __fastcall ~TFarPanelInfo();

  __property TList * Items = { read = GetItems };
  __property int ItemCount = { read = GetItemCount };
  __property int SelectedCount = { read = GetSelectedCount };
  __property TFarPanelItem * FocusedItem = { read = GetFocusedItem, write = SetFocusedItem };
  __property int FocusedIndex = { read = GetFocusedIndex, write = SetFocusedIndex };
  __property TRect Bounds = { read = GetBounds };
  __property TFarPanelType Type = { read = GetType };
  __property bool IsPlugin = { read = GetIsPlugin };
  __property AnsiString CurrentDirectory = { read = GetCurrentDirectory };

  void __fastcall ApplySelection();
  int __fastcall IndexOfFileName(const AnsiString FileName);

private:
  PanelInfo * FPanelInfo;
  TList * FItems;
  TCustomFarFileSystem * FOwner;

  TList * __fastcall GetItems();
  TFarPanelItem * __fastcall GetFocusedItem();
  void __fastcall SetFocusedItem(TFarPanelItem * value);
  int __fastcall GetFocusedIndex();
  void __fastcall SetFocusedIndex(int value);
  int __fastcall GetItemCount();
  int __fastcall GetSelectedCount();
  TRect __fastcall GetBounds();
  TFarPanelType __fastcall GetType();
  bool __fastcall GetIsPlugin();
  AnsiString __fastcall GetCurrentDirectory();
};
//---------------------------------------------------------------------------
class TFarMenuItems : public TStringList
{
public:
  __fastcall TFarMenuItems();
  void __fastcall AddSeparator();

  virtual void __fastcall Clear();
  virtual void __fastcall Delete(int Index);

  __property int ItemFocused = { read = FItemFocused, write = SetItemFocused };

  __property bool Disabled[int Index] = { read = GetFlag, write = SetFlag, index = MIF_DISABLE };
  __property bool Checked[int Index] = { read = GetFlag, write = SetFlag, index = MIF_CHECKED };

protected:
  virtual void __fastcall PutObject(int Index, TObject * AObject);

private:
  int FItemFocused;

  void __fastcall SetItemFocused(int value);
  void __fastcall SetFlag(int Index, int Flag, bool Value);
  bool __fastcall GetFlag(int Index, int Flag);
};
//---------------------------------------------------------------------------
extern TCustomFarPlugin * FarPlugin;
//---------------------------------------------------------------------------
#endif

