//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include <windows.h>
#include <Common.h>
#include "FarPlugin.h"
#include "FarConfiguration.h"
//---------------------------------------------------------------------------
#pragma argsused
//---------------------------------------------------------------------------
#define DLLEXPORT __declspec(dllexport)
//---------------------------------------------------------------------------
TCustomFarPlugin * __fastcall CreateFarPlugin(HWND Handle);
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI GetMinFarVersion(void)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->GetMinFarVersion();
}
//---------------------------------------------------------------------------
DLLEXPORT void WINAPI SetStartupInfo(const struct PluginStartupInfo * Info)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->SetStartupInfo(Info);
}
//---------------------------------------------------------------------------
DLLEXPORT void WINAPI ExitFAR()
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->ExitFAR();
}
//---------------------------------------------------------------------------
DLLEXPORT void WINAPI GetPluginInfo(struct PluginInfo * Info)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->GetPluginInfo(Info);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI Configure(int Item)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->Configure(Item);
}
//---------------------------------------------------------------------------
DLLEXPORT HANDLE WINAPI OpenPlugin(int OpenFrom, int Item)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->OpenPlugin(OpenFrom, Item);
}
//---------------------------------------------------------------------------
DLLEXPORT void WINAPI ClosePlugin(HANDLE Plugin)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->ClosePlugin(Plugin);
}
//---------------------------------------------------------------------------
DLLEXPORT void WINAPI GetOpenPluginInfo(HANDLE Plugin, struct OpenPluginInfo * Info)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->GetOpenPluginInfo(Plugin, Info);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI GetFindData(HANDLE Plugin,
  struct PluginPanelItem ** PanelItem, int * ItemsNumber, int OpMode)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->GetFindData(Plugin, PanelItem, ItemsNumber, OpMode);
}
//---------------------------------------------------------------------------
DLLEXPORT void WINAPI FreeFindData(HANDLE Plugin, struct PluginPanelItem * PanelItem,
  int ItemsNumber)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->FreeFindData(Plugin, PanelItem, ItemsNumber);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI ProcessHostFile(HANDLE Plugin,
  struct PluginPanelItem * PanelItem, int ItemsNumber, int OpMode)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->ProcessHostFile(Plugin, PanelItem, ItemsNumber, OpMode);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI ProcessKey(HANDLE Plugin, int Key, unsigned int ControlState)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->ProcessKey(Plugin, Key, ControlState);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI ProcessEvent(HANDLE Plugin, int Event, void * Param)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->ProcessEvent(Plugin, Event, Param);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI SetDirectory(HANDLE Plugin, const char * Dir,
  int OpMode)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->SetDirectory(Plugin, Dir, OpMode);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI MakeDirectory(HANDLE Plugin, char * Name, int OpMode)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->MakeDirectory(Plugin, Name, OpMode);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI DeleteFiles(HANDLE Plugin, struct PluginPanelItem *PanelItem,
  int ItemsNumber, int OpMode)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->DeleteFiles(Plugin, PanelItem, ItemsNumber, OpMode);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI GetFiles(HANDLE Plugin, struct PluginPanelItem *PanelItem,
  int ItemsNumber, int Move, char * DestPath, int OpMode)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->GetFiles(Plugin, PanelItem, ItemsNumber,
    Move, DestPath, OpMode);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI PutFiles(HANDLE Plugin, struct PluginPanelItem * PanelItem,
  int ItemsNumber, int Move, int OpMode)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->PutFiles(Plugin, PanelItem, ItemsNumber,
    Move, OpMode);
}
//---------------------------------------------------------------------------
DLLEXPORT int WINAPI ProcessEditorEvent(int Event, void * Param)
{
  assert(FarPlugin);
  TGuard Guard(FarPlugin->CriticalSection);
  return FarPlugin->ProcessEditorEvent(Event, Param);
}
//---------------------------------------------------------------------------
#ifdef _DEBUG
// On FAR 1.70 alpha 6 and later, some spare user breakpoints in NTDLL are
// triggered. This hack prevents that.
// See topic "ntdll.DbgUserBreakPoint problem" in borland.public.cppbuilder.ide
// http://groups.google.com/group/borland.public.cppbuilder.ide
void __fastcall PatchInt3()
{
  if (Win32Platform != VER_PLATFORM_WIN32_NT)
  {
    return;
  }

  HMODULE NtDll = GetModuleHandle("NTDLL.DLL");
  if (NtDll == NULL)
  {
    return;
  }

  FARPROC P = GetProcAddress(NtDll, "DbgBreakPoint");
  if (P == NULL)
  {
    return;
  }

  try
  {
    unsigned char OP;
    if (ReadProcessMemory(GetCurrentProcess(), P, &OP, sizeof(OP), NULL))
    {
      if (OP != 0xCC)
      {
        return;
      }

      DWORD BytesWritten;
      OP = 90; // NOP

      if (WriteProcessMemory(GetCurrentProcess(), P, &OP, sizeof(OP), &BytesWritten))
      {
        if (BytesWritten == sizeof(OP))
        {
          FlushInstructionCache(GetCurrentProcess(), P, sizeof(OP));
        }
      }
    }
  }
  catch(...)
  {
    // an exception may be raised here but don't worry about it
  }
}
#endif
//---------------------------------------------------------------------------
int WINAPI DllEntryPoint(HINSTANCE HInst, unsigned long Reason, void * /*Reserved*/)
{
  static int Processes = 0;

  switch (Reason)
  {
    case DLL_PROCESS_ATTACH:
      #ifdef _DEBUG
      PatchInt3();
      #endif

      FarPlugin = CreateFarPlugin(HInst);

      assert(!Processes);
      Processes++;

      if (ThousandSeparator == '\xA0')
      {
        ThousandSeparator = ' ';
      }
      break;

    case DLL_PROCESS_DETACH:
      assert(Processes);
      Processes--;
      if (!Processes)
      {
        assert(FarPlugin);
        SAFE_DESTROY(FarPlugin);
      }
      break;
  }
  return true;
}
//---------------------------------------------------------------------------



