//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include <math.h>
#include "WinSCPPlugin.h"
#include "WinSCPFileSystem.h"
#include "FarTexts.h"
#include "FarDialog.h"
#include "FarConfiguration.h"
#include <GUITools.h>
#include <ScpMain.h>
#include <Common.h>
#include <CopyParam.h>
#include <TextsCore.h>
#include <Terminal.h>
#include <Bookmarks.h>
#include <Queue.h>
#include <farkeys.hpp>
#include <farcolor.hpp>
// FAR WORKAROUND
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
enum TButtonResult { brCancel = -1, brOK = 1, brConnect };
//---------------------------------------------------------------------------
class TWinSCPDialog : public TFarDialog
{
public:
  __fastcall TWinSCPDialog(TCustomFarPlugin * AFarPlugin);

  void __fastcall AddStandardButtons(int Shift = 0, bool ButtonsOnly = false);

  TFarSeparator * ButtonSeparator;
  TFarButton * OkButton;
  TFarButton * CancelButton;
};
//---------------------------------------------------------------------------
__fastcall TWinSCPDialog::TWinSCPDialog(TCustomFarPlugin * AFarPlugin) : 
  TFarDialog(AFarPlugin)
{
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPDialog::AddStandardButtons(int Shift, bool ButtonsOnly)
{
  if (!ButtonsOnly)
  {
    NextItemPosition = ipNewLine;

    ButtonSeparator = new TFarSeparator(this);
    if (Shift >= 0)
    {
      ButtonSeparator->Move(0, Shift);
    }
    else
    {
      ButtonSeparator->Top = Shift;
      ButtonSeparator->Bottom = Shift;
    }
  }

  assert(OkButton == NULL);
  OkButton = new TFarButton(this);
  if (ButtonsOnly)
  {
    if (Shift >= 0)
    {
      OkButton->Move(0, Shift);
    }
    else
    {
      OkButton->Top = Shift;
      OkButton->Bottom = Shift;
    }
  }
  OkButton->Caption = GetMsg(MSG_BUTTON_OK);
  OkButton->Default = true;
  OkButton->Result = brOK;
  OkButton->CenterGroup = true;

  NextItemPosition = ipRight;

  assert(CancelButton == NULL);
  CancelButton = new TFarButton(this);
  CancelButton->Caption = GetMsg(MSG_BUTTON_Cancel);
  CancelButton->Result = brCancel;
  CancelButton->CenterGroup = true;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TTabbedDialog : public TWinSCPDialog
{
friend class TTabButton;

public:
  __fastcall TTabbedDialog(TCustomFarPlugin * AFarPlugin, int TabCount);
  
protected:  
  void __fastcall HideTabs();
  virtual void __fastcall SelectTab(int Tab);
  void __fastcall TabButtonClick(TFarButton * Sender, bool & Close);
  virtual bool __fastcall Key(TFarDialogItem * Item, long KeyCode);
  virtual AnsiString __fastcall TabName(int Tab);
  TTabButton * __fastcall TabButton(int Tab);

private:
  AnsiString FOrigCaption;
  int FTab;
  int FTabCount;
};
//---------------------------------------------------------------------------
class TTabButton : public TFarButton
{
public:
  __fastcall TTabButton(TTabbedDialog * Dialog);

  __property int Tab = { read = FTab, write = FTab };
  __property AnsiString TabName = { read = FTabName, write = SetTabName };

private:
  AnsiString FTabName;
  int FTab;

  void __fastcall SetTabName(AnsiString value);  
};
//---------------------------------------------------------------------------
__fastcall TTabbedDialog::TTabbedDialog(TCustomFarPlugin * AFarPlugin, int TabCount) :
  TWinSCPDialog(AFarPlugin)
{
  FTab = 0;
  FTabCount = TabCount;

  // FAR WORKAROUND
  // (to avoid first control on dialog be a button, that would be "pressed"
  // when listbox loses focus)
  TFarText * Text = new TFarText(this);
  // make next item be inserted to default position
  Text->Move(0, -1);
  // on FAR 1.70 alpha 6 and later, empty text control would overwrite the
  // dialog box caption
  Text->Visible = false;
}
//---------------------------------------------------------------------------
void __fastcall TTabbedDialog::HideTabs()
{
  for (int i = 0; i < ItemCount; i++)
  {
    TFarDialogItem * I = Item[i];
    if (I->Group)
    {
      I->Visible = false;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TTabbedDialog::SelectTab(int Tab)
{
  if (FTab != Tab)
  {
    if (FTab)
    {
      ShowGroup(FTab, false);
    }
    ShowGroup(Tab, true);
    FTab = Tab;
  }

  for (int i = 0; i < ItemCount; i++)
  {
    TFarDialogItem * I = Item[i];
    if ((I->Group == Tab) && I->CanFocus())
    {
      I->SetFocus();
      break;
    }
  }

  if (FOrigCaption.IsEmpty())
  {
    FOrigCaption = Caption;
  }
  Caption = FORMAT("%s - %s", (TabName(Tab), FOrigCaption));
}
//---------------------------------------------------------------------------
TTabButton * __fastcall TTabbedDialog::TabButton(int Tab)
{
  TTabButton * Result = NULL;
  for (int i = 0; i < ItemCount; i++)
  {
    TTabButton * T = dynamic_cast<TTabButton*>(Item[i]);
    if ((T != NULL) && (T->Tab == Tab))
    {
      Result = T;
      break;
    }
  }

  assert(Result != NULL);
  
  return Result;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TTabbedDialog::TabName(int Tab)
{
  return TabButton(Tab)->TabName;
}
//---------------------------------------------------------------------------
void __fastcall TTabbedDialog::TabButtonClick(TFarButton * Sender, bool & Close)
{
  TTabButton * Tab = dynamic_cast<TTabButton*>(Sender);
  assert(Tab != NULL);

  SelectTab(Tab->Tab);

  Close = false;
}
//---------------------------------------------------------------------------
bool __fastcall TTabbedDialog::Key(TFarDialogItem * /*Item*/, long KeyCode)
{
  bool Result = false;
  if (KeyCode == KEY_CTRLPGDN || KeyCode == KEY_CTRLPGUP)
  {
    int NewTab = FTab;
    do
    {
      if (KeyCode == KEY_CTRLPGDN)
      {
        NewTab = NewTab == FTabCount - 1 ? 1 : NewTab + 1;
      }
      else
      {
        NewTab = NewTab == 1 ? FTabCount - 1 : NewTab - 1;
      }
    }
    while (!TabButton(NewTab)->Enabled);
    SelectTab(NewTab);
    Result = true;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall TTabButton::TTabButton(TTabbedDialog * Dialog) :
  TFarButton(Dialog)
{
  CenterGroup = true;
  OnClick = Dialog->TabButtonClick;
}
//---------------------------------------------------------------------------
void __fastcall TTabButton::SetTabName(AnsiString value)
{
  if (FTabName != value)
  {
    AnsiString C;
    int P = value.Pos("|");
    if (P > 0)
    {
      C = value.SubString(1, P - 1);
      value.Delete(1, P);
    }
    else
    {
      C = value;
    }
    Caption = C;
    FTabName = StripHotKey(value);
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::ConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    TFarText * Text;

    Dialog->Size = TPoint(67, 23);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_INTERFACE))));

    TFarCheckBox * DisksMenuCheck = new TFarCheckBox(Dialog);
    DisksMenuCheck->Caption = GetMsg(CONFIG_DISKS_MENU);

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->Caption = GetMsg(CONFIG_HOTKEY_LABEL);
    Text->EnabledDependency = DisksMenuCheck;

    Dialog->NextItemPosition = ipRight;

    TFarRadioButton * AutoHotKeyButton = new TFarRadioButton(Dialog);
    AutoHotKeyButton->Caption = GetMsg(CONFIG_HOTKEY_AUTOASSIGN);
    AutoHotKeyButton->EnabledDependency = DisksMenuCheck;

    TFarRadioButton * ManualHotKeyButton = new TFarRadioButton(Dialog);
    ManualHotKeyButton->Caption = GetMsg(CONFIG_HOTKEY_MANUAL);
    ManualHotKeyButton->EnabledDependency = DisksMenuCheck;

    TFarEdit * HotKeyEdit = new TFarEdit(Dialog);
    HotKeyEdit->Width = 1;
    HotKeyEdit->Fixed = true;
    HotKeyEdit->Mask = "9";
    HotKeyEdit->EnabledDependency = ManualHotKeyButton;

    Text = new TFarText(Dialog);
    Text->Caption = "(1 - 9)";
    Text->EnabledDependency = ManualHotKeyButton;

    Dialog->NextItemPosition = ipNewLine;

    TFarCheckBox * PluginsMenuCheck = new TFarCheckBox(Dialog);
    PluginsMenuCheck->Caption = GetMsg(CONFIG_PLUGINS_MENU);

    TFarCheckBox * PluginsMenuCommandsCheck = new TFarCheckBox(Dialog);
    PluginsMenuCommandsCheck->Caption = GetMsg(CONFIG_PLUGINS_MENU_COMMANDS);

    TFarCheckBox * HostNameInTitleCheck = new TFarCheckBox(Dialog);
    HostNameInTitleCheck->Caption = GetMsg(CONFIG_HOST_NAME_IN_TITLE);

    new TFarSeparator(Dialog);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(CONFIG_COMAND_PREFIXES);

    TFarEdit * CommandPrefixesEdit = new TFarEdit(Dialog);

    new TFarSeparator(Dialog);

    TFarCheckBox * CustomPanelCheck = new TFarCheckBox(Dialog);
    CustomPanelCheck->Caption = GetMsg(CONFIG_PANEL_MODE_CHECK);

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_TYPES);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelTypesEdit = new TFarEdit(Dialog);
    CustomPanelTypesEdit->EnabledDependency = CustomPanelCheck;
    CustomPanelTypesEdit->Width = CustomPanelTypesEdit->Width / 2 - 1;

    Dialog->NextItemPosition = ipRight;

    Text = new TFarText(Dialog);
    Text->EnabledDependency = CustomPanelCheck;
    Text->Move(0, -1);
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_STATUS_TYPES);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelStatusTypesEdit = new TFarEdit(Dialog);
    CustomPanelStatusTypesEdit->EnabledDependency = CustomPanelCheck;

    Dialog->NextItemPosition = ipNewLine;

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_WIDTHS);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelWidthsEdit = new TFarEdit(Dialog);
    CustomPanelWidthsEdit->EnabledDependency = CustomPanelCheck;
    CustomPanelWidthsEdit->Width = CustomPanelTypesEdit->Width;

    Dialog->NextItemPosition = ipRight;

    Text = new TFarText(Dialog);
    Text->EnabledDependency = CustomPanelCheck;
    Text->Move(0, -1);
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_STATUS_WIDTHS);

    Dialog->NextItemPosition = ipBelow;

    TFarEdit * CustomPanelStatusWidthsEdit = new TFarEdit(Dialog);
    CustomPanelStatusWidthsEdit->EnabledDependency = CustomPanelCheck;

    Dialog->NextItemPosition = ipNewLine;

    TFarCheckBox * CustomPanelFullScreenCheck = new TFarCheckBox(Dialog);
    CustomPanelFullScreenCheck->Left += 4;
    CustomPanelFullScreenCheck->EnabledDependency = CustomPanelCheck;
    CustomPanelFullScreenCheck->Caption = GetMsg(CONFIG_PANEL_MODE_FULL_SCREEN);

    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_HINT);
    Text = new TFarText(Dialog);
    Text->Left += 4;
    Text->EnabledDependency = CustomPanelCheck;
    Text->Caption = GetMsg(CONFIG_PANEL_MODE_HINT2);

    Dialog->AddStandardButtons();

    DisksMenuCheck->Checked = FarConfiguration->DisksMenu;
    AutoHotKeyButton->Checked = !FarConfiguration->DisksMenuHotKey;
    ManualHotKeyButton->Checked = FarConfiguration->DisksMenuHotKey;
    HotKeyEdit->Text = FarConfiguration->DisksMenuHotKey ?
      IntToStr(FarConfiguration->DisksMenuHotKey) : AnsiString();
    PluginsMenuCheck->Checked = FarConfiguration->PluginsMenu;
    PluginsMenuCommandsCheck->Checked = FarConfiguration->PluginsMenuCommands;
    HostNameInTitleCheck->Checked = FarConfiguration->HostNameInTitle;
    CommandPrefixesEdit->Text = FarConfiguration->CommandPrefixes;

    CustomPanelCheck->Checked = FarConfiguration->CustomPanelModeDetailed;
    CustomPanelTypesEdit->Text = FarConfiguration->ColumnTypesDetailed;
    CustomPanelWidthsEdit->Text = FarConfiguration->ColumnWidthsDetailed;
    CustomPanelStatusTypesEdit->Text = FarConfiguration->StatusColumnTypesDetailed;
    CustomPanelStatusWidthsEdit->Text = FarConfiguration->StatusColumnWidthsDetailed;
    CustomPanelFullScreenCheck->Checked = FarConfiguration->FullScreenDetailed;

    Result = (Dialog->ShowModal() == brOK);
    if (Result)
    {
      FarConfiguration->DisksMenu = DisksMenuCheck->Checked;
      FarConfiguration->DisksMenuHotKey =
        ManualHotKeyButton->Checked && !HotKeyEdit->IsEmpty ?
          StrToInt(HotKeyEdit->Text) : 0;
      FarConfiguration->PluginsMenu = PluginsMenuCheck->Checked;
      FarConfiguration->PluginsMenuCommands = PluginsMenuCommandsCheck->Checked;
      FarConfiguration->HostNameInTitle = HostNameInTitleCheck->Checked;

      FarConfiguration->CommandPrefixes = CommandPrefixesEdit->Text;

      FarConfiguration->CustomPanelModeDetailed = CustomPanelCheck->Checked;
      FarConfiguration->ColumnTypesDetailed = CustomPanelTypesEdit->Text;
      FarConfiguration->ColumnWidthsDetailed = CustomPanelWidthsEdit->Text;
      FarConfiguration->StatusColumnTypesDetailed = CustomPanelStatusTypesEdit->Text;
      FarConfiguration->StatusColumnWidthsDetailed = CustomPanelStatusWidthsEdit->Text;
      FarConfiguration->FullScreenDetailed = CustomPanelFullScreenCheck->Checked;
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::PanelConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    Dialog->Size = TPoint(65, 7);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_PANEL))));

    TFarCheckBox * AutoReadDirectoryAfterOpCheck = new TFarCheckBox(Dialog);
    AutoReadDirectoryAfterOpCheck->Caption = GetMsg(CONFIG_AUTO_READ_DIRECTORY_AFTER_OP);

    Dialog->AddStandardButtons();

    AutoReadDirectoryAfterOpCheck->Checked = Configuration->AutoReadDirectoryAfterOp;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Configuration->BeginUpdate();
      try
      {
        Configuration->AutoReadDirectoryAfterOp = AutoReadDirectoryAfterOpCheck->Checked;
      }
      __finally
      {
        Configuration->EndUpdate();
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::LoggingConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    TFarSeparator * Separator;
    TFarText * Text;

    Dialog->Size = TPoint(65, 13);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_LOGGING))));

    TFarCheckBox * LoggingCheck = new TFarCheckBox(Dialog);
    LoggingCheck->Caption = GetMsg(LOGGING_ENABLE);

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(LOGGING_OPTIONS_GROUP);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(LOGGING_LOG_PROTOCOL);
    Text->EnabledDependency = LoggingCheck;

    Dialog->NextItemPosition = ipRight;

    TFarComboBox * LogProtocolCombo = new TFarComboBox(Dialog);
    LogProtocolCombo->DropDownList = true;
    LogProtocolCombo->Width = 10;
    for (int i = 0; i <= 2; i++)
    {
      LogProtocolCombo->Items->Add(GetMsg(LOGGING_LOG_PROTOCOL_0 + i));
    }
    LogProtocolCombo->EnabledDependency = LoggingCheck;

    Dialog->NextItemPosition = ipNewLine;

    new TFarSeparator(Dialog);

    TFarCheckBox * LogToFileCheck = new TFarCheckBox(Dialog);
    LogToFileCheck->Caption = GetMsg(LOGGING_LOG_TO_FILE);
    LogToFileCheck->EnabledDependency = LoggingCheck;

    TFarEdit * LogFileNameEdit = new TFarEdit(Dialog);
    LogFileNameEdit->Left += 4;
    LogFileNameEdit->History = LOG_FILE_HISTORY;
    LogFileNameEdit->EnabledDependency = LogToFileCheck;

    TFarRadioButton * LogFileAppendButton = new TFarRadioButton(Dialog);
    LogFileAppendButton->Left += 4;
    LogFileAppendButton->Caption = GetMsg(LOGGING_LOG_FILE_APPEND);
    LogFileAppendButton->EnabledDependency = LogToFileCheck;

    Dialog->NextItemPosition = ipRight;

    TFarRadioButton * LogFileOverwriteButton = new TFarRadioButton(Dialog);
    LogFileOverwriteButton->Caption = GetMsg(LOGGING_LOG_FILE_OVERWRITE);
    LogFileOverwriteButton->EnabledDependency = LogToFileCheck;

    /*Dialog->NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(LOGGING_LOG_VIEW_GROUP);

    TFarRadioButton * LogWindowCompleteButton = new TFarRadioButton(Dialog);
    LogWindowCompleteButton->Caption = GetMsg(LOGGING_LOG_VIEW_COMPLETE);
    LogWindowCompleteButton->EnabledDependency = LoggingCheck;

    TFarRadioButton * LogWindowLinesButton = new TFarRadioButton(Dialog);
    LogWindowLinesButton->Caption = GetMsg(LOGGING_LOG_VIEW_LINES);
    LogWindowLinesButton->EnabledDependency = LoggingCheck;

    Dialog->NextItemPosition = ipRight;

    TFarEdit * LogWindowLinesEdit = new TFarEdit(Dialog);
    LogWindowLinesEdit->Fixed = true;
    LogWindowLinesEdit->Mask = "9999";
    LogWindowLinesEdit->Width = 7;
    LogWindowLinesEdit->EnabledDependency = LogWindowLinesButton;

    TFarText * Text = new TFarText(Dialog);
    Text->Caption = GetMsg(LOGGING_LOG_VIEW_LINES2);
    Text->EnabledDependency = LoggingCheck;
    */
    Dialog->AddStandardButtons();

    LoggingCheck->Checked = Configuration->Logging;
    LogProtocolCombo->Items->Selected = Configuration->LogProtocol;
    LogToFileCheck->Checked = Configuration->LogToFile;
    LogFileNameEdit->Text =
      (!Configuration->LogToFile && Configuration->LogFileName.IsEmpty()) ?
      IncludeTrailingBackslash(SystemTemporaryDirectory()) + "&s.log" :
      Configuration->LogFileName;
    LogFileAppendButton->Checked = Configuration->LogFileAppend;
    LogFileOverwriteButton->Checked = !Configuration->LogFileAppend;
    /*LogWindowCompleteButton->Checked = Configuration->LogWindowComplete;
    LogWindowLinesButton->Checked = !Configuration->LogWindowComplete;
    LogWindowLinesEdit->AsInteger = !Configuration->LogWindowComplete ?
      Configuration->LogWindowLines : 500;*/

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Configuration->BeginUpdate();
      try
      {
        Configuration->Logging = LoggingCheck->Checked;
        Configuration->LogProtocol = LogProtocolCombo->Items->Selected;
        Configuration->LogToFile = LogToFileCheck->Checked;
        if (LogToFileCheck->Checked)
        {
          Configuration->LogFileName = LogFileNameEdit->Text;
        }
        Configuration->LogFileAppend = LogFileAppendButton->Checked;
        /*Configuration->LogWindowComplete = LogWindowCompleteButton->Checked;
        if (!LogWindowCompleteButton->Checked)
        {
          Configuration->LogWindowLines = LogWindowLinesEdit->AsInteger;
        } */
      }
      __finally
      {
        Configuration->EndUpdate();
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::TransferConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    TFarSeparator * Separator;
    TFarText * Text;

    Dialog->Size = TPoint(76, 19);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_TRANSFER))));

    TFarCheckBox * CalculateSizeCheck = new TFarCheckBox(Dialog);
    CalculateSizeCheck->Caption = GetMsg(TRANSFER_CALCULATE_SIZE);

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(TRANSFER_RESUME);

    TFarRadioButton * ResumeOnButton = new TFarRadioButton(Dialog);
    ResumeOnButton->Caption = GetMsg(TRANSFER_RESUME_ON);

    TFarRadioButton * ResumeSmartButton = new TFarRadioButton(Dialog);
    ResumeSmartButton->Caption = GetMsg(TRANSFER_RESUME_SMART);
    int ResumeThresholdLeft = ResumeSmartButton->Right;

    TFarRadioButton * ResumeOffButton = new TFarRadioButton(Dialog);
    ResumeOffButton->Caption = GetMsg(TRANSFER_RESUME_OFF);

    TFarEdit * ResumeThresholdEdit = new TFarEdit(Dialog);
    ResumeThresholdEdit->Move(0, -2);
    ResumeThresholdEdit->Left = ResumeThresholdLeft + 3;
    ResumeThresholdEdit->Fixed = true;
    ResumeThresholdEdit->Mask = "9999999";
    ResumeThresholdEdit->Width = 9;
    ResumeThresholdEdit->EnabledDependency = ResumeSmartButton;

    Dialog->NextItemPosition = ipRight;

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(TRANSFER_RESUME_THRESHOLD_UNIT);
    Text->EnabledDependency = ResumeSmartButton;

    Dialog->NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(TRANSFER_SESSION_REOPEN_GROUP);
    Separator->Move(0, 1);

    TFarCheckBox * SessionReopenAutoCheck = new TFarCheckBox(Dialog);
    SessionReopenAutoCheck->Caption = GetMsg(TRANSFER_SESSION_REOPEN_AUTO);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(TRANSFER_SESSION_REOPEN_AUTO_LABEL);
    Text->EnabledDependency = SessionReopenAutoCheck;
    Text->Move(4, 0);

    Dialog->NextItemPosition = ipRight;

    TFarEdit * SessionReopenAutoEdit = new TFarEdit(Dialog);
    SessionReopenAutoEdit->EnabledDependency = SessionReopenAutoCheck;
    SessionReopenAutoEdit->Fixed = true;
    SessionReopenAutoEdit->Mask = "999";
    SessionReopenAutoEdit->Width = 5;

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(TRANSFER_SESSION_REOPEN_AUTO_UNIT);
    Text->EnabledDependency = SessionReopenAutoCheck;

    Dialog->NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(TRANSFER_BACKGROUND);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(TRANSFER_QUEUE_LIMIT);

    Dialog->NextItemPosition = ipRight;

    TFarEdit * QueueTransferLimitEdit = new TFarEdit(Dialog);
    QueueTransferLimitEdit->Fixed = true;
    QueueTransferLimitEdit->Mask = "9";
    QueueTransferLimitEdit->Width = 3;

    Dialog->NextItemPosition = ipNewLine;

    TFarCheckBox * QueueCheck = new TFarCheckBox(Dialog);
    QueueCheck->Caption = GetMsg(TRANSFER_QUEUE_DEFAULT);

    TFarCheckBox * QueueAutoPopupCheck = new TFarCheckBox(Dialog);
    QueueAutoPopupCheck->Caption = GetMsg(TRANSFER_AUTO_POPUP);

    TFarCheckBox * RememberPasswordCheck = new TFarCheckBox(Dialog);
    RememberPasswordCheck->Caption = GetMsg(TRANSFER_REMEMBER_PASSWORD);

    Dialog->AddStandardButtons();

    CalculateSizeCheck->Checked = GUIConfiguration->DefaultCopyParam.CalculateSize;
    ResumeOnButton->Checked = GUIConfiguration->DefaultCopyParam.ResumeSupport == rsOn;
    ResumeSmartButton->Checked = GUIConfiguration->DefaultCopyParam.ResumeSupport == rsSmart;
    ResumeOffButton->Checked = GUIConfiguration->DefaultCopyParam.ResumeSupport == rsOff;
    ResumeThresholdEdit->AsInteger =
      static_cast<int>(GUIConfiguration->DefaultCopyParam.ResumeThreshold / 1024);

    QueueTransferLimitEdit->AsInteger = FarConfiguration->QueueTransfersLimit;
    QueueCheck->Checked = FarConfiguration->DefaultCopyParam.Queue;
    QueueAutoPopupCheck->Checked = FarConfiguration->QueueAutoPopup;
    RememberPasswordCheck->Checked = GUIConfiguration->QueueRememberPassword;

    SessionReopenAutoCheck->Checked = (Configuration->SessionReopenAuto > 0);
    SessionReopenAutoEdit->AsInteger = (Configuration->SessionReopenAuto > 0 ?
      (Configuration->SessionReopenAuto / 1000): 5);

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Configuration->BeginUpdate();
      try
      {
        TGUICopyParamType CopyParam = GUIConfiguration->DefaultCopyParam;

        CopyParam.CalculateSize = CalculateSizeCheck->Checked;

        if (ResumeOnButton->Checked) CopyParam.ResumeSupport = rsOn;
        if (ResumeSmartButton->Checked) CopyParam.ResumeSupport = rsSmart;
        if (ResumeOffButton->Checked) CopyParam.ResumeSupport = rsOff;
        CopyParam.ResumeThreshold = ResumeThresholdEdit->AsInteger * 1024;

        FarConfiguration->QueueTransfersLimit = QueueTransferLimitEdit->AsInteger;
        CopyParam.Queue = QueueCheck->Checked;
        FarConfiguration->QueueAutoPopup = QueueAutoPopupCheck->Checked;
        GUIConfiguration->QueueRememberPassword = RememberPasswordCheck->Checked;

        GUIConfiguration->DefaultCopyParam = CopyParam;

        Configuration->SessionReopenAuto =
          (SessionReopenAutoCheck->Checked ? (SessionReopenAutoEdit->AsInteger * 1000) : 0);
      }
      __finally
      {
        Configuration->EndUpdate();
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::TransferEditorConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    TFarSeparator * Separator;

    Dialog->Size = TPoint(55, 13);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_TRANSFER_EDITOR))));

    TFarCheckBox * EditorUploadOnSaveCheck = new TFarCheckBox(Dialog);
    EditorUploadOnSaveCheck->Caption = GetMsg(TRANSFER_EDITOR_UPLOAD_ON_SAVE);

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(TRANSFER_EDITOR_DOWNLOAD);

    TFarRadioButton * EditorDownloadDefaultButton = new TFarRadioButton(Dialog);
    EditorDownloadDefaultButton->Caption = GetMsg(TRANSFER_EDITOR_DOWNLOAD_DEFAULT);

    TFarRadioButton * EditorDownloadOptionsButton = new TFarRadioButton(Dialog);
    EditorDownloadOptionsButton->Caption = GetMsg(TRANSFER_EDITOR_DOWNLOAD_OPTIONS);

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(TRANSFER_EDITOR_UPLOAD);

    TFarRadioButton * EditorUploadSameButton = new TFarRadioButton(Dialog);
    EditorUploadSameButton->Caption = GetMsg(TRANSFER_EDITOR_UPLOAD_SAME);

    TFarRadioButton * EditorUploadOptionsButton = new TFarRadioButton(Dialog);
    EditorUploadOptionsButton->Caption = GetMsg(TRANSFER_EDITOR_UPLOAD_OPTIONS);

    Dialog->AddStandardButtons();

    EditorDownloadDefaultButton->Checked = FarConfiguration->EditorDownloadDefaultMode;
    EditorDownloadOptionsButton->Checked = !FarConfiguration->EditorDownloadDefaultMode;
    EditorUploadSameButton->Checked = FarConfiguration->EditorUploadSameOptions;
    EditorUploadOptionsButton->Checked = !FarConfiguration->EditorUploadSameOptions;
    EditorUploadOnSaveCheck->Checked = FarConfiguration->EditorUploadOnSave;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Configuration->BeginUpdate();
      try
      {
        FarConfiguration->EditorDownloadDefaultMode = EditorDownloadDefaultButton->Checked;
        FarConfiguration->EditorUploadSameOptions = EditorUploadSameButton->Checked;
        FarConfiguration->EditorUploadOnSave = EditorUploadOnSaveCheck->Checked;
      }
      __finally
      {
        Configuration->EndUpdate();
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::ConfirmationsConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    Dialog->Size = TPoint(65, 10);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_CONFIRMATIONS))));

    TFarCheckBox * ConfirmOverwritingCheck = new TFarCheckBox(Dialog);
    ConfirmOverwritingCheck->AllowGrayed = true;
    ConfirmOverwritingCheck->Caption = GetMsg(CONFIRMATIONS_CONFIRM_OVERWRITING);

    TFarCheckBox * ConfirmCommandSessionCheck = new TFarCheckBox(Dialog);
    ConfirmCommandSessionCheck->Caption = GetMsg(CONFIRMATIONS_OPEN_COMMAND_SESSION);

    TFarCheckBox * ConfirmResumeCheck = new TFarCheckBox(Dialog);
    ConfirmResumeCheck->Caption = GetMsg(CONFIRMATIONS_CONFIRM_RESUME);

    TFarCheckBox * ConfirmSynchronizedBrowsingCheck = new TFarCheckBox(Dialog);
    ConfirmSynchronizedBrowsingCheck->Caption = GetMsg(CONFIRMATIONS_SYNCHRONIZED_BROWSING);

    /*
    TFarCheckBox * ContinueOnErrorCheck = new TFarCheckBox(Dialog);
    ContinueOnErrorCheck->Caption = GetMsg(CONFIRMATIONS_CONTINUE_ON_ERROR);
    */

    Dialog->AddStandardButtons();

    ConfirmOverwritingCheck->Selected = !FarConfiguration->ConfirmOverwritingOverride ?
      BSTATE_3STATE : (Configuration->ConfirmOverwriting ? BSTATE_CHECKED :
        BSTATE_UNCHECKED);
    ConfirmCommandSessionCheck->Checked = GUIConfiguration->ConfirmCommandSession;
    ConfirmResumeCheck->Checked = GUIConfiguration->ConfirmResume;
    ConfirmSynchronizedBrowsingCheck->Checked = FarConfiguration->ConfirmSynchronizedBrowsing;
    //ContinueOnErrorCheck->Checked = FarConfiguration->ContinueOnError;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Configuration->BeginUpdate();
      try
      {
        FarConfiguration->ConfirmOverwritingOverride =
          ConfirmOverwritingCheck->Selected != BSTATE_3STATE;
        GUIConfiguration->ConfirmCommandSession = ConfirmCommandSessionCheck->Checked;
        GUIConfiguration->ConfirmResume = ConfirmResumeCheck->Checked;
        if (FarConfiguration->ConfirmOverwritingOverride)
        {
          Configuration->ConfirmOverwriting = ConfirmOverwritingCheck->Checked;
        }
        FarConfiguration->ConfirmSynchronizedBrowsing = ConfirmSynchronizedBrowsingCheck->Checked;
        //FarConfiguration->ContinueOnError = ContinueOnErrorCheck->Checked;
      }
      __finally
      {
        Configuration->EndUpdate();
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::IntegrationConfigurationDialog()
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    TFarText * Text;

    Dialog->Size = TPoint(65, 13);
    Dialog->Caption = FORMAT("%s - %s",
      (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_INTEGRATION))));

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(INTEGRATION_PUTTY);

    TFarEdit * PuttyPathEdit = new TFarEdit(Dialog);
    
    TFarCheckBox * PuttyPasswordCheck = new TFarCheckBox(Dialog);
    PuttyPasswordCheck->Caption = GetMsg(INTEGRATION_PUTTY_PATH);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(INTEGRATION_PAGEANT);

    TFarEdit * PageantPathEdit = new TFarEdit(Dialog);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(INTEGRATION_PUTTYGEN);

    TFarEdit * PuttygenPathEdit = new TFarEdit(Dialog);

    Dialog->AddStandardButtons();

    PuttyPathEdit->Text = GUIConfiguration->PuttyPath;
    PuttyPasswordCheck->Checked = GUIConfiguration->PuttyPassword;
    PageantPathEdit->Text = FarConfiguration->PageantPath;
    PuttygenPathEdit->Text = FarConfiguration->PuttygenPath;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Configuration->BeginUpdate();
      try
      {
        GUIConfiguration->PuttyPath = PuttyPathEdit->Text;
        GUIConfiguration->PuttyPassword = PuttyPasswordCheck->Checked;
        FarConfiguration->PageantPath = PageantPathEdit->Text;
        FarConfiguration->PuttygenPath = PuttygenPathEdit->Text;
      }
      __finally
      {
        Configuration->EndUpdate();
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
class TAboutDialog : public TFarDialog
{
public:
  __fastcall TAboutDialog(TCustomFarPlugin * AFarPlugin);

private:
  void __fastcall UrlButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall UrlTextClick(TFarDialogItem * Item, MOUSE_EVENT_RECORD * Event);
};
//---------------------------------------------------------------------------
__fastcall TAboutDialog::TAboutDialog(TCustomFarPlugin * AFarPlugin) :
  TFarDialog(AFarPlugin)
{
  TFarText * Text;
  TFarButton * Button;

  Size = TPoint(55, 19);
  Caption = FORMAT("%s - %s",
    (GetMsg(PLUGIN_TITLE), StripHotKey(GetMsg(CONFIG_ABOUT))));

  Text = new TFarText(this);
  Text->Caption = Configuration->FileInfoString["FileDescription"];
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Caption = FORMAT(GetMsg(ABOUT_VERSION), (Configuration->Version));
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Move(0, 1);
  Text->Caption = FORMAT(GetMsg(ABOUT_PRODUCT_VERSION),
    (Configuration->FileInfoString["ProductName"],
     Configuration->ProductVersion));
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Move(0, 1);
  Text->Caption = Configuration->FileInfoString["LegalCopyright"];
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Caption = Configuration->FileInfoString["WWW"];
  Text->Color = static_cast<char>((GetSystemColor(COL_DIALOGTEXT) & 0xF0) | 0x09);
  Text->CenterGroup = true;
  Text->OnMouseClick = UrlTextClick;

  Button = new TFarButton(this);
  Button->Move(0, 1);
  Button->Caption = GetMsg(ABOUT_HOMEPAGE);
  Button->OnClick = UrlButtonClick;
  Button->Tag = 1;
  Button->CenterGroup = true;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(ABOUT_FORUM);
  Button->OnClick = UrlButtonClick;
  Button->Tag = 2;
  Button->CenterGroup = true;

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  Text = new TFarText(this);
  Text->Caption = GetMsg(ABOUT_PUTTY);
  Text->CenterGroup = true;

  Text = new TFarText(this);
  Text->Caption = GetMsg(ABOUT_PUTTY2);
  Text->CenterGroup = true;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(ABOUT_PUTTY_HOMEPAGE);
  Button->OnClick = UrlButtonClick;
  Button->Tag = 3;
  Button->CenterGroup = true;

  new TFarSeparator(this);

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Close);
  Button->Default = true;
  Button->Result = brOK;
  Button->CenterGroup = true;
  Button->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TAboutDialog::UrlTextClick(TFarDialogItem * /*Item*/,
  MOUSE_EVENT_RECORD * /*Event*/)
{
  AnsiString Address = Configuration->FileInfoString["WWW"];
  ShellExecute(NULL, "open", Address.c_str(), NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------
void __fastcall TAboutDialog::UrlButtonClick(TFarButton * Sender, bool & /*Close*/)
{
  AnsiString Address;
  switch (Sender->Tag) {
    case 1: Address = Configuration->FileInfoString["WWW"] + "eng/docs/far"; break;
    case 2: Address = Configuration->FileInfoString["WWW"] + "forum/"; break;
    case 3: Address = LoadStr(PUTTY_URL); break;
  }
  ShellExecute(NULL, "open", Address.c_str(), NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TWinSCPPlugin::AboutDialog()
{
  TFarDialog * Dialog = new TAboutDialog(this);
  try
  {
    Dialog->ShowModal();
  }
  __finally
  {
    delete Dialog;
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TPasswordDialog : public TFarDialog
{
public:
  __fastcall TPasswordDialog(TCustomFarPlugin * AFarPlugin,
    AnsiString Prompt, TPromptKind Kind);

  bool __fastcall Execute(AnsiString & Password);

protected:
  virtual void __fastcall Change();

private:
  AnsiString FPrompt;
  TFarEdit * PasswordEdit;
  TFarEdit * NormalEdit;
  TFarCheckBox * HideTypingCheck;
  
  void __fastcall ShowPromptClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TPasswordDialog::TPasswordDialog(TCustomFarPlugin * AFarPlugin,
    AnsiString Prompt, TPromptKind Kind) : TFarDialog(AFarPlugin)
{
  TFarButton * Button;
  TFarText * Text;

  FPrompt = Prompt;

  TPoint S = TPoint(50 + (Kind == pkServerPrompt ? 25 : 0),
    8 + (Kind == pkServerPrompt ? 4 : 0));
  int P = Prompt.Pos("\n");
  if (P > 0)
  {
    Prompt.SetLength(P - 1);
  }
  P = Prompt.Pos("\r");
  if (P > 0)
  {
    Prompt.SetLength(P - 1);
  }
  if (S.x - 10 < Prompt.Length())
  {
    S.x = Prompt.Length() + 10;
    if (S.x > 80)
    {
      Prompt.SetLength(80 - 10 - 4);
      Prompt += " ...";
      S.x = 80;
    }
  }
  Size = S;

  int Msg;
  switch (Kind) {
    case pkPassphrase:
      Msg = PASSPHRASE_TITLE;
      break;
    case pkServerPrompt:
      Msg = SERVER_PASSWORD_TITLE;
      break;
    default:
      assert(false);
    case pkPassword:
      Msg = PASSWORD_TITLE;
      break;
  }
  Caption = GetMsg(Msg);

  Text = new TFarText(this);
  Text->Caption = Prompt;

  PasswordEdit = new TFarEdit(this);
  PasswordEdit->Password = true;

  if (Kind == pkServerPrompt)
  {
    NormalEdit = new TFarEdit(this);
    NormalEdit->Move(0, -1);
    NormalEdit->Visible = false;
  }
  else
  {
    NormalEdit = NULL;
  }

  if (Kind == pkServerPrompt)
  {
    new TFarSeparator(this);

    HideTypingCheck = new TFarCheckBox(this);
    HideTypingCheck->Caption = GetMsg(SERVER_PASSWORD_HIDE_TYPING);
    HideTypingCheck->Checked = true;

    Text = new TFarText(this);
    Text->Caption = GetMsg(SERVER_PASSWORD_NOTE1);
    Text = new TFarText(this);
    Text->Caption = GetMsg(SERVER_PASSWORD_NOTE2);
  }
  else
  {
    HideTypingCheck = NULL;
  }

  new TFarSeparator(this);

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_OK);
  Button->Default = true;
  Button->Result = brOK;
  Button->CenterGroup = true;

  NextItemPosition = ipRight;

  if (Prompt != FPrompt)
  {
    Button = new TFarButton(this);
    Button->Caption = GetMsg(PASSWORD_SHOW_PROMPT);
    Button->OnClick = ShowPromptClick;
    Button->CenterGroup = true;
  }

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;
}
//---------------------------------------------------------------------------
void __fastcall TPasswordDialog::ShowPromptClick(TFarButton * /*Sender*/,
  bool & /*Close*/)
{
  TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);

  WinSCPPlugin->MoreMessageDialog(FPrompt, NULL, qtInformation, qaOK);
}
//---------------------------------------------------------------------------
void __fastcall TPasswordDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    if (HideTypingCheck &&
        (HideTypingCheck->Checked != PasswordEdit->Visible))
    {
      AnsiString Value;
      Value = HideTypingCheck->Checked ? NormalEdit->Text : PasswordEdit->Text;
      PasswordEdit->Visible = HideTypingCheck->Checked;
      NormalEdit->Visible = !HideTypingCheck->Checked;
      (HideTypingCheck->Checked ? PasswordEdit : NormalEdit)->Text = Value;
    }
  }
}
//---------------------------------------------------------------------------
bool __fastcall TPasswordDialog::Execute(AnsiString & Password)
{
  PasswordEdit->Text = Password;

  bool Result = (ShowModal() != brCancel);
  if (Result)
  {
    Password = (!HideTypingCheck || HideTypingCheck->Checked) ?
      PasswordEdit->Text : NormalEdit->Text;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::PasswordDialog(AnsiString Prompt, TPromptKind Kind,
  AnsiString & Password)
{
  bool Result;
  TPasswordDialog * Dialog = new TPasswordDialog(FPlugin, Prompt, Kind);
  try
  {
    Result = Dialog->Execute(Password);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::BannerDialog(AnsiString SessionName,
  const AnsiString & Banner, bool & NeverShowAgain, int Options)
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(FPlugin);
  try
  {
    Dialog->Size = TPoint(70, 21);
    Dialog->Caption = FORMAT(GetMsg(BANNER_TITLE), (SessionName));

    TFarLister * Lister = new TFarLister(Dialog);
    FarWrapText(Banner, Lister->Items, Dialog->BorderBox->Width - 4);
    Lister->Height = 15;
    Lister->Left = Dialog->BorderBox->Left + 1;
    Lister->Right = Dialog->BorderBox->Right - (Lister->ScrollBar ? 0 : 1);

    new TFarSeparator(Dialog);

    TFarCheckBox * NeverShowAgainCheck = NULL;
    if (FLAGCLEAR(Options, boDisableNeverShowAgain))
    {
      NeverShowAgainCheck = new TFarCheckBox(Dialog);
      NeverShowAgainCheck->Caption = GetMsg(BANNER_NEVER_SHOW_AGAIN);
      NeverShowAgainCheck->Visible = FLAGCLEAR(Options, boDisableNeverShowAgain);
      NeverShowAgainCheck->Checked = NeverShowAgain;

      Dialog->NextItemPosition = ipRight;
    }

    TFarButton * Button = new TFarButton(Dialog);
    Button->Caption = GetMsg(BANNER_CONTINUE);
    Button->Default = true;
    Button->Result = brOK;
    if (NeverShowAgainCheck != NULL)
    {
      Button->Left = Dialog->BorderBox->Right - Button->Width - 1;
    }
    else
    {
      Button->CenterGroup = true;
    }

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      if (NeverShowAgainCheck != NULL)
      {
        NeverShowAgain = NeverShowAgainCheck->Checked;
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TSessionDialog : public TTabbedDialog
{
public:
  enum TSessionTab { tabSession = 1, tabEnvironment, tabDirectories, tabSFTP, tabSCP,
    tabConnection, tabProxy, tabSsh, tabKex, tabAuthentication, tabBugs, tabCount };
    
  __fastcall TSessionDialog(TCustomFarPlugin * AFarPlugin, TSessionAction Action);

  bool __fastcall Execute(TSessionData * Data, TSessionAction & Action);

protected:
  virtual void __fastcall Change();
  virtual bool __fastcall CloseQuery();

private:
  TSessionAction FAction;
  TFarButton * ConnectButton;
  TFarEdit * HostNameEdit;
  TFarEdit * PortNumberEdit;
  TFarEdit * UserNameEdit;
  TFarText * PasswordLabel;
  TFarEdit * PasswordEdit;
  TFarText * PrivateKeyLabel;
  TFarEdit * PrivateKeyEdit;
  TFarRadioButton * SCPonlyButton;
  TFarRadioButton * SFTPButton;
  TFarRadioButton * SFTPonlyButton;
  TFarCheckBox * UpdateDirectoriesCheck;
  TFarCheckBox * CacheDirectoriesCheck;
  TFarCheckBox * CacheDirectoryChangesCheck;
  TFarCheckBox * PreserveDirectoryChangesCheck;
  TFarCheckBox * ResolveSymlinksCheck;
  TFarEdit * RemoteDirectoryEdit;
  TFarRadioButton * EOLTypeLFButton;
  TFarRadioButton * EOLTypeCRLFButton;
  TFarRadioButton * ConsiderDSTOnCheck;
  TFarRadioButton * ConsiderDSTOffCheck;
  TFarCheckBox * CompressionCheck;
  TFarRadioButton * SshProt1onlyButton;
  TFarRadioButton * SshProt1Button;
  TFarRadioButton * SshProt2Button;
  TFarRadioButton * SshProt2onlyButton;
  TFarListBox * CipherListBox;
  TFarButton * CipherUpButton;
  TFarButton * CipherDownButton;
  TFarCheckBox * Ssh2DESCheck;
  TFarRadioButton * DefaultShellButton;
  TFarRadioButton * ShellEnterButton;
  TFarComboBox * ShellEdit;
  TFarRadioButton * ReturnVarAutodetectButton;
  TFarRadioButton * ReturnVarEnterButton;
  TFarComboBox * ReturnVarEdit;
  TFarCheckBox * LookupUserGroupsCheck;
  TFarCheckBox * ClearAliasesCheck;
  TFarCheckBox * UnsetNationalVarsCheck;
  TFarCheckBox * AliasGroupListCheck;
  TFarCheckBox * IgnoreLsWarningsCheck;
  TFarCheckBox * SCPLsFullTimeAutoCheck;
  TFarCheckBox * Scp1CompatibilityCheck;
  TFarEdit * TimeDifferenceEdit;
  TFarEdit * TimeDifferenceMinutesEdit;
  TFarEdit * TimeoutEdit;
  TFarRadioButton * PingOffButton;
  TFarRadioButton * PingNullPacketButton;
  TFarRadioButton * PingDummyCommandButton;
  TFarEdit * PingIntervalSecEdit;
  TFarRadioButton * ProxyNoneButton;
  TFarRadioButton * ProxySocks4Button;
  TFarRadioButton * ProxySocks5Button;
  TFarRadioButton * ProxyHTTPButton;
  TFarRadioButton * ProxyTelnetButton;
  TFarEdit * ProxyHostEdit;
  TFarEdit * ProxyPortEdit;
  TFarEdit * ProxyUsernameEdit;
  TFarText * ProxyPasswordLabel;
  TFarEdit * ProxyPasswordEdit;
  TFarEdit * ProxyTelnetCommandEdit;
  TFarCheckBox * ProxyLocalhostCheck;
  TFarRadioButton * ProxyDNSOffButton;
  TFarRadioButton * ProxyDNSAutoButton;
  TFarRadioButton * ProxyDNSOnButton;
  TFarComboBox * BugIgnore1Combo;
  TFarComboBox * BugPlainPW1Combo;
  TFarComboBox * BugRSA1Combo;
  TFarComboBox * BugHMAC2Combo;
  TFarComboBox * BugDeriveKey2Combo;
  TFarComboBox * BugRSAPad2Combo;
  TFarComboBox * BugPKSessID2Combo;
  TFarComboBox * BugRekey2Combo;
  TFarCheckBox * AuthTISCheck;
  TFarCheckBox * AuthKICheck;
  TFarCheckBox * AuthKIPasswordCheck;
  TFarCheckBox * AgentFwdCheck;
  TFarCheckBox * AuthGSSAPICheck;
  TFarCheckBox * DeleteToRecycleBinCheck;
  TFarCheckBox * OverwrittenToRecycleBinCheck;
  TFarText * RecycleBinPathLabel;
  TFarEdit * RecycleBinPathEdit;
  TFarComboBox * SFTPMaxVersionCombo;
  TFarComboBox * SFTPBugSymlinkCombo;
  TFarComboBox * SFTPBugUtfCombo;
  TFarComboBox * SFTPBugSignedTSCombo;
  TFarListBox * KexListBox;
  TFarButton * KexUpButton;
  TFarButton * KexDownButton;
  TFarEdit * RekeyTimeEdit;
  TFarEdit * RekeyDataEdit;
  TFarRadioButton * IPAutoButton;
  TFarRadioButton * IPv4Button;
  TFarRadioButton * IPv6Button;

  void __fastcall CipherButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall KexButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall AuthGSSAPICheckAllowChange(TFarDialogItem * Sender, long NewState, bool & Allow);
  void __fastcall UpdateControls();
};
//---------------------------------------------------------------------------
#define BUGS() \
  BUG(Ignore1, LOGIN_BUGS_IGNORE1, , SshProt2onlyButton); \
  BUG(PlainPW1, LOGIN_BUGS_PLAIN_PW1, , SshProt2onlyButton); \
  BUG(RSA1, LOGIN_BUGS_RSA1, , SshProt2onlyButton); \
  BUG(HMAC2, LOGIN_BUGS_HMAC2, , SshProt1onlyButton); \
  BUG(DeriveKey2, LOGIN_BUGS_DERIVE_KEY2, , SshProt1onlyButton); \
  BUG(RSAPad2, LOGIN_BUGS_RSA_PAD2, , SshProt1onlyButton); \
  BUG(PKSessID2, LOGIN_BUGS_PKSESSID2, , SshProt1onlyButton); \
  BUG(Rekey2, LOGIN_BUGS_REKEY2, , SshProt1onlyButton);
#define SFTP_BUGS() \
  BUG(Symlink, LOGIN_SFTP_BUGS_SYMLINK, SFTP, SCPonlyButton); \
  BUG(SignedTS, LOGIN_SFTP_BUGS_SIGNED_TS, SFTP, SCPonlyButton);
#define SFTP_UTF_BUG() \
  BUG(Utf, LOGIN_SFTP_BUGS_UTF, SFTP, SCPonlyButton);
//---------------------------------------------------------------------------
__fastcall TSessionDialog::TSessionDialog(TCustomFarPlugin * AFarPlugin,
  TSessionAction Action) : TTabbedDialog(AFarPlugin, tabCount),
  FAction(Action)
{
  Size = TPoint(67, 22);

  TRect CRect = ClientRect;

  TFarButton * Button;
  TTabButton * Tab;
  TFarSeparator * Separator;
  TFarText * Text;
  int GroupTop;
  int Pos;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_SESSION);
  Tab->Tab = tabSession;

  NextItemPosition = ipRight;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_ENVIRONMENT);
  Tab->Tab = tabEnvironment;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_DIRECTORIES);
  Tab->Tab = tabDirectories;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_SFTP);
  Tab->Tab = tabSFTP;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_SCP);
  Tab->Tab = tabSCP;

  NextItemPosition = ipNewLine;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_CONNECTION);
  Tab->Tab = tabConnection;

  NextItemPosition = ipRight;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_PROXY);
  Tab->Tab = tabProxy;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_SSH);
  Tab->Tab = tabSsh;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_KEX);
  Tab->Tab = tabKex;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_AUTH);
  Tab->Tab = tabAuthentication;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(LOGIN_TAB_BUGS);
  Tab->Tab = tabBugs;

  // Sesion tab

  NextItemPosition = ipNewLine;
  DefaultGroup = tabSession;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_GROUP_SESSION);
  GroupTop = Separator->Top;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_HOST_NAME);

  HostNameEdit = new TFarEdit(this);
  HostNameEdit->Right = CRect.Right - 12 - 2;

  NextItemPosition = ipRight;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PORT_NUMBER);
  Text->Move(0, -1);

  NextItemPosition = ipBelow;

  PortNumberEdit = new TFarEdit(this);
  PortNumberEdit->Fixed = true;
  PortNumberEdit->Mask = "99999";

  NextItemPosition = ipNewLine;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_USER_NAME);

  UserNameEdit = new TFarEdit(this);
  UserNameEdit->Width = UserNameEdit->Width / 2 - 1;

  NextItemPosition = ipRight;

  PasswordLabel = new TFarText(this);
  PasswordLabel->Caption = GetMsg(LOGIN_PASSWORD);
  PasswordLabel->Move(0, -1);

  NextItemPosition = ipBelow;

  PasswordEdit = new TFarEdit(this);
  PasswordEdit->Password = true;

  NextItemPosition = ipNewLine;

  PrivateKeyLabel = new TFarText(this);
  PrivateKeyLabel->Caption = GetMsg(LOGIN_PRIVATE_KEY);

  PrivateKeyEdit = new TFarEdit(this);

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_GROUP_PROTOCOL);

  SFTPonlyButton = new TFarRadioButton(this);
  SFTPonlyButton->Caption = GetMsg(LOGIN_SFTP_ONLY);

  NextItemPosition = ipRight;

  SFTPButton = new TFarRadioButton(this);
  SFTPButton->Caption = GetMsg(LOGIN_SFTP);

  SCPonlyButton = new TFarRadioButton(this);
  SCPonlyButton->Caption = GetMsg(LOGIN_SCP_ONLY);

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  Text = new TFarText(this);
  Text->Top = CRect.Bottom - 3;
  Text->Bottom = Text->Top;
  Text->Caption = GetMsg(LOGIN_TAB_HINT1);
  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TAB_HINT2);

  // Environment tab

  DefaultGroup = tabEnvironment;
  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_EOL_GROUP);

  EOLTypeLFButton = new TFarRadioButton(this);
  EOLTypeLFButton->Caption = GetMsg(LOGIN_EOL_LF);

  NextItemPosition = ipRight;

  EOLTypeCRLFButton = new TFarRadioButton(this);
  EOLTypeCRLFButton->Caption = GetMsg(LOGIN_EOL_CRLF);

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_CONSIDER_DST_GROUP);

  ConsiderDSTOnCheck = new TFarRadioButton(this);
  ConsiderDSTOnCheck->Caption = GetMsg(LOGIN_CONSIDER_DST_ON);

  ConsiderDSTOffCheck = new TFarRadioButton(this);
  ConsiderDSTOffCheck->Caption = GetMsg(LOGIN_CONSIDER_DST_OFF);

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_RECYCLE_BIN_GROUP);

  DeleteToRecycleBinCheck = new TFarCheckBox(this);
  DeleteToRecycleBinCheck->Caption = GetMsg(LOGIN_RECYCLE_BIN_DELETE);

  OverwrittenToRecycleBinCheck = new TFarCheckBox(this);
  OverwrittenToRecycleBinCheck->Caption = GetMsg(LOGIN_RECYCLE_BIN_OVERWRITE);
  OverwrittenToRecycleBinCheck->EnabledDependencyNegative = SCPonlyButton;

  RecycleBinPathLabel = new TFarText(this);
  RecycleBinPathLabel->Caption = GetMsg(LOGIN_RECYCLE_BIN_LABEL);

  RecycleBinPathEdit = new TFarEdit(this);

  new TFarSeparator(this);

  // Directories tab 
  
  DefaultGroup = tabDirectories;
  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_DIRECTORIES_GROUP);

  UpdateDirectoriesCheck = new TFarCheckBox(this);
  UpdateDirectoriesCheck->Caption = GetMsg(LOGIN_UPDATE_DIRECTORIES);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_REMOTE_DIRECTORY);

  RemoteDirectoryEdit = new TFarEdit(this);
  RemoteDirectoryEdit->History = REMOTE_DIR_HISTORY;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_DIRECTORY_OPTIONS_GROUP);

  CacheDirectoriesCheck = new TFarCheckBox(this);
  CacheDirectoriesCheck->Caption = GetMsg(LOGIN_CACHE_DIRECTORIES);

  CacheDirectoryChangesCheck = new TFarCheckBox(this);
  CacheDirectoryChangesCheck->Caption = GetMsg(LOGIN_CACHE_DIRECTORY_CHANGES);

  PreserveDirectoryChangesCheck = new TFarCheckBox(this);
  PreserveDirectoryChangesCheck->Caption = GetMsg(LOGIN_PRESERVE_DIRECTORY_CHANGES);
  PreserveDirectoryChangesCheck->Left += 4;

  ResolveSymlinksCheck = new TFarCheckBox(this);
  ResolveSymlinksCheck->Caption = GetMsg(LOGIN_RESOLVE_SYMLINKS);

  new TFarSeparator(this);

  // SCP Tab

  NextItemPosition = ipNewLine;

  DefaultGroup = tabSCP;

  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_SHELL_GROUP);

  DefaultShellButton = new TFarRadioButton(this);
  DefaultShellButton->Caption = GetMsg(LOGIN_SHELL_DEFAULT);

  NextItemPosition = ipRight;

  ShellEnterButton = new TFarRadioButton(this);
  ShellEnterButton->Caption = GetMsg(LOGIN_SHELL_ENTER);

  ShellEdit = new TFarComboBox(this);
  ShellEdit->Items->Add("/bin/bash");
  ShellEdit->Items->Add("/bin/ksh");
  ShellEdit->EnabledDependency = ShellEnterButton;

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_RETURN_VAR_GROUP);

  ReturnVarAutodetectButton = new TFarRadioButton(this);
  ReturnVarAutodetectButton->Caption = GetMsg(LOGIN_RETURN_VAR_AUTODETECT);

  NextItemPosition = ipRight;

  ReturnVarEnterButton = new TFarRadioButton(this);
  ReturnVarEnterButton->Caption = GetMsg(LOGIN_RETURN_VAR_ENTER);

  ReturnVarEdit = new TFarComboBox(this);
  ReturnVarEdit->Items->Add("?");
  ReturnVarEdit->Items->Add("status");
  ReturnVarEdit->EnabledDependency = ReturnVarEnterButton;

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_SCP_LS_OPTIONS_GROUP);

  IgnoreLsWarningsCheck = new TFarCheckBox(this);
  IgnoreLsWarningsCheck->Caption = GetMsg(LOGIN_IGNORE_LS_WARNINGS);
  
  NextItemPosition = ipRight;

  AliasGroupListCheck = new TFarCheckBox(this);
  AliasGroupListCheck->Caption = GetMsg(LOGIN_ALIAS_GROUP_LIST);
  
  NextItemPosition = ipNewLine;

  SCPLsFullTimeAutoCheck = new TFarCheckBox(this);
  SCPLsFullTimeAutoCheck->Caption = GetMsg(LOGIN_SCP_LS_FULL_TIME_AUTO);

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_SCP_OPTIONS);

  LookupUserGroupsCheck = new TFarCheckBox(this);
  LookupUserGroupsCheck->Caption = GetMsg(LOGIN_LOOKUP_USER_GROUPS);

  NextItemPosition = ipRight;

  UnsetNationalVarsCheck = new TFarCheckBox(this);
  UnsetNationalVarsCheck->Caption = GetMsg(LOGIN_CLEAR_NATIONAL_VARS);

  NextItemPosition = ipNewLine;

  ClearAliasesCheck = new TFarCheckBox(this);
  ClearAliasesCheck->Caption = GetMsg(LOGIN_CLEAR_ALIASES);

  NextItemPosition = ipRight;

  Scp1CompatibilityCheck = new TFarCheckBox(this);
  Scp1CompatibilityCheck->Caption = GetMsg(LOGIN_SCP1_COMPATIBILITY);

  NextItemPosition = ipNewLine;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TIME_DIFFERENCE);

  NextItemPosition = ipRight;

  TimeDifferenceEdit = new TFarEdit(this);
  TimeDifferenceEdit->Fixed = true;
  TimeDifferenceEdit->Mask = "###";
  TimeDifferenceEdit->Width = 4;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TIME_DIFFERENCE_HOURS);

  TimeDifferenceMinutesEdit = new TFarEdit(this);
  TimeDifferenceMinutesEdit->Fixed = true;
  TimeDifferenceMinutesEdit->Mask = "###";
  TimeDifferenceMinutesEdit->Width = 4;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TIME_DIFFERENCE_MINUTES);

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  // SFTP Tab

  NextItemPosition = ipNewLine;

  DefaultGroup = tabSFTP;

  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_SFTP_PROTOCOL_GROUP);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_SFTP_MAX_VERSION);
  Text->EnabledDependencyNegative = SCPonlyButton;
  NextItemPosition = ipRight;
  SFTPMaxVersionCombo = new TFarComboBox(this);
  SFTPMaxVersionCombo->DropDownList = true;
  SFTPMaxVersionCombo->Width = 7;
  for (int i = 0; i <= 5; i++)
  {
    SFTPMaxVersionCombo->Items->Add(IntToStr(i));
  }

  NextItemPosition = ipNewLine;

  #define BUG(BUGID, MSG, PREFIX, NEGDEP) \
    Text = new TFarText(this); \
    Text->Caption = GetMsg(MSG); \
    Text->EnabledDependencyNegative = NEGDEP; \
    NextItemPosition = ipRight; \
    PREFIX ## Bug ## BUGID ## Combo = new TFarComboBox(this); \
    PREFIX ## Bug ## BUGID ## Combo->DropDownList = true; \
    PREFIX ## Bug ## BUGID ## Combo->Width = 7; \
    PREFIX ## Bug ## BUGID ## Combo->Items->Add(GetMsg(LOGIN_BUGS_AUTO)); \
    PREFIX ## Bug ## BUGID ## Combo->Items->Add(GetMsg(LOGIN_BUGS_OFF)); \
    PREFIX ## Bug ## BUGID ## Combo->Items->Add(GetMsg(LOGIN_BUGS_ON)); \
    PREFIX ## Bug ## BUGID ## Combo->EnabledDependencyNegative = NEGDEP; \
    NextItemPosition = ipNewLine;

  SFTP_UTF_BUG();

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_SFTP_BUGS_GROUP);

  SFTP_BUGS();

  new TFarSeparator(this);

  // Connection tab

  NextItemPosition = ipNewLine;

  DefaultGroup = tabConnection;
  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_TIMEOUTS_GROUP);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TIMEOUT);

  NextItemPosition = ipRight;

  TimeoutEdit = new TFarEdit(this);
  TimeoutEdit->Fixed = true;
  TimeoutEdit->Mask = "####";
  TimeoutEdit->Width = 5;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_TIMEOUT_SECONDS);

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_PING_GROUP);

  PingOffButton = new TFarRadioButton(this);
  PingOffButton->Caption = GetMsg(LOGIN_PING_OFF);

  PingNullPacketButton = new TFarRadioButton(this);
  PingNullPacketButton->Caption = GetMsg(LOGIN_PING_NULL_PACKET);

  PingDummyCommandButton = new TFarRadioButton(this);
  PingDummyCommandButton->Caption = GetMsg(LOGIN_PING_DUMMY_COMMAND);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PING_INTERVAL);
  Text->EnabledDependencyNegative = PingOffButton;

  NextItemPosition = ipRight;

  PingIntervalSecEdit = new TFarEdit(this);
  PingIntervalSecEdit->Fixed = true;
  PingIntervalSecEdit->Mask = "####";
  PingIntervalSecEdit->Width = 6;
  PingIntervalSecEdit->EnabledDependencyNegative = PingOffButton;

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_IP_GROUP);

  IPAutoButton = new TFarRadioButton(this);
  IPAutoButton->Caption = GetMsg(LOGIN_IP_AUTO);

  NextItemPosition = ipRight;

  IPv4Button = new TFarRadioButton(this);
  IPv4Button->Caption = GetMsg(LOGIN_IP_V4);

  IPv6Button = new TFarRadioButton(this);
  IPv6Button->Caption = GetMsg(LOGIN_IP_V6);

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  // Proxy tab

  DefaultGroup = tabProxy;
  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_PROXY_GROUP);

  ProxyNoneButton = new TFarRadioButton(this);
  ProxyNoneButton->Caption = GetMsg(LOGIN_PROXY_NONE);

  NextItemPosition = ipRight;

  ProxySocks4Button = new TFarRadioButton(this);
  ProxySocks4Button->Caption = GetMsg(LOGIN_PROXY_SOCKS4);

  ProxySocks5Button = new TFarRadioButton(this);
  ProxySocks5Button->Caption = GetMsg(LOGIN_PROXY_SOCKS5);

  ProxyHTTPButton = new TFarRadioButton(this);
  ProxyHTTPButton->Caption = GetMsg(LOGIN_PROXY_HTTP);

  ProxyTelnetButton = new TFarRadioButton(this);
  ProxyTelnetButton->Caption = GetMsg(LOGIN_PROXY_TELNET);

  NextItemPosition = ipNewLine;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_HOST);
  Text->EnabledDependencyNegative = ProxyNoneButton;

  ProxyHostEdit = new TFarEdit(this);
  ProxyHostEdit->Right = CRect.Right - 12 - 2;
  ProxyHostEdit->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipRight;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_PORT);
  Text->Move(0, -1);
  Text->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipBelow;

  ProxyPortEdit = new TFarEdit(this);
  ProxyPortEdit->Fixed = true;
  ProxyPortEdit->Mask = "99999";
  ProxyPortEdit->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipNewLine;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_USERNAME);
  Text->EnabledDependencyNegative = ProxyNoneButton;

  ProxyUsernameEdit = new TFarEdit(this);
  ProxyUsernameEdit->Width = ProxyUsernameEdit->Width / 2 - 1;
  ProxyUsernameEdit->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipRight;

  ProxyPasswordLabel = new TFarText(this);
  ProxyPasswordLabel->Caption = GetMsg(LOGIN_PROXY_PASSWORD);
  ProxyPasswordLabel->Move(0, -1);

  NextItemPosition = ipBelow;

  ProxyPasswordEdit = new TFarEdit(this);
  ProxyPasswordEdit->Password = true;

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_PROXY_SETTINGS_GROUP);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_TELNET_COMMAND);
  Text->EnabledDependency = ProxyTelnetButton;

  NextItemPosition = ipRight;

  ProxyTelnetCommandEdit = new TFarEdit(this);
  ProxyTelnetCommandEdit->EnabledDependency = ProxyTelnetButton;

  NextItemPosition = ipNewLine;

  ProxyLocalhostCheck = new TFarCheckBox(this);
  ProxyLocalhostCheck->Caption = GetMsg(LOGIN_PROXY_LOCALHOST);
  ProxyLocalhostCheck->EnabledDependencyNegative = ProxyNoneButton;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_PROXY_DNS);
  Text->EnabledDependencyNegative = ProxyNoneButton;

  ProxyDNSOffButton = new TFarRadioButton(this);
  ProxyDNSOffButton->Caption = GetMsg(LOGIN_PROXY_DNS_NO);
  ProxyDNSOffButton->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipRight;

  ProxyDNSAutoButton = new TFarRadioButton(this);
  ProxyDNSAutoButton->Caption = GetMsg(LOGIN_PROXY_DNS_AUTO);
  ProxyDNSAutoButton->EnabledDependencyNegative = ProxyNoneButton;

  ProxyDNSOnButton = new TFarRadioButton(this);
  ProxyDNSOnButton->Caption = GetMsg(LOGIN_PROXY_DNS_YES);
  ProxyDNSOnButton->EnabledDependencyNegative = ProxyNoneButton;

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  // SSH tab

  NextItemPosition = ipNewLine;

  DefaultGroup = tabSsh;
  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_SSH_GROUP);

  CompressionCheck = new TFarCheckBox(this);
  CompressionCheck->Caption = GetMsg(LOGIN_COMPRESSION);

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_SSH_PROTOCOL_GROUP);

  SshProt1onlyButton = new TFarRadioButton(this);
  SshProt1onlyButton->Caption = GetMsg(LOGIN_SSH1_ONLY);

  NextItemPosition = ipRight;

  SshProt1Button = new TFarRadioButton(this);
  SshProt1Button->Caption = GetMsg(LOGIN_SSH1);

  SshProt2Button = new TFarRadioButton(this);
  SshProt2Button->Caption = GetMsg(LOGIN_SSH2);

  SshProt2onlyButton = new TFarRadioButton(this);
  SshProt2onlyButton->Caption = GetMsg(LOGIN_SSH2_ONLY);

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_ENCRYPTION_GROUP);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_CIPHER);

  CipherListBox = new TFarListBox(this);
  CipherListBox->Right = CipherListBox->Right - 15;
  CipherListBox->Height = 1 + CIPHER_COUNT + 1;
  Pos = CipherListBox->Bottom;

  NextItemPosition = ipRight;

  CipherUpButton = new TFarButton(this);
  CipherUpButton->Caption = GetMsg(LOGIN_UP);
  CipherUpButton->Move(0, 1);
  CipherUpButton->Result = -1;
  CipherUpButton->OnClick = CipherButtonClick;

  NextItemPosition = ipBelow;

  CipherDownButton = new TFarButton(this);
  CipherDownButton->Caption = GetMsg(LOGIN_DOWN);
  CipherDownButton->Result = 1;
  CipherDownButton->OnClick = CipherButtonClick;

  NextItemPosition = ipNewLine;

  Ssh2DESCheck = new TFarCheckBox(this);
  Ssh2DESCheck->Move(0, Pos - Ssh2DESCheck->Top + 1);
  Ssh2DESCheck->Caption = GetMsg(LOGIN_SSH2DES);
  Ssh2DESCheck->EnabledDependencyNegative = SshProt1onlyButton;

  // KEX tab

  DefaultGroup = tabKex;
  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_KEX_REEXCHANGE_GROUP);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_KEX_REKEY_TIME);
  Text->EnabledDependencyNegative = SshProt1onlyButton;
  
  NextItemPosition = ipRight;

  RekeyTimeEdit = new TFarEdit(this);
  RekeyTimeEdit->Fixed = true;
  RekeyTimeEdit->Mask = "####";
  RekeyTimeEdit->Width = 6;
  RekeyTimeEdit->EnabledDependencyNegative = SshProt1onlyButton;
  
  NextItemPosition = ipNewLine;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_KEX_REKEY_DATA);
  Text->EnabledDependencyNegative = SshProt1onlyButton;
  
  NextItemPosition = ipRight;

  RekeyDataEdit = new TFarEdit(this);
  RekeyDataEdit->Width = 6;
  RekeyDataEdit->EnabledDependencyNegative = SshProt1onlyButton;
  
  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(LOGIN_KEX_OPTIONS_GROUP);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LOGIN_KEX_LIST);
  Text->EnabledDependencyNegative = SshProt1onlyButton;

  KexListBox = new TFarListBox(this);
  KexListBox->Right = KexListBox->Right - 15;
  KexListBox->Height = 1 + KEX_COUNT + 1;
  KexListBox->EnabledDependencyNegative = SshProt1onlyButton;
  Pos = KexListBox->Bottom;

  NextItemPosition = ipRight;

  KexUpButton = new TFarButton(this);
  KexUpButton->Caption = GetMsg(LOGIN_UP);
  KexUpButton->Move(0, 1);
  KexUpButton->Result = -1;
  KexUpButton->OnClick = KexButtonClick;

  NextItemPosition = ipBelow;

  KexDownButton = new TFarButton(this);
  KexDownButton->Caption = GetMsg(LOGIN_DOWN);
  KexDownButton->Result = 1;
  KexDownButton->OnClick = KexButtonClick;

  NextItemPosition = ipNewLine;
  
  Separator = new TFarSeparator(this);
  Separator->Position = Pos + 1;

  // Authentication tab

  DefaultGroup = tabAuthentication;

  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_AUTH_GROUP);

  AuthTISCheck = new TFarCheckBox(this);
  AuthTISCheck->Caption = GetMsg(LOGIN_AUTH_TIS);

  AuthKICheck = new TFarCheckBox(this);
  AuthKICheck->Caption = GetMsg(LOGIN_AUTH_KI);

  AuthKIPasswordCheck = new TFarCheckBox(this);
  AuthKIPasswordCheck->Caption = GetMsg(LOGIN_AUTH_KI_PASSWORD);
  AuthKIPasswordCheck->Move(4, 0);

  AuthGSSAPICheck = new TFarCheckBox(this);
  AuthGSSAPICheck->Caption = GetMsg(LOGIN_AUTH_GSSAPI);
  AuthGSSAPICheck->OnAllowChange = AuthGSSAPICheckAllowChange;

  AgentFwdCheck = new TFarCheckBox(this);
  AgentFwdCheck->Caption = GetMsg(LOGIN_AUTH_AGENT_FWD);

  new TFarSeparator(this);

  // Bugs tab

  DefaultGroup = tabBugs;

  Separator = new TFarSeparator(this);
  Separator->Position = GroupTop;
  Separator->Caption = GetMsg(LOGIN_BUGS_GROUP);

  BUGS();
  #undef BUG

  new TFarSeparator(this);

  // Buttons

  NextItemPosition = ipNewLine;
  DefaultGroup = 0;

  Separator = new TFarSeparator(this);
  Separator->Position = CRect.Bottom - 1;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_OK);
  Button->Default = (Action != saConnect);
  Button->Result = brOK;
  Button->CenterGroup = true;

  NextItemPosition = ipRight;

  ConnectButton = new TFarButton(this);
  ConnectButton->Caption = GetMsg(LOGIN_CONNECT_BUTTON);
  ConnectButton->Default = (Action == saConnect);
  ConnectButton->Result = brConnect;
  ConnectButton->CenterGroup = true;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::Change()
{
  TTabbedDialog::Change();

  if (Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::UpdateControls()
{
  ConnectButton->Enabled = !HostNameEdit->IsEmpty && !UserNameEdit->IsEmpty;

  CipherUpButton->Enabled = CipherListBox->Items->Selected;
  CipherDownButton->Enabled =
    CipherListBox->Items->Selected < CipherListBox->Items->Count - 1;

  AuthKIPasswordCheck->Enabled = AuthTISCheck->Checked || AuthKICheck->Checked;

  CacheDirectoryChangesCheck->Enabled =
    !SCPonlyButton->Checked || CacheDirectoriesCheck->Checked;
  PreserveDirectoryChangesCheck->Enabled =
    CacheDirectoryChangesCheck->Enabled && CacheDirectoryChangesCheck->Checked;

  RecycleBinPathEdit->Enabled = DeleteToRecycleBinCheck->Checked ||
    (OverwrittenToRecycleBinCheck->Checked &&
     OverwrittenToRecycleBinCheck->IsEnabled);
  RecycleBinPathLabel->Enabled = RecycleBinPathEdit->IsEnabled;

  KexUpButton->Enabled = !SshProt1onlyButton->Checked &&
    (KexListBox->Items->Selected > 0);
  KexDownButton->Enabled = !SshProt1onlyButton->Checked &&
    (KexListBox->Items->Selected < KexListBox->Items->Count - 1);

  ProxyPasswordEdit->Enabled = !ProxyNoneButton->Checked &&
    !ProxySocks4Button->Checked;
  ProxyPasswordLabel->Enabled = ProxyPasswordEdit->Enabled;
}
//---------------------------------------------------------------------------
bool __fastcall TSessionDialog::Execute(TSessionData * SessionData, TSessionAction & Action)
{
  int Captions[] = { LOGIN_ADD, LOGIN_EDIT, LOGIN_CONNECT };
  Caption = GetMsg(Captions[Action]);

  HideTabs();
  SelectTab(tabSession);

  // load session data

  // Basic tab
  HostNameEdit->Text = SessionData->HostName;
  PortNumberEdit->AsInteger = SessionData->PortNumber;
  UserNameEdit->Text = SessionData->UserName;
  PasswordEdit->Text = SessionData->Password;
  PrivateKeyEdit->Text = SessionData->PublicKeyFile;

  switch (SessionData->FSProtocol) {
    case fsSCPonly: SCPonlyButton->Checked = true; break;
    case fsSFTP: SFTPButton->Checked = true; break;
    case fsSFTPonly:
    default: SFTPonlyButton->Checked = true; break;
  }

  // Directories tab
  RemoteDirectoryEdit->Text = SessionData->RemoteDirectory;
  UpdateDirectoriesCheck->Checked = SessionData->UpdateDirectories;
  CacheDirectoriesCheck->Checked = SessionData->CacheDirectories;
  CacheDirectoryChangesCheck->Checked = SessionData->CacheDirectoryChanges;
  PreserveDirectoryChangesCheck->Checked = SessionData->PreserveDirectoryChanges;
  ResolveSymlinksCheck->Checked = SessionData->ResolveSymlinks;

  // Environment tab
  if (SessionData->EOLType == eolLF)
  {
    EOLTypeLFButton->Checked = true;
  }
  else
  {
    EOLTypeCRLFButton->Checked = true;
  }
  ConsiderDSTOnCheck->Checked = SessionData->ConsiderDST;
  ConsiderDSTOffCheck->Checked = !SessionData->ConsiderDST;

  DeleteToRecycleBinCheck->Checked = SessionData->DeleteToRecycleBin;
  OverwrittenToRecycleBinCheck->Checked = SessionData->OverwrittenToRecycleBin;
  RecycleBinPathEdit->Text = SessionData->RecycleBinPath;

  // SCP tab
  (SessionData->DefaultShell ? DefaultShellButton : ShellEnterButton)->Checked = true;

  ShellEdit->Text = SessionData->Shell;
  (SessionData->DetectReturnVar ? ReturnVarAutodetectButton : ReturnVarEnterButton)->Checked = true;
  ReturnVarEdit->Text = SessionData->ReturnVar;
  LookupUserGroupsCheck->Checked = SessionData->LookupUserGroups;
  ClearAliasesCheck->Checked = SessionData->ClearAliases;
  IgnoreLsWarningsCheck->Checked = SessionData->IgnoreLsWarnings;
  Scp1CompatibilityCheck->Checked = SessionData->Scp1Compatibility;
  UnsetNationalVarsCheck->Checked = SessionData->UnsetNationalVars;
  AliasGroupListCheck->Checked = SessionData->AliasGroupList;
  SCPLsFullTimeAutoCheck->Checked = (SessionData->SCPLsFullTime != asOff);
  int TimeDifferenceMin = DateTimeToTimeStamp(SessionData->TimeDifference).Time / 60000;
  if (double(SessionData->TimeDifference) < 0)
  {
    TimeDifferenceMin = -TimeDifferenceMin;
  }
  TimeDifferenceEdit->AsInteger = TimeDifferenceMin / 60;
  TimeDifferenceMinutesEdit->AsInteger = TimeDifferenceMin % 60;

  // SFTP tab

  #define BUG(BUGID, MSG, PREFIX, NEGDEP) \
    PREFIX ## Bug ## BUGID ## Combo->Items->Selected = 2 - SessionData->PREFIX ## Bug[sb ## BUGID]
  SFTP_BUGS();
  SFTP_UTF_BUG();

  SFTPMaxVersionCombo->Items->Selected = SessionData->SFTPMaxVersion;

  // Connection tab
  switch (SessionData->PingType)
  {
    case ptNullPacket:
      PingNullPacketButton->Checked = true;
      break;

    case ptDummyCommand:
      PingDummyCommandButton->Checked = true;
      break;

    default:
      PingOffButton->Checked = true;
      break;
  }
  PingIntervalSecEdit->AsInteger = SessionData->PingInterval;
  TimeoutEdit->AsInteger = SessionData->Timeout;

  switch (SessionData->AddressFamily)
  {
    case afIPv4:
      IPv4Button->Checked = true;
      break;

    case afIPv6:
      IPv6Button->Checked = true;
      break;

    case afAuto:
    default:
      IPAutoButton->Checked = true;
      break;
  }

  // Proxy tab
  switch (SessionData->ProxyMethod) {
    case pmHTTP: ProxyHTTPButton->Checked = true; break;
    case pmSocks4: ProxySocks4Button->Checked = true; break;
    case pmSocks5: ProxySocks5Button->Checked = true; break;
    case pmTelnet: ProxyTelnetButton->Checked = true; break;
    default: ProxyNoneButton->Checked = true; break;
  }
  ProxyHostEdit->Text = SessionData->ProxyHost;
  ProxyPortEdit->AsInteger = SessionData->ProxyPort;
  ProxyUsernameEdit->Text = SessionData->ProxyUsername;
  ProxyPasswordEdit->Text = SessionData->ProxyPassword;
  ProxyTelnetCommandEdit->Text = SessionData->ProxyTelnetCommand;
  ProxyLocalhostCheck->Checked = SessionData->ProxyLocalhost;
  switch (SessionData->ProxyDNS) {
    case asOn: ProxyDNSOnButton->Checked = true; break;
    case asOff: ProxyDNSOffButton->Checked = true; break;
    default: ProxyDNSAutoButton->Checked = true; break;
  }

  // SSH tab
  CompressionCheck->Checked = SessionData->Compression;
  Ssh2DESCheck->Checked = SessionData->Ssh2DES;

  switch (SessionData->SshProt) {
    case ssh1only:  SshProt1onlyButton->Checked = true; break;
    case ssh1:      SshProt1Button->Checked = true; break;
    case ssh2:      SshProt2Button->Checked = true; break;
    case ssh2only:  SshProt2onlyButton->Checked = true; break;
  }

  CipherListBox->Items->Clear();
  assert(CIPHER_NAME_WARN+CIPHER_COUNT-1 == CIPHER_NAME_DES);
  for (int Index = 0; Index < CIPHER_COUNT; Index++)
  {
    CipherListBox->Items->AddObject(
      GetMsg(CIPHER_NAME_WARN + int(SessionData->Cipher[Index])),
      (TObject*)SessionData->Cipher[Index]);
  }

  // KEX tab

  RekeyTimeEdit->AsInteger = SessionData->RekeyTime;
  RekeyDataEdit->Text = SessionData->RekeyData;

  KexListBox->Items->Clear();
  assert(KEX_NAME_WARN+KEX_COUNT-1 == KEX_NAME_DHGEX);
  for (int Index = 0; Index < KEX_COUNT; Index++)
  {
    KexListBox->Items->AddObject(
      GetMsg(KEX_NAME_WARN + int(SessionData->Kex[Index])),
      (TObject*)SessionData->Kex[Index]);
  }

  // Authentication tab
  AuthTISCheck->Checked = SessionData->AuthTIS;
  AuthKICheck->Checked = SessionData->AuthKI;
  AuthKIPasswordCheck->Checked = SessionData->AuthKIPassword;
  AgentFwdCheck->Checked = SessionData->AgentFwd;
  AuthGSSAPICheck->Checked = SessionData->AuthGSSAPI;

  // Bugs tab

  BUGS();
  #undef BUG

  int Button = ShowModal();
  bool Result = (Button == brOK || Button == brConnect);
  if (Result)
  {
    if (Button == brConnect)
    {
      Action = saConnect;
    }
    else if (Action == saConnect)
    {
      Action = saEdit;
    }

    // save session data

    // Basic tab
    SessionData->HostName = HostNameEdit->Text;
    SessionData->PortNumber = PortNumberEdit->AsInteger;
    SessionData->UserName = UserNameEdit->Text;
    SessionData->Password = PasswordEdit->Text;
    SessionData->PublicKeyFile = PrivateKeyEdit->Text;

    if (SCPonlyButton->Checked)
    {
      SessionData->FSProtocol = fsSCPonly;
    }
    else if (SFTPButton->Checked)
    {
      SessionData->FSProtocol = fsSFTP;
    }
    else
    {
      SessionData->FSProtocol = fsSFTPonly;
    }

    // Directories tab
    SessionData->RemoteDirectory = RemoteDirectoryEdit->Text;
    SessionData->UpdateDirectories = UpdateDirectoriesCheck->Checked;
    SessionData->CacheDirectories = CacheDirectoriesCheck->Checked;
    SessionData->CacheDirectoryChanges = CacheDirectoryChangesCheck->Checked;
    SessionData->PreserveDirectoryChanges = PreserveDirectoryChangesCheck->Checked;
    SessionData->ResolveSymlinks = ResolveSymlinksCheck->Checked;

    // Environment tab
    SessionData->EOLType = EOLTypeLFButton->Checked ? eolLF : eolCRLF;
    SessionData->ConsiderDST = ConsiderDSTOnCheck->Checked;

    SessionData->DeleteToRecycleBin = DeleteToRecycleBinCheck->Checked;
    SessionData->OverwrittenToRecycleBin = OverwrittenToRecycleBinCheck->Checked;
    SessionData->RecycleBinPath = RecycleBinPathEdit->Text;

    // SCP tab
    SessionData->DefaultShell = DefaultShellButton->Checked;
    if (ShellEnterButton->Checked)
      SessionData->Shell = ShellEdit->Text;
    SessionData->DetectReturnVar = ReturnVarAutodetectButton->Checked;
    if (ReturnVarEnterButton->Checked)
      SessionData->ReturnVar = ReturnVarEdit->Text;
    SessionData->LookupUserGroups = LookupUserGroupsCheck->Checked;
    SessionData->ClearAliases = ClearAliasesCheck->Checked;
    SessionData->IgnoreLsWarnings = IgnoreLsWarningsCheck->Checked;
    SessionData->Scp1Compatibility = Scp1CompatibilityCheck->Checked;
    if (EOLTypeLFButton->Checked) SessionData->EOLType = eolLF;
      else SessionData->EOLType = eolCRLF;
    SessionData->UnsetNationalVars = UnsetNationalVarsCheck->Checked;
    SessionData->AliasGroupList = AliasGroupListCheck->Checked;
    SessionData->SCPLsFullTime = SCPLsFullTimeAutoCheck->Checked ? asAuto : asOff;
    SessionData->TimeDifference =
      (double(TimeDifferenceEdit->AsInteger) / 24) +
      (double(TimeDifferenceMinutesEdit->AsInteger) / 24 / 60);

    // SFTP tab

    #define BUG(BUGID, MSG, PREFIX, NEGDEP) \
      SessionData->PREFIX ## Bug[sb ## BUGID] = (TAutoSwitch)(2 - PREFIX ## Bug ## BUGID ## Combo->Items->Selected);
    SFTP_BUGS();
    SFTP_UTF_BUG();

    SessionData->SFTPMaxVersion = SFTPMaxVersionCombo->Items->Selected;

    // Connection tab
    if (PingNullPacketButton->Checked)
    {
      SessionData->PingType = ptNullPacket;
    }
    else if (PingDummyCommandButton->Checked)
    {
      SessionData->PingType = ptDummyCommand;
    }
    else
    {
      SessionData->PingType = ptOff;
    }
    SessionData->PingInterval = PingIntervalSecEdit->AsInteger;
    SessionData->Timeout = TimeoutEdit->AsInteger;

    if (IPv4Button->Checked)
    {
      SessionData->AddressFamily = afIPv4;
    }
    else if (IPv6Button->Checked)
    {
      SessionData->AddressFamily = afIPv6;
    }
    else
    {
      SessionData->AddressFamily = afAuto;
    }

    // Proxy tab
    if (ProxyHTTPButton->Checked) SessionData->ProxyMethod = pmHTTP;
      else
    if (ProxySocks4Button->Checked) SessionData->ProxyMethod = pmSocks4;
      else
    if (ProxySocks5Button->Checked) SessionData->ProxyMethod = pmSocks5;
      else
    if (ProxyTelnetButton->Checked) SessionData->ProxyMethod = pmTelnet;
      else SessionData->ProxyMethod = pmNone;

    SessionData->ProxyHost = ProxyHostEdit->Text;
    SessionData->ProxyPort = ProxyPortEdit->AsInteger;
    SessionData->ProxyUsername = ProxyUsernameEdit->Text;
    SessionData->ProxyPassword = ProxyPasswordEdit->Text;
    SessionData->ProxyTelnetCommand = ProxyTelnetCommandEdit->Text;
    SessionData->ProxyLocalhost = ProxyLocalhostCheck->Checked;

    if (ProxyDNSOnButton->Checked) SessionData->ProxyDNS = asOn;
      else
    if (ProxyDNSOffButton->Checked) SessionData->ProxyDNS = asOff;
      else SessionData->ProxyDNS = asAuto;

    // SSH tab
    SessionData->Compression = CompressionCheck->Checked;
    SessionData->Ssh2DES = Ssh2DESCheck->Checked;

    if (SshProt1onlyButton->Checked) SessionData->SshProt = ssh1only;
      else
    if (SshProt1Button->Checked) SessionData->SshProt = ssh1;
      else
    if (SshProt2Button->Checked) SessionData->SshProt = ssh2;
      else SessionData->SshProt = ssh2only;

    for (int Index = 0; Index < CIPHER_COUNT; Index++)
    {
      SessionData->Cipher[Index] = (TCipher)CipherListBox->Items->Objects[Index];
    }

    // KEX tab

    SessionData->RekeyTime = RekeyTimeEdit->AsInteger;
    SessionData->RekeyData = RekeyDataEdit->Text;

    for (int Index = 0; Index < KEX_COUNT; Index++)
    {
      SessionData->Kex[Index] = (TKex)KexListBox->Items->Objects[Index];
    }

    // Authentication tab
    SessionData->AuthTIS = AuthTISCheck->Checked;
    SessionData->AuthKI = AuthKICheck->Checked;
    SessionData->AuthKIPassword = AuthKIPasswordCheck->Checked;
    SessionData->AgentFwd = AgentFwdCheck->Checked;
    SessionData->AuthGSSAPI = AuthGSSAPICheck->Checked;

    // Bugs tab

    BUGS();
    #undef BUG
  }

  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TSessionDialog::CloseQuery()
{
  bool CanClose = TTabbedDialog::CloseQuery();

  TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);

  if (CanClose && (Result != brCancel) && !PrivateKeyEdit->Text.Trim().IsEmpty())
  {
    AnsiString FileName = PrivateKeyEdit->Text;
    TKeyType Type = KeyType(FileName);
    AnsiString Message;
    switch (Type)
    {
      case ktOpenSSH:
        Message = FMTLOAD(KEY_TYPE_UNSUPPORTED, (FileName, "OpenSSH SSH-2"));
        break;

      case ktSSHCom:
        Message = FMTLOAD(KEY_TYPE_UNSUPPORTED, (FileName, "ssh.com SSH-2"));
        break;

      case ktSSH1:
      case ktSSH2:
        if ((Type == ktSSH1) !=
              (SshProt1onlyButton->Checked || SshProt1Button->Checked))
        {
          Message = FMTLOAD(KEY_TYPE_DIFFERENT_SSH,
            (FileName, (Type == ktSSH1 ? "SSH-1" : "PuTTY SSH-2")));
        }
        break;

      default:
        assert(false);
        // fallthru
      case ktUnopenable:
      case ktUnknown:
        Message = FMTLOAD(KEY_TYPE_UNKNOWN, (FileName));
        break;
    }

    if (!Message.IsEmpty())
    {
      CanClose = (WinSCPPlugin->MoreMessageDialog(Message, NULL, qtWarning,
        qaIgnore | qaAbort) != qaAbort);
    }
  }

  if (CanClose && !PasswordEdit->Text.IsEmpty() &&
      !Configuration->DisablePasswordStoring &&
      (((Result == brOK)) ||
       ((Result == brConnect) && (FAction == saEdit))))
  {
    CanClose = (WinSCPPlugin->MoreMessageDialog(GetMsg(SAVE_PASSWORD), NULL,
      qtWarning, qaOK | qaCancel) == qaOK);
  }
  
  return CanClose;
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::CipherButtonClick(TFarButton * Sender, bool & Close)
{
  if (Sender->Enabled)
  {
    int Source = CipherListBox->Items->Selected;
    int Dest = Source + Sender->Result;

    CipherListBox->Items->Move(Source, Dest);
    CipherListBox->Items->Selected = Dest;
  }

  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::KexButtonClick(TFarButton * Sender, bool & Close)
{
  if (Sender->Enabled)
  {
    int Source = KexListBox->Items->Selected;
    int Dest = Source + Sender->Result;

    KexListBox->Items->Move(Source, Dest);
    KexListBox->Items->Selected = Dest;
  }

  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TSessionDialog::AuthGSSAPICheckAllowChange(TFarDialogItem * /*Sender*/,
  long NewState, bool & Allow)
{
  if ((NewState == BSTATE_CHECKED) && !Configuration->GSSAPIInstalled)
  {
    Allow = false;
    TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);

    WinSCPPlugin->MoreMessageDialog(GetMsg(GSSAPI_NOT_INSTALLED),
      NULL, qtError, qaOK);
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::SessionDialog(TSessionData * SessionData,
  TSessionAction & Action)
{
  bool Result;
  TSessionDialog * Dialog = new TSessionDialog(FPlugin, Action);
  try
  {
    Result = Dialog->Execute(SessionData, Action);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TRightsContainer : public TFarDialogContainer
{
public:
  __fastcall TRightsContainer(TFarDialog * ADialog, bool AAnyDirectories,
    bool ShowButtons, bool ShowSpecials,
    TFarDialogItem * EnabledDependency);
  __property bool AddXToDirectories = { read = GetAddXToDirectories, write = SetAddXToDirectories };
  __property TRights Rights = { read = GetRights, write = SetRights };
  __property TFarCheckBox * Checks[TRights::TRight Right] = { read = GetChecks };
  __property TRights::TState States[TRights::TRight Right] = { read = GetStates, write = SetStates };
  __property bool AllowUndef = { read = GetAllowUndef, write = SetAllowUndef };

protected:
  bool FAnyDirectories;
  TFarCheckBox * FCheckBoxes[12];
  TRights::TState FFixedStates[12];
  TFarEdit * OctalEdit;
  TFarCheckBox * DirectoriesXCheck;

  virtual void __fastcall Change();
  void __fastcall UpdateControls();

private:
  TRights __fastcall GetRights();
  void __fastcall SetRights(const TRights & value);
  void __fastcall SetAddXToDirectories(bool value);
  bool __fastcall GetAddXToDirectories();
  TFarCheckBox * __fastcall GetChecks(TRights::TRight Right);
  TRights::TState __fastcall GetStates(TRights::TRight Right);
  bool __fastcall GetAllowUndef();
  void __fastcall SetAllowUndef(bool value);
  void __fastcall SetStates(TRights::TRight Flag, TRights::TState value);
  void __fastcall OctalEditExit(TObject * Sender);
  void __fastcall RightsButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TRightsContainer::TRightsContainer(TFarDialog * ADialog,
  bool AAnyDirectories, bool ShowButtons,
  bool ShowSpecials, TFarDialogItem * EnabledDependency) :
  TFarDialogContainer(ADialog)
{
  FAnyDirectories = AAnyDirectories;

  TFarButton * Button;
  TFarText * Text;
  TFarCheckBox * CheckBox;

  Dialog->NextItemPosition = ipNewLine;

  static int RowLabels[] = { PROPERTIES_OWNER_RIGHTS, PROPERTIES_GROUP_RIGHTS,
    PROPERTIES_OTHERS_RIGHTS };
  static int ColLabels[] = { PROPERTIES_READ_RIGHTS, PROPERTIES_WRITE_RIGHTS,
    PROPERTIES_EXECUTE_RIGHTS };
  static int SpecialLabels[] = { PROPERTIES_SETUID_RIGHTS, PROPERTIES_SETGID_RIGHTS,
    PROPERTIES_STICKY_BIT_RIGHTS };

  for (int RowIndex = 0; RowIndex < 3; RowIndex++)
  {
    Dialog->NextItemPosition = ipNewLine;
    Text = new TFarText(Dialog);
    if (RowIndex == 0)
    {
      Text->Top = 0;
    }
    Text->Left = 0;
    Add(Text);
    Text->EnabledDependency = EnabledDependency;
    Text->Caption = GetMsg(RowLabels[RowIndex]);

    Dialog->NextItemPosition = ipRight;

    for (int ColIndex = 0; ColIndex < 3; ColIndex++)
    {
      CheckBox = new TFarCheckBox(Dialog);
      FCheckBoxes[(RowIndex + 1)* 3 + ColIndex] = CheckBox;
      Add(CheckBox);
      CheckBox->EnabledDependency = EnabledDependency;
      CheckBox->Caption = GetMsg(ColLabels[ColIndex]);
    }

    if (ShowSpecials)
    {
      CheckBox = new TFarCheckBox(Dialog);
      Add(CheckBox);
      CheckBox->Visible = ShowSpecials;
      CheckBox->EnabledDependency = EnabledDependency;
      CheckBox->Caption = GetMsg(SpecialLabels[RowIndex]);
      FCheckBoxes[RowIndex] = CheckBox;
    }
    else
    {
      FCheckBoxes[RowIndex] = NULL;
      FFixedStates[RowIndex] = TRights::rsNo;
    }
  }

  Dialog->NextItemPosition = ipNewLine;

  Text = new TFarText(Dialog);
  Add(Text);
  Text->EnabledDependency = EnabledDependency;
  Text->Left = 0;
  Text->Caption = GetMsg(PROPERTIES_OCTAL);

  Dialog->NextItemPosition = ipRight;

  OctalEdit = new TFarEdit(Dialog);
  Add(OctalEdit);
  OctalEdit->EnabledDependency = EnabledDependency;
  OctalEdit->Width = 5;
  OctalEdit->Mask = "9999";
  OctalEdit->OnExit = OctalEditExit;

  if (ShowButtons)
  {
    Dialog->NextItemPosition = ipRight;

    Button = new TFarButton(Dialog);
    Add(Button);
    Button->EnabledDependency = EnabledDependency;
    Button->Caption = GetMsg(PROPERTIES_NONE_RIGHTS);
    Button->Tag = TRights::rfNo;
    Button->OnClick = RightsButtonClick;

    Button = new TFarButton(Dialog);
    Add(Button);
    Button->EnabledDependency = EnabledDependency;
    Button->Caption = GetMsg(PROPERTIES_DEFAULT_RIGHTS);
    Button->Tag = TRights::rfDefault;
    Button->OnClick = RightsButtonClick;

    Button = new TFarButton(Dialog);
    Add(Button);
    Button->EnabledDependency = EnabledDependency;
    Button->Caption = GetMsg(PROPERTIES_ALL_RIGHTS);
    Button->Tag = TRights::rfAll;
    Button->OnClick = RightsButtonClick;
  }

  Dialog->NextItemPosition = ipNewLine;

  if (FAnyDirectories)
  {
    DirectoriesXCheck = new TFarCheckBox(Dialog);
    Add(DirectoriesXCheck);
    DirectoriesXCheck->EnabledDependency = EnabledDependency;
    DirectoriesXCheck->Left = 0;
    DirectoriesXCheck->Caption = GetMsg(PROPERTIES_DIRECTORIES_X);
  }
  else
  {
    DirectoriesXCheck = NULL;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::RightsButtonClick(TFarButton * Sender,
  bool & /*Close*/)
{
  TRights R = Rights;
  R.Number = (unsigned short)Sender->Tag;
  Rights = R;
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::OctalEditExit(TObject * /*Sender*/)
{
  if (!OctalEdit->Text.Trim().IsEmpty())
  {
    TRights R = Rights;
    R.Octal = OctalEdit->Text.Trim();
    Rights = R;
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::UpdateControls()
{
  if (Dialog->Handle)
  {
    TRights R = Rights;

    if (DirectoriesXCheck)
    {
      DirectoriesXCheck->Enabled =
        !((R.NumberSet & TRights::rfExec) == TRights::rfExec);
    }

    if (!OctalEdit->Focused())
    {
      OctalEdit->Text = R.IsUndef ? AnsiString() : R.Octal;
    }
    else if (OctalEdit->Text.Trim().Length() >= 3)
    {
      try
      {
        OctalEditExit(NULL);
      }
      catch(...)
      {
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::Change()
{
  TFarDialogContainer::Change();

  if (Dialog->Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
TFarCheckBox * __fastcall TRightsContainer::GetChecks(TRights::TRight Right)
{
  assert((Right >= 0) && (Right < LENOF(FCheckBoxes)));
  return FCheckBoxes[Right];
}
//---------------------------------------------------------------------------
TRights::TState __fastcall TRightsContainer::GetStates(TRights::TRight Right)
{
  TFarCheckBox * CheckBox = Checks[Right];
  if (CheckBox != NULL)
  {
    switch (CheckBox->Selected) {
      case BSTATE_UNCHECKED: return TRights::rsNo;
      case BSTATE_CHECKED: return TRights::rsYes;
      case BSTATE_3STATE:
      default: return TRights::rsUndef;
    }
  }
  else
  {
    return FFixedStates[Right];
  }
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::SetStates(TRights::TRight Right,
  TRights::TState value)
{
  TFarCheckBox * CheckBox = Checks[Right];
  if (CheckBox != NULL)
  {
    switch (value) {
      case TRights::rsNo: CheckBox->Selected = BSTATE_UNCHECKED; break;
      case TRights::rsYes: CheckBox->Selected = BSTATE_CHECKED; break;
      case TRights::rsUndef: CheckBox->Selected = BSTATE_3STATE; break;
    }
  }
  else
  {
    FFixedStates[Right]= value;
  }
}
//---------------------------------------------------------------------------
TRights __fastcall TRightsContainer::GetRights()
{
  TRights Result;
  Result.AllowUndef = AllowUndef;
  for (int Right = 0; Right < LENOF(FCheckBoxes); Right++)
  {
    Result.RightUndef[static_cast<TRights::TRight>(Right)] =
      States[static_cast<TRights::TRight>(Right)];
  }
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::SetRights(const TRights & value)
{
  if (Rights != value)
  {
    Dialog->LockChanges();
    try
    {
      AllowUndef = true; // temporarily
      for (int Right = 0; Right < LENOF(FCheckBoxes); Right++)
      {
        States[static_cast<TRights::TRight>(Right)] =
          value.RightUndef[static_cast<TRights::TRight>(Right)];
      }
      AllowUndef = value.AllowUndef;
    }
    __finally
    {
      Dialog->UnlockChanges();
    }
  }
}
//---------------------------------------------------------------------------
bool __fastcall TRightsContainer::GetAddXToDirectories()
{
  return DirectoriesXCheck ? DirectoriesXCheck->Checked : false;
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::SetAddXToDirectories(bool value)
{
  if (DirectoriesXCheck)
  {
    DirectoriesXCheck->Checked = value;
  }
}
//---------------------------------------------------------------------------
bool __fastcall TRightsContainer::GetAllowUndef()
{
  assert(FCheckBoxes[LENOF(FCheckBoxes) - 1] != NULL);
  return FCheckBoxes[LENOF(FCheckBoxes) - 1]->AllowGrayed;
}
//---------------------------------------------------------------------------
void __fastcall TRightsContainer::SetAllowUndef(bool value)
{
  for (int Right = 0; Right < LENOF(FCheckBoxes); Right++)
  {
    if (FCheckBoxes[Right] != NULL)
    {
      FCheckBoxes[Right]->AllowGrayed = value;
    }
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TPropertiesDialog : public TFarDialog
{
public:
  __fastcall TPropertiesDialog(TCustomFarPlugin * AFarPlugin, TStrings * FileList,
    const AnsiString Directory, TStrings * GroupList, TStrings * UserList,
    int AllowedChanges);

  bool __fastcall Execute(TRemoteProperties * Properties);

protected:
  virtual void __fastcall Change();
  void __fastcall UpdateProperties(TRemoteProperties & Properties);

private:
  bool FAnyDirectories;
  int FAllowedChanges;
  TRemoteProperties FOrigProperties;
  bool FMultiple;

  TRightsContainer * RightsContainer;
  TFarComboBox * OwnerComboBox;
  TFarComboBox * GroupComboBox;
  TFarCheckBox * RecursiveCheck;
  TFarButton * OkButton;
};
//---------------------------------------------------------------------------
__fastcall TPropertiesDialog::TPropertiesDialog(TCustomFarPlugin * AFarPlugin,
  TStrings * FileList, const AnsiString Directory, TStrings * GroupList,
  TStrings * UserList, int AAllowedChanges) : TFarDialog(AFarPlugin)
{
  FAllowedChanges = AAllowedChanges;

  assert(FileList->Count > 0);
  TRemoteFile * OnlyFile = dynamic_cast<TRemoteFile *>(FileList->Objects[0]);
  USEDPARAM(OnlyFile);
  assert(OnlyFile);
  FMultiple = (FileList->Count > 1);
  TRemoteFile * File;
  int Directories = 0;

  TStringList * UsedGroupList = NULL;
  TStringList * UsedUserList = NULL;

  try
  {
    if ((GroupList == NULL) || (GroupList->Count == 0))
    {
      UsedGroupList = new TStringList();
      UsedGroupList->Duplicates = dupIgnore;
      UsedGroupList->Sorted = true;
    }
    if ((UserList == NULL) || (UserList->Count == 0))
    {
      UsedUserList = new TStringList();
      UsedUserList->Duplicates = dupIgnore;
      UsedUserList->Sorted = true;
    }

    for (int Index = 0; Index < FileList->Count; Index++)
    {
      File = dynamic_cast<TRemoteFile *>(FileList->Objects[Index]);
      assert(File);
      if (UsedGroupList && !File->Group.IsEmpty())
      {
        UsedGroupList->Add(File->Group);
      }
      if (UsedUserList && !File->Owner.IsEmpty())
      {
        UsedUserList->Add(File->Owner);
      }
      if (File->IsDirectory)
      {
        Directories++;
      }
    }
    FAnyDirectories = (Directories > 0);

    Caption = GetMsg(PROPERTIES_CAPTION);

    Size = TPoint(56, 19);

    TFarButton * Button;
    TFarSeparator * Separator;
    TFarText * Text;
    TRect CRect = ClientRect;

    Text = new TFarText(this);
    Text->Caption = GetMsg(PROPERTIES_PROMPT);
    Text->CenterGroup = true;

    NextItemPosition = ipNewLine;

    Text = new TFarText(this);
    Text->CenterGroup = true;
    if (FileList->Count > 1)
    {
      Text->Caption = FORMAT(GetMsg(PROPERTIES_PROMPT_FILES), (FileList->Count));
    }
    else
    {
      Text->Caption = MinimizeName(FileList->Strings[0], ClientSize.x, true);
    }

    new TFarSeparator(this);

    Text = new TFarText(this);
    Text->Caption = GetMsg(PROPERTIES_OWNER);
    Text->Enabled = FAllowedChanges & cpOwner;

    NextItemPosition = ipRight;

    OwnerComboBox = new TFarComboBox(this);
    OwnerComboBox->Width = 20;
    OwnerComboBox->Enabled = FAllowedChanges & cpOwner;
    OwnerComboBox->Items->Assign(UsedUserList ? UsedUserList : UserList);

    NextItemPosition = ipNewLine;

    Text = new TFarText(this);
    Text->Caption = GetMsg(PROPERTIES_GROUP);
    Text->Enabled = FAllowedChanges & cpGroup;

    NextItemPosition = ipRight;

    GroupComboBox = new TFarComboBox(this);
    GroupComboBox->Width = OwnerComboBox->Width;
    GroupComboBox->Enabled = FAllowedChanges & cpGroup;
    GroupComboBox->Items->Assign(UsedGroupList ? UsedGroupList : GroupList);

    NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(this);
    Separator->Caption = GetMsg(PROPERTIES_RIGHTS);

    RightsContainer = new TRightsContainer(this, FAnyDirectories,
      true, true, NULL);
    RightsContainer->Enabled = FAllowedChanges & cpMode;

    if (FAnyDirectories)
    {
      Separator = new TFarSeparator(this);
      Separator->Position = Separator->Position + RightsContainer->Top;

      RecursiveCheck = new TFarCheckBox(this);
      RecursiveCheck->Caption = GetMsg(PROPERTIES_RECURSIVE);
    }
    else
    {
      RecursiveCheck = NULL;
    }

    NextItemPosition = ipNewLine;

    Separator = new TFarSeparator(this);
    Separator->Position = CRect.Bottom - 1;

    OkButton = new TFarButton(this);
    OkButton->Caption = GetMsg(MSG_BUTTON_OK);
    OkButton->Default = true;
    OkButton->Result = brOK;
    OkButton->CenterGroup = true;

    NextItemPosition = ipRight;

    Button = new TFarButton(this);
    Button->Caption = GetMsg(MSG_BUTTON_Cancel);
    Button->Result = brCancel;
    Button->CenterGroup = true;
  }
  __finally
  {
    delete UsedUserList;
    delete UsedGroupList;
  }
}
//---------------------------------------------------------------------------
void __fastcall TPropertiesDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    TRemoteProperties FileProperties;
    UpdateProperties(FileProperties);

    if (!FMultiple)
    {
      // when setting properties for one file only, allow undef state
      // only when the input right explicitly requires it or
      // when "recursive" is on (possible for directory only).
      RightsContainer->AllowUndef =
        (FOrigProperties.Valid.Contains(vpRights) &&
         FOrigProperties.Rights.AllowUndef) ||
        ((RecursiveCheck != NULL) && (RecursiveCheck->Checked));
    }

    OkButton->Enabled =
      // group name is specified or we set multiple-file properties and
      // no valid group was specified (there are at least two different groups)
      (!GroupComboBox->Text.IsEmpty() ||
       (FMultiple && !FOrigProperties.Valid.Contains(vpGroup)) ||
       (FOrigProperties.Group == GroupComboBox->Text)) &&
      // same but with owner
      (!OwnerComboBox->Text.IsEmpty() ||
       (FMultiple && !FOrigProperties.Valid.Contains(vpOwner)) ||
       (FOrigProperties.Owner == OwnerComboBox->Text)) &&
      ((FileProperties != FOrigProperties) || (RecursiveCheck && RecursiveCheck->Checked));
  }
}
//---------------------------------------------------------------------------
void __fastcall TPropertiesDialog::UpdateProperties(TRemoteProperties & Properties)
{
  if (FAllowedChanges & cpMode)
  {
    Properties.Valid << vpRights;
    Properties.Rights = RightsContainer->Rights;
    Properties.AddXToDirectories = RightsContainer->AddXToDirectories;
  }

  #define STORE_NAME(PROPERTY) \
    if (!PROPERTY ## ComboBox->Text.IsEmpty() && \
        FAllowedChanges & cp ## PROPERTY) \
    { \
      Properties.Valid << vp ## PROPERTY; \
      Properties.PROPERTY = PROPERTY ## ComboBox->Text.Trim(); \
    }
  STORE_NAME(Group);
  STORE_NAME(Owner);
  #undef STORE_NAME

  Properties.Recursive = RecursiveCheck != NULL && RecursiveCheck->Checked;
}
//---------------------------------------------------------------------------
bool __fastcall TPropertiesDialog::Execute(TRemoteProperties * Properties)
{
  TValidProperties Valid;
  if (Properties->Valid.Contains(vpRights) && FAllowedChanges & cpMode) Valid << vpRights;
  if (Properties->Valid.Contains(vpOwner) && FAllowedChanges & cpOwner) Valid << vpOwner;
  if (Properties->Valid.Contains(vpGroup) && FAllowedChanges & cpGroup) Valid << vpGroup;
  FOrigProperties = *Properties;
  FOrigProperties.Valid = Valid;
  FOrigProperties.Recursive = false;

  if (Properties->Valid.Contains(vpRights))
  {
    RightsContainer->Rights = Properties->Rights;
    RightsContainer->AddXToDirectories = Properties->AddXToDirectories;
  }
    else
  {
    RightsContainer->Rights = TRights();
    RightsContainer->AddXToDirectories = false;
  }
  OwnerComboBox->Text = Properties->Valid.Contains(vpOwner) ?
    Properties->Owner : AnsiString();
  GroupComboBox->Text = Properties->Valid.Contains(vpGroup) ?
    Properties->Group : AnsiString();
  if (RecursiveCheck)
  {
    RecursiveCheck->Checked = Properties->Recursive;
  }

  bool Result = ShowModal() != brCancel;
  if (Result)
  {
    *Properties = TRemoteProperties();
    UpdateProperties(*Properties);
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::PropertiesDialog(TStrings * FileList,
  const AnsiString Directory, TStrings * GroupList, TStrings * UserList,
  TRemoteProperties * Properties, int AllowedChanges)
{
  bool Result;
  TPropertiesDialog * Dialog = new TPropertiesDialog(FPlugin, FileList,
    Directory, GroupList, UserList, AllowedChanges);
  try
  {
    Result = Dialog->Execute(Properties);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
enum TParamsForDirection { pdToRemote, pdToLocal, pdAll };
//---------------------------------------------------------------------------
class TCopyParamsContainer : public TFarDialogContainer
{
public:
  __fastcall TCopyParamsContainer(TFarDialog * ADialog,
    TParamsForDirection Direction, int Options, int CopyParamAttrs, int MaxHeight);

  __property TCopyParamType Params = { read = GetParams, write = SetParams };
  __property int Height = { read = GetHeight };

protected:
  TFarRadioButton * TMTextButton;
  TFarRadioButton * TMBinaryButton;
  TFarRadioButton * TMAutomaticButton;
  TFarEdit * AsciiFileMaskEdit;
  TRightsContainer * RightsContainer;
  TFarRadioButton * CCNoChangeButton;
  TFarRadioButton * CCUpperCaseButton;
  TFarRadioButton * CCLowerCaseButton;
  TFarRadioButton * CCFirstUpperCaseButton;
  TFarRadioButton * CCLowerCaseShortButton;
  TFarCheckBox * ReplaceInvalidCharsCheck;
  TFarCheckBox * PreserveRightsCheck;
  TFarCheckBox * PreserveTimeCheck;
  TFarCheckBox * PreserveReadOnlyCheck;
  TFarCheckBox * IgnorePermErrorsCheck;
  TFarCheckBox * ClearArchiveCheck;
  TFarComboBox * NegativeExcludeCombo;
  TFarEdit * ExcludeFileMaskCombo;

  void __fastcall ValidateMaskComboExit(TObject * Sender);
  virtual void __fastcall Change();
  void __fastcall UpdateControls();

private:
  TParamsForDirection FDirection;
  int FOptions;
  bool FShowOther;
  int FCopyParamAttrs;
  TCopyParamType FParams;

  void __fastcall SetParams(TCopyParamType value);
  TCopyParamType __fastcall GetParams();
  int __fastcall GetHeight();
};
//---------------------------------------------------------------------------
__fastcall TCopyParamsContainer::TCopyParamsContainer(TFarDialog * ADialog,
  TParamsForDirection Direction, int Options, int CopyParamAttrs, int MaxHeight) :
  TFarDialogContainer(ADialog),
  FDirection(Direction), FOptions(Options), FCopyParamAttrs(CopyParamAttrs)
{
  TFarBox * Box;
  TFarSeparator * Separator;
  TFarText * Text;

  int TMWidth = 37;
  int TMTop;
  int TMBottom;

  FShowOther = (MaxHeight <= 0) || (MaxHeight >= 13);

  Left--;

  Box = new TFarBox(Dialog);
  Box->Left = 0;
  Box->Top = 0;
  Box->Height = 1;
  Add(Box);
  Box->Width = TMWidth + 2;
  Box->Caption = GetMsg(TRANSFER_MODE);

  Dialog->NextItemPosition = ipRight;

  Box = new TFarBox(Dialog);
  Add(Box);
  Box->Left -= 2;
  Box->Right++;
  Box->Caption = GetMsg(
    (Direction == pdAll) ? TRANSFER_UPLOAD_OPTIONS : TRANSFER_ATTRIBUTES);

  Dialog->NextItemPosition = ipNewLine;

  TMTextButton = new TFarRadioButton(Dialog);
  TMTextButton->Left = 1;
  Add(TMTextButton);
  TMTop = TMTextButton->Top;
  TMTextButton->Caption = GetMsg(TRANSFER_MODE_TEXT);
  TMTextButton->Enabled =
    FLAGCLEAR(CopyParamAttrs, cpaNoTransferMode) &&
    FLAGCLEAR(CopyParamAttrs, cpaExcludeMaskOnly);

  TMBinaryButton = new TFarRadioButton(Dialog);
  TMBinaryButton->Left = 1;
  Add(TMBinaryButton);
  TMBinaryButton->Caption = GetMsg(TRANSFER_MODE_BINARY);
  TMBinaryButton->Enabled = TMTextButton->Enabled;

  TMAutomaticButton = new TFarRadioButton(Dialog);
  TMAutomaticButton->Left = 1;
  Add(TMAutomaticButton);
  TMAutomaticButton->Caption = GetMsg(TRANSFER_MODE_AUTOMATIC);
  TMAutomaticButton->Enabled = TMTextButton->Enabled;

  Text = new TFarText(Dialog);
  Text->Left = 1;
  Add(Text);
  Text->Caption = GetMsg(TRANSFER_MODE_MASK);
  Text->EnabledDependency = TMAutomaticButton;

  AsciiFileMaskEdit = new TFarEdit(Dialog);
  AsciiFileMaskEdit->Left = 1;
  Add(AsciiFileMaskEdit);
  AsciiFileMaskEdit->EnabledDependency = TMAutomaticButton;
  AsciiFileMaskEdit->Width = TMWidth;
  AsciiFileMaskEdit->History = ASCII_MASK_HISTORY;
  AsciiFileMaskEdit->OnExit = ValidateMaskComboExit;

  Box = new TFarBox(Dialog);
  Box->Left = 0;
  Add(Box);
  Box->Width = TMWidth + 2;
  Box->Caption = GetMsg(TRANSFER_FILENAME_MODIFICATION);

  CCNoChangeButton = new TFarRadioButton(Dialog);
  CCNoChangeButton->Left = 1;
  Add(CCNoChangeButton);
  CCNoChangeButton->Caption = GetMsg(TRANSFER_FILENAME_NOCHANGE);
  CCNoChangeButton->Enabled = FLAGCLEAR(CopyParamAttrs, cpaExcludeMaskOnly);

  Dialog->NextItemPosition = ipRight;

  CCUpperCaseButton = new TFarRadioButton(Dialog);
  Add(CCUpperCaseButton);
  CCUpperCaseButton->Caption = GetMsg(TRANSFER_FILENAME_UPPERCASE);
  CCUpperCaseButton->Enabled = CCNoChangeButton->Enabled;

  Dialog->NextItemPosition = ipNewLine;

  CCFirstUpperCaseButton = new TFarRadioButton(Dialog);
  CCFirstUpperCaseButton->Left = 1;
  Add(CCFirstUpperCaseButton);
  CCFirstUpperCaseButton->Caption = GetMsg(TRANSFER_FILENAME_FIRSTUPPERCASE);
  CCFirstUpperCaseButton->Enabled = CCNoChangeButton->Enabled;

  Dialog->NextItemPosition = ipRight;

  CCLowerCaseButton = new TFarRadioButton(Dialog);
  Add(CCLowerCaseButton);
  CCLowerCaseButton->Caption = GetMsg(TRANSFER_FILENAME_LOWERCASE);
  CCLowerCaseButton->Enabled = CCNoChangeButton->Enabled;

  Dialog->NextItemPosition = ipNewLine;

  CCLowerCaseShortButton = new TFarRadioButton(Dialog);
  CCLowerCaseShortButton->Left = 1;
  Add(CCLowerCaseShortButton);
  CCLowerCaseShortButton->Caption = GetMsg(TRANSFER_FILENAME_LOWERCASESHORT);
  CCLowerCaseShortButton->Enabled = CCNoChangeButton->Enabled;

  if ((Direction == pdToLocal) || (Direction == pdAll))
  {
    Dialog->NextItemPosition = (Direction == pdToLocal) ? ipRight : ipNewLine;
    
    ReplaceInvalidCharsCheck = new TFarCheckBox(Dialog);
    Add(ReplaceInvalidCharsCheck);
    if (Direction == pdAll)
    {
      ReplaceInvalidCharsCheck->Left = 1;
    }
    ReplaceInvalidCharsCheck->Caption = GetMsg(TRANSFER_FILENAME_REPLACE_INVALID);
    ReplaceInvalidCharsCheck->Enabled = CCNoChangeButton->Enabled;

    TMBottom = ReplaceInvalidCharsCheck->Top;

    Dialog->NextItemPosition = ipNewLine;
  }
  else
  {
    TMBottom = CCLowerCaseShortButton->Top;
  }

  if ((Direction == pdToRemote) || (Direction == pdAll))
  {
    PreserveRightsCheck = new TFarCheckBox(Dialog);
    Add(PreserveRightsCheck);
    PreserveRightsCheck->Left = TMWidth + 3;
    PreserveRightsCheck->Top = TMTop;
    PreserveRightsCheck->Bottom = TMTop;
    PreserveRightsCheck->Caption = GetMsg(TRANSFER_PRESERVE_RIGHTS);
    PreserveRightsCheck->Enabled =
      FLAGCLEAR(CopyParamAttrs, cpaExcludeMaskOnly) &&
      FLAGCLEAR(CopyParamAttrs, cpaNoRights);

    Dialog->NextItemPosition = ipBelow;

    RightsContainer = new TRightsContainer(Dialog, true, false,
      false, PreserveRightsCheck);
    RightsContainer->Left = PreserveRightsCheck->ActualBounds.Left;
    RightsContainer->Top = PreserveRightsCheck->ActualBounds.Top + 1;
  }

  if (Direction == pdToRemote)
  {
    PreserveTimeCheck = new TFarCheckBox(Dialog);
    Add(PreserveTimeCheck);
    PreserveTimeCheck->Left = PreserveRightsCheck->Left;
    PreserveTimeCheck->Caption = GetMsg(TRANSFER_PRESERVE_TIMESTAMP);
    PreserveTimeCheck->Top = TMTop + 6;
    PreserveTimeCheck->Enabled =
      FLAGCLEAR(CopyParamAttrs, cpaNoPreserveTime) &&
      FLAGCLEAR(CopyParamAttrs, cpaExcludeMaskOnly);
  }

  if ((Direction == pdToRemote) || (Direction == pdAll))
  {
    IgnorePermErrorsCheck = new TFarCheckBox(Dialog);
    Add(IgnorePermErrorsCheck);
    IgnorePermErrorsCheck->Left = PreserveRightsCheck->Left;
    IgnorePermErrorsCheck->Top = TMTop + ((Direction == pdToRemote) ? 7 : 6);
    IgnorePermErrorsCheck->Caption = GetMsg(TRANSFER_PRESERVE_PERM_ERRORS);
  }

  if (Direction == pdToLocal)
  {
    PreserveTimeCheck = new TFarCheckBox(Dialog);
    Add(PreserveTimeCheck);
    PreserveTimeCheck->Left = TMWidth + 3;
    PreserveTimeCheck->Caption = GetMsg(TRANSFER_PRESERVE_TIMESTAMP);
    PreserveTimeCheck->Move(0, TMTop - PreserveTimeCheck->Top);
    PreserveTimeCheck->Enabled =
      FLAGCLEAR(CopyParamAttrs, cpaNoPreserveTime) &&
      FLAGCLEAR(CopyParamAttrs, cpaExcludeMaskOnly);

    Dialog->NextItemPosition = ipBelow;
  }

  if (Direction == pdAll)
  {
    Box = new TFarBox(Dialog);
    Add(Box);
    Box->Top = TMTop + 7;
    Box->Bottom = Box->Top;
    Box->Left = TMWidth + 3 - 1;
    Box->Caption = GetMsg(TRANSFER_DOWNLOAD_OPTIONS);
  }

  if ((Direction == pdToLocal) || (Direction == pdAll))
  {
    PreserveReadOnlyCheck = new TFarCheckBox(Dialog);
    Add(PreserveReadOnlyCheck);
    PreserveReadOnlyCheck->Top = TMTop + ((Direction == pdToLocal) ? 1 : 8);
    PreserveReadOnlyCheck->Left = TMWidth + 3;
    PreserveReadOnlyCheck->Caption = GetMsg(TRANSFER_PRESERVE_READONLY);
    PreserveReadOnlyCheck->Enabled =
      FLAGCLEAR(CopyParamAttrs, cpaExcludeMaskOnly) &&
      FLAGCLEAR(CopyParamAttrs, cpaNoPreserveReadOnly);
  }

  if (Direction == pdAll)
  {
    Box = new TFarBox(Dialog);
    Add(Box);
    Box->Left = TMWidth + 3 - 1;
    Box->Caption = GetMsg(TRANSFER_COMMON_OPTIONS);

    PreserveTimeCheck = new TFarCheckBox(Dialog);
    Add(PreserveTimeCheck);
    PreserveTimeCheck->Left = TMWidth + 3;
    PreserveTimeCheck->Caption = GetMsg(TRANSFER_PRESERVE_TIMESTAMP);
    PreserveTimeCheck->Enabled =
      FLAGCLEAR(CopyParamAttrs, cpaNoPreserveTime) &&
      FLAGCLEAR(CopyParamAttrs, cpaExcludeMaskOnly);
    if (Direction == pdAll)
    {
      TMBottom = PreserveTimeCheck->Top;
    }
  }

  Dialog->NextItemPosition = ipNewLine;

  // this separator either separates "bottom" part of dialog or "other" options
  Separator = new TFarSeparator(Dialog);
  Add(Separator);
  Separator->Position = TMBottom + 1;

  if (FShowOther && FLAGCLEAR(FOptions, coTempTransfer))
  {
    Separator->Caption = GetMsg(TRANSFER_OTHER);

    NegativeExcludeCombo = new TFarComboBox(Dialog);
    NegativeExcludeCombo->Left = 1;
    Add(NegativeExcludeCombo);
    NegativeExcludeCombo->Items->Add(GetMsg(TRANSFER_EXCLUDE));
    NegativeExcludeCombo->Items->Add(GetMsg(TRANSFER_INCLUDE));
    NegativeExcludeCombo->DropDownList = true;
    NegativeExcludeCombo->ResizeToFitContent();
    NegativeExcludeCombo->Enabled =
      FLAGCLEAR(CopyParamAttrs, cpaNoExcludeMask) ||
      FLAGSET(CopyParamAttrs, cpaExcludeMaskOnly);

    Dialog->NextItemPosition = ipRight;

    Text = new TFarText(Dialog);
    Add(Text);
    Text->Caption = GetMsg(TRANSFER_EXCLUDE_FILE_MASK);
    Text->Enabled = NegativeExcludeCombo->Enabled;

    ExcludeFileMaskCombo = new TFarEdit(Dialog);
    Add(ExcludeFileMaskCombo);
    ExcludeFileMaskCombo->History = EXCLUDE_FILE_MASK_HISTORY;
    ExcludeFileMaskCombo->OnExit = ValidateMaskComboExit;
    ExcludeFileMaskCombo->Enabled = NegativeExcludeCombo->Enabled;

    Dialog->NextItemPosition = ipNewLine;

    ClearArchiveCheck = new TFarCheckBox(Dialog);
    ClearArchiveCheck->Left = 1;
    Add(ClearArchiveCheck);
    ClearArchiveCheck->Caption = GetMsg(TRANSFER_CLEAR_ARCHIVE);
    ClearArchiveCheck->Enabled =
      FLAGCLEAR(FOptions, coTempTransfer) &&
      FLAGCLEAR(CopyParamAttrs, cpaNoClearArchive) &&
      FLAGCLEAR(CopyParamAttrs, cpaExcludeMaskOnly);

    Separator = new TFarSeparator(Dialog);
    Separator->Left = 0;
    Add(Separator);
  }
}
//---------------------------------------------------------------------------
void __fastcall TCopyParamsContainer::UpdateControls()
{
  if (IgnorePermErrorsCheck != NULL)
  {
    IgnorePermErrorsCheck->Enabled =
      ((PreserveRightsCheck->Enabled && PreserveRightsCheck->Checked) ||
       (PreserveTimeCheck->Enabled && PreserveTimeCheck->Checked)) &&
      FLAGCLEAR(FCopyParamAttrs, cpaNoIgnorePermErrors) &&
      FLAGCLEAR(FCopyParamAttrs, cpaExcludeMaskOnly);
  }
}
//---------------------------------------------------------------------------
void __fastcall TCopyParamsContainer::Change()
{
  TFarDialogContainer::Change();

  if (Dialog->Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
void __fastcall TCopyParamsContainer::SetParams(TCopyParamType value)
{
  if (TMBinaryButton->Enabled)
  {
    switch (value.TransferMode)
    {
      case tmAscii:
        TMTextButton->Checked = true;
        break;

      case tmBinary:
        TMBinaryButton->Checked = true;
        break;

      default:
        TMAutomaticButton->Checked = true;
        break;
    }
  }
  else
  {
    TMBinaryButton->Checked = true;
  }

  AsciiFileMaskEdit->Text = value.AsciiFileMask.Masks;

  switch (value.FileNameCase)
  {
    case ncLowerCase:
      CCLowerCaseButton->Checked = true;
      break;

    case ncUpperCase:
      CCUpperCaseButton->Checked = true;
      break;

    case ncFirstUpperCase:
      CCFirstUpperCaseButton->Checked = true;
      break;

    case ncLowerCaseShort:
      CCLowerCaseShortButton->Checked = true;
      break;

    default:
    case ncNoChange:
      CCNoChangeButton->Checked = true;
      break;
  }

  if ((FDirection == pdToRemote) || (FDirection == pdAll))
  {
    RightsContainer->AddXToDirectories = value.AddXToDirectories;
    RightsContainer->Rights = value.Rights;
    PreserveRightsCheck->Checked = value.PreserveRights;
    IgnorePermErrorsCheck->Checked = value.IgnorePermErrors;
  }
  
  if ((FDirection == pdToLocal) || (FDirection == pdAll))
  {
    PreserveReadOnlyCheck->Checked = value.PreserveReadOnly;
    ReplaceInvalidCharsCheck->Checked =
      (value.InvalidCharsReplacement != TCopyParamType::NoReplacement);
  }

  if (FShowOther && FLAGCLEAR(FOptions, coTempTransfer))
  {
    assert(ClearArchiveCheck != NULL);
    ClearArchiveCheck->Checked = value.ClearArchive;
    NegativeExcludeCombo->Items->Selected = (value.NegativeExclude ? 1 : 0);
    ExcludeFileMaskCombo->Text = value.ExcludeFileMask.Masks;
  }

  PreserveTimeCheck->Checked = value.PreserveTime;
  
  FParams = value;
}
//---------------------------------------------------------------------------
TCopyParamType __fastcall TCopyParamsContainer::GetParams()
{
  TCopyParamType Result = FParams;

  assert(TMTextButton->Checked || TMBinaryButton->Checked || TMAutomaticButton->Checked);
  if (TMTextButton->Checked) Result.TransferMode = tmAscii;
    else
  if (TMAutomaticButton->Checked) Result.TransferMode = tmAutomatic;
    else Result.TransferMode = tmBinary;

  if (Result.TransferMode == tmAutomatic)
  {
    Result.AsciiFileMask.Masks = AsciiFileMaskEdit->Text;
    assert(Result.AsciiFileMask.IsValid());
  }

  if (CCLowerCaseButton->Checked) Result.FileNameCase = ncLowerCase;
    else
  if (CCUpperCaseButton->Checked) Result.FileNameCase = ncUpperCase;
    else
  if (CCFirstUpperCaseButton->Checked) Result.FileNameCase = ncFirstUpperCase;
    else
  if (CCLowerCaseShortButton->Checked) Result.FileNameCase = ncLowerCaseShort;
    else Result.FileNameCase = ncNoChange;

  if ((FDirection == pdToRemote) || (FDirection == pdAll))
  {
    Result.AddXToDirectories = RightsContainer->AddXToDirectories;
    Result.Rights = RightsContainer->Rights;
    Result.PreserveRights = PreserveRightsCheck->Checked;
    Result.IgnorePermErrors = IgnorePermErrorsCheck->Checked;
  }

  if ((FDirection == pdToLocal) || (FDirection == pdAll))
  {
    Result.ReplaceInvalidChars = ReplaceInvalidCharsCheck->Checked;
    Result.PreserveReadOnly = PreserveReadOnlyCheck->Checked;
  }

  if (FShowOther && FLAGCLEAR(FOptions, coTempTransfer))
  {
    assert(ClearArchiveCheck != NULL);
    Result.ClearArchive = ClearArchiveCheck->Checked;
    Result.NegativeExclude = (NegativeExcludeCombo->Items->Selected == 1);
    Result.ExcludeFileMask.Masks = ExcludeFileMaskCombo->Text;
  }

  Result.PreserveTime = PreserveTimeCheck->Checked;

  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TCopyParamsContainer::ValidateMaskComboExit(TObject * Sender)
{
  TFarEdit * Edit = dynamic_cast<TFarEdit *>(Sender);
  assert(Edit != NULL);
  TFileMasks Masks = Edit->Text;
  int Start, Length;
  if (!Masks.IsValid(Start, Length))
  {
    Edit->SetFocus();
    throw Exception(FORMAT(GetMsg(MASK_ERROR), (Masks.Masks.SubString(Start+1, Length))));
  }
}
//---------------------------------------------------------------------------
int __fastcall TCopyParamsContainer::GetHeight()
{
  return (FShowOther ? 14 : 11) + (FDirection == pdAll ? 2 : 0);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TCopyDialog : TFarDialog
{
public:
  __fastcall TCopyDialog(TCustomFarPlugin * AFarPlugin,
    bool ToRemote, bool Move, TStrings * FileList, int Options, int CopyParamAttrs);

  bool __fastcall Execute(AnsiString & TargetDirectory, TGUICopyParamType * Params);

protected:
  virtual void __fastcall Init();
  virtual bool __fastcall CloseQuery();

private:
  TFarEdit * DirectoryEdit;
  TFarCheckBox * NewerOnlyCheck;
  TFarCheckBox * SaveSettingsCheck;
  TFarCheckBox * QueueCheck;
  TFarCheckBox * QueueNoConfirmationCheck;
  TCopyParamsContainer * CopyParamsContainer;

  bool FExpanded;
  int FExpansionDelta;
  TRect FLastPosition;
  bool FToRemote;
  int FOptions;

  void __fastcall MoreButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TCopyDialog::TCopyDialog(TCustomFarPlugin * AFarPlugin,
  bool ToRemote, bool Move, TStrings * FileList,
  int Options, int CopyParamAttrs) : TFarDialog(AFarPlugin)
{
  FToRemote = ToRemote;
  FOptions = Options;

  TFarButton * Button;
  TFarSeparator * Separator;
  TFarText * Text;

  // temporary
  Size = TPoint(78, 20);

  Caption = GetMsg(Move ? MOVE_TITLE : COPY_TITLE);

  if ((FOptions & coTempTransfer) == 0)
  {
    AnsiString Prompt;
    if (FileList->Count > 1)
    {
      Prompt = FORMAT(GetMsg(Move ? MOVE_FILES_PROMPT : COPY_FILES_PROMPT), (FileList->Count));
    }
    else
    {
      Prompt = FORMAT(GetMsg(Move ? MOVE_FILE_PROMPT : COPY_FILE_PROMPT),
        (ToRemote ? ExtractFileName(FileList->Strings[0]) :
            UnixExtractFileName(FileList->Strings[0])));
    }

    Text = new TFarText(this);
    Text->Caption = Prompt;

    DirectoryEdit = new TFarEdit(this);
    DirectoryEdit->History = ToRemote ? REMOTE_DIR_HISTORY : "Copy";
  }

  DefaultGroup = 1;

  CopyParamsContainer = new TCopyParamsContainer(this,
    (ToRemote ? pdToRemote : pdToLocal), FOptions, CopyParamAttrs,
    FarPlugin->TerminalInfo().y - 14);
  Size = TPoint(78, 8 + CopyParamsContainer->Height +
    (FLAGCLEAR(FOptions, coTempTransfer) ? 3 : 0));

  TRect CRect = ClientRect;

  NewerOnlyCheck = new TFarCheckBox(this);
  NewerOnlyCheck->Top = CopyParamsContainer->Top + CopyParamsContainer->Height;
  NewerOnlyCheck->Bottom = NewerOnlyCheck->Top;
  NewerOnlyCheck->Caption = GetMsg(TRANSFER_NEWER_ONLY);
  NewerOnlyCheck->Enabled = FLAGCLEAR(FOptions, coDisableNewerOnly);

  SaveSettingsCheck = new TFarCheckBox(this);
  SaveSettingsCheck->Caption = GetMsg(TRANSFER_REUSE_SETTINGS);

  DefaultGroup = 0;

  if ((FOptions & coTempTransfer) == 0)
  {
    QueueCheck = new TFarCheckBox(this);
    QueueCheck->Caption = GetMsg(TRANSFER_QUEUE);
    QueueCheck->Top = CRect.Bottom - 2;
    QueueCheck->Bottom = QueueCheck->Top + 1;

    NextItemPosition = ipRight;

    QueueNoConfirmationCheck = new TFarCheckBox(this);
    QueueNoConfirmationCheck->Caption = GetMsg(TRANSFER_QUEUE_NO_CONFIRMATION);
    QueueNoConfirmationCheck->EnabledDependency = QueueCheck;
    QueueNoConfirmationCheck->Group = 1;

    NextItemPosition = ipNewLine;
  }

  Separator = new TFarSeparator(this);
  Separator->Position = CRect.Bottom - 1;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_OK);
  Button->Default = true;
  Button->Result = brOK;
  Button->CenterGroup = true;
  Button->EnabledDependency =
    ((Options & coTempTransfer) == 0) ? DirectoryEdit : NULL;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;

  if ((Options & coTempTransfer) == 0)
  {
    Button = new TFarButton(this);
    Button->Caption = GetMsg(LESS_BUTTON);
    Button->CenterGroup = true;
    Button->OnClick = MoreButtonClick;
    FExpanded = true;
    FExpansionDelta = Size.y - 9;

    if (!FarConfiguration->CopyParamDialogExpanded)
    {
      bool Close;
      MoreButtonClick(Button, Close);
    }
  }
  else
  {
    FExpanded = true;
  }
}
//---------------------------------------------------------------------------
void __fastcall TCopyDialog::MoreButtonClick(TFarButton * Sender, bool & /*Close*/)
{
  LockChanges();
  try
  {
    FExpanded = !FExpanded;
    TRect B = Bounds;
    int Factor;
    if (FExpanded)
    {
      Sender->Caption = GetMsg(LESS_BUTTON);
      ShowGroup(1, true);
      Factor = 1;
    }
    else
    {
      Sender->Caption = GetMsg(MORE_BUTTON);
      ShowGroup(1, false);
      Factor = -1;
    }
    if (FLastPosition == B)
    {
      B.Top -= Factor * FExpansionDelta / 2;
      B.Bottom += Factor * (FExpansionDelta - FExpansionDelta / 2);
      FLastPosition = B;
    }
    else
    {
      B.Bottom += Factor * FExpansionDelta;
      FLastPosition = TRect(-1, -1, -1, -1);
    }
    Bounds = B;
  }
  __finally
  {
    UnlockChanges();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TCopyDialog::Execute(AnsiString & TargetDirectory,
  TGUICopyParamType * Params)
{
  CopyParamsContainer->Params = *Params;

  if ((FOptions & coTempTransfer) == 0)
  {
    DirectoryEdit->Text =
      (FToRemote ? UnixIncludeTrailingBackslash(TargetDirectory) :
        IncludeTrailingBackslash(TargetDirectory)) + Params->FileMask;

    QueueCheck->Checked = Params->Queue;
    QueueNoConfirmationCheck->Checked = Params->QueueNoConfirmation;
  }

  NewerOnlyCheck->Checked = FLAGCLEAR(FOptions, coDisableNewerOnly) && Params->NewerOnly;

  bool Result = ShowModal() != brCancel;

  if (Result)
  {
    // overwrites TCopyParamType files only
    *Params = CopyParamsContainer->Params;

    if ((FOptions & coTempTransfer) == 0)
    {
      Params->FileMask = FToRemote ? UnixExtractFileName(DirectoryEdit->Text) :
        ExtractFileName(DirectoryEdit->Text);
      TargetDirectory = FToRemote ? UnixExtractFilePath(DirectoryEdit->Text) :
        ExtractFilePath(DirectoryEdit->Text);

      Params->Queue = QueueCheck->Checked;
      Params->QueueNoConfirmation = QueueNoConfirmationCheck->Checked;
    }

    Params->NewerOnly = FLAGCLEAR(FOptions, coDisableNewerOnly) && NewerOnlyCheck->Checked;
    
    Configuration->BeginUpdate();
    try
    {
      if ((FOptions & coTempTransfer) == 0)
      {
        FarConfiguration->CopyParamDialogExpanded = FExpanded;
      }
      if (SaveSettingsCheck->Checked)
      {
        GUIConfiguration->DefaultCopyParam = *Params;
      }
    }
    __finally
    {
      Configuration->EndUpdate();
    }
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TCopyDialog::CloseQuery()
{
  bool CanClose = TFarDialog::CloseQuery();

  if (CanClose && Result >= 0)
  {
    if (!FToRemote && ((FOptions & coTempTransfer) == 0))
    {
      AnsiString Directory = ExtractFilePath(DirectoryEdit->Text);
      if (!DirectoryExists(Directory))
      {
        TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);

        if (WinSCPPlugin->MoreMessageDialog(FORMAT(GetMsg(CREATE_LOCAL_DIRECTORY), (Directory)),
              NULL, qtConfirmation, qaOK | qaCancel) != qaCancel)
        {
          if (!ForceDirectories(Directory))
          {
            DirectoryEdit->SetFocus();
            throw Exception(FORMAT(GetMsg(CREATE_LOCAL_DIR_ERROR), (Directory)));
          }
        }
        else
        {
          DirectoryEdit->SetFocus();
          Abort();
        }
      }
    }
  }
  return CanClose;
}
//---------------------------------------------------------------------------
void __fastcall TCopyDialog::Init()
{
  TFarDialog::Init();
  FLastPosition = Bounds;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::CopyDialog(bool ToRemote,
  bool Move, TStrings * FileList, 
  AnsiString & TargetDirectory, TGUICopyParamType * Params, int Options,
  int CopyParamAttrs)
{
  bool Result;
  TCopyDialog * Dialog = new TCopyDialog(FPlugin, ToRemote,
    Move, FileList, Options, CopyParamAttrs);
  try
  {
    Result = Dialog->Execute(TargetDirectory, Params);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPPlugin::CopyParamCustomDialog(TCopyParamType & CopyParam,
  int CopyParamAttrs)
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(this);
  try
  {
    Dialog->Caption = GetMsg(COPY_PARAM_CUSTOM_TITLE);

    // temporary
    Dialog->Size = TPoint(78, 10);

    TCopyParamsContainer * CopyParamsContainer = new TCopyParamsContainer(
      Dialog, pdAll, 0, CopyParamAttrs, 0);

    Dialog->Size = TPoint(78, 2 + CopyParamsContainer->Height + 3);

    Dialog->NextItemPosition = ipNewLine;

    Dialog->AddStandardButtons(2, true);

    CopyParamsContainer->Params = CopyParam;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      CopyParam = CopyParamsContainer->Params;
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TLinkDialog : TFarDialog
{
public:
  __fastcall TLinkDialog(TCustomFarPlugin * AFarPlugin,
    bool Edit, bool AllowSymbolic);

  bool __fastcall Execute(AnsiString & FileName, AnsiString & PointTo,
    bool & Symbolic);

protected:
  virtual void __fastcall Change();

private:
  TFarEdit * FileNameEdit;
  TFarEdit * PointToEdit;
  TFarCheckBox * SymbolicCheck;
  TFarButton * OkButton;
};
//---------------------------------------------------------------------------
__fastcall TLinkDialog::TLinkDialog(TCustomFarPlugin * AFarPlugin,
    bool Edit, bool AllowSymbolic) : TFarDialog(AFarPlugin)
{
  TFarButton * Button;
  TFarSeparator * Separator;
  TFarText * Text;

  Size = TPoint(76, 12);
  TRect CRect = ClientRect;

  Caption = GetMsg(Edit ? LINK_EDIT_CAPTION : LINK_ADD_CAPTION);

  Text = new TFarText(this);
  Text->Caption = GetMsg(LINK_FILE);
  Text->Enabled = !Edit;

  FileNameEdit = new TFarEdit(this);
  FileNameEdit->Enabled = !Edit;
  FileNameEdit->History = LINK_FILENAME_HISTORY;

  Text = new TFarText(this);
  Text->Caption = GetMsg(LINK_POINT_TO);

  PointToEdit = new TFarEdit(this);
  PointToEdit->History = LINK_POINT_TO_HISTORY;

  new TFarSeparator(this);

  SymbolicCheck = new TFarCheckBox(this);
  SymbolicCheck->Caption = GetMsg(LINK_SYMLINK);
  SymbolicCheck->Enabled = AllowSymbolic && !Edit;

  Separator = new TFarSeparator(this);
  Separator->Position = CRect.Bottom - 1;

  OkButton = new TFarButton(this);
  OkButton->Caption = GetMsg(MSG_BUTTON_OK);
  OkButton->Default = true;
  OkButton->Result = brOK;
  OkButton->CenterGroup = true;

  NextItemPosition = ipRight;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(MSG_BUTTON_Cancel);
  Button->Result = brCancel;
  Button->CenterGroup = true;
}
//---------------------------------------------------------------------------
void __fastcall TLinkDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    OkButton->Enabled = !FileNameEdit->Text.IsEmpty() &&
      !PointToEdit->Text.IsEmpty();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TLinkDialog::Execute(AnsiString & FileName, AnsiString & PointTo,
    bool & Symbolic)
{
  FileNameEdit->Text = FileName;
  PointToEdit->Text = PointTo;
  SymbolicCheck->Checked = Symbolic;

  bool Result = ShowModal() != brCancel;
  if (Result)
  {
    FileName = FileNameEdit->Text;
    PointTo = PointToEdit->Text;
    Symbolic = SymbolicCheck->Checked;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::LinkDialog(AnsiString & FileName,
  AnsiString & PointTo, bool & Symbolic, bool Edit, bool AllowSymbolic)
{
  bool Result;
  TLinkDialog * Dialog = new TLinkDialog(FPlugin, Edit, AllowSymbolic);
  try
  {
    Result = Dialog->Execute(FileName, PointTo, Symbolic);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
typedef void __fastcall (__closure *TFeedFileSystemData)
  (TObject * Control, int Label, AnsiString Value);
//---------------------------------------------------------------------------
class TLabelList;
class TFileSystemInfoDialog : TTabbedDialog
{
public:
  enum { tabServer = 1, tabProtocol, tabSpaceAvailable, tabCount };

  __fastcall TFileSystemInfoDialog(TCustomFarPlugin * AFarPlugin,
    TGetSpaceAvailable OnGetSpaceAvailable);

  void __fastcall Execute(const TFileSystemInfo & FileSystemInfo,
    AnsiString SpaceAvailablePath);

protected:
  void __fastcall Feed(TFeedFileSystemData AddItem);
  AnsiString __fastcall CapabilityStr(TFSCapability Capability);
  AnsiString __fastcall CapabilityStr(TFSCapability Capability1,
    TFSCapability Capability2);
  AnsiString __fastcall SpaceStr(__int64 Bytes);
  void __fastcall ControlsAddItem(TObject * Control, int Label, AnsiString Value);
  void __fastcall CalculateMaxLenAddItem(TObject * Control, int Label, AnsiString Value);
  void __fastcall ClipboardAddItem(TObject * Control, int Label, AnsiString Value);
  void __fastcall FeedControls();
  void __fastcall UpdateControls();
  TLabelList * __fastcall CreateLabelArray(int Count);
  virtual void __fastcall SelectTab(int Tab);
  virtual void __fastcall Change();
  void __fastcall SpaceAvailableButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall ClipboardButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall CheckSpaceAvailable();
  void __fastcall NeedSpaceAvailable();
  bool __fastcall SpaceAvailableSupported();
  virtual bool __fastcall Key(TFarDialogItem * Item, long KeyCode);

private:
  TGetSpaceAvailable FOnGetSpaceAvailable;
  TFileSystemInfo FFileSystemInfo;
  bool FSpaceAvailableLoaded;
  TSpaceAvailable FSpaceAvailable;
  TObject * FLastFeededControl;
  int FLastListItem;
  AnsiString FClipboard;

  TLabelList * ServerLabels;
  TLabelList * ProtocolLabels;
  TLabelList * SpaceAvailableLabels;
  TTabButton * SpaceAvailableTab;
  TFarEdit * HostKeyFingerprintEdit;
  TFarLister * InfoLister;
  TFarEdit * SpaceAvailablePathEdit;
  TFarButton * OkButton;
};
//---------------------------------------------------------------------------
class TLabelList : public TList
{
public:
  TLabelList() :
    TList(), MaxLen(0)
  {
  }

  int MaxLen;
};
//---------------------------------------------------------------------------
__fastcall TFileSystemInfoDialog::TFileSystemInfoDialog(TCustomFarPlugin * AFarPlugin,
  TGetSpaceAvailable OnGetSpaceAvailable) : TTabbedDialog(AFarPlugin, tabCount),
  FOnGetSpaceAvailable(OnGetSpaceAvailable),
  FSpaceAvailableLoaded(false)
{
  TFarText * Text;
  TFarSeparator * Separator;
  TFarButton * Button;
  TTabButton * Tab;
  int GroupTop;

  Size = TPoint(73, 21);
  Caption = GetMsg(SERVER_PROTOCOL_INFORMATION);

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(SERVER_PROTOCOL_TAB_SERVER);
  Tab->Tab = tabServer;

  NextItemPosition = ipRight;

  Tab = new TTabButton(this);
  Tab->TabName = GetMsg(SERVER_PROTOCOL_TAB_PROTOCOL);
  Tab->Tab = tabProtocol;

  SpaceAvailableTab = new TTabButton(this);
  SpaceAvailableTab->TabName = GetMsg(SERVER_PROTOCOL_TAB_SPACE_AVAILABLE);
  SpaceAvailableTab->Tab = tabSpaceAvailable;

  // Server tab
  
  NextItemPosition = ipNewLine;
  DefaultGroup = tabServer;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(SERVER_INFORMATION_GROUP);
  GroupTop = Separator->Top;

  ServerLabels = CreateLabelArray(5);

  new TFarSeparator(this);

  Text = new TFarText(this);
  Text->Caption = GetMsg(SERVER_HOST_KEY);
  HostKeyFingerprintEdit = new TFarEdit(this);
  HostKeyFingerprintEdit->ReadOnly = true;

  // Protocol tab

  DefaultGroup = tabProtocol;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(PROTOCOL_INFORMATION_GROUP);
  Separator->Position = GroupTop;

  ProtocolLabels = CreateLabelArray(8);

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(PROTOCOL_INFO_GROUP);

  InfoLister = new TFarLister(this);
  InfoLister->Height = 4;
  InfoLister->Left = BorderBox->Left + 1;
  // Right edge is adjusted in FeedControls

  // Space available tab

  DefaultGroup = tabSpaceAvailable;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(SPACE_AVAILABLE_GROUP);
  Separator->Position = GroupTop;

  Text = new TFarText(this);
  Text->Caption = GetMsg(SPACE_AVAILABLE_PATH);

  NextItemPosition = ipRight;

  SpaceAvailablePathEdit = new TFarEdit(this);
  SpaceAvailablePathEdit->Right =
    - (GetMsg(SPACE_AVAILABLE_CHECK_SPACE).Length() + 11);

  Button = new TFarButton(this);
  Button->Caption = GetMsg(SPACE_AVAILABLE_CHECK_SPACE);
  Button->EnabledDependency = SpaceAvailablePathEdit;
  Button->OnClick = SpaceAvailableButtonClick;

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  SpaceAvailableLabels = CreateLabelArray(5);

  // Buttons

  DefaultGroup = 0;

  Separator = new TFarSeparator(this);
  Separator->Position = ClientRect.Bottom - 1;

  Button = new TFarButton(this);
  Button->Caption = GetMsg(SERVER_PROTOCOL_COPY_CLIPBOARD);
  Button->OnClick = ClipboardButtonClick;
  Button->CenterGroup = true;

  NextItemPosition = ipRight;

  OkButton = new TFarButton(this);
  OkButton->Caption = GetMsg(MSG_BUTTON_OK);
  OkButton->Default = true;
  OkButton->Result = brOK;
  OkButton->CenterGroup = true;

  Feed(CalculateMaxLenAddItem);
}
//---------------------------------------------------------------------------
TLabelList * __fastcall TFileSystemInfoDialog::CreateLabelArray(int Count)
{
  TLabelList * List = new TLabelList();
  try
  {
    for (int Index = 0; Index < Count; Index++)
    {
      List->Add(new TFarText(this));
    }
  }
  catch(...)
  {
    delete List;
    throw;
  }
  return List;
}
//---------------------------------------------------------------------
AnsiString __fastcall TFileSystemInfoDialog::CapabilityStr(TFSCapability Capability)
{
  return BooleanToStr(FFileSystemInfo.IsCapable[Capability]);
}
//---------------------------------------------------------------------
AnsiString __fastcall TFileSystemInfoDialog::CapabilityStr(TFSCapability Capability1,
  TFSCapability Capability2)
{
  return FORMAT("%s/%s", (CapabilityStr(Capability1), CapabilityStr(Capability2)));
}
//---------------------------------------------------------------------
AnsiString __fastcall TFileSystemInfoDialog::SpaceStr(__int64 Bytes)
{
  AnsiString Result;
  if (Bytes == 0)
  {
    Result = GetMsg(SPACE_AVAILABLE_BYTES_UNKNOWN);
  }
  else
  {
    Result = FormatBytes(Bytes);
    AnsiString SizeUnorderedStr = FormatBytes(Bytes, false);
    if (Result != SizeUnorderedStr)
    {
      Result = FORMAT("%s (%s)", (Result, SizeUnorderedStr));
    }
  }
  return Result;
}
//---------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::Feed(TFeedFileSystemData AddItem)
{
  AddItem(ServerLabels, SERVER_SSH_VERSION, FORMAT("SSH-%d", (FFileSystemInfo.SshVersion)));
  AddItem(ServerLabels, SERVER_SSH_IMPLEMENTATION, FFileSystemInfo.SshImplementation);

  AnsiString Str = CipherNames[FFileSystemInfo.CSCipher];
  if (FFileSystemInfo.CSCipher != FFileSystemInfo.SCCipher)
  {
    Str += FORMAT("/%s", (CipherNames[FFileSystemInfo.SCCipher]));
  }
  AddItem(ServerLabels, SERVER_CIPHER, Str);

  Str = BooleanToStr(FFileSystemInfo.CSCompression != ctNone);
  if (FFileSystemInfo.CSCompression != FFileSystemInfo.SCCompression)
  {
    Str += FORMAT("/%s", (BooleanToStr(FFileSystemInfo.SCCompression != ctNone)));
  }
  AddItem(ServerLabels, SERVER_COMPRESSION, Str);
  AddItem(ServerLabels, SERVER_FS_PROTOCOL, FFileSystemInfo.ProtocolName);

  AddItem(HostKeyFingerprintEdit, 0, FFileSystemInfo.HostKeyFingerprint);

  AddItem(ProtocolLabels, PROTOCOL_MODE_CHANGING, CapabilityStr(fcModeChanging));
  AddItem(ProtocolLabels, PROTOCOL_OWNER_GROUP_CHANGING, CapabilityStr(fcGroupChanging));
  AddItem(ProtocolLabels, PROTOCOL_ANY_COMMAND, CapabilityStr(fcAnyCommand));
  AddItem(ProtocolLabels, PROTOCOL_SYMBOLIC_HARD_LINK, CapabilityStr(fcSymbolicLink, fcHardLink));
  AddItem(ProtocolLabels, PROTOCOL_USER_GROUP_LISTING, CapabilityStr(fcUserGroupListing));
  AddItem(ProtocolLabels, PROTOCOL_REMOTE_COPY, CapabilityStr(fcRemoteCopy));
  AddItem(ProtocolLabels, PROTOCOL_CHECKING_SPACE_AVAILABLE, CapabilityStr(fcCheckingSpaceAvailable));
  AddItem(ProtocolLabels, PROTOCOL_NATIVE_TEXT_MODE, CapabilityStr(fcNativeTextMode));

  AddItem(InfoLister, 0, FFileSystemInfo.AdditionalInfo);

  AddItem(SpaceAvailableLabels, SPACE_AVAILABLE_BYTES_ON_DEVICE, SpaceStr(FSpaceAvailable.BytesOnDevice));
  AddItem(SpaceAvailableLabels, SPACE_AVAILABLE_UNUSED_BYTES_ON_DEVICE, SpaceStr(FSpaceAvailable.UnusedBytesOnDevice));
  AddItem(SpaceAvailableLabels, SPACE_AVAILABLE_BYTES_AVAILABLE_TO_USER, SpaceStr(FSpaceAvailable.BytesAvailableToUser));
  AddItem(SpaceAvailableLabels, SPACE_AVAILABLE_UNUSED_BYTES_AVAILABLE_TO_USER, SpaceStr(FSpaceAvailable.UnusedBytesAvailableToUser));
  AddItem(SpaceAvailableLabels, SPACE_AVAILABLE_BYTES_PER_ALLOCATION_UNIT, SpaceStr(FSpaceAvailable.BytesPerAllocationUnit));
}
//---------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::ControlsAddItem(TObject * Control,
  int Label, AnsiString Value)
{
  if (FLastFeededControl != Control)
  {
    FLastFeededControl = Control;
    FLastListItem = 0;
  }

  if (Control == HostKeyFingerprintEdit)
  {
    HostKeyFingerprintEdit->Text = Value;
  }
  else if (Control == InfoLister)
  {
    InfoLister->Items->Text = Value;
  }
  else
  {
    TLabelList * List = dynamic_cast<TLabelList *>(Control);
    assert(List != NULL);
    TFarText * Text = reinterpret_cast<TFarText *>(List->Items[FLastListItem]);
    FLastListItem++;

    Text->Caption = FORMAT("%-*s  %s", (List->MaxLen, GetMsg(Label), (Value)));
  }
}
//---------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::CalculateMaxLenAddItem(TObject * Control,
  int Label, AnsiString Value)
{
  TLabelList * List = dynamic_cast<TLabelList *>(Control);
  if (List != NULL)
  {
    AnsiString S = GetMsg(Label);
    if (List->MaxLen < S.Length())
    {
      List->MaxLen = S.Length();
    }
  }
}
//---------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::ClipboardAddItem(TObject * Control,
  int Label, AnsiString Value)
{
  if ((Control != SpaceAvailableLabels) ||
      SpaceAvailableSupported())
  {
    if (FLastFeededControl != Control)
    {
      if (FLastFeededControl != NULL)
      {
        FClipboard += AnsiString::StringOfChar('-', 60) + "\r\n";
      }
      FLastFeededControl = Control;
    }

    if (dynamic_cast<TLabelList *>(Control) == NULL)
    {
      AnsiString LabelStr;
      if (Control == HostKeyFingerprintEdit)
      {
        LabelStr = GetMsg(SERVER_HOST_KEY);
      }
      else if (Control == InfoLister)
      {
        LabelStr = GetMsg(PROTOCOL_INFO_GROUP).Trim();
      }
      else
      {
        assert(false);
      }

      if (!LabelStr.IsEmpty() && (LabelStr[LabelStr.Length()] == ':'))
      {
        LabelStr.SetLength(LabelStr.Length() - 1);
      }

      if ((Value.Length() >= 2) && (Value.SubString(Value.Length() - 1, 2) == "\r\n"))
      {
        Value.SetLength(Value.Length() - 2);
      }

      FClipboard += FORMAT("%s\r\n%s\r\n", (LabelStr, Value));
    }
    else
    {
      assert(dynamic_cast<TLabelList *>(Control) != NULL);
      AnsiString LabelStr = GetMsg(Label);
      if (!LabelStr.IsEmpty() && (LabelStr[LabelStr.Length()] == ':'))
      {
        LabelStr.SetLength(LabelStr.Length() - 1);
      }
      FClipboard += FORMAT("%s = %s\r\n", (LabelStr, Value));
    }
  }
}
//---------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::FeedControls()
{
  FLastFeededControl = NULL;
  Feed(ControlsAddItem);
  InfoLister->Right = BorderBox->Right - (InfoLister->ScrollBar ? 0 : 1);
}
//---------------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::SelectTab(int Tab)
{
  TTabbedDialog::SelectTab(Tab);
  if (InfoLister->Visible)
  {
    // At first the dialog border box hides the eventual scrollbar of infolister,
    // so redraw to reshow it.
    Redraw();
  }

  if (Tab == tabSpaceAvailable)
  {
    NeedSpaceAvailable();
  }
}
//---------------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::Execute(
  const TFileSystemInfo & FileSystemInfo, AnsiString SpaceAvailablePath)
{
  FFileSystemInfo = FileSystemInfo;
  SpaceAvailablePathEdit->Text = SpaceAvailablePath;
  UpdateControls();

  FeedControls();
  HideTabs();
  SelectTab(tabServer);

  ShowModal();
}
//---------------------------------------------------------------------------
bool __fastcall TFileSystemInfoDialog::Key(TFarDialogItem * Item, long KeyCode)
{
  bool Result;
  if ((Item == SpaceAvailablePathEdit) && (KeyCode == KEY_ENTER))
  {
    CheckSpaceAvailable();
    Result = true;
  }
  else
  {
    Result = TTabbedDialog::Key(Item, KeyCode);
  }
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::Change()
{
  TTabbedDialog::Change();

  if (Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::UpdateControls()
{
  SpaceAvailableTab->Enabled = SpaceAvailableSupported();
}
//---------------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::ClipboardButtonClick(TFarButton * /*Sender*/,
  bool & Close)
{
  NeedSpaceAvailable();
  FLastFeededControl = NULL;
  FClipboard = "";
  Feed(ClipboardAddItem);
  FarPlugin->FarCopyToClipboard(FClipboard);
  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::SpaceAvailableButtonClick(
  TFarButton * /*Sender*/, bool & Close)
{
  CheckSpaceAvailable();
  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::CheckSpaceAvailable()
{
  assert(FOnGetSpaceAvailable != NULL);
  assert(!SpaceAvailablePathEdit->Text.IsEmpty());

  FSpaceAvailableLoaded = true;

  bool DoClose = false;

  FOnGetSpaceAvailable(SpaceAvailablePathEdit->Text, FSpaceAvailable, DoClose);

  FeedControls();
  if (DoClose)
  {
    Close(OkButton);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFileSystemInfoDialog::NeedSpaceAvailable()
{
  if (!FSpaceAvailableLoaded && SpaceAvailableSupported())
  {
    CheckSpaceAvailable();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TFileSystemInfoDialog::SpaceAvailableSupported()
{
  return (FOnGetSpaceAvailable != NULL);
}
//---------------------------------------------------------------------------
void __fastcall TWinSCPFileSystem::FileSystemInfoDialog(
  const TFileSystemInfo & FileSystemInfo, AnsiString SpaceAvailablePath,
  TGetSpaceAvailable OnGetSpaceAvailable)
{
  TFileSystemInfoDialog * Dialog = new TFileSystemInfoDialog(FPlugin, OnGetSpaceAvailable);
  try
  {
    Dialog->Execute(FileSystemInfo, SpaceAvailablePath);
  }
  __finally
  {
    delete Dialog;
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
/*class TOpenDirectoryDialog : TWinSCPDialog
{
public:
  __fastcall TOpenDirectoryDialog(TCustomFarPlugin * AFarPlugin, bool Add);

  bool __fastcall Execute(AnsiString & Directory, TBookmarkList * BookmarkList);

protected:
  virtual void __fastcall Change();

private:
  TFarListBox * BookmarksList;
  TFarButton * RemoveButton;
  TFarButton * UpButton;
  TFarButton * DownButton;
  TBookmarkList * FBookmarkList;

  void __fastcall UpdateControls();
  void __fastcall LoadBookmarks();
  void __fastcall UpDownButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall RemoveButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TOpenDirectoryDialog::TOpenDirectoryDialog(
  TCustomFarPlugin * AFarPlugin, bool Add) : TWinSCPDialog(AFarPlugin)
{
  Size = TPoint(76, 18);
  TRect CRect = ClientRect;

  Caption = GetMsg(Add ? OPEN_DIRECTORY_ADD_BOOMARK_ACTION :
    OPEN_DIRECTORY_BROWSE_CAPTION);

  BookmarksList = new TFarListBox(this);
  BookmarksList->Right = BookmarksList->Right - 15;
  BookmarksList->Height = 1 + 10 + 1;

  NextItemPosition = ipRight;

  RemoveButton = new TFarButton(this);
  RemoveButton->Caption = GetMsg(OPEN_DIRECTORY_REMOVE);
  RemoveButton->Move(0, 1);
  RemoveButton->EnabledDependency = BookmarksList;
  RemoveButton->OnClick = RemoveButtonClick;

  NextItemPosition = ipBelow;

  UpButton = new TFarButton(this);
  UpButton->Caption = GetMsg(OPEN_DIRECTORY_UP);
  UpButton->Move(0, BookmarksList->Height - 5);
  UpButton->Result = -1;
  UpButton->OnClick = UpDownButtonClick;

  DownButton = new TFarButton(this);
  DownButton->Caption = GetMsg(OPEN_DIRECTORY_DOWN);
  DownButton->Result = 1;
  DownButton->OnClick = UpDownButtonClick;

  AddStandardButtons(1);

  OkButton->EnabledDependency = BookmarksList;
}
//---------------------------------------------------------------------------
void __fastcall TOpenDirectoryDialog::Change()
{
  TWinSCPDialog::Change();

  if (Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
void __fastcall TOpenDirectoryDialog::UpdateControls()
{
  UpButton->Enabled = (BookmarksList->Items->Selected > 0);
  DownButton->Enabled = (BookmarksList->Items->Selected >= 0) &&
    (BookmarksList->Items->Selected < BookmarksList->Items->Count - 1);
}
//---------------------------------------------------------------------------
void __fastcall TOpenDirectoryDialog::LoadBookmarks()
{
  BookmarksList->Items->Clear();
  for (int i = 0; i < FBookmarkList->Count; i++)
  {
    TBookmark * Bookmark = FBookmarkList->Bookmarks[i];
    AnsiString Directory = Bookmark->Remote;
    if (!Directory.IsEmpty() && (BookmarksList->Items->IndexOf(Directory) < 0))
    {
      BookmarksList->Items->AddObject(Directory, Bookmark);
    }
  }
}
//---------------------------------------------------------------------------
bool __fastcall TOpenDirectoryDialog::Execute(AnsiString & Directory,
  TBookmarkList * BookmarkList)
{
  FBookmarkList = BookmarkList;
  LoadBookmarks();

  BookmarksList->Items->Selected = BookmarksList->Items->IndexOf(Directory);

  bool Result = ShowModal() != brCancel;
  if (Result)
  {
    assert(BookmarksList->Items->Selected >= 0);
    Directory = BookmarksList->Items->Strings[BookmarksList->Items->Selected];
  }
  FBookmarkList = NULL;
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TOpenDirectoryDialog::RemoveButtonClick(TFarButton * Sender,
  bool & Close)
{
  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TOpenDirectoryDialog::UpDownButtonClick(TFarButton * Sender,
  bool & Close)
{
  Close = false;
} */
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::OpenDirectoryDialog(
  bool Add, AnsiString & Directory, TBookmarkList * BookmarkList)
{
  bool Result;
  TFarMenuItems * BookmarkItems = new TFarMenuItems();
  TList * Bookmarks = new TList();
  try
  {
    BookmarkItems->Sorted = true;
    const int BreakKeys[] = { VK_DELETE, VK_F8, VK_RETURN + (PKF_CONTROL << 16),
      'C' + (PKF_CONTROL << 16), VK_INSERT + (PKF_CONTROL << 16), 0 };
    BookmarkItems->Clear();
    int ItemFocused = -1;
    for (int i = 0; i < BookmarkList->Count; i++)
    {
      TBookmark * Bookmark = BookmarkList->Bookmarks[i];
      AnsiString RemoteDirectory = Bookmark->Remote;
      if (!RemoteDirectory.IsEmpty() && (BookmarkItems->IndexOf(RemoteDirectory) < 0))
      {
        int Pos;
        Pos = BookmarkItems->Add(RemoteDirectory);
        if (RemoteDirectory == Directory)
        {
          ItemFocused = Pos;
        }
        else if (ItemFocused >= 0 && ItemFocused >= Pos)
        {
          ItemFocused++;
        }
        Bookmarks->Insert(Pos, Bookmark);
      }
    }

    if (BookmarkItems->Count == 0)
    {
      throw Exception(GetMsg(OPEN_DIRECTORY_NO_BOOKMARK));
    }

    BookmarkItems->ItemFocused = ItemFocused;

    int BreakCode;
    bool Repeat;

    do
    {
      Repeat = false;
      AnsiString Caption = GetMsg(Add ? OPEN_DIRECTORY_ADD_BOOMARK_ACTION :
        OPEN_DIRECTORY_BROWSE_CAPTION);
      ItemFocused = FPlugin->Menu(FMENU_AUTOHIGHLIGHT | FMENU_SHOWAMPERSAND,
        Caption, GetMsg(OPEN_DIRECTORY_HELP), BookmarkItems, BreakKeys, BreakCode);
      TBookmark * Bookmark = (ItemFocused >= 0) ?
        static_cast<TBookmark *>(Bookmarks->Items[ItemFocused]) : NULL;
      if (BreakCode >= 0)
      {
        assert(BreakCode >= 0 && BreakCode <= 4);
        if (BreakCode == 0 || BreakCode == 1)
        {
          assert(ItemFocused >= 0);
          assert(Bookmark != NULL);
          BookmarkList->Delete(Bookmark);
          BookmarkItems->Delete(ItemFocused);
          Bookmarks->Delete(ItemFocused);
          BookmarkItems->ItemFocused = (ItemFocused < BookmarkItems->Count - 1) ?
            ItemFocused : BookmarkItems->Count - 1;
          Repeat = true;
        }
        else if (BreakCode == 2)
        {
          FarControl(FCTL_INSERTCMDLINE, Bookmark->Remote.c_str());
        }
        else if (BreakCode == 3 || BreakCode == 4)
        {
          FPlugin->FarCopyToClipboard(Bookmark->Remote);
          Repeat = true;
        }
      }
      else if (ItemFocused >= 0)
      {
        assert(Bookmark != NULL);
        Directory = Bookmark->Remote;
      }
    }
    while (Repeat && (BookmarkItems->Count > 0));

    Result = (BreakCode < 0) && (ItemFocused >= 0);
  }
  __finally
  {
    delete BookmarkItems;
    delete Bookmarks;
  }

  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TApplyCommandDialog : public TWinSCPDialog
{
public:
  __fastcall TApplyCommandDialog(TCustomFarPlugin * AFarPlugin);

  bool __fastcall Execute(AnsiString & Command, int & Params);

protected:
  virtual void __fastcall Change();

private:
  int FParams;

  TFarEdit * CommandEdit;
  TFarText * LocalHintText;
  TFarRadioButton * RemoteCommandButton;
  TFarRadioButton * LocalCommandButton;
  TFarCheckBox * ApplyToDirectoriesCheck;
  TFarCheckBox * RecursiveCheck;
  TFarCheckBox * ShowResultsCheck;
  TFarCheckBox * CopyResultsCheck;
  
  AnsiString FPrompt;
  TFarEdit * PasswordEdit;
  TFarEdit * NormalEdit;
  TFarCheckBox * HideTypingCheck;
};
//---------------------------------------------------------------------------
__fastcall TApplyCommandDialog::TApplyCommandDialog(TCustomFarPlugin * AFarPlugin) : 
  TWinSCPDialog(AFarPlugin)
{
  TFarText * Text;

  Size = TPoint(76, 16);
  Caption = GetMsg(APPLY_COMMAND_TITLE);

  Text = new TFarText(this);
  Text->Caption = GetMsg(APPLY_COMMAND_PROMPT);

  CommandEdit = new TFarEdit(this);
  CommandEdit->History = APPLY_COMMAND_HISTORY;

  Text = new TFarText(this);
  Text->Caption = GetMsg(APPLY_COMMAND_HINT1);
  Text = new TFarText(this);
  Text->Caption = GetMsg(APPLY_COMMAND_HINT2);
  Text = new TFarText(this);
  Text->Caption = GetMsg(APPLY_COMMAND_HINT3);
  LocalHintText = new TFarText(this);
  LocalHintText->Caption = GetMsg(APPLY_COMMAND_HINT_LOCAL);

  new TFarSeparator(this);

  RemoteCommandButton = new TFarRadioButton(this);
  RemoteCommandButton->Caption = GetMsg(APPLY_COMMAND_REMOTE_COMMAND);

  NextItemPosition = ipRight;

  LocalCommandButton = new TFarRadioButton(this);
  LocalCommandButton->Caption = GetMsg(APPLY_COMMAND_LOCAL_COMMAND);
  
  LocalHintText->EnabledDependency = LocalCommandButton; 

  NextItemPosition = ipNewLine;

  ApplyToDirectoriesCheck = new TFarCheckBox(this);
  ApplyToDirectoriesCheck->Caption = 
    GetMsg(APPLY_COMMAND_APPLY_TO_DIRECTORIES);

  NextItemPosition = ipRight;

  RecursiveCheck = new TFarCheckBox(this);
  RecursiveCheck->Caption = GetMsg(APPLY_COMMAND_RECURSIVE);

  NextItemPosition = ipNewLine;

  ShowResultsCheck = new TFarCheckBox(this);
  ShowResultsCheck->Caption = GetMsg(APPLY_COMMAND_SHOW_RESULTS);
  ShowResultsCheck->EnabledDependency = RemoteCommandButton;

  NextItemPosition = ipRight;

  CopyResultsCheck = new TFarCheckBox(this);
  CopyResultsCheck->Caption = GetMsg(APPLY_COMMAND_COPY_RESULTS);
  CopyResultsCheck->EnabledDependency = RemoteCommandButton;

  AddStandardButtons();
  
  OkButton->EnabledDependency = CommandEdit; 
}
//---------------------------------------------------------------------------
void __fastcall TApplyCommandDialog::Change()
{
  TWinSCPDialog::Change();

  if (Handle)
  {
    bool RemoteCommand = RemoteCommandButton->Checked;
    bool AllowRecursive = true;
    bool AllowApplyToDirectories = true;
    try
    {
      TRemoteCustomCommand RemoteCustomCommand;
      TLocalCustomCommand LocalCustomCommand;
      TFileCustomCommand * FileCustomCommand =
        (RemoteCommand ? &RemoteCustomCommand : &LocalCustomCommand);

      TInteractiveCustomCommand InteractiveCustomCommand(FileCustomCommand);
      AnsiString Cmd = InteractiveCustomCommand.Complete(CommandEdit->Text, false);
      bool FileCommand = FileCustomCommand->IsFileCommand(Cmd);
      AllowRecursive = FileCommand && !FileCustomCommand->IsFileListCommand(Cmd);
      if (AllowRecursive && !RemoteCommand)
      {
        AllowRecursive = !LocalCustomCommand.HasLocalFileName(Cmd);
      }
      AllowApplyToDirectories = FileCommand;
    }
    catch(...)
    {
    }

    RecursiveCheck->Enabled = AllowRecursive;
    ApplyToDirectoriesCheck->Enabled = AllowApplyToDirectories;
  }
}
//---------------------------------------------------------------------------
bool __fastcall TApplyCommandDialog::Execute(AnsiString & Command, int & Params)
{
  CommandEdit->Text = Command;
  FParams = Params;
  RemoteCommandButton->Checked = FLAGCLEAR(Params, ccLocal);
  LocalCommandButton->Checked = FLAGSET(Params, ccLocal);
  ApplyToDirectoriesCheck->Checked = FLAGSET(Params, ccApplyToDirectories);
  RecursiveCheck->Checked = FLAGSET(Params, ccRecursive);
  ShowResultsCheck->Checked = FLAGSET(Params, ccShowResults);
  CopyResultsCheck->Checked = FLAGSET(Params, ccCopyResults);

  bool Result = (ShowModal() != brCancel);
  if (Result)
  {
    Command = CommandEdit->Text;
    Params &= ~(ccLocal | ccApplyToDirectories | ccRecursive | ccShowResults | ccCopyResults);
    Params |=
      FLAGMASK(!RemoteCommandButton->Checked, ccLocal) |
      FLAGMASK(ApplyToDirectoriesCheck->Checked, ccApplyToDirectories) |
      FLAGMASK(RecursiveCheck->Checked && RecursiveCheck->Enabled, ccRecursive) |
      FLAGMASK(ShowResultsCheck->Checked && ShowResultsCheck->Enabled, ccShowResults) |
      FLAGMASK(CopyResultsCheck->Checked && CopyResultsCheck->Enabled, ccCopyResults);
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::ApplyCommandDialog(AnsiString & Command,
  int & Params)
{
  bool Result;
  TApplyCommandDialog * Dialog = new TApplyCommandDialog(FPlugin);
  try
  {
    Result = Dialog->Execute(Command, Params);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TFullSynchronizeDialog : public TWinSCPDialog
{
public:
  __fastcall TFullSynchronizeDialog(TCustomFarPlugin * AFarPlugin, int Options,
    const TUsableCopyParamAttrs & CopyParamAttrs);

  bool __fastcall Execute(TTerminal::TSynchronizeMode & Mode,
    int & Params, AnsiString & LocalDirectory, AnsiString & RemoteDirectory,
    TCopyParamType * CopyParams, bool & SaveSettings, bool & SaveMode);

protected:
  virtual bool __fastcall CloseQuery();
  virtual void __fastcall Change();
  virtual long __fastcall DialogProc(int Msg, int Param1, long Param2);

  void __fastcall TransferSettingsButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall CopyParamListerClick(TFarDialogItem * Item, MOUSE_EVENT_RECORD * Event);

  int __fastcall ActualCopyParamAttrs();
  void __fastcall CustomCopyParam();
  void __fastcall AdaptSize();

private:
  TFarEdit * LocalDirectoryEdit;
  TFarEdit * RemoteDirectoryEdit;
  TFarRadioButton * SynchronizeBothButton;
  TFarRadioButton * SynchronizeRemoteButton;
  TFarRadioButton * SynchronizeLocalButton;
  TFarCheckBox * SynchronizeDeleteCheck;
  TFarCheckBox * SynchronizeExistingOnlyCheck;
  TFarCheckBox * SynchronizeSelectedOnlyCheck;
  TFarCheckBox * SynchronizePreviewChangesCheck;
  TFarCheckBox * SynchronizeTimestampCheck;
  TFarCheckBox * SynchronizeByTimeCheck;
  TFarCheckBox * SynchronizeBySizeCheck;
  TFarCheckBox * SaveSettingsCheck;
  TFarLister * CopyParamLister;

  bool FSaveMode;
  int FOptions;
  int FFullHeight;
  TTerminal::TSynchronizeMode FOrigMode;
  TUsableCopyParamAttrs FCopyParamAttrs;
  TCopyParamType FCopyParams;
  
  TTerminal::TSynchronizeMode __fastcall GetMode();
};
//---------------------------------------------------------------------------
__fastcall TFullSynchronizeDialog::TFullSynchronizeDialog(
  TCustomFarPlugin * AFarPlugin, int Options,
  const TUsableCopyParamAttrs & CopyParamAttrs) :
  TWinSCPDialog(AFarPlugin)
{
  FOptions = Options;
  FCopyParamAttrs = CopyParamAttrs;

  TFarText * Text;
  TFarSeparator * Separator;

  Size = TPoint(78, 24);
  Caption = GetMsg(FULL_SYNCHRONIZE_TITLE);

  Text = new TFarText(this);
  Text->Caption = GetMsg(FULL_SYNCHRONIZE_LOCAL_LABEL);

  LocalDirectoryEdit = new TFarEdit(this);
  LocalDirectoryEdit->History = LOCAL_SYNC_HISTORY;

  Text = new TFarText(this);
  Text->Caption = GetMsg(FULL_SYNCHRONIZE_REMOTE_LABEL);

  RemoteDirectoryEdit = new TFarEdit(this);
  RemoteDirectoryEdit->History = REMOTE_SYNC_HISTORY;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(FULL_SYNCHRONIZE_DIRECTION_GROUP);

  SynchronizeBothButton = new TFarRadioButton(this);
  SynchronizeBothButton->Caption = GetMsg(FULL_SYNCHRONIZE_BOTH);

  NextItemPosition = ipRight;

  SynchronizeRemoteButton = new TFarRadioButton(this);
  SynchronizeRemoteButton->Caption = GetMsg(FULL_SYNCHRONIZE_REMOTE);

  SynchronizeLocalButton = new TFarRadioButton(this);
  SynchronizeLocalButton->Caption = GetMsg(FULL_SYNCHRONIZE_LOCAL);

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(FULL_SYNCHRONIZE_GROUP);

  SynchronizeTimestampCheck = new TFarCheckBox(this);
  SynchronizeTimestampCheck->Caption = GetMsg(SYNCHRONIZE_TIMESTAMP);
  SynchronizeTimestampCheck->Enabled = FLAGCLEAR(Options, fsoDisableTimestamp);

  SynchronizeDeleteCheck = new TFarCheckBox(this);
  SynchronizeDeleteCheck->Caption = GetMsg(SYNCHRONIZE_DELETE);

  NextItemPosition = ipRight;

  SynchronizeExistingOnlyCheck = new TFarCheckBox(this);
  SynchronizeExistingOnlyCheck->Caption = GetMsg(SYNCHRONIZE_EXISTING_ONLY);
  SynchronizeExistingOnlyCheck->EnabledDependencyNegative = SynchronizeTimestampCheck;

  NextItemPosition = ipNewLine;

  SynchronizePreviewChangesCheck = new TFarCheckBox(this);
  SynchronizePreviewChangesCheck->Caption = GetMsg(SYNCHRONIZE_PREVIEW_CHANGES);

  NextItemPosition = ipRight;

  SynchronizeSelectedOnlyCheck = new TFarCheckBox(this);
  SynchronizeSelectedOnlyCheck->Caption = GetMsg(SYNCHRONIZE_SELECTED_ONLY);
  SynchronizeSelectedOnlyCheck->Enabled = FLAGSET(FOptions, fsoAllowSelectedOnly);

  NextItemPosition = ipNewLine;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(FULL_SYNCHRONIZE_CRITERIONS_GROUP);

  SynchronizeByTimeCheck = new TFarCheckBox(this);
  SynchronizeByTimeCheck->Caption = GetMsg(SYNCHRONIZE_BY_TIME);

  NextItemPosition = ipRight;

  SynchronizeBySizeCheck = new TFarCheckBox(this);
  SynchronizeBySizeCheck->Caption = GetMsg(SYNCHRONIZE_BY_SIZE);
  SynchronizeBySizeCheck->EnabledDependencyNegative = SynchronizeBothButton;

  NextItemPosition = ipNewLine;

  new TFarSeparator(this);

  SaveSettingsCheck = new TFarCheckBox(this);
  SaveSettingsCheck->Caption = GetMsg(SYNCHRONIZE_REUSE_SETTINGS);

  Separator = new TFarSeparator(this);
  Separator->Group = 1;
  Separator->Caption = GetMsg(SYNCHRONIZE_COPY_PARAM_GROUP);

  CopyParamLister = new TFarLister(this);
  CopyParamLister->Height = 3;
  CopyParamLister->Left = BorderBox->Left + 1;
  CopyParamLister->TabStop = false;
  CopyParamLister->OnMouseClick = CopyParamListerClick;
  CopyParamLister->Group = 1;
  // Right edge is adjusted in Change

  // align buttons with bottom of the window
  Separator = new TFarSeparator(this);
  Separator->Position = -4;

  TFarButton * Button = new TFarButton(this);
  Button->Caption = GetMsg(SYNCHRONIZE_TRANSFER_SETTINGS_BUTTON);
  Button->Result = -1;
  Button->CenterGroup = true;
  Button->OnClick = TransferSettingsButtonClick;

  NextItemPosition = ipRight;

  AddStandardButtons(0, true);

  FFullHeight = Size.y;
  AdaptSize();
}
//---------------------------------------------------------------------------
void __fastcall TFullSynchronizeDialog::AdaptSize()
{
  bool ShowCopyParam = (FFullHeight <= MaxSize.y);
  if (ShowCopyParam != CopyParamLister->Visible)
  {
    ShowGroup(1, ShowCopyParam);
    Height = FFullHeight - (ShowCopyParam ? 0 : CopyParamLister->Height + 1);
  }
}
//---------------------------------------------------------------------------
TTerminal::TSynchronizeMode __fastcall TFullSynchronizeDialog::GetMode()
{
  TTerminal::TSynchronizeMode Mode;
  
  if (SynchronizeRemoteButton->Checked)
  {
    Mode = TTerminal::smRemote;
  }
  else if (SynchronizeLocalButton->Checked)
  {
    Mode = TTerminal::smLocal;
  }
  else
  {
    Mode = TTerminal::smBoth;
  }

  return Mode;
}
//---------------------------------------------------------------------------
void __fastcall TFullSynchronizeDialog::TransferSettingsButtonClick(
  TFarButton * /*Sender*/, bool & Close)
{
  CustomCopyParam();
  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TFullSynchronizeDialog::CopyParamListerClick(
  TFarDialogItem * /*Item*/, MOUSE_EVENT_RECORD * Event)
{
  if (FLAGSET(Event->dwEventFlags, DOUBLE_CLICK))
  {
    CustomCopyParam();
  }
}
//---------------------------------------------------------------------------
void __fastcall TFullSynchronizeDialog::CustomCopyParam()
{
  TWinSCPPlugin * WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);
  if (WinSCPPlugin->CopyParamCustomDialog(FCopyParams, ActualCopyParamAttrs()))
  {
    Change();
  }
}
//---------------------------------------------------------------------------
void __fastcall TFullSynchronizeDialog::Change()
{
  TWinSCPDialog::Change();

  if (Handle)
  {
    if (SynchronizeTimestampCheck->Checked)
    {
      SynchronizeExistingOnlyCheck->Checked = true;
      SynchronizeDeleteCheck->Checked = false;
      SynchronizeByTimeCheck->Checked = true;
    }
    if (SynchronizeBothButton->Checked)
    {
      SynchronizeBySizeCheck->Checked = false;
    }
    SynchronizeDeleteCheck->Enabled = !SynchronizeBothButton->Checked && 
      !SynchronizeTimestampCheck->Checked;
    SynchronizeByTimeCheck->Enabled = !SynchronizeBothButton->Checked && 
      !SynchronizeTimestampCheck->Checked;

    SynchronizeBySizeCheck->Caption = SynchronizeTimestampCheck->Checked ?
      GetMsg(SYNCHRONIZE_SAME_SIZE) : GetMsg(SYNCHRONIZE_BY_SIZE);

    if (!SynchronizeBySizeCheck->Checked && !SynchronizeByTimeCheck->Checked)
    {
      // suppose that in FAR the checkbox cannot be unchecked unless focused
      if (SynchronizeByTimeCheck->Focused())
      {
        SynchronizeBySizeCheck->Checked = true;
      }
      else
      {
        SynchronizeByTimeCheck->Checked = true;
      }
    }

    AnsiString InfoStr = FCopyParams.GetInfoStr("; ", ActualCopyParamAttrs());
    TStringList * InfoStrLines = new TStringList();
    try
    {
      FarWrapText(InfoStr, InfoStrLines, BorderBox->Width - 4);
      CopyParamLister->Items = InfoStrLines;
      CopyParamLister->Right = BorderBox->Right - (CopyParamLister->ScrollBar ? 0 : 1);
    }
    __finally
    {
      delete InfoStrLines;
    }
  }
}
//---------------------------------------------------------------------------
int __fastcall TFullSynchronizeDialog::ActualCopyParamAttrs()
{
  int Result;
  if (SynchronizeTimestampCheck->Checked)
  {
    Result = cpaExcludeMaskOnly;
  }
  else
  {
    switch (GetMode())
    {
      case TTerminal::smRemote:
        Result = FCopyParamAttrs.Upload;
        break;

      case TTerminal::smLocal:
        Result = FCopyParamAttrs.Download;
        break;

      default:
        assert(false);
        //fallthru
      case TTerminal::smBoth:
        Result = FCopyParamAttrs.General;
        break;
    }
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TFullSynchronizeDialog::CloseQuery()
{
  bool CanClose = TWinSCPDialog::CloseQuery();

  if (CanClose && (Result == brOK) &&
      SaveSettingsCheck->Checked && (FOrigMode != GetMode()) && !FSaveMode)
  {
    TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);

    switch (WinSCPPlugin->MoreMessageDialog(GetMsg(SAVE_SYNCHRONIZE_MODE), NULL,
            qtConfirmation, qaYes | qaNo | qaCancel, 0))
    {
      case qaYes:
        FSaveMode = true;
        break;

      case qaCancel:
        CanClose = false;
        break;
    }
  }
  
  return CanClose;
}
//---------------------------------------------------------------------------
long __fastcall TFullSynchronizeDialog::DialogProc(int Msg, int Param1, long Param2)
{
  if (Msg == DN_RESIZECONSOLE)
  {
    AdaptSize();
  }

  return TFarDialog::DialogProc(Msg, Param1, Param2);
}
//---------------------------------------------------------------------------
bool __fastcall TFullSynchronizeDialog::Execute(TTerminal::TSynchronizeMode & Mode,
  int & Params, AnsiString & LocalDirectory, AnsiString & RemoteDirectory,
  TCopyParamType * CopyParams, bool & SaveSettings, bool & SaveMode)
{
  LocalDirectoryEdit->Text = LocalDirectory;
  RemoteDirectoryEdit->Text = RemoteDirectory;
  SynchronizeRemoteButton->Checked = (Mode == TTerminal::smRemote);
  SynchronizeLocalButton->Checked = (Mode == TTerminal::smLocal);
  SynchronizeBothButton->Checked = (Mode == TTerminal::smBoth);
  SynchronizeDeleteCheck->Checked = FLAGSET(Params, TTerminal::spDelete);
  SynchronizeExistingOnlyCheck->Checked = FLAGSET(Params, TTerminal::spExistingOnly);
  SynchronizePreviewChangesCheck->Checked = FLAGSET(Params, TTerminal::spPreviewChanges);
  SynchronizeSelectedOnlyCheck->Checked = FLAGSET(Params, spSelectedOnly);
  SynchronizeTimestampCheck->Checked = FLAGSET(Params, TTerminal::spTimestamp) &&
    FLAGCLEAR(FOptions, fsoDisableTimestamp);
  SynchronizeByTimeCheck->Checked = FLAGCLEAR(Params, TTerminal::spNotByTime);
  SynchronizeBySizeCheck->Checked = FLAGSET(Params, TTerminal::spBySize);
  SaveSettingsCheck->Checked = SaveSettings;
  FSaveMode = SaveMode;
  FOrigMode = Mode;
  FCopyParams = *CopyParams;

  bool Result = (ShowModal() == brOK);

  if (Result)
  {
    RemoteDirectory = RemoteDirectoryEdit->Text;
    LocalDirectory = LocalDirectoryEdit->Text;

    Mode = GetMode();

    Params &= ~(TTerminal::spDelete | TTerminal::spNoConfirmation |
      TTerminal::spExistingOnly | TTerminal::spPreviewChanges |
      TTerminal::spTimestamp | TTerminal::spNotByTime | TTerminal::spBySize |
      spSelectedOnly);
    Params |=
      FLAGMASK(SynchronizeDeleteCheck->Checked, TTerminal::spDelete) |
      FLAGMASK(SynchronizeExistingOnlyCheck->Checked, TTerminal::spExistingOnly) |
      FLAGMASK(SynchronizePreviewChangesCheck->Checked, TTerminal::spPreviewChanges) |
      FLAGMASK(SynchronizeSelectedOnlyCheck->Checked, spSelectedOnly) |
      FLAGMASK(SynchronizeTimestampCheck->Checked && FLAGCLEAR(FOptions, fsoDisableTimestamp),
        TTerminal::spTimestamp) |
      FLAGMASK(!SynchronizeByTimeCheck->Checked, TTerminal::spNotByTime) | 
      FLAGMASK(SynchronizeBySizeCheck->Checked, TTerminal::spBySize);

    SaveSettings = SaveSettingsCheck->Checked;
    SaveMode = FSaveMode;
    *CopyParams = FCopyParams;
  }

  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::FullSynchronizeDialog(TTerminal::TSynchronizeMode & Mode,
  int & Params, AnsiString & LocalDirectory, AnsiString & RemoteDirectory,
  TCopyParamType * CopyParams, bool & SaveSettings, bool & SaveMode, int Options,
  const TUsableCopyParamAttrs & CopyParamAttrs)
{
  bool Result;
  TFullSynchronizeDialog * Dialog = new TFullSynchronizeDialog(
    FPlugin, Options, CopyParamAttrs);
  try
  {
    Result = Dialog->Execute(Mode, Params, LocalDirectory, RemoteDirectory,
      CopyParams, SaveSettings, SaveMode);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TSynchronizeChecklistDialog : public TWinSCPDialog
{
public:
  __fastcall TSynchronizeChecklistDialog(
    TCustomFarPlugin * AFarPlugin, TTerminal::TSynchronizeMode Mode, int Params,
    const AnsiString LocalDirectory, const AnsiString RemoteDirectory);

  bool __fastcall Execute(TSynchronizeChecklist * Checklist);

protected:
  virtual long __fastcall DialogProc(int Msg, int Param1, long Param2);
  virtual bool __fastcall Key(TFarDialogItem * Item, long KeyCode);
  void __fastcall CheckAllButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall VideoModeButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall ListBoxClick(TFarDialogItem * Item, MOUSE_EVENT_RECORD * Event);

private:
  TFarText * Header;
  TFarListBox * ListBox;
  TFarButton * CheckAllButton;
  TFarButton * UncheckAllButton;
  TFarButton * VideoModeButton;

  TSynchronizeChecklist * FChecklist;
  AnsiString FLocalDirectory;
  AnsiString FRemoteDirectory;
  static const size_t FColumns = 8;
  int FWidths[FColumns];
  AnsiString FActions[TSynchronizeChecklist::ActionCount];
  int FScroll;
  bool FCanScrollRight;
  int FChecked;

  void __fastcall AdaptSize();
  int __fastcall ColumnWidth(int Index);
  void __fastcall LoadChecklist();
  void __fastcall RefreshChecklist(bool Scroll);
  void __fastcall UpdateControls();
  void __fastcall CheckAll(bool Check);
  AnsiString __fastcall ItemLine(const TSynchronizeChecklist::TItem * ChecklistItem);
  inline void AddColumn(AnsiString & List, const AnsiString & Value, int Width,
    bool Header = false);
  AnsiString __fastcall FormatSize(__int64 Size, int Column);
  static inline AnsiString FarModificationStr(const TDateTime & DateTime,
    TModificationFmt Precision);
};
//---------------------------------------------------------------------------
__fastcall TSynchronizeChecklistDialog::TSynchronizeChecklistDialog(
  TCustomFarPlugin * AFarPlugin, TTerminal::TSynchronizeMode /*Mode*/, int /*Params*/,
  const AnsiString LocalDirectory, const AnsiString RemoteDirectory) :
  TWinSCPDialog(AFarPlugin),
  FChecklist(NULL),
  FLocalDirectory(LocalDirectory),
  FRemoteDirectory(RemoteDirectory),
  FScroll(0),
  FCanScrollRight(false)
{
  Caption = GetMsg(CHECKLIST_TITLE);

  Header = new TFarText(this);

  ListBox = new TFarListBox(this);
  ListBox->NoBox = true;
  // align list with bottom of the window
  ListBox->Bottom = -5;
  ListBox->OnMouseClick = ListBoxClick;

  AnsiString Actions = GetMsg(CHECKLIST_ACTIONS);
  int Action = 0;
  while (!Actions.IsEmpty() && (Action < LENOF(FActions)))
  {
    FActions[Action] = CutToChar(Actions, '|', false);
    Action++;
  }

  // align buttons with bottom of the window
  ButtonSeparator = new TFarSeparator(this);
  ButtonSeparator->Top = -4;
  ButtonSeparator->Bottom = ButtonSeparator->Top;

  CheckAllButton = new TFarButton(this);
  CheckAllButton->Caption = GetMsg(CHECKLIST_CHECK_ALL);
  CheckAllButton->CenterGroup = true;
  CheckAllButton->OnClick = CheckAllButtonClick;

  NextItemPosition = ipRight;

  UncheckAllButton = new TFarButton(this);
  UncheckAllButton->Caption = GetMsg(CHECKLIST_UNCHECK_ALL);
  UncheckAllButton->CenterGroup = true;
  UncheckAllButton->OnClick = CheckAllButtonClick;

  VideoModeButton = new TFarButton(this);
  VideoModeButton->CenterGroup = true;
  VideoModeButton->OnClick = VideoModeButtonClick;

  AddStandardButtons(0, true);

  AdaptSize();
  UpdateControls();
  ListBox->SetFocus();
}
//---------------------------------------------------------------------------
inline void TSynchronizeChecklistDialog::AddColumn(AnsiString & List,
  const AnsiString & Value, int Column, bool Header)
{
  char Separator = '\xB3';
  int Len = Value.Length();
  int Width = FWidths[Column];
  bool Right = (Column == 2) || (Column == 3) || (Column == 6) || (Column == 7);
  bool LastCol = (Column == FColumns - 1);
  if (Len <= Width)
  {
    int Added = 0;
    if (Header && (Len < Width))
    {
      Added += (Width - Len) / 2;
    }
    else if (Right && (Len < Width))
    {
      Added += Width - Len;
    }
    List += AnsiString::StringOfChar(' ', Added) + Value;
    Added += Value.Length();
    if (Width > Added)
    {
      List += AnsiString::StringOfChar(' ', Width - Added);
    }
    if (!LastCol)
    {
      List += Separator;
    }
  }
  else
  {
    int Scroll = FScroll;
    if ((Scroll > 0) && !Header)
    {
      if (List.IsEmpty())
      {
        List += '{';
        Width--;
        Scroll++;
      }
      else
      {
        List[List.Length()] = '{';
      }
    }
    if (Scroll > Len - Width)
    {
      Scroll = Len - Width;
    }
    else if (!Header && LastCol && (Scroll < Len - Width))
    {
      Width--;
    }
    List += Value.SubString(Scroll + 1, Width);
    if (!Header && (Len - Scroll > Width))
    {
      List += '}';
      FCanScrollRight = true;
    }
    else if (!LastCol)
    {
      List += Separator;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeChecklistDialog::AdaptSize()
{
  FScroll = 0;
  Size = MaxSize;

  VideoModeButton->Caption = GetMsg(
    FarPlugin->ConsoleWindowState() == SW_SHOWMAXIMIZED ?
      CHECKLIST_RESTORE : CHECKLIST_MAXIMIZE);

  static const Ratio[FColumns] = { 140, 100, 80, 150, -2, 100, 80, 150 };

  int Width = ListBox->Width - 2 /*checkbox*/ - 1 /*scrollbar*/ - FColumns;
  double Temp[FColumns];

  int TotalRatio = 0;
  int FixedRatio = 0;
  for (int Index = 0; Index < FColumns; Index++)
  {
    if (Ratio[Index] >= 0)
    {
      TotalRatio += Ratio[Index];
    }
    else
    {
      FixedRatio += -Ratio[Index];
    }
  }

  int TotalAssigned = 0;
  for (int Index = 0; Index < FColumns; Index++)
  {
    if (Ratio[Index] >= 0)
    {
      double W = static_cast<float>(Ratio[Index]) * (Width - FixedRatio) / TotalRatio;
      FWidths[Index] = floor(W);
      Temp[Index] = W - FWidths[Index];
    }
    else
    {
      FWidths[Index] = -Ratio[Index];
      Temp[Index] = 0;
    }
    TotalAssigned += FWidths[Index];
  }

  while (TotalAssigned < Width)
  {
    int GrowIndex = 0;
    double MaxMissing = 0.0;
    for (int Index = 0; Index < FColumns; Index++)
    {
      if (MaxMissing < Temp[Index])
      {
        MaxMissing = Temp[Index];
        GrowIndex = Index;
      }
    }

    assert(MaxMissing > 0.0);
    
    FWidths[GrowIndex]++;
    Temp[GrowIndex] = 0.0;
    TotalAssigned++; 
  }

  RefreshChecklist(false);
}
//---------------------------------------------------------------------------
AnsiString __fastcall TSynchronizeChecklistDialog::FormatSize(
  __int64 Size, int Column)
{
  int Width = FWidths[Column];
  AnsiString Result = FormatFloat("#,##0", Size);

  if (Result.Length() > Width)
  {
    Result = FormatFloat("0", Size);

    if (Result.Length() > Width)
    {
      Result = FormatFloat("0 'K'", Size / 1024);
      if (Result.Length() > Width)
      {
        Result = FormatFloat("0 'M'", Size / (1024*1024));
        if (Result.Length() > Width)
        {
          Result = FormatFloat("0 'G'", Size / (1024*1024*1024));
          if (Result.Length() > Width)
          {
            // back to default
            Result = FormatFloat("#,##0", Size);
          }
        }
      }
    }
  }

  return Result;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TSynchronizeChecklistDialog::ItemLine(
  const TSynchronizeChecklist::TItem * ChecklistItem)
{
  AnsiString Line;
  AnsiString S;

  S = ChecklistItem->FileName;
  if (ChecklistItem->IsDirectory)
  {
    S = IncludeTrailingBackslash(S);
  }
  AddColumn(Line, S, 0);

  if (ChecklistItem->Action == TSynchronizeChecklist::saDeleteRemote)
  {
    AddColumn(Line, "", 1);
    AddColumn(Line, "", 2);
    AddColumn(Line, "", 3);
  }
  else
  {
    S = ChecklistItem->Local.Directory;
    if (AnsiSameText(FLocalDirectory, S.SubString(1, FLocalDirectory.Length())))
    {
      S[1] = '.';
      S.Delete(2, FLocalDirectory.Length() - 1);
    }
    else
    {
      assert(false);
    }
    AddColumn(Line, S, 1);
    if (ChecklistItem->Action == TSynchronizeChecklist::saDownloadNew)
    {
      AddColumn(Line, "", 2);
      AddColumn(Line, "", 3);
    }
    else
    {
      if (ChecklistItem->IsDirectory)
      {
        AddColumn(Line, "", 2);
      }
      else
      {
        AddColumn(Line, FormatSize(ChecklistItem->Local.Size, 2), 2);
      }
      AddColumn(Line, UserModificationStr(ChecklistItem->Local.Modification,
        ChecklistItem->Local.ModificationFmt), 3);
    }
  }

  int Action = int(ChecklistItem->Action) - 1;
  assert(Action < LENOF(FActions));
  AddColumn(Line, FActions[Action], 4);

  if (ChecklistItem->Action == TSynchronizeChecklist::saDeleteLocal)
  {
    AddColumn(Line, "", 5);
    AddColumn(Line, "", 6);
    AddColumn(Line, "", 7);
  }
  else
  {
    S = ChecklistItem->Remote.Directory;
    if (AnsiSameText(FRemoteDirectory, S.SubString(1, FRemoteDirectory.Length())))
    {
      S[1] = '.';
      S.Delete(2, FRemoteDirectory.Length() - 1);
    }
    else
    {
      assert(false);
    }
    AddColumn(Line, S, 5);
    if (ChecklistItem->Action == TSynchronizeChecklist::saUploadNew)
    {
      AddColumn(Line, "", 6);
      AddColumn(Line, "", 7);
    }
    else
    {
      if (ChecklistItem->IsDirectory)
      {
        AddColumn(Line, "", 6);
      }
      else
      {
        AddColumn(Line, FormatSize(ChecklistItem->Remote.Size, 6), 6);
      }
      AddColumn(Line, UserModificationStr(ChecklistItem->Remote.Modification,
        ChecklistItem->Remote.ModificationFmt), 7);
    }
  }

  return Line;
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeChecklistDialog::LoadChecklist()
{
  FChecked = 0;
  TFarList * List = new TFarList();
  try
  {
    List->BeginUpdate();
    for (int Index = 0; Index < FChecklist->Count; Index++)
    {
      const TSynchronizeChecklist::TItem * ChecklistItem = FChecklist->Item[Index];

      List->AddObject(ItemLine(ChecklistItem),
        const_cast<TObject *>(reinterpret_cast<const TObject *>(ChecklistItem)));
    }
    List->EndUpdate();

    // items must be checked in second pass once the internal array is allocated
    for (int Index = 0; Index < FChecklist->Count; Index++)
    {
      const TSynchronizeChecklist::TItem * ChecklistItem = FChecklist->Item[Index];

      List->Checked[Index] = ChecklistItem->Checked;
      if (ChecklistItem->Checked)
      {
        FChecked++;
      }
    }
    
    ListBox->Items = List;
  }
  __finally
  {
    delete List;
  }

  UpdateControls();
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeChecklistDialog::RefreshChecklist(bool Scroll)
{
  AnsiString HeaderStr = GetMsg(CHECKLIST_HEADER);
  AnsiString HeaderCaption(AnsiString::StringOfChar(' ', 2));

  for (int Index = 0; Index < FColumns; Index++)
  {
    AddColumn(HeaderCaption, CutToChar(HeaderStr, '|', false), Index, true);
  }
  Header->Caption = HeaderCaption;

  FCanScrollRight = false;
  TFarList * List = ListBox->Items;
  List->BeginUpdate();
  try
  {
    for (int Index = 0; Index < List->Count; Index++)
    {
      if (!Scroll || (List->Strings[Index].LastDelimiter("{}") > 0))
      {
        const TSynchronizeChecklist::TItem * ChecklistItem =
          reinterpret_cast<TSynchronizeChecklist::TItem *>(List->Objects[Index]);
        
        List->Strings[Index] = ItemLine(ChecklistItem);
      }
    }
  }
  __finally
  {
    List->EndUpdate();
  }  
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeChecklistDialog::UpdateControls()
{
  ButtonSeparator->Caption =
    FORMAT(GetMsg(CHECKLIST_CHECKED), (FChecked, ListBox->Items->Count));
  CheckAllButton->Enabled = (FChecked < ListBox->Items->Count);
  UncheckAllButton->Enabled = (FChecked > 0);
}
//---------------------------------------------------------------------------
long __fastcall TSynchronizeChecklistDialog::DialogProc(int Msg, int Param1, long Param2)
{
  if (Msg == DN_RESIZECONSOLE)
  {
    AdaptSize();
  }
  
  return TFarDialog::DialogProc(Msg, Param1, Param2);
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeChecklistDialog::CheckAll(bool Check)
{
  TFarList * List = ListBox->Items;
  List->BeginUpdate();
  try
  {
    int Count = List->Count;
    for (int Index = 0; Index < Count; Index++)
    {
      List->Checked[Index] = Check;
    }

    FChecked = (Check ? Count : 0);
  }
  __finally
  {
    List->EndUpdate();
  }  

  UpdateControls();
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeChecklistDialog::CheckAllButtonClick(
  TFarButton * Sender, bool & Close)
{
  CheckAll(Sender == CheckAllButton);
  ListBox->SetFocus();

  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeChecklistDialog::VideoModeButtonClick(
  TFarButton * /*Sender*/, bool & Close)
{
  FarPlugin->ToggleVideoMode();

  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeChecklistDialog::ListBoxClick(
  TFarDialogItem * /*Item*/, MOUSE_EVENT_RECORD * /*Event*/)
{
  int Index = ListBox->Items->Selected;
  if (Index >= 0)
  {
    if (ListBox->Items->Checked[Index])
    {
      ListBox->Items->Checked[Index] = false;
      FChecked--;
    }
    else if (!ListBox->Items->Checked[Index])
    {
      ListBox->Items->Checked[Index] = true;
      FChecked++;
    }

    UpdateControls();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TSynchronizeChecklistDialog::Key(TFarDialogItem * Item, long KeyCode)
{
  bool Result = false;
  if (ListBox->Focused())
  {
    if ((KeyCode == KEY_SHIFTADD) || (KeyCode == KEY_SHIFTSUBTRACT))
    {
      CheckAll(KeyCode == KEY_SHIFTADD);
      Result = true;
    }
    else if ((KeyCode == KEY_SPACE) || (KeyCode == KEY_INS) ||
             (KeyCode == KEY_ADD) || (KeyCode == KEY_SUBTRACT))
    {
      int Index = ListBox->Items->Selected;
      if (Index >= 0)
      {
        if (ListBox->Items->Checked[Index] && (KeyCode != KEY_ADD))
        {
          ListBox->Items->Checked[Index] = false;
          FChecked--;
        }
        else if (!ListBox->Items->Checked[Index] && (KeyCode != KEY_SUBTRACT))
        {
          ListBox->Items->Checked[Index] = true;
          FChecked++;
        }

        // FAR WORKAROUND
        // Changing "checked" state is not always drawn.
        Redraw();
        UpdateControls();
        if ((KeyCode == KEY_INS) &&
            (Index < ListBox->Items->Count - 1))
        {
          ListBox->Items->Selected = Index + 1;
        }
      }
      Result = true;
    }
    else if (KeyCode == KEY_ALTLEFT)
    {
      if (FScroll > 0)
      {
        FScroll--;
        RefreshChecklist(true);
      }
      Result = true;
    }
    else if (KeyCode == KEY_ALTRIGHT)
    {
      if (FCanScrollRight)
      {
        FScroll++;
        RefreshChecklist(true);
      }
      Result = true;
    }
  }

  if (!Result)
  {
    Result = TWinSCPDialog::Key(Item, KeyCode);
  }

  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TSynchronizeChecklistDialog::Execute(TSynchronizeChecklist * Checklist)
{
  FChecklist = Checklist;
  LoadChecklist();
  bool Result = (ShowModal() == brOK);

  if (Result)
  {
    TFarList * List = ListBox->Items;
    int Count = List->Count;
    for (int Index = 0; Index < Count; Index++)
    {
      TSynchronizeChecklist::TItem * ChecklistItem =
        reinterpret_cast<TSynchronizeChecklist::TItem *>(List->Objects[Index]);
      ChecklistItem->Checked = List->Checked[Index];
    }
  }

  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::SynchronizeChecklistDialog(
  TSynchronizeChecklist * Checklist, TTerminal::TSynchronizeMode Mode, int Params,
  const AnsiString LocalDirectory, const AnsiString RemoteDirectory)
{
  bool Result;
  TSynchronizeChecklistDialog * Dialog = new TSynchronizeChecklistDialog(
    FPlugin, Mode, Params, LocalDirectory, RemoteDirectory);
  try
  {
    Result = Dialog->Execute(Checklist);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TSynchronizeDialog : TFarDialog
{
public:
  __fastcall TSynchronizeDialog(TCustomFarPlugin * AFarPlugin,
    TSynchronizeStartStopEvent OnStartStop,
    int Options, int CopyParamAttrs, TGetSynchronizeOptionsEvent OnGetOptions);
  virtual __fastcall ~TSynchronizeDialog();

  bool __fastcall Execute(TSynchronizeParamType & Params,
    const TCopyParamType * CopyParams, bool & SaveSettings);

protected:
  virtual void __fastcall Change();
  void __fastcall UpdateControls();
  void __fastcall StartButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall StopButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall TransferSettingsButtonClick(TFarButton * Sender, bool & Close);
  void __fastcall CopyParamListerClick(TFarDialogItem * Item, MOUSE_EVENT_RECORD * Event);
  void __fastcall Stop();
  void __fastcall DoStartStop(bool Start, bool Synchronize);
  TSynchronizeParamType __fastcall GetParams();
  void __fastcall DoAbort(TObject * Sender, bool Close);
  void __fastcall DoLog(TSynchronizeController * Controller,
    TSynchronizeLogEntry Entry, const AnsiString Message);
  void __fastcall DoSynchronizeThreads(TObject * Sender, TThreadMethod Method);
  virtual long __fastcall DialogProc(int Msg, int Param1, long Param2);
  virtual bool __fastcall CloseQuery();
  virtual bool __fastcall Key(TFarDialogItem * Item, long KeyCode);
  TCopyParamType __fastcall GetCopyParams();
  int __fastcall ActualCopyParamAttrs();
  void __fastcall CustomCopyParam();

private:
  bool FSynchronizing;
  bool FStarted;
  bool FAbort;
  bool FClose;
  TSynchronizeParamType FParams;
  TSynchronizeStartStopEvent FOnStartStop;
  int FOptions;
  TSynchronizeOptions * FSynchronizeOptions;
  TCopyParamType FCopyParams;
  TGetSynchronizeOptionsEvent FOnGetOptions;
  int FCopyParamAttrs;

  TFarEdit * LocalDirectoryEdit;
  TFarEdit * RemoteDirectoryEdit;
  TFarCheckBox * SynchronizeDeleteCheck;
  TFarCheckBox * SynchronizeExistingOnlyCheck;
  TFarCheckBox * SynchronizeSelectedOnlyCheck;
  TFarCheckBox * SynchronizeRecursiveCheck;
  TFarCheckBox * SynchronizeSynchronizeCheck;
  TFarCheckBox * SaveSettingsCheck;
  TFarButton * StartButton;
  TFarButton * StopButton;
  TFarButton * CloseButton;
  TFarLister * CopyParamLister;
};
//---------------------------------------------------------------------------
__fastcall TSynchronizeDialog::TSynchronizeDialog(TCustomFarPlugin * AFarPlugin,
  TSynchronizeStartStopEvent OnStartStop,
  int Options, int CopyParamAttrs, TGetSynchronizeOptionsEvent OnGetOptions) :
  TFarDialog(AFarPlugin)
{
  TFarText * Text;
  TFarSeparator * Separator;

  FSynchronizing = false;
  FStarted = false;
  FOnStartStop = OnStartStop;
  FAbort = false;
  FClose = false;
  FOptions = Options;
  FOnGetOptions = OnGetOptions;
  FSynchronizeOptions = NULL;
  FCopyParamAttrs = CopyParamAttrs;

  Size = TPoint(76, 20);

  DefaultGroup = 1;

  Text = new TFarText(this);
  Text->Caption = GetMsg(SYNCHRONIZE_LOCAL_LABEL);

  LocalDirectoryEdit = new TFarEdit(this);
  LocalDirectoryEdit->History = LOCAL_SYNC_HISTORY;

  Text = new TFarText(this);
  Text->Caption = GetMsg(SYNCHRONIZE_REMOTE_LABEL);

  RemoteDirectoryEdit = new TFarEdit(this);
  RemoteDirectoryEdit->History = REMOTE_SYNC_HISTORY;

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(SYNCHRONIZE_GROUP);
  Separator->Group = 0;

  SynchronizeDeleteCheck = new TFarCheckBox(this);
  SynchronizeDeleteCheck->Caption = GetMsg(SYNCHRONIZE_DELETE);

  NextItemPosition = ipRight;

  SynchronizeExistingOnlyCheck = new TFarCheckBox(this);
  SynchronizeExistingOnlyCheck->Caption = GetMsg(SYNCHRONIZE_EXISTING_ONLY);

  NextItemPosition = ipNewLine;

  SynchronizeRecursiveCheck = new TFarCheckBox(this);
  SynchronizeRecursiveCheck->Caption = GetMsg(SYNCHRONIZE_RECURSIVE);

  NextItemPosition = ipRight;

  SynchronizeSelectedOnlyCheck = new TFarCheckBox(this);
  SynchronizeSelectedOnlyCheck->Caption = GetMsg(SYNCHRONIZE_SELECTED_ONLY);
  // have more complex enable rules
  SynchronizeSelectedOnlyCheck->Group = 0;

  NextItemPosition = ipNewLine;

  SynchronizeSynchronizeCheck = new TFarCheckBox(this);
  SynchronizeSynchronizeCheck->Caption = GetMsg(SYNCHRONIZE_SYNCHRONIZE);
  SynchronizeSynchronizeCheck->AllowGrayed = true;

  Separator = new TFarSeparator(this);
  Separator->Group = 0;

  SaveSettingsCheck = new TFarCheckBox(this);
  SaveSettingsCheck->Caption = GetMsg(SYNCHRONIZE_REUSE_SETTINGS);

  Separator = new TFarSeparator(this);
  Separator->Caption = GetMsg(SYNCHRONIZE_COPY_PARAM_GROUP);

  CopyParamLister = new TFarLister(this);
  CopyParamLister->Height = 3;
  CopyParamLister->Left = BorderBox->Left + 1;
  CopyParamLister->TabStop = false;
  CopyParamLister->OnMouseClick = CopyParamListerClick;
  // Right edge is adjusted in Change

  DefaultGroup = 0;

  // align buttons with bottom of the window
  Separator = new TFarSeparator(this);
  Separator->Position = -4;

  TFarButton * Button = new TFarButton(this);
  Button->Caption = GetMsg(SYNCHRONIZE_TRANSFER_SETTINGS_BUTTON);
  Button->Result = -1;
  Button->CenterGroup = true;
  Button->OnClick = TransferSettingsButtonClick;

  NextItemPosition = ipRight;

  StartButton = new TFarButton(this);
  StartButton->Caption = GetMsg(SYNCHRONIZE_START_BUTTON);
  StartButton->Default = true;
  StartButton->CenterGroup = true;
  StartButton->OnClick = StartButtonClick;

  StopButton = new TFarButton(this);
  StopButton->Caption = GetMsg(SYNCHRONIZE_STOP_BUTTON);
  StopButton->CenterGroup = true;
  StopButton->OnClick = StopButtonClick;

  NextItemPosition = ipRight;

  CloseButton = new TFarButton(this);
  CloseButton->Caption = GetMsg(MSG_BUTTON_Close);
  CloseButton->Result = brCancel;
  CloseButton->CenterGroup = true;
}
//---------------------------------------------------------------------------
__fastcall TSynchronizeDialog::~TSynchronizeDialog()
{
  delete FSynchronizeOptions;
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::TransferSettingsButtonClick(
  TFarButton * /*Sender*/, bool & Close)
{
  CustomCopyParam();
  Close = false;
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::CopyParamListerClick(
  TFarDialogItem * /*Item*/, MOUSE_EVENT_RECORD * Event)
{
  if (FLAGSET(Event->dwEventFlags, DOUBLE_CLICK))
  {
    CustomCopyParam();
  }
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::CustomCopyParam()
{
  TWinSCPPlugin * WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);
  // PreserveTime is forced for some settings, but avoid hard-setting it until
  // use really confirms it on cutom dialog
  TCopyParamType ACopyParams = GetCopyParams();
  if (WinSCPPlugin->CopyParamCustomDialog(ACopyParams, ActualCopyParamAttrs()))
  {
    FCopyParams = ACopyParams;
    Change();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TSynchronizeDialog::Execute(TSynchronizeParamType & Params,
  const TCopyParamType * CopyParams, bool & SaveSettings)
{
  RemoteDirectoryEdit->Text = Params.RemoteDirectory;
  LocalDirectoryEdit->Text = Params.LocalDirectory;
  SynchronizeDeleteCheck->Checked = FLAGSET(Params.Params, TTerminal::spDelete);
  SynchronizeExistingOnlyCheck->Checked = FLAGSET(Params.Params, TTerminal::spExistingOnly);
  SynchronizeSelectedOnlyCheck->Checked = FLAGSET(Params.Params, spSelectedOnly);
  SynchronizeRecursiveCheck->Checked = FLAGSET(Params.Options, soRecurse);
  SynchronizeSynchronizeCheck->Selected = 
    FLAGSET(Params.Options, soSynchronizeAsk) ? BSTATE_3STATE :
      (FLAGSET(Params.Options, soSynchronize) ? BSTATE_CHECKED : BSTATE_UNCHECKED);
  SaveSettingsCheck->Checked = SaveSettings;

  FParams = Params;
  FCopyParams = *CopyParams;

  ShowModal();

  Params = GetParams();
  SaveSettings = SaveSettingsCheck->Checked;

  return true;
}
//---------------------------------------------------------------------------
TSynchronizeParamType __fastcall TSynchronizeDialog::GetParams()
{
  TSynchronizeParamType Result = FParams;
  Result.RemoteDirectory = RemoteDirectoryEdit->Text;
  Result.LocalDirectory = LocalDirectoryEdit->Text;
  Result.Params =
    (Result.Params & ~(TTerminal::spDelete | TTerminal::spExistingOnly |
     spSelectedOnly | TTerminal::spTimestamp)) |
    FLAGMASK(SynchronizeDeleteCheck->Checked, TTerminal::spDelete) |
    FLAGMASK(SynchronizeExistingOnlyCheck->Checked, TTerminal::spExistingOnly) |
    FLAGMASK(SynchronizeSelectedOnlyCheck->Checked, spSelectedOnly);
  Result.Options = 
    (Result.Options & ~(soRecurse | soSynchronize | soSynchronizeAsk)) |
    FLAGMASK(SynchronizeRecursiveCheck->Checked, soRecurse) |
    FLAGMASK(SynchronizeSynchronizeCheck->Selected == BSTATE_CHECKED, soSynchronize) |
    FLAGMASK(SynchronizeSynchronizeCheck->Selected == BSTATE_3STATE, soSynchronizeAsk);
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::DoStartStop(bool Start, bool Synchronize)
{
  if (FOnStartStop)
  {
    TSynchronizeParamType SParams = GetParams();
    SParams.Options =
      (SParams.Options & ~(soSynchronize | soSynchronizeAsk)) |
      FLAGMASK(Synchronize, soSynchronize);
    if (Start)
    {
      delete FSynchronizeOptions;
      FSynchronizeOptions = new TSynchronizeOptions;
      FOnGetOptions(SParams.Params, *FSynchronizeOptions);
    }
    FOnStartStop(this, Start, SParams, GetCopyParams(), FSynchronizeOptions, DoAbort,
      DoSynchronizeThreads, DoLog);
  }
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::DoSynchronizeThreads(TObject * /*Sender*/,
  TThreadMethod Method)
{
  if (FStarted)
  {
    Synchronize(Method);
  }
}
//---------------------------------------------------------------------------
long __fastcall TSynchronizeDialog::DialogProc(int Msg, int Param1, long Param2)
{
  if (FAbort)
  {
    FAbort = false;
    
    if (FSynchronizing)
    {
      Stop();
    }

    if (FClose)
    {
      assert(CloseButton->Enabled);
      Close(CloseButton);
    }
  }

  return TFarDialog::DialogProc(Msg, Param1, Param2);
}
//---------------------------------------------------------------------------
bool __fastcall TSynchronizeDialog::CloseQuery()
{
  return TFarDialog::CloseQuery() && !FSynchronizing;
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::DoAbort(TObject * /*Sender*/, bool Close)
{
  FAbort = true;
  FClose = Close;
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::DoLog(TSynchronizeController * /*Controller*/,
  TSynchronizeLogEntry /*Entry*/, const AnsiString /*Message*/)
{
  // void
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::StartButtonClick(TFarButton * /*Sender*/,
  bool & /*Close*/)
{
  bool Synchronize;
  bool Continue = true;
  if (SynchronizeSynchronizeCheck->Selected == BSTATE_3STATE)
  {
    TMessageParams Params;
    Params.Params = qpNeverAskAgainCheck;
    TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);
    switch (WinSCPPlugin->MoreMessageDialog(GetMsg(SYNCHRONISE_BEFORE_KEEPUPTODATE),
        NULL, qtConfirmation, qaYes | qaNo | qaCancel, &Params))
    {
      case qaNeverAskAgain:
        SynchronizeSynchronizeCheck->Selected = BSTATE_CHECKED;
        // fall thru

      case qaYes:
        Synchronize = true;
        break;

      case qaNo:
        Synchronize = false;
        break;

      default:
      case qaCancel:
        Continue = false;
        break;
    };
  }
  else
  {
    Synchronize = SynchronizeSynchronizeCheck->Checked;
  }

  if (Continue)
  {
    assert(!FSynchronizing);

    FSynchronizing = true;
    try
    {
      UpdateControls();

      DoStartStop(true, Synchronize);

      StopButton->SetFocus();
      FStarted = true;
    }
    catch(Exception & E)
    {
      FSynchronizing = false;
      UpdateControls();
    
      FarPlugin->HandleException(&E);
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::StopButtonClick(TFarButton * /*Sender*/,
  bool & /*Close*/)
{
  Stop();
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::Stop()
{
  FSynchronizing = false;
  FStarted = false;
  BreakSynchronize();
  DoStartStop(false, false);
  UpdateControls();
  StartButton->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::Change()
{
  TFarDialog::Change();

  if (Handle && !ChangesLocked())
  {
    UpdateControls();

    AnsiString InfoStr = FCopyParams.GetInfoStr("; ", ActualCopyParamAttrs());
    TStringList * InfoStrLines = new TStringList();
    try
    {
      FarWrapText(InfoStr, InfoStrLines, BorderBox->Width - 4);
      CopyParamLister->Items = InfoStrLines;
      CopyParamLister->Right = BorderBox->Right - (CopyParamLister->ScrollBar ? 0 : 1);
    }
    __finally
    {
      delete InfoStrLines;
    }
  }
}
//---------------------------------------------------------------------------
bool __fastcall TSynchronizeDialog::Key(TFarDialogItem * /*Item*/, long KeyCode)
{
  bool Result = false;
  if ((KeyCode == KEY_ESC) && FSynchronizing)
  {
    Stop();
    Result = true;
  }
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TSynchronizeDialog::UpdateControls()
{
  Caption = GetMsg(FSynchronizing ? SYNCHRONIZE_SYCHRONIZING : SYNCHRONIZE_TITLE);
  StartButton->Enabled = !FSynchronizing;
  StopButton->Enabled = FSynchronizing;
  CloseButton->Enabled = !FSynchronizing;
  EnableGroup(1, !FSynchronizing);
  SynchronizeSelectedOnlyCheck->Enabled =
    !FSynchronizing && FLAGSET(FOptions, soAllowSelectedOnly);
}
//---------------------------------------------------------------------------
TCopyParamType __fastcall TSynchronizeDialog::GetCopyParams()
{
  TCopyParamType Result = FCopyParams;
  Result.PreserveTime = true;
  return Result;
}
//---------------------------------------------------------------------------
int __fastcall TSynchronizeDialog::ActualCopyParamAttrs()
{
  return FCopyParamAttrs | cpaNoPreserveTime;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::SynchronizeDialog(TSynchronizeParamType & Params,
  const TCopyParamType * CopyParams, TSynchronizeStartStopEvent OnStartStop,
  bool & SaveSettings, int Options, int CopyParamAttrs, TGetSynchronizeOptionsEvent OnGetOptions)
{
  bool Result;
  TSynchronizeDialog * Dialog = new TSynchronizeDialog(FPlugin, OnStartStop,
    Options, CopyParamAttrs, OnGetOptions);
  try
  {
    Result = Dialog->Execute(Params, CopyParams, SaveSettings);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::RemoteTransferDialog(TStrings * FileList,
  AnsiString & Target, AnsiString & FileMask, bool Move)
{
  AnsiString Prompt = FileNameFormatString(
    GetMsg(Move ? REMOTE_MOVE_FILE : REMOTE_COPY_FILE),
    GetMsg(Move ? REMOTE_MOVE_FILES : REMOTE_COPY_FILES), FileList, true);

  AnsiString Value = UnixIncludeTrailingBackslash(Target) + FileMask;
  bool Result = FPlugin->InputBox(
    GetMsg(Move ? REMOTE_MOVE_TITLE : REMOTE_COPY_TITLE), Prompt,
    Value, 0, MOVE_TO_HISTORY) && !Value.IsEmpty();
  if (Result)
  {
    Target = UnixExtractFilePath(Value);
    FileMask = UnixExtractFileName(Value);
  }
  return Result;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::RenameFileDialog(TRemoteFile * File,
  AnsiString & NewName)
{
  return FPlugin->InputBox(GetMsg(RENAME_FILE_TITLE),
    FORMAT(GetMsg(RENAME_FILE), (File->FileName)), NewName, 0) &&
    !NewName.IsEmpty();
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TQueueDialog : TFarDialog
{
public:
  __fastcall TQueueDialog(TCustomFarPlugin * AFarPlugin,
    TWinSCPFileSystem * AFileSystem, bool ClosingPlugin);

  bool __fastcall Execute(TTerminalQueueStatus * Status);

protected:
  virtual void __fastcall Change();
  virtual void __fastcall Idle();
  bool __fastcall UpdateQueue();
  void __fastcall LoadQueue();
  void __fastcall RefreshQueue();
  bool __fastcall FillQueueItemLine(AnsiString & Line,
    TQueueItemProxy * QueueItem, int Index);
  bool __fastcall QueueItemNeedsFrequentRefresh(TQueueItemProxy * QueueItem);
  void __fastcall UpdateControls();
  virtual bool __fastcall Key(TFarDialogItem * Item, long KeyCode);
  virtual bool __fastcall CloseQuery();

private:
  TTerminalQueueStatus * FStatus;
  TWinSCPFileSystem * FFileSystem;
  bool FClosingPlugin;

  TFarListBox * QueueListBox;
  TFarButton * ShowButton;
  TFarButton * ExecuteButton;
  TFarButton * DeleteButton;
  TFarButton * MoveUpButton;
  TFarButton * MoveDownButton;
  TFarButton * CloseButton;

  void __fastcall OperationButtonClick(TFarButton * Sender, bool & Close);
};
//---------------------------------------------------------------------------
__fastcall TQueueDialog::TQueueDialog(TCustomFarPlugin * AFarPlugin,
  TWinSCPFileSystem * AFileSystem, bool ClosingPlugin) :
  TFarDialog(AFarPlugin), FFileSystem(AFileSystem),
  FClosingPlugin(ClosingPlugin)
{
  TFarSeparator * Separator;
  TFarText * Text;

  Size = TPoint(80, 23);
  TRect CRect = ClientRect;
  int ListTop;
  int ListHeight = ClientSize.y - 4;

  Caption = GetMsg(QUEUE_TITLE);

  Text = new TFarText(this);
  Text->Caption = GetMsg(QUEUE_HEADER);

  Separator = new TFarSeparator(this);
  ListTop = Separator->Bottom;

  Separator = new TFarSeparator(this);
  Separator->Move(0, ListHeight);

  ExecuteButton = new TFarButton(this);
  ExecuteButton->Caption = GetMsg(QUEUE_EXECUTE);
  ExecuteButton->OnClick = OperationButtonClick;
  ExecuteButton->CenterGroup = true;

  NextItemPosition = ipRight;

  DeleteButton = new TFarButton(this);
  DeleteButton->Caption = GetMsg(QUEUE_DELETE);
  DeleteButton->OnClick = OperationButtonClick;
  DeleteButton->CenterGroup = true;

  MoveUpButton = new TFarButton(this);
  MoveUpButton->Caption = GetMsg(QUEUE_MOVE_UP);
  MoveUpButton->OnClick = OperationButtonClick;
  MoveUpButton->CenterGroup = true;

  MoveDownButton = new TFarButton(this);
  MoveDownButton->Caption = GetMsg(QUEUE_MOVE_DOWN);
  MoveDownButton->OnClick = OperationButtonClick;
  MoveDownButton->CenterGroup = true;

  CloseButton = new TFarButton(this);
  CloseButton->Caption = GetMsg(QUEUE_CLOSE);
  CloseButton->Result = brCancel;
  CloseButton->CenterGroup = true;
  CloseButton->Default = true;

  NextItemPosition = ipNewLine;

  QueueListBox = new TFarListBox(this);
  QueueListBox->Top = ListTop + 1;
  QueueListBox->Height = ListHeight;
  QueueListBox->NoBox = true;
  QueueListBox->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::OperationButtonClick(TFarButton * Sender,
  bool & /*Close*/)
{
  TQueueItemProxy * QueueItem;
  if (QueueListBox->Items->Selected >= 0)
  {
    QueueItem = reinterpret_cast<TQueueItemProxy *>(
      QueueListBox->Items->Objects[QueueListBox->Items->Selected]);

    if (Sender == ExecuteButton)
    {
      if (QueueItem->Status == TQueueItem::qsProcessing)
      {
        QueueItem->Pause();
      }
      else if (QueueItem->Status == TQueueItem::qsPaused)
      {
        QueueItem->Resume();
      }
      else if (QueueItem->Status == TQueueItem::qsPending)
      {
        QueueItem->ExecuteNow();
      }
      else if (TQueueItem::IsUserActionStatus(QueueItem->Status))
      {
        QueueItem->ProcessUserAction();
      }
      else
      {
        assert(false);
      }
    }
    else if ((Sender == MoveUpButton) || (Sender == MoveDownButton))
    {
      QueueItem->Move(Sender == MoveUpButton);
    }
    else if (Sender == DeleteButton)
    {
      QueueItem->Delete();
    }
  }
}
//---------------------------------------------------------------------------
bool __fastcall TQueueDialog::Key(TFarDialogItem * /*Item*/, long KeyCode)
{
  bool Result = false;
  if (QueueListBox->Focused())
  {
    TFarButton * DoButton = NULL;
    if (KeyCode == KEY_ENTER)
    {
      if (ExecuteButton->Enabled)
      {
        DoButton = ExecuteButton;
      }
      Result = true;
    }
    else if (KeyCode == KEY_DEL)
    {
      if (DeleteButton->Enabled)
      {
        DoButton = DeleteButton;
      }
      Result = true;
    }
    else if (KeyCode == KEY_CTRLUP)
    {
      if (MoveUpButton->Enabled)
      {
        DoButton = MoveUpButton;
      }
      Result = true;
    }
    else if (KeyCode == KEY_CTRLDOWN)
    {
      if (MoveDownButton->Enabled)
      {
        DoButton = MoveDownButton;
      }
      Result = true;
    }

    if (DoButton != NULL)
    {
      bool Close;
      OperationButtonClick(DoButton, Close);
    }
  }
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::UpdateControls()
{
  TQueueItemProxy * QueueItem = NULL;
  if (QueueListBox->Items->Selected >= 0)
  {
    QueueItem = reinterpret_cast<TQueueItemProxy *>(
      QueueListBox->Items->Objects[QueueListBox->Items->Selected]);
  }

  if ((QueueItem != NULL) && (QueueItem->Status == TQueueItem::qsProcessing))
  {
    ExecuteButton->Caption = GetMsg(QUEUE_PAUSE);
    ExecuteButton->Enabled = true;
  }
  else if ((QueueItem != NULL) && (QueueItem->Status == TQueueItem::qsPaused))
  {
    ExecuteButton->Caption = GetMsg(QUEUE_RESUME);
    ExecuteButton->Enabled = true;
  }
  else if ((QueueItem != NULL) && TQueueItem::IsUserActionStatus(QueueItem->Status))
  {
    ExecuteButton->Caption = GetMsg(QUEUE_SHOW);
    ExecuteButton->Enabled = true;
  }
  else
  {
    ExecuteButton->Caption = GetMsg(QUEUE_EXECUTE);
    ExecuteButton->Enabled =
      (QueueItem != NULL) && (QueueItem->Status == TQueueItem::qsPending);
  }
  DeleteButton->Enabled = (QueueItem != NULL) &&
    (QueueItem->Status != TQueueItem::qsDone) &&
    !TQueueItem::IsUserActionStatus(QueueItem->Status);
  MoveUpButton->Enabled = (QueueItem != NULL) &&
    (QueueItem->Status == TQueueItem::qsPending) &&
    (QueueItem->Index > FStatus->ActiveCount);
  MoveDownButton->Enabled = (QueueItem != NULL) &&
    (QueueItem->Status == TQueueItem::qsPending) &&
    (QueueItem->Index < FStatus->Count - 1);
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::Idle()
{
  TFarDialog::Idle();

  if (UpdateQueue())
  {
    LoadQueue();
    UpdateControls();
  }
  else
  {
    RefreshQueue();
  }
}
//---------------------------------------------------------------------------
bool __fastcall TQueueDialog::CloseQuery()
{
  bool Result = TFarDialog::CloseQuery();
  if (Result)
  {
    TWinSCPPlugin* WinSCPPlugin = dynamic_cast<TWinSCPPlugin*>(FarPlugin);
    Result = !FClosingPlugin || (FStatus->Count == 0) ||
      (WinSCPPlugin->MoreMessageDialog(GetMsg(QUEUE_PENDING_ITEMS), NULL,
        qtWarning, qaOK | qaCancel) == qaCancel);
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TQueueDialog::UpdateQueue()
{
  assert(FFileSystem != NULL);
  TTerminalQueueStatus * Status = FFileSystem->ProcessQueue();
  bool Result = (Status != NULL);
  if (Result)
  {
    FStatus = Status;
  }
  return Result;
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::Change()
{
  TFarDialog::Change();

  if (Handle)
  {
    UpdateControls();
  }
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::RefreshQueue()
{
  if (QueueListBox->Items->Count > 0)
  {
    bool Change = false;
    int TopIndex = QueueListBox->Items->TopIndex;
    int Index = TopIndex;

    int ILine = 0;
    while ((Index - ILine > 0) &&
           (QueueListBox->Items->Objects[Index] ==
              QueueListBox->Items->Objects[Index - ILine - 1]))
    {
      ILine++;
    }

    TQueueItemProxy * PrevQueueItem = NULL;
    TQueueItemProxy * QueueItem;
    AnsiString Line;
    while ((Index < QueueListBox->Items->Count) &&
           (Index < TopIndex + QueueListBox->Height))
    {
      QueueItem = reinterpret_cast<TQueueItemProxy*>(
        QueueListBox->Items->Objects[Index]);
      assert(QueueItem != NULL);
      if ((PrevQueueItem != NULL) && (QueueItem != PrevQueueItem))
      {
        ILine = 0;
      }

      if (QueueItemNeedsFrequentRefresh(QueueItem) &&
          !QueueItem->ProcessingUserAction)
      {
        FillQueueItemLine(Line, QueueItem, ILine);
        if (QueueListBox->Items->Strings[Index] != Line)
        {
          Change = true;
          QueueListBox->Items->Strings[Index] = Line;
        }
      }

      PrevQueueItem = QueueItem;
      Index++;
      ILine++;
    }

    if (Change)
    {
      Redraw();
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TQueueDialog::LoadQueue()
{
  TFarList * List = new TFarList();
  try
  {
    AnsiString Line;
    TQueueItemProxy * QueueItem;
    for (int Index = 0; Index < FStatus->Count; Index++)
    {
      QueueItem = FStatus->Items[Index];
      int ILine = 0;
      while (FillQueueItemLine(Line, QueueItem, ILine))
      {
        List->AddObject(Line, reinterpret_cast<TObject*>(QueueItem));
        List->Disabled[List->Count - 1] = (ILine > 0);
        ILine++;
      }
    }
    QueueListBox->Items = List;
  }
  __finally
  {
    delete List;
  }
}
//---------------------------------------------------------------------------
bool __fastcall TQueueDialog::FillQueueItemLine(AnsiString & Line,
  TQueueItemProxy * QueueItem, int Index)
{
  int PathMaxLen = 49;

  if ((Index > 2) ||
      ((Index == 2) && (QueueItem->Status == TQueueItem::qsPending)))
  {
    return false;
  }

  AnsiString ProgressStr;

  switch (QueueItem->Status)
  {
    case TQueueItem::qsPending:
      ProgressStr = GetMsg(QUEUE_PENDING);
      break;

    case TQueueItem::qsConnecting:
      ProgressStr = GetMsg(QUEUE_CONNECTING);
      break;

    case TQueueItem::qsQuery:
      ProgressStr = GetMsg(QUEUE_QUERY);
      break;

    case TQueueItem::qsError:
      ProgressStr = GetMsg(QUEUE_ERROR);
      break;

    case TQueueItem::qsPrompt:
      ProgressStr = GetMsg(QUEUE_PROMPT);
      break;

    case TQueueItem::qsPaused:
      ProgressStr = GetMsg(QUEUE_PAUSED);
      break;
  }

  bool BlinkHide = QueueItemNeedsFrequentRefresh(QueueItem) &&
    !QueueItem->ProcessingUserAction &&
    ((GetTickCount() % 2000) >= 1000);

  AnsiString Operation;
  AnsiString Direction;
  AnsiString Values[2];
  TFileOperationProgressType * ProgressData = QueueItem->ProgressData;
  TQueueItem::TInfo * Info = QueueItem->Info;

  if (Index == 0)
  {
    if (!BlinkHide)
    {
      switch (Info->Operation)
      {
        case foCopy:
          Operation = GetMsg(QUEUE_COPY);
          break;

        case foMove:
          Operation = GetMsg(QUEUE_MOVE);
          break;
      }
      Direction = GetMsg((Info->Side == osLocal) ? QUEUE_UPLOAD : QUEUE_DOWNLOAD);
    }

    Values[0] = MinimizeName(Info->Source, PathMaxLen, (Info->Side == osRemote));

    if ((ProgressData != NULL) &&
        (ProgressData->Operation == Info->Operation))
    {
      Values[1] = FormatBytes(ProgressData->TotalTransfered);
    }
  }
  else if (Index == 1)
  {
    Values[0] = MinimizeName(Info->Destination, PathMaxLen, (Info->Side == osLocal));
      
    if (ProgressStr.IsEmpty())
    {
      if (ProgressData != NULL)
      {
        if (ProgressData->Operation == Info->Operation)
        {
          Values[1] = FORMAT("%d%%", (ProgressData->OverallProgress()));
        }
        else if (ProgressData->Operation == foCalculateSize)
        {
          Values[1] = GetMsg(QUEUE_CALCULATING_SIZE);
        }
      }
    }
    else if (!BlinkHide)
    {
      Values[1] = ProgressStr;
    }
  }
  else
  {
    if (ProgressData != NULL)
    {
      Values[0] = MinimizeName(ProgressData->FileName, PathMaxLen,
        (Info->Side == osRemote));
      if (ProgressData->Operation == Info->Operation)
      {
        Values[1] = FORMAT("%d%%", (ProgressData->TransferProgress()));
      }
    }
    else
    {
      Values[0] = ProgressStr;
    }
  }

  Line = FORMAT("%1s %1s  %-*.*s %s",
    (Operation, Direction, PathMaxLen, PathMaxLen, Values[0], Values[1]));

  return true;
}
//---------------------------------------------------------------------------
bool __fastcall TQueueDialog::QueueItemNeedsFrequentRefresh(
  TQueueItemProxy * QueueItem)
{
  return
    (TQueueItem::IsUserActionStatus(QueueItem->Status) ||
     (QueueItem->Status == TQueueItem::qsPaused));
}
//---------------------------------------------------------------------------
bool __fastcall TQueueDialog::Execute(TTerminalQueueStatus * Status)
{
  FStatus = Status;

  UpdateQueue();
  LoadQueue();

  bool Result = (ShowModal() != brCancel);

  FStatus = NULL;
  
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::QueueDialog(
  TTerminalQueueStatus * Status, bool ClosingPlugin)
{
  bool Result;
  TQueueDialog * Dialog = new TQueueDialog(FPlugin, this, ClosingPlugin);
  try
  {
    Result = Dialog->Execute(Status);
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------
bool __fastcall TWinSCPFileSystem::CreateDirectoryDialog(AnsiString & Directory,
  TRemoteProperties * Properties, bool & SaveSettings)
{
  bool Result;
  TWinSCPDialog * Dialog = new TWinSCPDialog(FPlugin);
  try
  {
    TFarText * Text;
    TFarSeparator * Separator;

    Dialog->Caption = GetMsg(CREATE_FOLDER_TITLE);
    Dialog->Size = TPoint(66, 15);

    Text = new TFarText(Dialog);
    Text->Caption = GetMsg(CREATE_FOLDER_PROMPT);

    TFarEdit * DirectoryEdit = new TFarEdit(Dialog);
    DirectoryEdit->History = "NewFolder";

    Separator = new TFarSeparator(Dialog);
    Separator->Caption = GetMsg(CREATE_FOLDER_ATTRIBUTES);

    TFarCheckBox * SetRightsCheck = new TFarCheckBox(Dialog);
    SetRightsCheck->Caption = GetMsg(CREATE_FOLDER_SET_RIGHTS);

    TRightsContainer * RightsContainer = new TRightsContainer(Dialog, false, true,
      true, SetRightsCheck);

    TFarCheckBox * SaveSettingsCheck = new TFarCheckBox(Dialog);
    SaveSettingsCheck->Caption = GetMsg(CREATE_FOLDER_REUSE_SETTINGS);
    SaveSettingsCheck->Move(0, 6);

    Dialog->AddStandardButtons();

    DirectoryEdit->Text = Directory;
    SaveSettingsCheck->Checked = SaveSettings;
    assert(Properties != NULL);
    SetRightsCheck->Checked = Properties->Valid.Contains(vpRights);
    // expect sensible value even if rights are not set valid
    RightsContainer->Rights = Properties->Rights;

    Result = (Dialog->ShowModal() == brOK);

    if (Result)
    {
      Directory = DirectoryEdit->Text;
      SaveSettings = SaveSettingsCheck->Checked;
      if (SetRightsCheck->Checked)
      {
        Properties->Valid = Properties->Valid << vpRights;
        Properties->Rights = RightsContainer->Rights;
      }
      else
      {
        Properties->Valid = Properties->Valid >> vpRights;
      }
    }
  }
  __finally
  {
    delete Dialog;
  }
  return Result;
}
//---------------------------------------------------------------------------

