#define MainFileSource "..\far.dll"
#define ParentRegistryKey "Software\Martin Prikryl"
#define RegistryKey ParentRegistryKey+"\WinSCP 2"
#define Year 2006

#define Status ""

#define Major
#define Minor
#define Rev
#define Build
#expr ParseVersion(MainFileSource, Major, Minor, Rev, Build)
#define Version Str(Major)+"."+Str(Minor)+(Rev > 0 ? "."+Str(Rev) : "")+(Status != "" ? " "+Status : "")

[Setup]
AppId=winscpfar
AppMutex=WinSCPFar
AppName=WinSCP plugin for FAR
AppPublisher=Martin Prikryl
AppPublisherURL=http://winscp.net/eng/docs/far
AppSupportURL=http://winscp.net/forum/
AppUpdatesURL=http://winscp.net/eng/download.php
VersionInfoCompany=Martin Prikryl
VersionInfoDescription=Setup for WinSCP plugin for FAR {#Version}
VersionInfoVersion={#Major}.{#Minor}.{#Rev}.{#Build}
VersionInfoTextVersion={#Version}
VersionInfoCopyright=(c) 2000-{#Year} Martin Prikryl
DefaultDirName={pf}\FAR\Plugins\WinSCP
DisableProgramGroupPage=true
LicenseFile=licence.setup
UninstallDisplayIcon={app}\winscp.ico
OutputDir=files_far\
DisableStartupPrompt=yes
AppVersion={#Version}
AppVerName=WinSCP plugin for FAR {#Version}
OutputBaseFilename=winscpfar{#Major}{#Minor}{#Rev}setup
SolidCompression=yes

[Types]
Name: full; Description: "Full installation"
Name: compact; Description: "Compact installation"
Name: custom; Description: "Custom installation"; Flags: iscustom

[Components]
Name: main; Description: "WinSCP plugin for FAR"; Types: full custom compact
Name: pageant; Description: "Pageant (SSH authentication agent)"; Types: full
Name: puttygen; Description: "PuTTYgen (key generator)"; Types: full

[Files]
Source: "{#MainFileSource}"; DestName: "WinSCP.dll"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "..\far.lng"; DestName: "WinSCP.lng"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "..\far\Russian.lng"; DestName: "Russian.lng"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "WinSCP.ico"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "licence"; DestName: "licence"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "C:\Program Files\PuTTY\LICENCE"; DestDir: "{app}\PuTTY"; Components: pageant puttygen; Flags: ignoreversion
Source: "C:\Program Files\PuTTY\putty.hlp"; DestDir: "{app}\PuTTY"; Components: pageant puttygen; Flags: ignoreversion
Source: "C:\Program Files\PuTTY\pageant.exe"; DestDir: "{app}\PuTTY"; Components: pageant; Flags: ignoreversion
Source: "C:\Program Files\PuTTY\puttygen.exe"; DestDir: "{app}\PuTTY"; Components: puttygen; Flags: ignoreversion

[Code]

procedure ComponentsListClickCheck(Sender: TObject);
begin
  if not WizardForm.ComponentsList.Checked[0] then
    WizardForm.ComponentsList.Checked[0] := True;
end;

procedure InitializeWizard();
begin
  // allow installation without requiring user to accept licence
  WizardForm.LicenseAcceptedRadio.Checked := True;
  WizardForm.LicenseAcceptedRadio.Visible := False;
  WizardForm.LicenseLabel1.Visible := False;
  WizardForm.LicenseNotAcceptedRadio.Visible := False;
  WizardForm.LicenseMemo.Top := WizardForm.LicenseLabel1.Top;
  WizardForm.LicenseMemo.Height :=
    WizardForm.LicenseNotAcceptedRadio.Top +
    WizardForm.LicenseNotAcceptedRadio.Height -
    WizardForm.LicenseMemo.Top - 5;

  // prevent the main component to be unchecked
  WizardForm.ComponentsList.OnClickCheck := @ComponentsListClickCheck;
end;
