/* ssh2.cp
 *
 */

#include <GUSIInternal.h>
#include <GUSIBasics.h>
#include <GUSIContext.h>
#include <GUSIConfig.h>
#include <GUSIDiag.h>
#include <GUSISocket.h>
#include <GUSIPThread.h>
#include <GUSIFactory.h>
#include <GUSIDevice.h>
#include <GUSIDescriptor.h>

#ifdef __cplusplus
extern "C" {
#endif

void add_one_file(int fd);
void remove_one_file(int fd);
void close_all_files();

void ssh2_init();

int	open(const char * path, int mode, ...);
int socket(int domain, int type, int protocol);
int close(int s);

#ifdef __cplusplus
}
#endif


/*
 * default GUSIProcess::Yield has 20 ticks to remain in same state
 * we use 0.
 */

void GUSIProcess::Yield(GUSIYieldMode wait)
{
	ProcessSerialNumber	front;
	Boolean				same;

	if (!GetFrontProcess(&front) && !SameProcess(&front, &fProcess, &same) && same)
		GUSIConfiguration::Instance()->CheckInterrupt();
	if (wait == kGUSIBlock) {
		fWillSleep = true;
		if (fReadyThreads > 1 || fDontSleep)
			wait = kGUSIYield;
	}
	if (wait == kGUSIYield && LMGetTicks() - fResumeTicks < 0) {
		return;
	}
	if (fClosing)
		fClosing->CheckClose();
	if (gGUSISpinHook) {
		gGUSISpinHook(wait == kGUSIBlock);
	} else {
		GUSI_SMESSAGE("Suspend\n");
		GUSIHandleNextEvent(wait == kGUSIBlock ? 600 : 0);
		GUSI_SMESSAGE("Resume\n");
	} 
		
	fWillSleep 		= false;
	fDontSleep 		= false;
	fResumeTicks 	= LMGetTicks();
}


/*
 * default GUSIContext::Yield has 12 ticks to remain in same state
 * we use 0.
 */

bool GUSIContext::Yield(GUSIYieldMode wait)
{
	if (wait == kGUSIYield && LMGetTicks() - sCurrentContext->fEntryTicks < 0)
		return false;	

	bool			mainThread	= sCurrentContext->fThreadID == kApplicationThreadID;
	bool 			block		= wait == kGUSIBlock && !mainThread;
	GUSIProcess	*	process 	= GUSIProcess::Instance();
	bool 			interrupt 	= false;
	
	do {
		if (mainThread)
			process->Yield(wait);
				
		if (interrupt = Raise())
			goto done;
				
		if (sHasThreading) {
			if (block)
				SetThreadState(kCurrentThreadID, kStoppedThreadState, kNoThreadID);
			else
				YieldToAnyThread();
		}
	} while (wait == kGUSIBlock && !sCurrentContext->fWakeup);
done:
	sCurrentContext->fWakeup = false;
	
	return interrupt;
}

/*
 * my PLstrrchr in CWPro6 (last MPTP release) crashes in 68k ???
 */
Ptr PLstrrchr(unsigned char *s, char c)
{
	int			size;

	size = s[0];
	while ( size > 0 ) {
		if ( s[size] == (unsigned char)c ) {
			return (char *)s + size;
		}
		size--;
	}
	return NULL;
}

/*
 * ssh2_init
 */

void ssh2_init()
{
	static Boolean		sGUSISetup = false;

	if ( !sGUSISetup ) {
		GUSIContext::Setup(true);
		GUSISetupConsole();
		sGUSISetup = true;
	}
}

/*
 * we need to track open() calls to close files/sockets.
 */

int	open(const char * path, int mode, ...)
{
	GUSIErrorSaver			saveError;
	GUSIDeviceRegistry *	factory	= GUSIDeviceRegistry::Instance();
	GUSIDescriptorTable *	table	= GUSIDescriptorTable::Instance();
	GUSISocket * 			sock;
	int						fd;
	
	if (sock = factory->open(path, mode)) {
		if ((fd = table->InstallSocket(sock)) > -1) {
			add_one_file(fd);
			return fd;
		}
		sock->close();
	}
	if (!errno)
		return GUSISetPosixError(ENOMEM);
	else
		return -1;
}

/*
 * we need to track socket() calls to close files/sockets.
 */

int socket(int domain, int type, int protocol)
{
	GUSIErrorSaver			saveError;
	GUSISocketFactory *		factory	= GUSISocketDomainRegistry::Instance();
	GUSIDescriptorTable *	table	= GUSIDescriptorTable::Instance();
	GUSISocket * 			sock;
	int						fd;
	
	if (sock = factory->socket(domain, type, protocol)) {
		if ((fd = table->InstallSocket(sock)) > -1) {
			add_one_file(fd);
			return fd;
		}
		sock->close();
	}
	if (!errno)
		return GUSISetPosixError(ENOMEM);
	else
		return -1;
}

/*
 * we need to track close() calls to close files/sockets.
 */

int close(int s)
{
	GUSIDescriptorTable *	table	= GUSIDescriptorTable::Instance();

	if (s > 2) {
		remove_one_file(s);
		return table->RemoveSocket(s);
	} else {
		/* we don't close stdin/stdout/stderr */
		return 0;
	}
}
