#ifndef GABA_DEFINE
struct userauth_special_exception
{
  struct exception super;
  struct lsh_string *reply;
};
extern struct lsh_class userauth_special_exception_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_userauth_special_exception_free(struct lsh_object *o)
{
  struct userauth_special_exception *i = (struct userauth_special_exception *) o;
  lsh_string_free(i->reply);
}

struct lsh_class userauth_special_exception_class =
{ STATIC_HEADER,
  &exception_class, "userauth_special_exception", sizeof(struct userauth_special_exception),
  NULL,
  do_userauth_special_exception_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct lsh_user
{
  struct lsh_object super;
  struct lsh_string *name;
  uid_t uid;
  void (*(verify_password))(struct lsh_user *self, struct lsh_string *pw, struct command_continuation *c, struct exception_handler *e);
  int (*(file_exists))(struct lsh_user *self, struct lsh_string *name, int free);
  void (*(read_file))(struct lsh_user *self, const char *name, int secret, struct command_continuation *c, struct exception_handler *e);
  int (*(chdir_home))(struct lsh_user *self);
  int (*(fork_process))(struct lsh_user *self, struct resource **child, struct exit_callback *c, struct address_info * peer, struct lsh_string *tty);
  void (*(exec_shell))(struct lsh_user *self, int login, char **argv, unsigned env_length, const struct env_value *env);
};
extern struct lsh_class lsh_user_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_lsh_user_free(struct lsh_object *o)
{
  struct lsh_user *i = (struct lsh_user *) o;
  lsh_string_free(i->name);
}

struct lsh_class lsh_user_class =
{ STATIC_HEADER,
  0, "lsh_user", sizeof(struct lsh_user),
  NULL,
  do_lsh_user_free
};
#endif /* !GABA_DECLARE */

