/*
CLASS:ssh_channel:resource
*/
#ifndef GABA_DEFINE
struct ssh_channel
{
  struct resource super;
  uint32_t local_channel_number;
  uint32_t remote_channel_number;
  uint32_t rec_window_size;
  uint32_t rec_max_packet;
  uint32_t send_window_size;
  uint32_t send_max_packet;
  struct ssh_connection *connection;
  const struct channel_request_methods * request_methods;
  struct alist *request_types;
  int flags;
  unsigned sources;
  unsigned sinks;
  void (*(receive))(struct ssh_channel *self,int type,uint32_t length,const uint8_t *data);
  void (*(send_adjust))(struct ssh_channel *self,uint32_t increment);
  void (*(event))(struct ssh_channel *self,enum channel_event);
  struct object_queue pending_requests;
  struct object_queue active_requests;
};
extern struct lsh_class ssh_channel_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_ssh_channel_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct ssh_channel *i = (struct ssh_channel *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->request_types);
  object_queue_mark(&(i->pending_requests),
    mark);
  object_queue_mark(&(i->active_requests),
    mark);
}
static void
do_ssh_channel_free(struct lsh_object *o)
{
  struct ssh_channel *i = (struct ssh_channel *) o;
  object_queue_free(&(i->pending_requests));
  object_queue_free(&(i->active_requests));
}
struct lsh_class ssh_channel_class =
{
  STATIC_HEADER,
  &(resource_class),
  "ssh_channel",
  sizeof(struct ssh_channel),
  do_ssh_channel_mark,
  do_ssh_channel_free,
};
#endif /* !GABA_DECLARE */

/*
CLASS:channel_request:
*/
#ifndef GABA_DEFINE
struct channel_request
{
  struct lsh_object super;
  void (*(handler))(struct channel_request *self,struct ssh_channel *channel,const struct channel_request_info *info,struct simple_buffer *args,struct command_continuation *c,struct exception_handler *e);
};
extern struct lsh_class channel_request_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class channel_request_class =
{
  STATIC_HEADER,
  NULL,
  "channel_request",
  sizeof(struct channel_request),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

