/*
CLASS:escape_callback:lsh_callback
*/
#ifndef GABA_DEFINE
struct escape_callback
{
  struct lsh_callback super;
  const char * help;
};
extern struct lsh_class escape_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class escape_callback_class =
{
  STATIC_HEADER,
  &(lsh_callback_class),
  "escape_callback",
  sizeof(struct escape_callback),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:escape_info:
*/
#ifndef GABA_DEFINE
struct escape_info
{
  struct lsh_object super;
  uint8_t escape;
  struct escape_callback *((dispatch)[0x100]);
};
extern struct lsh_class escape_info_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_escape_info_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct escape_info *i = (struct escape_info *) o;
  {
    unsigned k1;
    for(k1=0; k1<0x100; k1++)
      mark((struct lsh_object *) (i->dispatch)[k1]);
  };
}
struct lsh_class escape_info_class =
{
  STATIC_HEADER,
  NULL,
  "escape_info",
  sizeof(struct escape_info),
  do_escape_info_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:client_session:ssh_channel
*/
#ifndef GABA_DEFINE
struct client_session
{
  struct ssh_channel super;
  struct channel_read_state in;
  struct channel_write_state out;
  struct channel_write_state err;
  struct resource_list *resources;
  struct object_queue requests;
  struct exception_handler *e;
  struct escape_info *escape;
  int * exit_status;
};
extern struct lsh_class client_session_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_client_session_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct client_session *i = (struct client_session *) o;
  channel_read_state_mark(&(i->in),
    mark);
  channel_write_state_mark(&(i->out),
    mark);
  channel_write_state_mark(&(i->err),
    mark);
  mark((struct lsh_object *) i->resources);
  object_queue_mark(&(i->requests),
    mark);
  mark((struct lsh_object *) i->e);
  mark((struct lsh_object *) i->escape);
}
static void
do_client_session_free(struct lsh_object *o)
{
  struct client_session *i = (struct client_session *) o;
  channel_read_state_free(&(i->in));
  channel_write_state_free(&(i->out));
  channel_write_state_free(&(i->err));
  object_queue_free(&(i->requests));
}
struct lsh_class client_session_class =
{
  STATIC_HEADER,
  &(ssh_channel_class),
  "client_session",
  sizeof(struct client_session),
  do_client_session_mark,
  do_client_session_free,
};
#endif /* !GABA_DECLARE */

/*
CLASS:client_options:werror_config
*/
#ifndef GABA_DEFINE
struct client_options
{
  struct werror_config super;
  struct randomness *random;
  struct interact *tty;
  int escape;
  struct exception_handler *handler;
  int * exit_code;
  int not;
  const char * port;
  const char * target;
  char * local_user;
  char * user;
  int with_remote_peers;
  int with_pty;
  int with_x11;
  const char * stdin_file;
  const char * stdout_file;
  const char * stderr_file;
  int used_stdin;
  int used_pty;
  int used_x11;
  int write_pid;
  int detach_end;
  int inhibit_actions;
  int start_shell;
  int remote_forward;
  struct object_queue actions;
  struct resource_list *resources;
};
extern struct lsh_class client_options_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_client_options_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct client_options *i = (struct client_options *) o;
  mark((struct lsh_object *) i->random);
  mark((struct lsh_object *) i->tty);
  mark((struct lsh_object *) i->handler);
  object_queue_mark(&(i->actions),
    mark);
  mark((struct lsh_object *) i->resources);
}
static void
do_client_options_free(struct lsh_object *o)
{
  struct client_options *i = (struct client_options *) o;
  object_queue_free(&(i->actions));
}
struct lsh_class client_options_class =
{
  STATIC_HEADER,
  &(werror_config_class),
  "client_options",
  sizeof(struct client_options),
  do_client_options_mark,
  do_client_options_free,
};
#endif /* !GABA_DECLARE */

