/*
CLASS:lsh_transport_config:transport_context
*/
#ifndef GABA_DEFINE
struct lsh_transport_config
{
  struct transport_context super;
  struct algorithms_options *algorithms;
  struct werror_config *werror_config;
  struct int_list *kex_algorithms;
  struct interact *tty;
  int sloppy;
  const char * capture_file;
  int capture_fd;
  struct alist *signature_algorithms;
  const char * host_acls;
  struct lsh_transport_lookup_verifier *host_db;
  const char * home;
  const char * port;
  const char * target;
  int userauth;
  const char * user;
  const char * identity;
  struct keypair *keypair;
  const char * requested_service;
  const char * service;
};
extern struct lsh_class lsh_transport_config_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_lsh_transport_config_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct lsh_transport_config *i = (struct lsh_transport_config *) o;
  mark((struct lsh_object *) i->algorithms);
  mark((struct lsh_object *) i->werror_config);
  mark((struct lsh_object *) i->kex_algorithms);
  mark((struct lsh_object *) i->tty);
  mark((struct lsh_object *) i->signature_algorithms);
  mark((struct lsh_object *) i->host_db);
  mark((struct lsh_object *) i->keypair);
}
struct lsh_class lsh_transport_config_class =
{
  STATIC_HEADER,
  &(transport_context_class),
  "lsh_transport_config",
  sizeof(struct lsh_transport_config),
  do_lsh_transport_config_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:lsh_transport_connection:transport_forward
*/
#ifndef GABA_DEFINE
struct lsh_transport_connection
{
  struct transport_forward super;
  enum lsh_transport_state state;
  struct lsh_transport_config *config;
  unsigned tried_empty_password;
  int expect_info_request;
};
extern struct lsh_class lsh_transport_connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_lsh_transport_connection_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct lsh_transport_connection *i = (struct lsh_transport_connection *) o;
  mark((struct lsh_object *) i->config);
}
struct lsh_class lsh_transport_connection_class =
{
  STATIC_HEADER,
  &(transport_forward_class),
  "lsh_transport_connection",
  sizeof(struct lsh_transport_connection),
  do_lsh_transport_connection_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:lsh_transport_lookup_verifier:lookup_verifier
*/
#ifndef GABA_DEFINE
struct lsh_transport_lookup_verifier
{
  struct lookup_verifier super;
  struct lsh_transport_config *config;
  struct spki_context *db;
  struct lsh_string *access;
  const struct hash_algorithm *hash;
};
extern struct lsh_class lsh_transport_lookup_verifier_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_lsh_transport_lookup_verifier_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct lsh_transport_lookup_verifier *i = (struct lsh_transport_lookup_verifier *) o;
  mark((struct lsh_object *) i->config);
  mark((struct lsh_object *) i->db);
  mark((struct lsh_object *) i->hash);
}
static void
do_lsh_transport_lookup_verifier_free(struct lsh_object *o)
{
  struct lsh_transport_lookup_verifier *i = (struct lsh_transport_lookup_verifier *) o;
  lsh_string_free(i->access);
}
struct lsh_class lsh_transport_lookup_verifier_class =
{
  STATIC_HEADER,
  &(lookup_verifier_class),
  "lsh_transport_lookup_verifier",
  sizeof(struct lsh_transport_lookup_verifier),
  do_lsh_transport_lookup_verifier_mark,
  do_lsh_transport_lookup_verifier_free,
};
#endif /* !GABA_DECLARE */

