/*
CLASS:socks_channel:channel_forward
*/
#ifndef GABA_DEFINE
struct socks_channel
{
  struct channel_forward super;
  uint32_t pos;
  uint32_t length;
  struct address_info *peer;
  enum socks_state state;
  uint8_t version;
  struct address_info *target;
};
extern struct lsh_class socks_channel_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_socks_channel_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct socks_channel *i = (struct socks_channel *) o;
  mark((struct lsh_object *) i->peer);
  mark((struct lsh_object *) i->target);
}
struct lsh_class socks_channel_class =
{
  STATIC_HEADER,
  &(channel_forward_class),
  "socks_channel",
  sizeof(struct socks_channel),
  do_socks_channel_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

struct command *
make_socks_server(struct address_info *local)
  /* (S connection_remember (S (B listen_tcp socks_handshake) (prog1 local))) */
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
{
  CAST_SUBTYPE(command, res,
MAKE_TRACE("make_socks_server",
    S2(CONNECTION_REMEMBER,
      S2(B2(LISTEN_TCP,
          SOCKS_HANDSHAKE),
        A(PROG1,
          ((struct lsh_object *) local))))));
return res;
;
}
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
