#line 5 "macros.m4"









#line 16




#line 33


#line 37


#line 65
    


#line 84


#line 102





#line 109 "macros.m4"

#line 111
#include "lsh.h"

#include "crypto.h"
#include "digits.h"
#include "format.h"
#include "sexp.h"
#include "spki.h"
#include "xalloc.h"

#include <assert.h>
#include <stdio.h>

int main(int argc UNUSED, char **argv UNUSED)
{
#line 1 "des-test.m4"
/* From Applied Cryptography, 2:nd edition */

#line 6

#line 6
  {
#line 6
    struct crypto_algorithm *algorithm = &crypto_des_algorithm;
#line 6
    struct lsh_string *key = simple_decode_hex("0123456789ABCDEF") ;
#line 6
    struct lsh_string *plain = simple_decode_hex("0123456789ABCDE7") ;
#line 6
    struct lsh_string *cipher = simple_decode_hex("C95744256A5ED31D") ;
#line 6
    struct crypto_instance *c;
#line 6

#line 6
    assert(key->length == algorithm->key_size);
#line 6
    assert(!algorithm->iv_size);
#line 6

#line 6
    c = MAKE_ENCRYPT(algorithm, key->data, NULL);
#line 6
    
#line 6
  {
#line 6
    struct lsh_string *a, *b;
#line 6
    fputs("Encrypting with DES AC... ", stderr);
#line 6
    a = crypt_string(c, plain, 0);
#line 6
    b = lsh_string_dup(cipher);
#line 6
    if (!lsh_string_eq(crypt_string(c, plain, 0), lsh_string_dup(cipher)))
#line 6
      { fputs("failed.\n", stderr);; exit(1); }
#line 6
    fputs("ok.\n", stderr);
#line 6
    lsh_string_free(a);
#line 6
    lsh_string_free(b);
#line 6
  }
#line 6

#line 6
    KILL(c);
#line 6
    c = MAKE_DECRYPT(algorithm, key->data, NULL);
#line 6
    
#line 6
  {
#line 6
    struct lsh_string *a, *b;
#line 6
    fputs("Decrypting with DES AC... ", stderr);
#line 6
    a = crypt_string(c, cipher, 0);
#line 6
    b = plain;
#line 6
    if (!lsh_string_eq(crypt_string(c, cipher, 0), plain))
#line 6
      { fputs("failed.\n", stderr);; exit(1); }
#line 6
    fputs("ok.\n", stderr);
#line 6
    lsh_string_free(a);
#line 6
    lsh_string_free(b);
#line 6
  }
#line 6

#line 6
    KILL(c);
#line 6
    
#line 6
    lsh_string_free(key);
#line 6
    lsh_string_free(cipher);
#line 6
  }
#line 6


/* From Dana How's DEScore */
#line 12

#line 12
  {
#line 12
    struct crypto_algorithm *algorithm = &crypto_des_algorithm;
#line 12
    struct lsh_string *key = simple_decode_hex("0101010101010180") ;
#line 12
    struct lsh_string *plain = simple_decode_hex("0000000000000000") ;
#line 12
    struct lsh_string *cipher = simple_decode_hex("9CC62DF43B6EED74") ;
#line 12
    struct crypto_instance *c;
#line 12

#line 12
    assert(key->length == algorithm->key_size);
#line 12
    assert(!algorithm->iv_size);
#line 12

#line 12
    c = MAKE_ENCRYPT(algorithm, key->data, NULL);
#line 12
    
#line 12
  {
#line 12
    struct lsh_string *a, *b;
#line 12
    fputs("Encrypting with DES 1... ", stderr);
#line 12
    a = crypt_string(c, plain, 0);
#line 12
    b = lsh_string_dup(cipher);
#line 12
    if (!lsh_string_eq(crypt_string(c, plain, 0), lsh_string_dup(cipher)))
#line 12
      { fputs("failed.\n", stderr);; exit(1); }
#line 12
    fputs("ok.\n", stderr);
#line 12
    lsh_string_free(a);
#line 12
    lsh_string_free(b);
#line 12
  }
#line 12

#line 12
    KILL(c);
#line 12
    c = MAKE_DECRYPT(algorithm, key->data, NULL);
#line 12
    
#line 12
  {
#line 12
    struct lsh_string *a, *b;
#line 12
    fputs("Decrypting with DES 1... ", stderr);
#line 12
    a = crypt_string(c, cipher, 0);
#line 12
    b = plain;
#line 12
    if (!lsh_string_eq(crypt_string(c, cipher, 0), plain))
#line 12
      { fputs("failed.\n", stderr);; exit(1); }
#line 12
    fputs("ok.\n", stderr);
#line 12
    lsh_string_free(a);
#line 12
    lsh_string_free(b);
#line 12
  }
#line 12

#line 12
    KILL(c);
#line 12
    
#line 12
    lsh_string_free(key);
#line 12
    lsh_string_free(cipher);
#line 12
  }
#line 12


#line 17

#line 17
  {
#line 17
    struct crypto_algorithm *algorithm = &crypto_des_algorithm;
#line 17
    struct lsh_string *key = simple_decode_hex("8001010101010101") ;
#line 17
    struct lsh_string *plain = simple_decode_hex("0000000000000040") ;
#line 17
    struct lsh_string *cipher = simple_decode_hex("A380E02A6BE54696") ;
#line 17
    struct crypto_instance *c;
#line 17

#line 17
    assert(key->length == algorithm->key_size);
#line 17
    assert(!algorithm->iv_size);
#line 17

#line 17
    c = MAKE_ENCRYPT(algorithm, key->data, NULL);
#line 17
    
#line 17
  {
#line 17
    struct lsh_string *a, *b;
#line 17
    fputs("Encrypting with DES 2... ", stderr);
#line 17
    a = crypt_string(c, plain, 0);
#line 17
    b = lsh_string_dup(cipher);
#line 17
    if (!lsh_string_eq(crypt_string(c, plain, 0), lsh_string_dup(cipher)))
#line 17
      { fputs("failed.\n", stderr);; exit(1); }
#line 17
    fputs("ok.\n", stderr);
#line 17
    lsh_string_free(a);
#line 17
    lsh_string_free(b);
#line 17
  }
#line 17

#line 17
    KILL(c);
#line 17
    c = MAKE_DECRYPT(algorithm, key->data, NULL);
#line 17
    
#line 17
  {
#line 17
    struct lsh_string *a, *b;
#line 17
    fputs("Decrypting with DES 2... ", stderr);
#line 17
    a = crypt_string(c, cipher, 0);
#line 17
    b = plain;
#line 17
    if (!lsh_string_eq(crypt_string(c, cipher, 0), plain))
#line 17
      { fputs("failed.\n", stderr);; exit(1); }
#line 17
    fputs("ok.\n", stderr);
#line 17
    lsh_string_free(a);
#line 17
    lsh_string_free(b);
#line 17
  }
#line 17

#line 17
    KILL(c);
#line 17
    
#line 17
    lsh_string_free(key);
#line 17
    lsh_string_free(cipher);
#line 17
  }
#line 17


#line 22

#line 22
  {
#line 22
    struct crypto_algorithm *algorithm = &crypto_des_algorithm;
#line 22
    struct lsh_string *key = simple_decode_hex("08192A3B4C5D6E7F") ;
#line 22
    struct lsh_string *plain = simple_decode_hex("0000000000000000") ;
#line 22
    struct lsh_string *cipher = simple_decode_hex("25DDAC3E96176467") ;
#line 22
    struct crypto_instance *c;
#line 22

#line 22
    assert(key->length == algorithm->key_size);
#line 22
    assert(!algorithm->iv_size);
#line 22

#line 22
    c = MAKE_ENCRYPT(algorithm, key->data, NULL);
#line 22
    
#line 22
  {
#line 22
    struct lsh_string *a, *b;
#line 22
    fputs("Encrypting with DES 3... ", stderr);
#line 22
    a = crypt_string(c, plain, 0);
#line 22
    b = lsh_string_dup(cipher);
#line 22
    if (!lsh_string_eq(crypt_string(c, plain, 0), lsh_string_dup(cipher)))
#line 22
      { fputs("failed.\n", stderr);; exit(1); }
#line 22
    fputs("ok.\n", stderr);
#line 22
    lsh_string_free(a);
#line 22
    lsh_string_free(b);
#line 22
  }
#line 22

#line 22
    KILL(c);
#line 22
    c = MAKE_DECRYPT(algorithm, key->data, NULL);
#line 22
    
#line 22
  {
#line 22
    struct lsh_string *a, *b;
#line 22
    fputs("Decrypting with DES 3... ", stderr);
#line 22
    a = crypt_string(c, cipher, 0);
#line 22
    b = plain;
#line 22
    if (!lsh_string_eq(crypt_string(c, cipher, 0), plain))
#line 22
      { fputs("failed.\n", stderr);; exit(1); }
#line 22
    fputs("ok.\n", stderr);
#line 22
    lsh_string_free(a);
#line 22
    lsh_string_free(b);
#line 22
  }
#line 22

#line 22
    KILL(c);
#line 22
    
#line 22
    lsh_string_free(key);
#line 22
    lsh_string_free(cipher);
#line 22
  }
#line 22


#line 27

#line 27
  {
#line 27
    struct crypto_algorithm *algorithm = &crypto_des_algorithm;
#line 27
    struct lsh_string *key = simple_decode_hex("0123456789ABCDEF") ;
#line 27
    struct lsh_string *plain = ssh_format("%lz", "Now is t") ;
#line 27
    struct lsh_string *cipher = simple_decode_hex("3FA40E8A984D4815") ;
#line 27
    struct crypto_instance *c;
#line 27

#line 27
    assert(key->length == algorithm->key_size);
#line 27
    assert(!algorithm->iv_size);
#line 27

#line 27
    c = MAKE_ENCRYPT(algorithm, key->data, NULL);
#line 27
    
#line 27
  {
#line 27
    struct lsh_string *a, *b;
#line 27
    fputs("Encrypting with DES 4... ", stderr);
#line 27
    a = crypt_string(c, plain, 0);
#line 27
    b = lsh_string_dup(cipher);
#line 27
    if (!lsh_string_eq(crypt_string(c, plain, 0), lsh_string_dup(cipher)))
#line 27
      { fputs("failed.\n", stderr);; exit(1); }
#line 27
    fputs("ok.\n", stderr);
#line 27
    lsh_string_free(a);
#line 27
    lsh_string_free(b);
#line 27
  }
#line 27

#line 27
    KILL(c);
#line 27
    c = MAKE_DECRYPT(algorithm, key->data, NULL);
#line 27
    
#line 27
  {
#line 27
    struct lsh_string *a, *b;
#line 27
    fputs("Decrypting with DES 4... ", stderr);
#line 27
    a = crypt_string(c, cipher, 0);
#line 27
    b = plain;
#line 27
    if (!lsh_string_eq(crypt_string(c, cipher, 0), plain))
#line 27
      { fputs("failed.\n", stderr);; exit(1); }
#line 27
    fputs("ok.\n", stderr);
#line 27
    lsh_string_free(a);
#line 27
    lsh_string_free(b);
#line 27
  }
#line 27

#line 27
    KILL(c);
#line 27
    
#line 27
    lsh_string_free(key);
#line 27
    lsh_string_free(cipher);
#line 27
  }
#line 27

#line 106 "macros.m4"

  return 0;
} 