#ifndef GABA_DEFINE
struct dh_client_exchange
{
  struct keyexchange_algorithm super;
  struct dh_method *dh;
};
extern struct lsh_class dh_client_exchange_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_dh_client_exchange_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dh_client_exchange *i = (struct dh_client_exchange *) o;
  mark((struct lsh_object *) i->dh);
}

struct lsh_class dh_client_exchange_class =
{ STATIC_HEADER,
  &keyexchange_algorithm_class, "dh_client_exchange", sizeof(struct dh_client_exchange),
  do_dh_client_exchange_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct dh_client
{
  struct packet_handler super;
  struct dh_instance dh;
  UINT32 hostkey_algorithm;
  struct lookup_verifier *verifier;
  struct install_keys *install;
};
extern struct lsh_class dh_client_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_dh_client_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dh_client *i = (struct dh_client *) o;
  dh_instance_mark(&i->dh, mark);
  mark((struct lsh_object *) i->verifier);
  mark((struct lsh_object *) i->install);
}

static void do_dh_client_free(struct lsh_object *o)
{
  struct dh_client *i = (struct dh_client *) o;
  dh_instance_free(&i->dh);
}

struct lsh_class dh_client_class =
{ STATIC_HEADER,
  &packet_handler_class, "dh_client", sizeof(struct dh_client),
  do_dh_client_mark,
  do_dh_client_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct srp_client_instance
{
  struct lsh_object super;
  struct dh_instance dh;
  struct lsh_string *name;
  struct install_keys *install;
};
extern struct lsh_class srp_client_instance_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_srp_client_instance_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct srp_client_instance *i = (struct srp_client_instance *) o;
  dh_instance_mark(&i->dh, mark);
  mark((struct lsh_object *) i->install);
}

static void do_srp_client_instance_free(struct lsh_object *o)
{
  struct srp_client_instance *i = (struct srp_client_instance *) o;
  dh_instance_free(&i->dh);
  lsh_string_free(i->name);
}

struct lsh_class srp_client_instance_class =
{ STATIC_HEADER,
  0, "srp_client_instance", sizeof(struct srp_client_instance),
  do_srp_client_instance_mark,
  do_srp_client_instance_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct srp_client_handler
{
  struct packet_handler super;
  struct srp_client_instance *srp;
};
extern struct lsh_class srp_client_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_srp_client_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct srp_client_handler *i = (struct srp_client_handler *) o;
  mark((struct lsh_object *) i->srp);
}

struct lsh_class srp_client_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "srp_client_handler", sizeof(struct srp_client_handler),
  do_srp_client_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct srp_client_exchange
{
  struct keyexchange_algorithm super;
  struct dh_method *dh;
  struct lsh_string *name;
};
extern struct lsh_class srp_client_exchange_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_srp_client_exchange_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct srp_client_exchange *i = (struct srp_client_exchange *) o;
  mark((struct lsh_object *) i->dh);
}

static void do_srp_client_exchange_free(struct lsh_object *o)
{
  struct srp_client_exchange *i = (struct srp_client_exchange *) o;
  lsh_string_free(i->name);
}

struct lsh_class srp_client_exchange_class =
{ STATIC_HEADER,
  &keyexchange_algorithm_class, "srp_client_exchange", sizeof(struct srp_client_exchange),
  do_srp_client_exchange_mark,
  do_srp_client_exchange_free
};
#endif /* !GABA_DECLARE */

