#ifndef GABA_DEFINE
struct userauth_special_exception
{
  struct exception super;
  struct lsh_string *reply;
};
extern struct lsh_class userauth_special_exception_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_userauth_special_exception_free(struct lsh_object *o)
{
  struct userauth_special_exception *i = (struct userauth_special_exception *) o;
  lsh_string_free(i->reply);
}

struct lsh_class userauth_special_exception_class =
{ STATIC_HEADER,
  &exception_class, "userauth_special_exception", sizeof(struct userauth_special_exception),
  NULL,
  do_userauth_special_exception_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct user
{
  struct lsh_object super;
  struct lsh_string *name;
  uid_t uid;
  int (*(verify_password))(struct user *self, struct lsh_string *pw, int free);
  int (*(file_exists))(struct user *self, struct lsh_string *name, int free);
  int (*(chdir_home))(struct user *self);
  int (*(fork_process))(struct user *self, pid_t *);
  void (*(exec_shell))(struct user *self, int login, char **argv, unsigned env_length, const struct env_value *env);
};
extern struct lsh_class user_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_user_free(struct lsh_object *o)
{
  struct user *i = (struct user *) o;
  lsh_string_free(i->name);
}

struct lsh_class user_class =
{ STATIC_HEADER,
  0, "user", sizeof(struct user),
  NULL,
  do_user_free
};
#endif /* !GABA_DECLARE */

