#ifndef GABA_DEFINE
struct connection_service
{
  struct command super;
  struct alist *global_requests;
  struct alist *channel_types;
};
extern struct lsh_class connection_service_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connection_service_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connection_service *i = (struct connection_service *) o;
  mark((struct lsh_object *) i->global_requests);
  mark((struct lsh_object *) i->channel_types);
}

struct lsh_class connection_service_class =
{ STATIC_HEADER,
  &command_class, "connection_service", sizeof(struct connection_service),
  do_connection_service_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct exc_finish_channel_handler
{
  struct exception_handler super;
  struct ssh_connection *connection;
  int dead;
  UINT32 channel_number;
};
extern struct lsh_class exc_finish_channel_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_exc_finish_channel_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct exc_finish_channel_handler *i = (struct exc_finish_channel_handler *) o;
  mark((struct lsh_object *) i->connection);
}

struct lsh_class exc_finish_channel_handler_class =
{ STATIC_HEADER,
  &exception_handler_class, "exc_finish_channel_handler", sizeof(struct exc_finish_channel_handler),
  do_exc_finish_channel_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct request_status
{
  struct lsh_object super;
  int status;
};
extern struct lsh_class request_status_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class request_status_class =
{ STATIC_HEADER,
  0, "request_status", sizeof(struct request_status),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct global_request_continuation
{
  struct command_continuation super;
  struct ssh_connection *connection;
  struct request_status *active;
};
extern struct lsh_class global_request_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_global_request_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct global_request_continuation *i = (struct global_request_continuation *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->active);
}

struct lsh_class global_request_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "global_request_continuation", sizeof(struct global_request_continuation),
  do_global_request_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct global_request_exception_handler
{
  struct exception_handler super;
  struct ssh_connection *connection;
  struct request_status *active;
};
extern struct lsh_class global_request_exception_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_global_request_exception_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct global_request_exception_handler *i = (struct global_request_exception_handler *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->active);
}

struct lsh_class global_request_exception_handler_class =
{ STATIC_HEADER,
  &exception_handler_class, "global_request_exception_handler", sizeof(struct global_request_exception_handler),
  do_global_request_exception_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct channel_request_continuation
{
  struct command_continuation super;
  struct ssh_connection *connection;
  struct ssh_channel *channel;
  struct request_status *active;
};
extern struct lsh_class channel_request_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_channel_request_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_request_continuation *i = (struct channel_request_continuation *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->channel);
  mark((struct lsh_object *) i->active);
}

struct lsh_class channel_request_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "channel_request_continuation", sizeof(struct channel_request_continuation),
  do_channel_request_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct channel_request_exception_handler
{
  struct exception_handler super;
  struct ssh_connection *connection;
  struct ssh_channel *channel;
  struct request_status *active;
};
extern struct lsh_class channel_request_exception_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_channel_request_exception_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_request_exception_handler *i = (struct channel_request_exception_handler *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->channel);
  mark((struct lsh_object *) i->active);
}

struct lsh_class channel_request_exception_handler_class =
{ STATIC_HEADER,
  &exception_handler_class, "channel_request_exception_handler", sizeof(struct channel_request_exception_handler),
  do_channel_request_exception_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct channel_open_continuation
{
  struct command_continuation super;
  struct ssh_connection *connection;
  UINT32 local_channel_number;
  UINT32 remote_channel_number;
  UINT32 window_size;
  UINT32 max_packet;
};
extern struct lsh_class channel_open_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_channel_open_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_open_continuation *i = (struct channel_open_continuation *) o;
  mark((struct lsh_object *) i->connection);
}

struct lsh_class channel_open_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "channel_open_continuation", sizeof(struct channel_open_continuation),
  do_channel_open_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct exc_channel_open_handler
{
  struct exception_handler super;
  struct ssh_connection *connection;
  UINT32 local_channel_number;
  UINT32 remote_channel_number;
};
extern struct lsh_class exc_channel_open_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_exc_channel_open_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct exc_channel_open_handler *i = (struct exc_channel_open_handler *) o;
  mark((struct lsh_object *) i->connection);
}

struct lsh_class exc_channel_open_handler_class =
{ STATIC_HEADER,
  &exception_handler_class, "exc_channel_open_handler", sizeof(struct exc_channel_open_handler),
  do_exc_channel_open_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct channel_write
{
  struct abstract_write super;
  struct ssh_channel *channel;
};
extern struct lsh_class channel_write_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_channel_write_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_write *i = (struct channel_write *) o;
  mark((struct lsh_object *) i->channel);
}

struct lsh_class channel_write_class =
{ STATIC_HEADER,
  &abstract_write_class, "channel_write", sizeof(struct channel_write),
  do_channel_write_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct channel_write_extended
{
  struct channel_write super;
  UINT32 type;
};
extern struct lsh_class channel_write_extended_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class channel_write_extended_class =
{ STATIC_HEADER,
  &channel_write_class, "channel_write_extended", sizeof(struct channel_write_extended),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct channel_close_callback
{
  struct lsh_callback super;
  struct ssh_channel *channel;
};
extern struct lsh_class channel_close_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_channel_close_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_close_callback *i = (struct channel_close_callback *) o;
  mark((struct lsh_object *) i->channel);
}

struct lsh_class channel_close_callback_class =
{ STATIC_HEADER,
  &lsh_callback_class, "channel_close_callback", sizeof(struct channel_close_callback),
  do_channel_close_callback_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct channel_io_exception_handler
{
  struct exception_handler super;
  struct ssh_channel *channel;
  const char * prefix;
};
extern struct lsh_class channel_io_exception_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_channel_io_exception_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_io_exception_handler *i = (struct channel_io_exception_handler *) o;
  mark((struct lsh_object *) i->channel);
}

struct lsh_class channel_io_exception_handler_class =
{ STATIC_HEADER,
  &exception_handler_class, "channel_io_exception_handler", sizeof(struct channel_io_exception_handler),
  do_channel_io_exception_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

