/* client.h
 *
 *
 *
 * $Id: client.h,v 1.32 2000/10/06 23:46:44 nisse Exp $ */

/* lsh, an implementation of the ssh protocol
 *
 * Copyright (C) 1998 Niels Mller
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LSH_CLIENT_H_INCLUDED
#define LSH_CLIENT_H_INCLUDED

#include "channel_commands.h"
#include "io.h"
#include "keyexchange.h"

#define GABA_DECLARE
#include "client.h.x"
#undef GABA_DECLARE

struct fd_callback *
make_client_callback(struct io_backend *b,
		     const char *comment,
		     UINT32 block_size,
		     struct randomness *random,
		     struct make_kexinit *init,
		     struct packet_handler *kexinit_handler);

struct read_handler *make_client_read_line(struct ssh_connection *c);
struct lsh_callback *make_client_close_handler(void);

struct packet_handler *
make_accept_service_handler(UINT32 service,
			    struct command_continuation *c,
			    struct exception_handler *e);

/* GABA:
   (class
     (name request_service)
     (super command)
     (vars
       (service . int)))
*/

void
do_request_service(struct command *s,
		   struct lsh_object *x,
		   struct command_continuation *c,
		   struct exception_handler *e);

#define STATIC_REQUEST_SERVICE(service) \
{ STATIC_COMMAND(do_request_service), service } 

struct command *make_request_service(int service);
struct channel_request *make_handle_exit_status(int *exit_code);
struct channel_request *make_handle_exit_signal(int *exit_code);

struct command *make_open_session_command(struct ssh_channel *session);


extern struct channel_request_command request_shell;
#define REQUEST_SHELL (&request_shell.super.super)

extern struct command client_io;
#define CLIENT_START_IO (&client_io.super)

struct ssh_channel *make_client_session(struct lsh_fd *in,
					struct lsh_fd *out,
					struct lsh_fd *err,
					UINT32 initial_window,
					int *exit_status);

struct command *
make_exec_request(struct lsh_string *command);
     
#endif /* LSH_CLIENT_H_INCLUDED */
