#ifndef GABA_DEFINE
struct backend_command
{
  struct command super;
  struct io_backend *backend;
};
extern struct lsh_class backend_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_backend_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct backend_command *i = (struct backend_command *) o;
  mark((struct lsh_object *) i->backend);
}

struct lsh_class backend_command_class =
{ STATIC_HEADER,
  &command_class, "backend_command", sizeof(struct backend_command),
  do_backend_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct remember_continuation
{
  struct command_continuation super;
  struct resource_list *resources;
  struct command_continuation *up;
};
extern struct lsh_class remember_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_remember_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct remember_continuation *i = (struct remember_continuation *) o;
  mark((struct lsh_object *) i->resources);
  mark((struct lsh_object *) i->up);
}

struct lsh_class remember_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "remember_continuation", sizeof(struct remember_continuation),
  do_remember_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct listen_with_callback
{
  struct command super;
  struct command *callback;
  struct io_backend *backend;
};
extern struct lsh_class listen_with_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_listen_with_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct listen_with_callback *i = (struct listen_with_callback *) o;
  mark((struct lsh_object *) i->callback);
  mark((struct lsh_object *) i->backend);
}

struct lsh_class listen_with_callback_class =
{ STATIC_HEADER,
  &command_class, "listen_with_callback", sizeof(struct listen_with_callback),
  do_listen_with_callback_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct listen_with_connection
{
  struct command super;
  struct ssh_connection *connection;
  struct io_backend *backend;
};
extern struct lsh_class listen_with_connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_listen_with_connection_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct listen_with_connection *i = (struct listen_with_connection *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->backend);
}

struct lsh_class listen_with_connection_class =
{ STATIC_HEADER,
  &command_class, "listen_with_connection", sizeof(struct listen_with_connection),
  do_listen_with_connection_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connect_continuation
{
  struct command_continuation super;
  struct address_info *target;
  struct command_continuation *up;
};
extern struct lsh_class connect_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connect_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connect_continuation *i = (struct connect_continuation *) o;
  mark((struct lsh_object *) i->target);
  mark((struct lsh_object *) i->up);
}

struct lsh_class connect_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "connect_continuation", sizeof(struct connect_continuation),
  do_connect_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connect_port
{
  struct command super;
  struct io_backend *backend;
  struct address_info *target;
};
extern struct lsh_class connect_port_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connect_port_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connect_port *i = (struct connect_port *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->target);
}

struct lsh_class connect_port_class =
{ STATIC_HEADER,
  &command_class, "connect_port", sizeof(struct connect_port),
  do_connect_port_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct simple_io_command
{
  struct command super;
  struct io_backend *backend;
  struct resource_list *resources;
};
extern struct lsh_class simple_io_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_simple_io_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct simple_io_command *i = (struct simple_io_command *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->resources);
}

struct lsh_class simple_io_command_class =
{ STATIC_HEADER,
  &command_class, "simple_io_command", sizeof(struct simple_io_command),
  do_simple_io_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connect_connection
{
  struct command super;
  struct io_backend *backend;
};
extern struct lsh_class connect_connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connect_connection_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connect_connection *i = (struct connect_connection *) o;
  mark((struct lsh_object *) i->backend);
}

struct lsh_class connect_connection_class =
{ STATIC_HEADER,
  &command_class, "connect_connection", sizeof(struct connect_connection),
  do_connect_connection_mark,
  NULL
};
#endif /* !GABA_DECLARE */

