



















    













#include "lsh.h"

#include "algorithms.h"
#include "crypto.h"
#include "digits.h"
#include "format.h"
#include "randomness.h"
#include "sexp.h"
#include "spki.h"
#include "werror.h"
#include "xalloc.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>

int main(int argc, char **argv)
{
  argp_parse(&werror_argp, argc, argv, 0, NULL, NULL);

  {
    struct crypto_instance *c;
    struct crypto_algorithm *algorithm = &crypto_cast128_cbc_algorithm;
    struct lsh_string *key = simple_decode_hex("0123456789ABCDEFFEDCBA9876543210") ;
    struct lsh_string *plain = simple_decode_hex("00000000000000001111111111111111") ;
    struct lsh_string *cipher = simple_decode_hex("9a1bf354bca596adf7b2a2ce5f09a8b2") ;


    struct lsh_string *ivs = simple_decode_hex("0011223344556677") ;
    UINT8 *iv = ivs->data;
    assert(ivs->length == algorithm->iv_size);

    assert(key->length == algorithm->key_size);

    c = MAKE_ENCRYPT(algorithm, key->data, iv);
    
  {
    struct lsh_string *a, *b;
    fputs("Encrypting with CAST-128 CBC ... ", stderr);
    a = crypt_string(c, plain, 0);
    b = lsh_string_dup(cipher);
    if (!lsh_string_eq(a, b))
      { fputs("failed.\n", stderr);; exit(1); }
    fputs("ok.\n", stderr);
    lsh_string_free(a);
    lsh_string_free(b);
  }

    KILL(c);
    c = MAKE_DECRYPT(algorithm, key->data, iv);
    
  {
    struct lsh_string *a, *b;
    fputs("Decrypting with CAST-128 CBC ... ", stderr);
    a = crypt_string(c, cipher, 0);
    b = plain;
    if (!lsh_string_eq(a, b))
      { fputs("failed.\n", stderr);; exit(1); }
    fputs("ok.\n", stderr);
    lsh_string_free(a);
    lsh_string_free(b);
  }

    KILL(c);
    

    lsh_string_free(ivs);

    lsh_string_free(key);
    lsh_string_free(cipher);
  }


  return 0;
}
