/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CLevelMeter.cp,v 1.4 1999/03/10 02:34:32 heller Exp $
____________________________________________________________________________*/
#include <UDrawingState.h>
#include <LView.h>

#include "CLevelMeter.h"

#define LEVELMETERPATID			7000
#define LEVELMETERBAKPATID		7001
#define LEVELMETERDISABLEDID	7002

CLevelMeter *CLevelMeter::CreateLevelMeterStream(LStream *inStream)
{
	return (new CLevelMeter(inStream));
}

CLevelMeter::CLevelMeter()
{
}

CLevelMeter::CLevelMeter(LStream *inStream)
		: LPane(inStream)
{
	mOn = FALSE;
	mLevel = 0;
	StartRepeating();
	mBackPat = GetPixPat(LEVELMETERBAKPATID);
	mForePat = GetPixPat(LEVELMETERPATID);
	mDisabledPat = GetPixPat(LEVELMETERDISABLEDID);
}

CLevelMeter::~CLevelMeter()
{
	DisposePixPat(mBackPat);
	DisposePixPat(mForePat);
	DisposePixPat(mDisabledPat);
	StopRepeating();
}

void
CLevelMeter::DoDraw(short /*full*/)
{
	Rect frame, metRect;
	RGBColor rgbBarOutlineColor = {0x2147, 0x2147, 0x2147};
	long j;
	
	if(FocusDraw())
	{
		StColorState savedColors;
		
		CalcLocalFrameRect(frame);
		::RGBForeColor(&rgbBarOutlineColor);
		::FrameRect(&frame);
		metRect = frame;
		::InsetRect(&metRect, 1, 1);
		if(mOn)
		{
			j = (mLevel * 16) / 254 * 3;	/* 16 = # of boxes, 3 = pixel height of boxes */
			if(j > metRect.right - metRect.left)
				j = metRect.right - metRect.left;
			metRect.right = metRect.left + j;
			::PenPixPat(mForePat);
			::PaintRect(&metRect);
			metRect.left = metRect.right;
			metRect.right = frame.right - 1;
			if(metRect.right != metRect.left)
			{
				::PenPixPat(mBackPat);
				::PaintRect(&metRect);
			}
		}
		else
		{
			::PenPixPat(mDisabledPat);
			::PaintRect(&metRect);
		}
		::PenNormal();
	}
}

void
CLevelMeter::DrawSelf()
{
	DoDraw(1);
}

void
CLevelMeter::SpendTime(const EventRecord &/*inMacEvent*/)
{
	LView::OutOfFocus(nil);
	DoDraw(0);
}

void
CLevelMeter::SetLevel(long level)
{
	//	This routine might get called during a pre-emptive thread, so
	//	don't use any OS calls
	mLevel = level;
}

void
CLevelMeter::SetStatus(Boolean status)
{
	mOn = status;
}

