/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPFTAppleTalk.h,v 1.3 1999/03/10 02:35:30 heller Exp $
____________________________________________________________________________*/
#pragma once

#include "CPFTransport.h"
#include <OpenTransport.h>
#include <OpenTptAppleTalk.h>

#define MAXPGPFDDPSIZE		586		//not arbitrary, solid DDP limitation
#define PGPFDDPTYPE			47		// do not modify
#define PGPFDDPRCVBUFLEN	8192

class CPFWindow;

class CPFTAppleTalk		:	public CPFTransport
{
public:
					CPFTAppleTalk();
					CPFTAppleTalk(CPFWindow *cpfWindow, LThread *thread, short *result);
					~CPFTAppleTalk();
	PGErr			Connect(ContactEntry *con, short *connectResult);
	PGErr			Disconnect();
	PGErr			Listen(Boolean answer);
	PGErr			Reset();
	PGErr			WriteBlock(void *buffer, long *count, short channel);
	PGErr			WriteBlockTo(void *buffer, long *count, DDPAddress *addr);
	PGErr			WriteAsync(long count, short channel, AsyncTransport *async);
	long			Read(void *data, long max, short *channel);
	void			ReceiveDDPMsg(uchar *msg, long len);
	
	LThread			*mThread;
	OTResult		mOTResult;
	Boolean			mDataReady;
private:
	OSErr			MakeOTEndpoint();
	OSErr			CloseOTEndpoint();
	OSStatus		ClearLookErr(EndpointRef endpoint);
	
	EndpointRef		mEndpoint;
	DDPNBPAddress	mAddress;
	size_t			mAddressLen;
	DDPAddress		mRemoteAddress, mLastAddress;
	Boolean			mMore;
	uchar			mRcvBuf[PGPFDDPRCVBUFLEN];
};

extern char gPGPFNBPTypeStr[];

