/*

	This file includes all of the separate functions which comprise
	the CELP codec.  We declare the functions static and include them
	in this manner to avoid name space clashes with other components:
	only the external interface of the CODEC defined in Clep.h is
	exported.

	Because we've experienced code optimisation problems with this
	library, particularly with Microsoft Visual Studio 97 / C 5.0,
	the inclusion of each module is wrapped with commented-out #pragma
	statements to disable optimisation for it.  If you run into trouble,
	you can enable these to track down where the optimisation problem
	lies.  Modules with past optimisation problems are commented with
	a representation of the audio effect the problem created.

*/

//#pragma optimize("", off)
#include "autohf.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "bwexp.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "cbsearch.h"
//#pragma optimize("", on)

//#pragma optimize("", off)	// SQWERBLE-SQWERBLE
#include "cgain.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "clip.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "confg.h"
//#pragma optimize("", on)

#include "contextc.h"

//#pragma optimize("", off)
#include "cor.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "csub.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "dcodcbg.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "dcodcbi.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "dcodpg.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "dcodtau.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "delay.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "durbin.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "gaincode.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "ham.h"
//#pragma optimize("", on)

#ifdef CELP_PROTECT
#include "hamming.h"
#endif

//#pragma optimize("", off)
#include "impulse.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "intanaly.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "intsynth.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "ldelay.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "lsp34.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "lsptopc.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "mexcite.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "movefr.h"
//#pragma optimize("", on)

#ifdef CELP_PROTECT
#include "mtrxgen.h"
#endif

//#pragma optimize("", off)
#include "pack.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "packtau.h"
//#pragma optimize("", on)

//#pragma optimize("", off)	// BZZZZZZZT!!!!!
#include "pctolsp2.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "pctorc.h"
//#pragma optimize("", on)

//#pragma optimize("", off)	// KERSCRUZZ!!!!
#include "pgain.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "pitchvq.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "polefilt.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "postfilt.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "prefilt.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "psearch.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "ptcode.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "round.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "setr.h"
//#pragma optimize("", on)

#ifdef CELP_PROTECT
#include "smcbg.h"
#include "smpg.h"
#include "smt.h"
#endif

//#pragma optimize("", off)
#include "unpack.h"
//#pragma optimize("", on)

#ifdef CELP_PROTECT
#include "variance.h"
#endif

//#pragma optimize("", off)
#include "vdecode.h"
//#pragma optimize("", on)

//#pragma optimize("", off)
#include "zerofilt.h"
//#pragma optimize("", on)
