/*	Define CELPDIAG to enable diagnostics for abnormal situations
	during encoding and decoding.  Diagnostics are written to
	standard error.  */

/* #define CELPDIAG */

#define CELP_ERROR(code) { if (celp_error == CELP_OK) { celp_error = code; } }

#define CELP_PI 3.14159265358979323846

static void autohf(float si[], float w[], int n, int p, float omega, float a[], float rc[]);
static void bwexp(float alpha, float pc[], float pcexp[], int n);
static void cbsearch(int l, float a_v[]);
static float cgain(const float ex[], int l, int first, int len, float *match);
static int clip(float s[], int l);
static void confg(float s[], int l, float d1[], float d2[],
		float d3[], float d4[], int isw1, int isw2, int isw3, int isw4);
static void cor(float *rar, int idim, int n, float *c0, float *c);
static void csub(float s[], float a_v[], int l, int lp);
static void dcodcbg(int cbgbits, int a_bitsum1, int a_bitsum2,
		int *a_bitpointer, int nn, short a_stream[], float a_cbg[]);
static void dcodcbi(int cbbits, int a_bitsum1, int a_bitsum2,
		int *a_bitpointer, int nn, short a_stream[], int cbi[]);
static void dcodpg(int pgbits, int a_bitsum1, int a_bitsum2,
		int *a_bitpointer, int nn, short a_stream[], float a_pgs[]);
static void dcodtau(int taubits, int taudelta, int a_bitsum1,
		int a_bitsum2, int *a_bitpointer, int nn, short a_stream[],
		const float pddecode[], int pdtabi[], float a_taus[]);
static float sinc(float arg);
static int qd(float d);
static void delay(float x[], int start, int n, float d, int m, float y[]);
static float sinc(float arg);
static void durbin(float c0, float *c, float *a, int n);
static float gainencode(float input, int *index);
static void gaindecode(int a_gindex, int bits, float *gain);
#ifdef CELP_PROTECT
static void encodeham(int codelength1, int codelength2,
		int a_hmatrix[], int *a_paritybit, int a_codeword[]);
static void decodeham(int codelength1, int a_hmatrix[], int a_syndrometable[],
		int a_paritybit, int a_codeword[], int *a_twoerror, int *synflag);
#endif
static void ham(float win[], int n);
static void impulse(int l);
static void intanaly(float lspnew[], int nn, float a_lsp[][MAXNO]);
static void intsynth(float lspnew[], int nn, float a_lsp[][MAXNO],
		int twoerror, float syndavg);
static void ldelay(float x[], int start, int n, float d, int m, float y[]);
static void lsp34(float freq[], int no, const int bits[], int a_findex[]);
static void lspdecode34(int a_findex[], int no, float freq[]);
static void lsptopc(float f[], float pc[]);
static void mexcite1(int l);
static void mexcite2(int l);
static void mexcite3(float *cgain);
#ifdef MOVEFR_SUB
static void movefr(int n, float *a, float *b);
#else
#define movefr(n, src, dest) memcpy((dest), (src), (n) * sizeof(float))
#endif
#ifdef CELP_PROTECT
static void matrixgen(int codelength1, int codelength2,
		int a_hmatrix[], int a_syndrometable[]);
#endif
static void pack(int value, int bits, short array[], int *a_pointer);
static void packtau(int value, int bits, const int pdencode[], short array[], int *a_pointer);
static void pctolsp2(float a[], int m, float freq[], int *a_lspflag);
static void pctorc(const float lpc[], float rc[], int n);
static float pgain(const float ex[], int l, int first, int m, int len, float *match);
static void pitchvq(float rar[], int idim, float buf[],
	int idimb, float b[], char type[]);
static void polefilt(const float a[], int n, float z[], float xy[], int len);
static void postfilt(float s[], int l, float alpha, float beta,
	float *powerin, float *powerout, float a_dp1[],
	float a_dp2[], float a_dp3[]);
static void prefilt(float s[], int l, float dpp[]);
static void psearch(int l);
static float pitchencode(float input, int *index);
static void pitchdecode(int a_pindex, float *pitch);
#ifdef ROUNDFUNC
static int round(float afloat);
#else
#define round(f) (((f) < 0) ? \
    (((int) (f)) - ((((f) - ((int) (f))) <= -0.5) ? 1 : 0)) \
                            : \
	(((int) (f)) + ((((f) - ((int) (f))) >=  0.5) ? 1 : 0)))
							
#endif
static void setr(int n, float a_v, float a[]);
#ifdef CELP_PROTECT
static void smoothcbgain(float *cbgain, int a_twoerror, float a_syndavg,
	float gains[], int subframe);
static void smoothpgain(float *pgain, int a_twoerror, float a_syndavg,
	float pgains[], int subframe);
static void smoothtau(float *tau, int a_twoerror, float a_syndavg,
	float tau3, int subframe);
#endif
static void unpack(const short array[], int bits, int *value, int *a_pointer);
#ifdef CELP_PROTECT
static void variance(float arr[], int no, float *var, float *avg);
#endif
static void vdecode(float a_decodedgain, int l, float a_vdecoded[]);
static void zerofilt(const float b[], int n, float z[], float xy[], int len);
