
#ifdef CELP_USE_CONTEXT

#define CELP_MAXL	  60
//#define CELP_MAXCODE   2*(MAXNCSIZE)+CELP_MAXL
#define CELP_MAXLL	  240
#define CELP_MAXNO	  10 
#define CELP_MAXLP	  60
#define CELP_MAXNP	  3
#define CELP_MMIN	  20
#define CELP_MMAX	  147
#define CELP_MAXPD	  256
#define CELP_MAXM2	  20
#define CELP_MAXPA	  (CELP_MAXLP+CELP_MMAX+2+CELP_MAXM2)

struct celp_context {
	int CELP_cbindex /* = 0 */,
		CELP_gindex /* = 0 */,
		CELP_idb /* = 0 */,
		CELP_nseg /* = 0 */,
		CELP_pindex /* = 0 */,
		CELP_frame /* = 0 */,
		CELP_tauptr /* = 0 */,
		CELP_minptr /* = 0 */,
		CELP_plevel1 /* = 0 */,
		CELP_plevel2 /* = 0 */;

	float CELP_bb[CELP_MAXNP + 1],
		  CELP_e0[CELP_MAXLP],
		  CELP_fc[CELP_MAXNO + 1],
		  CELP_fcn[CELP_MAXNO + 1],
		  CELP_fci[CELP_MAXNO + 1],
		  CELP_h[CELP_MAXLP];

	int CELP_cbi[CELP_MAXLL / CELP_MAXL];
	int CELP_i,
		CELP_j,
		CELP_k;
	int CELP_nn;
	int CELP_findex[CELP_MAXNO];
	int CELP_lspflag;
	int CELP_pdtabi[CELP_MAXPD];

	float CELP_cbg[CELP_MAXLL / CELP_MAXL],
		  CELP_pgs[CELP_MAXLL / CELP_MAXL];
	float CELP_sold[CELP_MAXLL],
		  CELP_snew[CELP_MAXLL],
		  CELP_ssub[CELP_MAXLL],
		  CELP_v[CELP_MAXLL];
	float CELP_vdecoded[CELP_MAXLL],
		  CELP_rcn[CELP_MAXNO],
		  CELP_hamw[CELP_MAXLL];
	float CELP_dps[CELP_MAXPA],
		  CELP_newfreq[CELP_MAXNO],
		  CELP_unqfreq[CELP_MAXNO],
		  CELP_lsp[CELP_MAXLL / CELP_MAXL][CELP_MAXNO];
	float CELP_dpps[CELP_MAXPA]; 
	float CELP_decodedgain,
		  CELP_taus[4];

	/* Bit stream */

	int CELP_pointer,
		CELP_bitpointer,
		CELP_bitsum1,
		CELP_bitsum2;
#define CELP_STREAMBITS 144
	short CELP_stream[CELP_STREAMBITS],
		  CELP_savestream[CELP_STREAMBITS];
#undef CELP_STREAMBITS

	/* Filter memories (should be MAXNO+1) */

	float CELP_dhpf1[3],
		  CELP_dhpf2[3],
		  CELP_dss[CELP_MAXNO+1];
	float CELP_dp1[CELP_MAXNO+1],
		  CELP_dp2[CELP_MAXNO+1],
		  CELP_dp3[2];
	float CELP_ip,
		  CELP_op;

	/* Error control coding parameters */

	float CELP_syndavg /* = 0.0 */;
	int CELP_twoerror;

#ifdef CELP_PROTECT
#define CELP_CODELENGTH1 15
	int CELP_snrflag;
	int CELP_syncBit /* = 1 */;
	int CELP_codeword[CELP_CODELENGTH1],
		CELP_hmatrix[CELP_CODELENGTH1];
	int CELP_syndrometable[CELP_CODELENGTH1],
		CELP_paritybit,
		CELP_protect;
	int CELP_syndrome;
#undef CELP_CODELENGTH1
#endif

	float CGAIN_y[CELP_MAXL],
		  CGAIN_y59save,
		  CGAIN_y60save,
		  CGAIN_eng;

	float CSUB_d1a[CELP_MAXPA],
		  CSUB_d1b[CELP_MAXPA],
		  CSUB_d2a[CELP_MAXNO+1],
		  CSUB_d2b[CELP_MAXNO+1],
		  CSUB_d3a[CELP_MAXNO+1],
		  CSUB_d3b[CELP_MAXNO+1];
	float CSUB_d4a[CELP_MAXNO+1],
		  CSUB_d4b[CELP_MAXNO+1];

	int DCODTAU_lptr /* = 0 */;
	
#define DELAY_NFRAC 5
#define DELAY_M1 -4
#define DELAY_M2  3
#define DELAY_SIZE (DELAY_M2 - DELAY_M1 + 1)
	float DELAY_wsinc[DELAY_SIZE][DELAY_NFRAC],
		  DELAY_hwin[12*DELAY_SIZE+1];
	int DELAY_first /* = TRUE */;
#undef DELAY_SIZE
#undef DELAY_NFRAC
#undef DELAY_M1
#undef DELAY_M2
	
	float INTANALY_tempfreq;
	float INTANALY_lspold[CELP_MAXNO] /* = {.03, .05, .09, .13, .19, .23, .29, .33, .39, .44} */;
	float INTANALY_oldlsp[CELP_MAXNO];

	float INTSYNTH_lspold[CELP_MAXNO] /* = { .03, .05, .09, .13, .19, .23, .29, .33, .39, .44 } */;

#define LDELAY_SIZE (LDELAY_M2 - LDELAY_M1 + 1)
#define LDELAY_NFRAC 5
#define LDELAY_M1 -20
#define LDELAY_M2  19
	float LDELAY_wsinc[LDELAY_SIZE][LDELAY_NFRAC],
		  LDELAY_hwin[12*LDELAY_SIZE+1];
	int LDELAY_first /* = TRUE */;
#undef LDELAY_SIZE
#undef LDELAY_NFRAC
#undef LDELAY_M1
#undef LDELAY_M2

	float MEXCITE_ccor;
	float MEXCITE_e1,
		  MEXCITE_e0save[60];

#define PCTOLSP2_MAXORD 24
	float PCTOLSP2_lastfreq[PCTOLSP2_MAXORD];
#undef PCTOLSP2_MAXORD

	float PGAIN_y[CELP_MAXLP];

	int PSEARCH_oldptr /* = 1 */;
	
#define SMCBG_CBGAINHISTORY 	4
	int SMCBG_enable;
	float SMCBG_oldcbgain[SMCBG_CBGAINHISTORY];
#undef SMCBG_CBGAINHISTORY

#define SMPG_PGAINHISTORY		4
	int SMPG_enable;
	float SMPG_oldpgain[SMPG_PGAINHISTORY];
#undef SMPG_PGAINHISTORY

#define SMT_TAUHISTORY	4
	int SMT_enable;
	float SMT_oldtau[SMT_TAUHISTORY];
#undef SMT_TAUHISTORY

// *** char celp_bitbucket[16384]; // *** DEBUG OVERWRITE

};

#undef CELP_MAXL
//#undef CELP_MAXCODE
#undef CELP_MAXLL
#undef CELP_MAXNO
#undef CELP_MAXLP
#undef CELP_MAXNP
#undef CELP_MMIN
#undef CELP_MMAX
#undef CELP_MAXPD
#undef CELP_MAXM2
#undef CELP_MAXPA

#endif
