/**************************************************************************
*
* ROUTINE
*				dcodcbg.c
*
* FUNCTION
*				 Decodes all code book gains for a frame
*
*
* SYNOPSIS
*				subroutine dcodcbg(cbgbits,bitsum1,bitsum2,bitpointer,
*								   nn,stream,cbg)
*
*	formal
*
*						data	I/O
*		name			type	type	function
*		-------------------------------------------------------------------
*		cbgbits 		int 	i		number of bits for quantization
*		bitsum1 		int 	i		number of bits for odd subframes
*		bitsum2 		int 	i		number of bits for even subframes
*		bitpointer		int 	i/o 	number of bits used
*		nn				int 	i		number of subframes/frame
*		stream			short	i		bit stream
*		cbg 			float	o		vector of code book indicies
*
***************************************************************************
*
* DESCRIPTION
*
*
***************************************************************************
*
* CALLED BY
*
*		celp
*
* CALLS
*
*		gaindecode		unpack
*
***************************************************************************
*
* REFERENCES
*
*
**************************************************************************/

static void dcodcbg(int cbgbits, int a_bitsum1, int a_bitsum2,
	int *a_bitpointer, int nn, short a_stream[], float a_cbg[])
{
  int i, l_pointer, index;

  l_pointer = *a_bitpointer;
  for (i = 0; i < nn; i++)
  {
	unpack(a_stream, cbgbits, &index, &l_pointer);
	gaindecode(index, cbgbits, &a_cbg[i]);
	if (i == 0 || i == 2 || i == 4)
	  l_pointer += a_bitsum2 - cbgbits;
	else if (i == 1 || i == 3 || i == 5)
	  l_pointer += a_bitsum1 - cbgbits;
	else {
#ifdef CELPDIAG
      fprintf(stderr, "dcodcbg: ***Error in decoding cbgain\n");
#endif
	  CELP_ERROR(CELP_ERR_DCODCBG);
	  return;
	}
  }
  *a_bitpointer += cbgbits;
}
