/**************************************************************************
*
* ROUTINE
*				dcodpg.c
*
* FUNCTION
*				 Decodes all pitch gain values for a frame
*
*
* SYNOPSIS
*				subroutine dcodpg(pgbits,bitsum1,bitsum2,bitpointer,
*								  nn,stream,pgs)
*
*	formal
*
*						data	I/O
*		name			type	type	function
*		-------------------------------------------------------------------
*		pgbits			int 	i		number of bits for quantization
*		bitsum1 		int 	i		number of bits for odd subframes
*		bitsum2 		int 	i		number of bits for even subframes
*		bitpointer		int 	i		number of bits used
*		nn				int 	i		number of subframes/frame
*		stream			short	i		bit stream
*		pgs 			float	o		vector of pitch gains
*
***************************************************************************
*
* DESCRIPTION
*
*
***************************************************************************
*
* CALLED BY
*
*		celp
*
* CALLS
*
*		pitchdecode 	 unpack
*
***************************************************************************
*
* REFERENCES
*
*
**************************************************************************/

static void dcodpg(int pgbits, int a_bitsum1, int a_bitsum2,
	int *a_bitpointer, int nn, short a_stream[], float a_pgs[])
{
  int i, l_pointer, index;

  l_pointer = *a_bitpointer;
  for (i = 0; i < nn; i++)
  {
	unpack(a_stream, pgbits, &index, &l_pointer);
	pitchdecode(index, &a_pgs[i]);
	if (i == 0 || i == 2 || i == 4)
	  l_pointer += a_bitsum2 - pgbits;
	else if (i == 1 || i == 3 || i == 5)
	  l_pointer += a_bitsum1 - pgbits;
	else {
#ifdef CELPDIAG
      fprintf(stderr, "dcodpg:  Error in decoding pitch gain\n");
	  CELP_ERROR(CELP_ERR_DCODPG);
	  return;
#endif
	}
  }
  *a_bitpointer += pgbits;
}
