/**************************************************************************
*
* ROUTINE
*				pitchencode
*
* FUNCTION
*
*				encode and quantize pitch gain (bb(3)) for various
*				quantizer types.
*
* SYNOPSIS
*				subroutine pitchencode(input, index)
*
*	formal
*
*						data	I/O
*		name			type	type	function
*		-------------------------------------------------------------------
*		input			int 	i		pitch gain input (true value)
*		index			float	o		encoded pitch gain index
*		pitchencode 	float	fun 	encoded pitch gain
*
***************************************************************************
*
* DESCRIPTION
*
*       This funtion uses output level data obtained by Max's minimum
*		distortion quantization priciples and quantizes to the nearest
*		level (L1 norm).  (Using level data only was found superior to
*       using both of Max's level and boundry data.)
*
***************************************************************************
*
* CALLED BY
*
*		psearch
*
* CALLS
*
*		
***************************************************************************
*
* REFERENCES
*
*		Quantizing for Minimum Distorion
*		J. Max
*		IRE Trans. Inform. Theory, vol. IT-6, pp.7-12, Mar. 1960
*
***************************************************************************
*
*		The data used in the table generation is from 3m3f.spd.
*
**************************************************************************/

static const float pitch2max5[32] =
{
  -0.993f, -0.831f, -0.693f, -0.555f, -0.414f, -0.229f,    0.0f,  0.139f,
   0.255f,	0.368f,  0.457f,  0.531f,  0.601f,	0.653f,  0.702f,  0.745f,
   0.780f,	0.816f,  0.850f,  0.881f,  0.915f,	0.948f,  0.983f,  1.020f, 
   1.062f,	1.117f,  1.193f,  1.289f,  1.394f,	1.540f,  1.765f,  1.991f
};

static float pitchencode(float input, int *index)
{
  int i;
  float dist, low;
  
  low = dist = (float) fabs(input - *pitch2max5);
  *index = 0;
  for (i = 1; i < 32; i++)
  {
	dist = (float) fabs(input - pitch2max5[i]);
	if (dist < low)
	{
	  low = dist;
	  *index = i;
	}
  }
  return (pitch2max5[*index]);
}

/**************************************************************************
*
* ROUTINE
*				pitchdecode
*
* FUNCTION
*
*				decode pitch gain (bb(3)) from pitch index and bit
*				index (bits)
*
* SYNOPSIS
*				subroutine pitchdecode(pindex, pitch)
*
*	formal
*
*						data	I/O
*		name			type	type	function
*		-------------------------------------------------------------------
*		pindex			int 	i		pitch index value
*		pitch			float	o		pitch gain decoded
*
***************************************************************************
*
* DESCRIPTION
*
*
***************************************************************************
*
* CALLED BY
*
*		dcodpg
*
* CALLS
*
*
***************************************************************************
*
*		The data used in the table generation is from 3m3f.spd.
*
***************************************************************************
*
* REFERENCES
*
*		Quantizing for Minimum Distorion
*		J. Max
*		IRE Trans. Inform. Theory, vol. IT-6, pp.7-12, Mar. 1960
*
***************************************************************************
*
*		The data used in the table generation is from 3m3f.spd.
*
**************************************************************************/

static void pitchdecode(int a_pindex, float *pitch)
{
  *pitch = pitch2max5[a_pindex];
}
