/**************************************************************************
*
* ROUTINE
*				vdecode
*
* FUNCTION
*
*				create excitation vector from code book index and decoded gain
*
* SYNOPSIS
*				subroutine vdecode(decodedgain, l, vdecoded)
*
*	formal
*
*						data	I/O
*		name			type	type	function
*		-------------------------------------------------------------------
*		decodedgain 	r		i		decoded gain value
*		l				i		i		pitch&code frame length
*		vdecoded		r		o		decoded excitation array
*
*	external
*						data	I/O
*		name			type	type	function
*		-------------------------------------------------------------------
*		x[] 			float	i
*
***************************************************************************
*
* CALLED BY
*
*		celp
*
* CALLS
*
*
*
**************************************************************************/

static void vdecode(float a_decodedgain, int l, float a_vdecoded[])
{
  int i, l_codeword;

  /* *copy selected vector to excitation array							 */

  l_codeword = 2 * (MAXNCSIZE - cbindex);
  if (l_codeword < 0)
  {
#ifdef CELPDIAG
    fprintf(stderr, "vdecode: cbindex > MAXNCSIZE at frame %d\n", frame);
#endif
	l_codeword = 0;
  }
  for (i = 0; i < l; i++)
	a_vdecoded[i] = x[i + l_codeword] * a_decodedgain;
}
